/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editaluastate;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrEditAsymmetricAccessStatesAC
extends SJctrApplyController {
    private static final int LUNM_BASE_TIME = 30;
    private static final double COEFFICIENT = 0.003;
    public List<SJctrPortLunTableKey> luPathList;
    protected SJctrError representativeError = null;
    protected Map<Integer, Map<Integer, SJctrError>> aluaStateErrorMap = Collections.emptyMap();
    List<SJctrError> resultData = null;
    public static final String FUNC_ID_LUNM_UPDATE_ASYMMETRIC_ACCESS_STATE_PERHG = "LUNMupdateAsymmetricAccessStatePerHG";
    public static final String KEY_ERRORINFO = "ErrorInfo";
    public static final String KEY_ERRORCODE = "ErrorCode";
    public static final String KEY_MESSAGEID = "MessageId";
    public static final String KEY_ID = "Id";
    public static final String KEY_PORT = "Port";
    public static final String KEY_HOSTGROUP = "HostGroup";
    public static final String KEY_ASYMMETRIC_ACCESS_STATE_SETTING_OPERATIONS = "AsymmetricAccessStateSettingOperations";
    public static final String KEY_ASYMMETRIC_ACCESS_STATE = "AsymmetricAccessState";
    int hgNum = 0;

    @Override
    public int getLeadTime() {
        double sendNum = (double)this.hgNum / 450.0;
        double leadtime = 30.0 + Math.ceil(sendNum) * 3.5;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            SanRequest requestData = supplier.newRequest(FUNC_ID_LUNM_UPDATE_ASYMMETRIC_ACCESS_STATE_PERHG);
            SanList reqAccessStatePerHGList = requestData.newList(KEY_ASYMMETRIC_ACCESS_STATE_SETTING_OPERATIONS);
            if (this.luPathList == null) {
                SJctrLogUty.error("SJctrEditAsymmetricAccessStatesAC", "applyStart", "Parameter is invalid.");
                return;
            }
            short portId = -1;
            short hgId = -1;
            for (SJctrPortLunTableKey luPath : this.luPathList) {
                short setPortId = luPath.getPortLunDetail().getSPort();
                short setHgId = luPath.getPortLunDetail().getSHostGroup();
                if (portId == setPortId && hgId == setHgId) continue;
                portId = setPortId;
                hgId = setHgId;
                SanObject accessStateParam = reqAccessStatePerHGList.addObj();
                accessStateParam.putInt(KEY_ASYMMETRIC_ACCESS_STATE, (int)luPath.getPortLunDetail().getByAsymmetricAccessState());
                SanObject portParam = accessStateParam.newObj(KEY_PORT);
                portParam.putInt(KEY_ID, (int)portId);
                SanObject hgParam = portParam.newObj(KEY_HOSTGROUP);
                hgParam.putInt(KEY_ID, (int)hgId);
            }
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateAsymmetricAccessStatePerHG)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateAsymmetricAccessStatePerHG)");
            this.getEditAsymmetricAccessStates(resultObject);
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfaced error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private void getEditAsymmetricAccessStates(Object resultObject) throws SanDataException {
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJctrError err = new SJctrError(10, 22, 107001);
            throw err.createException();
        }
        SJctrLogUty.info(this.title, "getEditAsymmetricAccessStates", "get SanResponse.");
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj(KEY_ERRORINFO)).getIntArray(KEY_MESSAGEID))[1]) {
            this.representativeError = new SJctrError(errMsgId[0] / 100, errMsgId[0] % 100, errMsgId[1]);
        }
        SanList AsymmetricAccessStateSettingList = responseData.getList(KEY_ASYMMETRIC_ACCESS_STATE_SETTING_OPERATIONS);
        this.aluaStateErrorMap = new HashMap<Integer, Map<Integer, SJctrError>>(AsymmetricAccessStateSettingList.size());
        for (SanObject AsymmetricAccessStateSetting : AsymmetricAccessStateSettingList) {
            SanObject portInfo = AsymmetricAccessStateSetting.getObj(KEY_PORT);
            int portId = portInfo.getInt(KEY_ID);
            SanObject hgInfo = portInfo.getObj(KEY_HOSTGROUP);
            int hgId = hgInfo.getInt(KEY_ID);
            SanObject errInfo = AsymmetricAccessStateSetting.getObj(KEY_ERRORINFO);
            int[] errMsgId2 = errInfo.getIntArray(KEY_MESSAGEID);
            SJctrError error = new SJctrError(errMsgId2[0] / 100, errMsgId2[0] % 100, errMsgId2[1]);
            Map<Integer, SJctrError> hgErrorMap = this.aluaStateErrorMap.get(portId);
            if (hgErrorMap == null) {
                hgErrorMap = new HashMap<Integer, SJctrError>(AsymmetricAccessStateSettingList.size());
                this.aluaStateErrorMap.put(portId, hgErrorMap);
            }
            hgErrorMap.put(hgId, error);
        }
    }

    public void setWizardSetData(List<SJctrPortLunTableKey> luPathList) {
        this.luPathList = luPathList;
    }

    public void setHgNum(int num) {
        this.hgNum = num;
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(new SJctrError(0, 0, 0));
        }
        this.resultData = new ArrayList<SJctrError>(this.luPathList.size());
        if (this.aluaStateErrorMap.isEmpty()) {
            return;
        }
        for (SJctrPortLunTableKey luPathInfo : this.luPathList) {
            SJctrError error;
            SJmoPortLunDetail luPathDtl = luPathInfo.getPortLunDetail();
            short portId = luPathDtl.getSPort();
            short hgId = luPathDtl.getSHostGroup();
            Map<Integer, SJctrError> hgErrorMap = this.aluaStateErrorMap.get(portId);
            if (hgErrorMap == null) {
                error = new SJctrError(10, 22, 107001);
            } else {
                error = hgErrorMap.get(hgId);
                if (error == null) {
                    error = new SJctrError(10, 22, 107001);
                }
            }
            this.resultData.add(error);
        }
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

