/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editcommanddevices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.editcommanddevices.SJctrEditCommandDeviceErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.editcommanddevices.SJctrEditCommandDeviceLdevDetail;
import sanproject.sn2.controller.wizard.lunm.editcommanddevices.SJctrEditCommandDeviceSelectLdev;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;

public class SJctrEditCommandDevicesDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100701;
    private static final String KEY_CMDDEVINF = "COM_CMDDEVINF";
    private static final String KEY_CMDDEVSECINF = "COM_CMDDEVSECINF";
    private static final String KEY_USERAUTHINF = "COM_USERAUTHINF";
    private static final String KEY_DEVGRPINF = "COM_DEVGRPINF";
    private static final String KEY_ENABLE = "COM_ENABLE";
    private static final String KEY_DISABLE = "COM_DISABLE";
    public static final String TITLE = "DISP_DI70S_TITLE";
    public static final Class<? extends SJmoGetKind_IF> KEY_CLASS_SELECT_LDEV = SJctrEditCommandDeviceSelectLdev.class;
    public static final String KEY_TABLE = "COM_TABLE";
    public List<SJmoLdevIndex> selectLdevList = null;
    public ArrayList<SJmoLdevDetail> originLdevDtlList = null;
    public ArrayList<SJmoLdevGuardInfo> originLdevGDList = null;
    public ArrayList<SJmoLdevDetail> editLdevDtlList = null;
    List ldevDetailList = null;
    List ldevGdList = null;
    List<SJmoLdevLuseInfo> ldevLuseList = null;
    int radioCmdDevice = 0;
    int radioSecurity = 0;
    int radioUser = 0;
    int radioDeviceGrp = 0;
    public static int EDITCMDDEV_ERR1 = 107001;
    public static int EDITCMDDEV_ERR2 = 106519;
    public static int EDITCMDDEV_ERR3 = 108006;
    public static int EDITCMDDEV_ERR4 = 108007;
    public static int EDITCMDDEV_ERR5 = 108008;
    public static int EDITCMDDEV_ERR6 = 108009;
    public static int EDITCMDDEV_ERR7 = 108010;
    public static int EDITCMDDEV_ERR8 = 108011;
    public static int EDITCMDDEV_ERR9 = 108012;
    public static int EDITCMDDEV_ERR10 = 108013;
    public static int EDITCMDDEV_ERR11 = 108014;
    public static int EDITCMDDEV_ERR12 = 108015;
    public static int EDITCMDDEV_ERR13 = 107001;
    public static int EDITCMDDEV_ERR14 = 105083;
    public static int EDITCMDDEV_ERR15 = 107001;
    public static int EDITCMDDEV_ERR16 = 105204;
    public static int EDITCMDDEV_ERR17 = 107002;
    public static int EDITCMDDEV_ERR18 = 105298;
    public static int EDITCMDDEV_ERR_ODM = 108034;
    public static int EDITCMDDEV_ERR_SysRSG_LDEV = 205165;
    public static int EDITCMDDEV_ERR_Hnas_LDEV = 205179;
    public static int LUNM_ERROR_CODE_T10PI_NOT_SUPPORT = 206295;
    public static int LUNM_ERROR_CODE_FPTVOL_LDEV = 205220;

    public SJctrEditCommandDevicesDC() throws SJcException {
        super(0x1100701);
        this.setRestoreFlg(false);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> targetList = this.getCache(KEY_CLASS_SELECT_LDEV);
        if (targetList == null) {
            ret = false;
        } else if (targetList.size() == 0) {
            ret = false;
        }
        if (ret) {
            for (Object ldevObj : targetList) {
                if (ldevObj instanceof SJmoLdevIndex) continue;
                ret = false;
            }
        }
        if (!ret) {
            SJctrError err = new SJctrError(10, 22, EDITCMDDEV_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        this.selectLdevList = targetList;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJctrErrorColumnData errData;
        SJctrErrorColumnData errData2;
        SJctrError err;
        boolean ret = true;
        SJctrError errInfo = null;
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        ArrayList<SJmoLdevIndex> errLdevList = new ArrayList<SJmoLdevIndex>(this.selectLdevList.size());
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.selectLdevList.size());
        this.ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        this.ldevGdList = this.getCache(SJmoGetLdevGuardInfo.class);
        this.ldevLuseList = this.getCache(SJmoGetLdevLuseInfo.class);
        this.originLdevDtlList = new ArrayList(this.selectLdevList.size());
        this.originLdevGDList = new ArrayList(this.selectLdevList.size());
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err2 = new SJctrError(10, 22, EDITCMDDEV_ERR17);
            SJcException exp = err2.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        if (ret) {
            for (SJmoLdevIndex originldevIndex : this.selectLdevList) {
                SJctrErrorColumnData errData3;
                int dtlIndex = Collections.binarySearch(this.ldevDetailList, originldevIndex);
                if (dtlIndex < 0) {
                    ret = false;
                    err = new SJctrError(10, 22, EDITCMDDEV_ERR2);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    errLdevList.add(originldevIndex);
                    errData2 = new SJctrErrorColumnData(originldevIndex, err);
                    errList.add(errData2);
                    continue;
                }
                this.originLdevDtlList.add((SJmoLdevDetail)this.ldevDetailList.get(dtlIndex));
                int rsgId = rsgUtil.getRsgId(originldevIndex);
                boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                if (!rsgFlg) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "Extract Impossible Ldev RSG ID = " + rsgId);
                    ret = false;
                    SJctrError err3 = new SJctrError(10, 22, EDITCMDDEV_ERR18);
                    if (errInfo == null) {
                        errInfo = err3;
                    }
                    errLdevList.add(originldevIndex);
                    SJctrErrorColumnData errData4 = new SJctrErrorColumnData(originldevIndex, err3);
                    errList.add(errData4);
                    continue;
                }
                boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(originldevIndex);
                if (sysRsgFlg) {
                    ret = false;
                    SJctrError err4 = new SJctrError(10, 22, EDITCMDDEV_ERR_SysRSG_LDEV);
                    if (errInfo == null) {
                        errInfo = err4;
                    }
                    errLdevList.add(originldevIndex);
                    SJctrErrorColumnData errData5 = new SJctrErrorColumnData(originldevIndex, err4);
                    errList.add(errData5);
                    continue;
                }
                SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.ldevDetailList.get(dtlIndex);
                if (ldevDetail.getByVolumeFlag() != 3) {
                    ret = false;
                    SJctrError err5 = new SJctrError(10, 22, EDITCMDDEV_ERR5);
                    if (errInfo == null) {
                        errInfo = err5;
                    }
                    errLdevList.add(ldevDetail);
                    errData3 = new SJctrErrorColumnData(ldevDetail, err5);
                    errList.add(errData3);
                    continue;
                }
                if (ldevDetail.getBUserLu() || ldevDetail.getBSystemLu()) {
                    ret = false;
                    SJctrError err6 = new SJctrError(10, 22, EDITCMDDEV_ERR_Hnas_LDEV);
                    if (errInfo == null) {
                        errInfo = err6;
                    }
                    errLdevList.add(ldevDetail);
                    errData3 = new SJctrErrorColumnData(ldevDetail, err6);
                    errList.add(errData3);
                    continue;
                }
                int gdlIndex = Collections.binarySearch(this.ldevGdList, originldevIndex);
                if (gdlIndex >= 0) {
                    this.originLdevGDList.add((SJmoLdevGuardInfo)this.ldevGdList.get(gdlIndex));
                    continue;
                }
                ret = false;
                SJctrError err7 = new SJctrError(10, 22, EDITCMDDEV_ERR2);
                if (errInfo == null) {
                    errInfo = err7;
                }
                errLdevList.add(originldevIndex);
                SJctrErrorColumnData errData6 = new SJctrErrorColumnData(originldevIndex, err7);
                errList.add(errData6);
            }
        }
        if (ret) {
            for (SJmoLdevGuardInfo ldevGD : this.originLdevGDList) {
                if ((ldevGD.getByLdevGuardStatus() & 8) != 8) continue;
                ret = false;
                SJctrError err8 = new SJctrError(10, 22, EDITCMDDEV_ERR3);
                if (errInfo == null) {
                    errInfo = err8;
                }
                errLdevList.add(ldevGD);
                errData = new SJctrErrorColumnData(ldevGD, err8);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevGuardInfo ldevGD : this.originLdevGDList) {
                if (ldevGD.getByLdevGuardStatus() == -128) continue;
                ret = false;
                SJctrError err9 = new SJctrError(10, 22, EDITCMDDEV_ERR4);
                if (errInfo == null) {
                    errInfo = err9;
                }
                errLdevList.add(ldevGD);
                errData = new SJctrErrorColumnData(ldevGD, err9);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbHIHSMReserve()) continue;
                ret = false;
                SJctrError err10 = new SJctrError(10, 22, EDITCMDDEV_ERR17);
                throw err10.createException();
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbSystemDisk()) continue;
                ret = false;
                SJctrError err11 = new SJctrError(10, 22, EDITCMDDEV_ERR17);
                throw err11.createException();
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbJNLVolume()) continue;
                ret = false;
                SJctrError err12 = new SJctrError(10, 22, EDITCMDDEV_ERR8);
                if (errInfo == null) {
                    errInfo = err12;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err12);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbPoolVol()) continue;
                ret = false;
                SJctrError err13 = new SJctrError(10, 22, EDITCMDDEV_ERR9);
                if (errInfo == null) {
                    errInfo = err13;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err13);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                byte volType = ldev.getByVolumeType();
                if (volType != 2) continue;
                ret = false;
                err = new SJctrError(10, 22, EDITCMDDEV_ERR10);
                if (errInfo == null) {
                    errInfo = err;
                }
                errLdevList.add(ldev);
                errData2 = new SJctrErrorColumnData(ldev, err);
                errList.add(errData2);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbRmtComDev()) continue;
                ret = false;
                SJctrError err14 = new SJctrError(10, 22, EDITCMDDEV_ERR11);
                if (errInfo == null) {
                    errInfo = err14;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err14);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getBLockVolume()) continue;
                ret = false;
                SJctrError err15 = new SJctrError(10, 22, EDITCMDDEV_ERR12);
                if (errInfo == null) {
                    errInfo = err15;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err15);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getbOdmVol()) continue;
                ret = false;
                SJctrError err16 = new SJctrError(10, 22, EDITCMDDEV_ERR_ODM);
                if (errInfo == null) {
                    errInfo = err16;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err16);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (!ldev.getBT10pi()) continue;
                ret = false;
                SJctrError err17 = new SJctrError(10, 22, LUNM_ERROR_CODE_T10PI_NOT_SUPPORT);
                if (errInfo == null) {
                    errInfo = err17;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err17);
                errList.add(errData);
            }
        }
        if (ret) {
            for (SJmoLdevDetail ldev : this.originLdevDtlList) {
                if (ldev.getByVolumeType() != 3 || !ldev.getBFPTVol()) continue;
                ret = false;
                SJctrError err18 = new SJctrError(10, 22, LUNM_ERROR_CODE_FPTVOL_LDEV);
                if (errInfo == null) {
                    errInfo = err18;
                }
                errLdevList.add(ldev);
                errData = new SJctrErrorColumnData(ldev, err18);
                errList.add(errData);
            }
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            SJctrEditCommandDeviceErrorTableModel errorTable = new SJctrEditCommandDeviceErrorTableModel();
            errorTable.setDataController(this);
            errorTable.initGuidance(this.getComUtility());
            errorTable.createModelDirect();
            errorTable.divideModelData(this.getProxy().getModelDataMap());
            errorTable.setBasicDataList(errLdevList);
            errorTable.makeDataModel();
            errDc.setParameter(errorTable, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrRadioButtonGroupDataModel cmdDevRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_CMDDEVINF);
        SJctrRadioButtonGroupDataModel cmdDevSecRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_CMDDEVSECINF);
        SJctrRadioButtonGroupDataModel userAuthRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_USERAUTHINF);
        SJctrRadioButtonGroupDataModel devGrpRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_DEVGRPINF);
        if (cmdDevRadio.getSelect() == null || cmdDevSecRadio.getSelect() == null || userAuthRadio.getSelect() == null || devGrpRadio.getSelect() == null) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, EDITCMDDEV_ERR14);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean retpp = true;
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        if (!authorizeContainer.getSystemParamContainer().isLocalHost() && !ppcontainer.checkPP(SJctrLicenseContainer.PPID_LUNM)) {
            if (this.radioCmdDevice != 1 && cmdDevRadio.getSelect().equals(KEY_ENABLE)) {
                retpp = false;
            }
            if (this.radioSecurity != 1 && cmdDevSecRadio.getSelect().equals(KEY_ENABLE)) {
                retpp = false;
            }
            if (this.radioUser != 1 && userAuthRadio.getSelect().equals(KEY_ENABLE)) {
                retpp = false;
            }
            if (this.radioDeviceGrp == 0 && !devGrpRadio.getSelect().equals(KEY_DISABLE) || this.radioDeviceGrp == 1 && !devGrpRadio.getSelect().equals(KEY_ENABLE)) {
                retpp = false;
            }
        }
        if (!retpp) {
            SJctrError err = new SJctrError(10, 22, EDITCMDDEV_ERR16);
            SJcException exp = err.createException();
            throw exp;
        }
        if (ret) {
            boolean cmdDev = false;
            boolean cmdDevSec = false;
            boolean userAuth = false;
            boolean devGrp = false;
            this.editLdevDtlList = new ArrayList(this.originLdevDtlList.size());
            for (SJmoLdevDetail ldevdtl : this.originLdevDtlList) {
                try {
                    this.editLdevDtlList.add((SJmoLdevDetail)ldevdtl.clone());
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("checkEndData", "LdevDetail clone fail", e, 40000);
                }
            }
            if (cmdDevRadio.getSelect().equals(KEY_ENABLE)) {
                cmdDev = true;
                if (cmdDevSecRadio.getSelect().equals(KEY_ENABLE)) {
                    cmdDevSec = true;
                }
                if (userAuthRadio.getSelect().equals(KEY_ENABLE)) {
                    userAuth = true;
                }
                if (devGrpRadio.getSelect().equals(KEY_ENABLE)) {
                    devGrp = true;
                }
            }
            for (SJmoLdevDetail ldev : this.editLdevDtlList) {
                ldev.setbLUPathCmdDev(cmdDev);
                ldev.setbLUPathCmdDevSec(cmdDevSec);
                ldev.setbCmdDevAuth(userAuth);
                ldev.setbDevGrpDefine(devGrp);
            }
            List<SJctrLdevDetailLUSEInfo> newLdevList = SJctrLdevUtility.getLdevDetailLUListSEInfoList(this.editLdevDtlList, this.ldevDetailList, this.ldevLuseList);
            this.putCache(SJctrEditCommandDeviceLdevDetail.class, newLdevList);
        }
        return ret;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_CMDDEVINF, this.createCmdDevRadioButtonGroup());
        this.addDataObjectModel(KEY_CMDDEVSECINF, this.createCmdDevSecRadioButtonGroup());
        this.addDataObjectModel(KEY_USERAUTHINF, this.createUserAuthenticationRadioButtonGroup());
        this.addDataObjectModel(KEY_DEVGRPINF, this.createDeviGrpDefinitionRadioButtonGroup());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevGuardInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private SJctrRadioButtonGroupDataModel createCmdDevRadioButtonGroup() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        if (this.getSelect().equals(SJctrEditCommandDevicesDC.KEY_ENABLE)) {
                            // empty if block
                        }
                    }
                });
            }

            @Override
            protected void makeDataObject() {
                int status;
                SJctrRadioButtonGroupDataModel cmdDevSec = (SJctrRadioButtonGroupDataModel)SJctrEditCommandDevicesDC.this.getDataObjectModel(SJctrEditCommandDevicesDC.KEY_CMDDEVSECINF);
                SJctrRadioButtonGroupDataModel userAuth = (SJctrRadioButtonGroupDataModel)SJctrEditCommandDevicesDC.this.getDataObjectModel(SJctrEditCommandDevicesDC.KEY_USERAUTHINF);
                SJctrRadioButtonGroupDataModel devGrpDef = (SJctrRadioButtonGroupDataModel)SJctrEditCommandDevicesDC.this.getDataObjectModel(SJctrEditCommandDevicesDC.KEY_DEVGRPINF);
                SJctrEditCommandDevicesDC.this.radioCmdDevice = status = SJctrEditCommandDevicesDC.this.getCmdDevSelect(SJctrEditCommandDevicesDC.this.originLdevDtlList);
                if (status == 0) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                    cmdDevSec.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                    userAuth.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                    devGrpDef.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                    cmdDevSec.setState(SJctrSelectableDataObject.VISIBLE_INACTIVE);
                    userAuth.setState(SJctrSelectableDataObject.VISIBLE_INACTIVE);
                    devGrpDef.setState(SJctrSelectableDataObject.VISIBLE_INACTIVE);
                } else if (status == 1) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_ENABLE);
                }
            }
        };
        radio.add(KEY_ENABLE);
        radio.add(KEY_DISABLE);
        return radio;
    }

    private SJctrRadioButtonGroupDataModel createCmdDevSecRadioButtonGroup() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        if (this.getSelect().equals(SJctrEditCommandDevicesDC.KEY_ENABLE)) {
                            // empty if block
                        }
                    }
                });
            }

            @Override
            protected void makeDataObject() {
                int status;
                SJctrEditCommandDevicesDC.this.radioSecurity = status = SJctrEditCommandDevicesDC.this.getCmdDevSecSelect(SJctrEditCommandDevicesDC.this.originLdevDtlList);
                if (status == 0) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                } else if (status == 1) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_ENABLE);
                }
            }
        };
        radio.add(KEY_ENABLE);
        radio.add(KEY_DISABLE);
        return radio;
    }

    private SJctrRadioButtonGroupDataModel createUserAuthenticationRadioButtonGroup() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        if (this.getSelect().equals(SJctrEditCommandDevicesDC.KEY_ENABLE)) {
                            // empty if block
                        }
                    }
                });
            }

            @Override
            protected void makeDataObject() {
                int status;
                SJctrEditCommandDevicesDC.this.radioUser = status = SJctrEditCommandDevicesDC.this.getUserAutehticationSelect(SJctrEditCommandDevicesDC.this.originLdevDtlList);
                if (status == 0) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                } else if (status == 1) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_ENABLE);
                }
            }
        };
        radio.add(KEY_ENABLE);
        radio.add(KEY_DISABLE);
        return radio;
    }

    private SJctrRadioButtonGroupDataModel createDeviGrpDefinitionRadioButtonGroup() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        if (this.getSelect().equals(SJctrEditCommandDevicesDC.KEY_ENABLE)) {
                            // empty if block
                        }
                    }
                });
            }

            @Override
            protected void makeDataObject() {
                int status;
                SJctrEditCommandDevicesDC.this.radioDeviceGrp = status = SJctrEditCommandDevicesDC.this.getDeviceGroupDefinitionSelect(SJctrEditCommandDevicesDC.this.originLdevDtlList);
                if (status == 0) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_DISABLE);
                } else if (status == 1) {
                    this.setSelect(SJctrEditCommandDevicesDC.KEY_ENABLE);
                }
            }
        };
        radio.add(KEY_ENABLE);
        radio.add(KEY_DISABLE);
        return radio;
    }

    private int getCmdDevSelect(List<SJmoLdevDetail> ldevList) {
        boolean status = ldevList.get(0).getbLUPathCmdDev();
        int ret = status ? 1 : 0;
        for (SJmoLdevDetail ldevDtl : ldevList) {
            if (status == ldevDtl.getbLUPathCmdDev()) continue;
            ret = -1;
            break;
        }
        return ret;
    }

    private int getCmdDevSecSelect(List<SJmoLdevDetail> ldevList) {
        boolean status = ldevList.get(0).getbLUPathCmdDevSec();
        int ret = status ? 1 : 0;
        for (SJmoLdevDetail ldevDtl : ldevList) {
            if (status == ldevDtl.getbLUPathCmdDevSec()) continue;
            ret = -1;
            break;
        }
        return ret;
    }

    private int getUserAutehticationSelect(List<SJmoLdevDetail> ldevList) {
        boolean status = ldevList.get(0).getbCmdDevAuth();
        int ret = status ? 1 : 0;
        for (SJmoLdevDetail ldevDtl : ldevList) {
            if (status == ldevDtl.getbCmdDevAuth()) continue;
            ret = -1;
            break;
        }
        return ret;
    }

    private int getDeviceGroupDefinitionSelect(List<SJmoLdevDetail> ldevList) {
        boolean status = ldevList.get(0).getbDevGrpDefine();
        int ret = status ? 1 : 0;
        for (SJmoLdevDetail ldevDtl : ldevList) {
            if (status == ldevDtl.getbDevGrpDefine()) continue;
            ret = -1;
            break;
        }
        return ret;
    }
}

