/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.addnewchapuser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;

public class SJctrAddNewChapUserDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595529;
    private static final String KEY_CHAP_USERNAME_TXT = "COM_CHAP_USERNAME";
    private static final String KEY_CHAP_SECRET_TXT = "COM_CHAP_SECRET";
    private static final String KEY_CHAP_REENTERSECRET_TXT = "COM_CHAP_REENTERSECRET";
    public static final String KEY_ADD_NEW_CHAPUSER_DATA_SELECT = "ADD_NEW_CHAPUSER_DATA_SELECT";
    public static final String KEY_ADD_NEW_CHAPUSER_DATA_INVALID = "ADD_NEW_CHAPUSER_DATA_INVALID";
    public static final String KEY_ADD_NEW_CHAPUSER_DATA_NEW_LIST = "ADD_NEW_CHAPUSER_DATA_NEW_LIST";
    public static final String KEY_ADD_NEW_CHAPUSER_DATA = "ADD_NEW_CHAPUSER_DATA";

    public SJctrAddNewChapUserDC() throws SJcException {
        super(33595529);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrTextBoxDataModel userNameTextBox = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_CHAP_USERNAME_TXT, userNameTextBox);
        SJctrTextBoxDataModel secretTextBox = new SJctrTextBoxDataModel();
        secretTextBox.setTrim(false);
        this.addDataObjectModel(KEY_CHAP_SECRET_TXT, secretTextBox);
        SJctrTextBoxDataModel reEnterSecretTextBox = new SJctrTextBoxDataModel();
        reEnterSecretTextBox.setTrim(false);
        this.addDataObjectModel(KEY_CHAP_REENTERSECRET_TXT, reEnterSecretTextBox);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_SELECT);
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> invalidList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_INVALID);
        if (null == invalidList) {
            this.logUty.putlog("checkStartData", "CHAP User name Invalid list is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> newChapList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_NEW_LIST);
        if (null == newChapList) {
            this.logUty.putlog("checkStartData", "New CHAP user data list is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        List<?> viewDataList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_SELECT);
        if (viewDataList.size() > 0) {
            SJctrChapUserInfoIncludeNewChap viewData0 = (SJctrChapUserInfoIncludeNewChap)viewDataList.get(0);
            String strString0 = viewData0.getStrUserName();
            for (int index = 1; index < viewDataList.size(); ++index) {
                SJctrChapUserInfoIncludeNewChap viewData = (SJctrChapUserInfoIncludeNewChap)viewDataList.get(index);
                String compareString = viewData.getStrUserName();
                if (compareString.equals(strString0)) continue;
                strString0 = "";
                break;
            }
            SJctrTextBoxDataModel chapUserNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USERNAME_TXT);
            chapUserNameText.setValue(strString0);
        }
        SJctrTextBoxDataModel chapUserNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USERNAME_TXT);
        chapUserNameText.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
        SJctrTextBoxDataModel chapSecretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_SECRET_TXT);
        chapSecretText.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean result;
        HashSet userNameHashSet = null;
        List<?> invlidList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_INVALID);
        List<?> newChapList = this.getCache(KEY_ADD_NEW_CHAPUSER_DATA_NEW_LIST);
        SJctrTextBoxDataModel chapUserNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_USERNAME_TXT);
        String strUserName = chapUserNameText.getValue();
        SJctrTextBoxDataModel chapSecretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_SECRET_TXT);
        String strSecret = chapSecretText.getValue();
        SJctrTextBoxDataModel chapReEnterSecretText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_CHAP_REENTERSECRET_TXT);
        String strReEnterSecret = chapReEnterSecretText.getValue();
        if (strUserName.length() == 0) {
            this.logUty.putlog("checkEndData", "Entered User Name is blank string.");
            SJctrError err = new SJctrError(12, 22, 206197);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!strSecret.equals(strReEnterSecret)) {
            this.logUty.putlog("checkEndData", "Secret and Re-Enter does not match.");
            SJctrError err = new SJctrError(12, 22, 206221);
            SJcException exp = err.createException();
            throw exp;
        }
        if (invlidList.size() > 0 && (result = (userNameHashSet = (HashSet)invlidList.get(0)).contains(strUserName))) {
            this.logUty.putlog("checkEndData", "Entered User name is already exist.");
            SJctrError err = new SJctrError(12, 22, 206216);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrChapUserInfoIncludeNewChap chapInfo : newChapList) {
            if (!chapInfo.getStrUserName().equals(strUserName) || !chapInfo.getStrSecret().equals(strSecret)) continue;
            this.logUty.putlog("checkEndData", "Entered CHAP user info is already exist.");
            SJctrError err = new SJctrError(12, 22, 206217);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoChapUserInfo addChapUserInfo = new SJmoChapUserInfo();
        addChapUserInfo.setStrUserName(strUserName);
        addChapUserInfo.setStrSecret(strSecret);
        SJctrChapUserInfoIncludeNewChap addNewChapInfo = new SJctrChapUserInfoIncludeNewChap(addChapUserInfo, -1, true);
        ArrayList<SJctrChapUserInfoIncludeNewChap> addList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        addList.add(addNewChapInfo);
        this.putCache(KEY_ADD_NEW_CHAPUSER_DATA, addList);
        ArrayList<Integer> dispIdList = new ArrayList<Integer>();
        dispIdList.add(33595529);
        this.putCache("KEY_SEL_ISCSI_EXIT_DISP_ID", dispIdList);
        return true;
    }
}

