/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrOperationIscsiBaseAC;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public abstract class SJctrOperationIscsiNameBaseAc
extends SJctrOperationIscsiBaseAC {
    private static final long serialVersionUID = 448090736321807407L;
    protected List<SJctrIscsiNameWithTgInfo> applyInfo = new ArrayList<SJctrIscsiNameWithTgInfo>();

    @Override
    protected void setDetailError(SanResponse resultObject) throws SanDataException {
        SanList iScsiPortList = resultObject.getList("iScsiPorts");
        if (null == iScsiPortList) {
            SJctrLogUty.info(this.title, "setDetailError", "iScsiPortList is null.");
        } else {
            for (SanObject iScsiPort : iScsiPortList) {
                SanList iScsiTargetList = iScsiPort.getList("iScsiTargets");
                for (SanObject iScsiTarget : iScsiTargetList) {
                    SanList iScsiNameList = iScsiTarget.getList("RemoteiScsiNames");
                    for (SanObject iScsiName : iScsiNameList) {
                        SanObject errInfo = iScsiName.getObj("ErrorInfo");
                        int[] errMsgId = errInfo.getIntArray("MessageId");
                        if (0 == errMsgId[1]) continue;
                        SJmoIscsiName iscsiNameInfo = new SJmoIscsiName();
                        iscsiNameInfo.setSPort((short)iScsiPort.getInt("Id"));
                        iscsiNameInfo.setStrIscsiName(iScsiName.getString("Name"));
                        SJmoIscsiTargetInfo iScsiTargetInfo = new SJmoIscsiTargetInfo();
                        iScsiTargetInfo.setSPort((short)iScsiPort.getInt("Id"));
                        iScsiTargetInfo.setSIscsiTarget((short)iScsiTarget.getInt("Id"));
                        SJctrIscsiNameWithTgInfo key = new SJctrIscsiNameWithTgInfo(iscsiNameInfo, iScsiTargetInfo);
                        SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId, key);
                        this.resultData.add(iscsiError);
                    }
                }
            }
        }
    }

    @Override
    public int getLeadTime() {
        int leadTime = SJctrIscsiUtility.getLeadTime(this.applyInfo.size(), 1.0, 3200.0);
        return leadTime;
    }
}

