/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationErrorForIscsiTarget;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsConfirmTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsSelectedTableModelErrorDetail;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilIscsiTarget;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJctrCreateIscsiTargetsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16802063;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_DETAIL = "COM_DETAIL";

    public SJctrCreateIscsiTargetsConfirmDC() throws SJcException {
        super(16802063);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrCreateIscsiTargetsConfirmTableDataModel tblIscsi = new SJctrCreateIscsiTargetsConfirmTableDataModel();
        tblIscsi.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, tblIscsi);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateIscsiTargetsConfirmDC.this.fireMessageEvent(CREATE_TARGETS_CNF_MSG.SELECT_DETAIL);
            }
        });
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_TARGETS_CNF_MSG.SELECT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateIscsiTargetsConfirmDC.this.actionDetail(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        try {
            List<?> listConfirmData = this.getCache(SJctrCreateIscsiTargetsConfirmData.class);
            if (listConfirmData == null || listConfirmData.size() == 0) {
                throw SJctrIscsiUtility.makeException(107005);
            }
            SJctrCreateIscsiTargetsConfirmData confirmData = (SJctrCreateIscsiTargetsConfirmData)listConfirmData.get(0);
            if (confirmData == null) {
                throw SJctrIscsiUtility.makeException(107005);
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107005);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrCreateIscsiTargetsConfirmData confirmData = (SJctrCreateIscsiTargetsConfirmData)this.getProxy().getCache(SJctrCreateIscsiTargetsConfirmData.class).get(0);
            SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
            if (table instanceof SJctrCreateIscsiTargetsConfirmTableDataModel) {
                ((SJctrCreateIscsiTargetsConfirmTableDataModel)table).setBasicDataList(confirmData.getIscsiTargetList());
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107005);
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        List<?> listConfirmData = this.getCache(SJctrCreateIscsiTargetsConfirmData.class);
        HashMap retMap = new HashMap();
        retMap.put(SJctrCreateIscsiTargetsConfirmData.class.getName(), listConfirmData);
        return retMap;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) {
        List<?> confirmDataList = this.getCache(SJctrCreateIscsiTargetsConfirmData.class);
        SJctrCreateIscsiTargetsConfirmData confirmData = (SJctrCreateIscsiTargetsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrCreateIscsiTargetsConfirmData confirmData = (SJctrCreateIscsiTargetsConfirmData)this.getProxy().getCache(SJctrCreateIscsiTargetsConfirmData.class).get(0);
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<SJctrCreateIscsiTargetInfo> rowDataList = confirmData.getIscsiTargetList();
        Collections.sort(rowDataList);
        for (SJctrIscsiOperationErrorForIscsiTarget error : errorList) {
            SJmoIscsiTargetIndex iscsiTargetIndex = new SJmoIscsiTargetIndex();
            iscsiTargetIndex.setSPort(error.getPortId());
            iscsiTargetIndex.setSIscsiTarget(error.getIscsiTargetId());
            int index = Collections.binarySearch(rowDataList, iscsiTargetIndex);
            if (0 > index) continue;
            SJmoIscsiTargetInfo createIscsiInfo = rowDataList.get(index);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(createIscsiInfo, error);
            errColumnList.add(errColumn);
        }
        SJctrCreateIscsiTargetsSelectedTableModelErrorDetail errTable = new SJctrCreateIscsiTargetsSelectedTableModelErrorDetail(errColumnList);
        errTable.setBasicDataMap(confirmData.getNeedDataMap());
        errTable.setBasicDataList(rowDataList);
        errTable.initGuidance(this.getComUtility());
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.makeDataModel();
    }

    private void actionDetail(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            HashMap param = new HashMap();
            SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedRows = selectedTable.getSelectedRowData();
            param.put("KEY_SELECTED_ISCSI_TARGETS", selectedRows);
            param.put(SJmoGetPortDetail.class.getName(), SJctrIscsiUtility.getSJmoPortDetailList(this));
            param.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this));
            SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrIscsiTargetPropertiesDC.class, param);
            this.addUpdateDisp(dialogRelated);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    @Override
    public List<SJmoRscUtil> getRscUtil() {
        List<SJmoRscUtil> rscUtilList = this.getCache(SJmoGetRscUtilIscsiTarget.class);
        return rscUtilList;
    }

    public static enum CREATE_TARGETS_CNF_MSG implements SJctrNotifyState
    {
        SELECT_DETAIL;

    }
}

