/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsConfirmTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrDeleteIscsiTargetsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17871141;
    private static final String KEY_TABLE_SEL_ISCSI_TARGETS = "COM_TABLE";
    private static final String KEY_BTN_DETAIL = "COM_DETAIL";

    public SJctrDeleteIscsiTargetsConfirmDC() throws SJcException {
        super(17871141);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrDeleteIscsiTargetsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrDeleteIscsiTargetsConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrDeleteIscsiTargetsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    protected void initDataModel() {
        SJctrDeleteIscsiTargetsConfirmTableDataModel tableDeleteIscsiTargets = new SJctrDeleteIscsiTargetsConfirmTableDataModel();
        tableDeleteIscsiTargets.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS, tableDeleteIscsiTargets);
        SJctrButtonDataModel detailBtn = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BTN_DETAIL, detailBtn);
        detailBtn.addEventListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrDeleteIscsiTargetsConfirmDC.this.fireMessageEvent(DELETE_TARGETS_MSG.BTN_DETAIL);
            }
        });
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrDeleteIscsiTargetsConfirmData.class);
        SJctrDeleteIscsiTargetsConfirmData confirmData = (SJctrDeleteIscsiTargetsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
        if (confirmTable instanceof SJctrDeleteIscsiTargetsConfirmTableDataModel) {
            SJctrDeleteIscsiTargetsConfirmData confirmData = (SJctrDeleteIscsiTargetsConfirmData)this.getProxy().getCache(SJctrDeleteIscsiTargetsConfirmData.class).get(0);
            List<SJmoIscsiTargetInfo> rowDataList = confirmData.getIscsiTargetList();
            Collections.sort(rowDataList, new SJctrIscsiTargetAliasComparator());
            ((SJctrDeleteIscsiTargetsConfirmTableDataModel)confirmTable).setBasicDataList(rowDataList);
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrDeleteIscsiTargetsConfirmData.class);
        retMap.put(SJctrDeleteIscsiTargetsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrDeleteIscsiTargetsConfirmData confirmData = (SJctrDeleteIscsiTargetsConfirmData)this.getProxy().getCache(SJctrDeleteIscsiTargetsConfirmData.class).get(0);
        List<SJmoIscsiTargetInfo> rowDataList = confirmData.getIscsiTargetList();
        SJctrDeleteIscsiTargetsConfirmTableDataModel confirmTable = (SJctrDeleteIscsiTargetsConfirmTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
        confirmTable.setBasicDataList(rowDataList);
        confirmTable.setBasicData(SJmoGetPortDetail.class, confirmData.getNeedDataMap().get(SJmoGetPortDetail.class.getName()));
        confirmTable.setBasicData(SJmoGetPortAttributeInfo.class, confirmData.getNeedDataMap().get(SJmoGetPortAttributeInfo.class.getName()));
        confirmTable.makeDataModel();
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        ArrayList<SJmoIscsiTargetInfo> searchRowDataList = new ArrayList<SJmoIscsiTargetInfo>(rowDataList);
        Collections.sort(searchRowDataList);
        for (SJctrIscsiOperationError error : errorList) {
            int index = Collections.binarySearch(searchRowDataList, error.getKey());
            if (0 > index) continue;
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData((SJmoIscsiTargetInfo)searchRowDataList.get(index), error);
            errColumnList.add(errColumn);
        }
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS, errTable);
        errTable.initialize(confirmTable, errColumnList, new SJctrErrorColumnDataComparator());
    }

    protected void initListener() {
        this.addMessageEventListener(DELETE_TARGETS_MSG.BTN_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDeleteIscsiTargetsConfirmDC.this.actionDetail(event, dstModel);
            }
        });
    }

    private void actionDetail(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrTableDataModel targetsTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSI_TARGETS);
            List<Object> selectedRows = targetsTable.getSelectedRowData();
            if (selectedRows.isEmpty()) {
                this.logUty.putlog("actionDetail", "iSCSI Target isn't selected.");
                return;
            }
            HashMap map = new HashMap();
            map.put("KEY_SELECTED_ISCSI_TARGETS", selectedRows);
            map.put(SJmoGetPortDetail.class.getName(), SJctrIscsiUtility.getSJmoPortDetailList(this));
            map.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this));
            SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrIscsiTargetPropertiesDC.class, map);
            this.addUpdateDisp(relatedObj);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    public static enum DELETE_TARGETS_MSG implements SJctrNotifyState
    {
        BTN_DETAIL;

    }
}

