/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcSystemUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrHostModeOptionTableKey;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrHostModeOptionsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrEditIscsiTargetsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831825;
    private static final String DISP_TITLE = "EDIT_ISCSI_TARGETS";
    public static final String KEY_ISCSI_TARGET_NAME_TITLE = "COM_ISCSI_TARGET_NAME_TITLE";
    private static final String KEY_ISCSI_TARGET_NAME_TEXT = "COM_ISCSI_TARGET_NAME_TEXT";
    private static final String KEY_ISCSI_TARGET_TYPE_RADIO = "COM_ISCSI_TARGET_TYPE_RADIO";
    public static final String KEY_ISCSI_TARGET_ALIAS_TITLE = "COM_ISCSI_TARGET_ALIAS_TITLE";
    private static final String KEY_ISCSI_TARGET_ALIAS_TEXT = "COM_ISCSI_TARGET_ALIAS_TEXT";
    public static final String KEY_HOST_MODE_TITLE = "COM_HOST_MODE_TITLE";
    private static final String KEY_HOST_MODE_COMBO = "COM_HOST_MODE_COMBO";
    private static final String KEY_HOST_MODE_OPT_TABLE = "COM_HOST_MODE_OPT_TABLE";
    public static final String KEY_CHAP_AUTH_TITLE = "COM_CHAP_AUTH_TITLE";
    private static final String KEY_CHAP_AUTH_COMBO = "COM_CHAP_AUTH_COMBO";
    public static final String KEY_AUTH_MODE_TITLE = "COM_AUTH_MODE_TITLE";
    private static final String KEY_AUTH_MODE_RADIO = "COM_AUTH_MODE_RADIO";
    public static final String KEY_USER_NAME_TITLE = "COM_USER_NAME_TITLE";
    private static final String KEY_USER_NAME_TEXT = "COM_USER_NAME_TEXT";
    public static final String KEY_SECRET_TITLE = "COM_SECRET_TITLE";
    private static final String KEY_SECRET_TEXT = "COM_SECRET_TEXT";
    private static final String KEY_REENT_SECRET_TITLE = "COM_REENT_SECRET_TITLE";
    private static final String KEY_REENT_SECRET_TEXT = "COM_REENT_SECRET_TEXT";
    private static final String KEY_CHECKBOX = "COM_CHECKBOX";
    private static final String KEY_SELECTED_ISCSI_TARGETS = "KEY_SELECTED_ISCSI_TARGETS";
    private static final String KEY_NEW_TARGETS = "KEY_NEW_TARGETS";
    private static final String HM_RESERVE_FORMAT = "[0-9A-F]+ \\[Reserve\\]";
    private static final String KEY_RADIO_IQN = "COM_IQN";
    private static final String KEY_RADIO_EUI = "COM_EUI";
    private static final String KEY_RADIO_UNIDIRECT = "COM_UNIDIRECTIONAL";
    private static final String KEY_RADIO_MUTUAL = "COM_MUTUAL";
    private boolean isDuplicatePort = false;
    private boolean isExistEmptyUserName = false;
    Map<Short, Set<String>> aliasCheckMap = null;
    Map<Short, Set<String>> tgNameCheckMap = null;
    Map<Short, Set<String>> tgChapCheckMap = null;
    Set<SJmoIscsiTargetIndex> disableUvmHostModeTargetSet = null;

    public SJctrEditIscsiTargetsDC() throws SJcException {
        super(17831825);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJctrGetSystemOption();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrSimpleDataModel targetAliasTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TITLE, targetAliasTitle);
        targetAliasTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel targetNameTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_ISCSI_TARGET_NAME_TITLE, targetNameTitle);
        targetNameTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrRadioButtonGroupDataModel targetNameRadio = new SJctrRadioButtonGroupDataModel();
        targetNameRadio.add(KEY_RADIO_IQN);
        targetNameRadio.add(KEY_RADIO_EUI);
        this.addDataObjectModel(KEY_ISCSI_TARGET_TYPE_RADIO, SJctrIscsiUtility.addItemSelectEventListener(targetNameRadio, EDIT_ISCSI_TARGET_MSG.SEL_TARGET));
        this.addDataObjectModel(KEY_ISCSI_TARGET_NAME_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel hostModeTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_HOST_MODE_TITLE, hostModeTitle);
        hostModeTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_HOST_MODE_COMBO, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_HOST_MODE));
        SJctrHostModeOptionsTableModel hostModeOptTable = new SJctrHostModeOptionsTableModel();
        hostModeOptTable.setPaging(false);
        this.addDataObjectModel(KEY_HOST_MODE_OPT_TABLE, hostModeOptTable);
        SJctrSimpleDataModel chapAuthTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_CHAP_AUTH_TITLE, chapAuthTitle);
        chapAuthTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_CHAP_AUTH_COMBO, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel authModeTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_AUTH_MODE_TITLE, authModeTitle);
        authModeTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrRadioButtonGroupDataModel authModeRadio = new SJctrRadioButtonGroupDataModel();
        authModeRadio.add(KEY_RADIO_UNIDIRECT);
        authModeRadio.add(KEY_RADIO_MUTUAL);
        this.addDataObjectModel(KEY_AUTH_MODE_RADIO, SJctrIscsiUtility.addItemSelectEventListener(authModeRadio, EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel userNameTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_USER_NAME_TITLE, userNameTitle);
        userNameTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_USER_NAME_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel secretTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_SECRET_TITLE, secretTitle);
        secretTitle.addDataModel(KEY_CHECKBOX, SJctrIscsiUtility.addItemSelectEventListener(new SJctrCheckBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel(KEY_SECRET_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        SJctrSimpleDataModel reEntsecretTitle = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_REENT_SECRET_TITLE, reEntsecretTitle);
        reEntsecretTitle.addDataModel(KEY_CHECKBOX, new SJctrCheckBoxDataModel());
        this.addDataObjectModel(KEY_REENT_SECRET_TEXT, SJctrIscsiUtility.addTextChangeEventListener(new SJctrTextBoxDataModel(), EDIT_ISCSI_TARGET_MSG.SEL_CHANGE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_ISCSI_TARGET_MSG.SEL_CHANGE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_ISCSI_TARGET_MSG.SEL_TARGET, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionTargetNameRadioBtn(event, dstModel);
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_ISCSI_TARGET_MSG.SEL_HOST_MODE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionHostModePullDown(event, dstModel);
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_ISCSI_TARGET_MSG.SEL_ENABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionHostModeOptEnableBtn(event, dstModel);
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
        this.addMessageEventListener(EDIT_ISCSI_TARGET_MSG.SEL_DISABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditIscsiTargetsDC.this.actionHostModeOptDisableBtn(event, dstModel);
                SJctrEditIscsiTargetsDC.this.actionChangeEvent(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        List<?> iscsiTargetList = this.getCache(KEY_SELECTED_ISCSI_TARGETS);
        if (iscsiTargetList == null || iscsiTargetList.size() == 0) {
            this.getLogUty().putlog("checkStartData", "Inherited list data is invalid.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoIscsiTargetInfo> selectedTargetList = this.getCache(KEY_SELECTED_ISCSI_TARGETS);
            SJctrIscsiUtility.getSJmoPortDetailList(this);
            SJctrIscsiUtility.getSJmoPortAttributeInfoList(this);
            SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            SJctrIscsiUtility.getSJmoSubsystemInfo(this);
            SJctrIscsiUtility.getSystemOptionInfo(this);
            SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this);
            SJctrIscsiUtility.getSJmoLdevDetail(this);
            SJctrIscsiUtility.getSJmoPortLunInfo(this);
            List<SJmoPortIscsiTargetInfo> portTargetList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            List<SJmoIscsiTargetInfo> editTargetList = this.checkAndGetIscsiTargetInfo(portTargetList, selectedTargetList);
            this.putCache(KEY_NEW_TARGETS, editTargetList);
            SJmoIscsiTargetInfo baseInfo = editTargetList.get(0);
            Boolean disAgreeTargetAlias = false;
            Boolean disAgreeTargetType = false;
            Boolean disAgreeTargetName = false;
            Boolean disAgreeHostMode = false;
            Boolean disAgreeChapAuth = false;
            Boolean disAgreeAuthMode = false;
            Boolean disAgreeChapUser = false;
            BitSet disAgreeHostModeOpts = new BitSet();
            short portId = baseInfo.getSPort();
            String inputTargetAlias = baseInfo.getStrIscsiTargetAlias();
            String inputTargetNameType = SJctrIscsiUtility.isIqn(baseInfo) ? "iqn." : "eui.";
            String inputTargetName = baseInfo.getStrIscsiTargetName();
            int inputHostMode = baseInfo.getIHostMode();
            BitSet inputHostModeOpts = (BitSet)baseInfo.getBtOption().clone();
            int inputChapAuth = baseInfo.getiUserAuthentSwitch();
            int inputAuthMode = baseInfo.getiAuthentMode();
            String inputUserName = baseInfo.getStrTargetUserName();
            if (baseInfo.getStrTargetUserName().length() == 0) {
                this.isExistEmptyUserName = true;
            }
            HashSet<Short> duplicatePortSet = new HashSet<Short>();
            duplicatePortSet.add(portId);
            if (editTargetList.size() > 1) {
                for (int idx = 1; idx < editTargetList.size(); ++idx) {
                    SJmoIscsiTargetInfo checkInfo = editTargetList.get(idx);
                    duplicatePortSet.add(checkInfo.getSPort());
                    if (!disAgreeTargetAlias.booleanValue() && !inputTargetAlias.equals(checkInfo.getStrIscsiTargetAlias())) {
                        disAgreeTargetAlias = true;
                        inputTargetAlias = "";
                    }
                    if (!disAgreeTargetType.booleanValue() && !checkInfo.getStrIscsiTargetName().startsWith(inputTargetNameType)) {
                        disAgreeTargetType = true;
                        inputTargetNameType = "";
                    }
                    if (!disAgreeTargetName.booleanValue() && !inputTargetName.equals(checkInfo.getStrIscsiTargetName())) {
                        disAgreeTargetName = true;
                        inputTargetName = "";
                    }
                    if (!disAgreeHostMode.booleanValue() && inputHostMode != checkInfo.getIHostMode()) {
                        disAgreeHostMode = true;
                        inputHostMode = -1;
                    }
                    BitSet btXorResult = (BitSet)inputHostModeOpts.clone();
                    btXorResult.xor(checkInfo.getBtOption());
                    disAgreeHostModeOpts.or(btXorResult);
                    if (!disAgreeChapAuth.booleanValue() && inputChapAuth != checkInfo.getiUserAuthentSwitch()) {
                        disAgreeChapAuth = true;
                        inputChapAuth = -1;
                    }
                    if (!disAgreeAuthMode.booleanValue() && inputAuthMode != checkInfo.getiAuthentMode()) {
                        disAgreeAuthMode = true;
                        inputAuthMode = -1;
                    }
                    if (!disAgreeChapUser.booleanValue() && !inputUserName.equals(checkInfo.getStrTargetUserName())) {
                        disAgreeChapUser = true;
                        inputUserName = "";
                    }
                    if (checkInfo.getStrTargetUserName().length() != 0) continue;
                    this.isExistEmptyUserName = true;
                }
            }
            if (editTargetList.size() != duplicatePortSet.size()) {
                this.isDuplicatePort = true;
            }
            this.initializeIscsiTargetAliasArea(inputTargetAlias);
            this.initializeIscsiTargetNameArea(inputTargetNameType, inputTargetName);
            this.initializeHostModeArea(disAgreeHostMode, inputHostMode, disAgreeHostModeOpts, inputHostModeOpts);
            this.initializeChapAuthArea(disAgreeChapAuth, inputChapAuth);
            this.initializeAuthModeArea(inputAuthMode);
            this.initializeUserNameArea(inputUserName);
            this.initializeSecretArea();
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    private List<SJmoIscsiTargetInfo> checkAndGetIscsiTargetInfo(List<SJmoPortIscsiTargetInfo> modelIscsiTargetList, List<SJmoIscsiTargetInfo> selectIscsiTgList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>(selectIscsiTgList.size());
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoIscsiTargetInfo iscsiTgInfo : selectIscsiTgList) {
            SJmoIscsiTargetInfo searchTgInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(modelIscsiTargetList, (SJmoIscsiTargetIndex)iscsiTgInfo);
            if (searchTgInfo != null) {
                iscsiTargetList.add(searchTgInfo);
                continue;
            }
            this.getLogUty().putlog("checkAndGetIscsiTargetInfo", "Not found iSCSI Taget data. Target# : " + iscsiTgInfo.getIndexKey());
            SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(iscsiTgInfo, SJctrIscsiUtility.makeError(206513));
            errColumnList.add(errColumnData);
        }
        if (errColumnList.size() > 0) {
            this.displayIscsiTargetErrorTable(selectIscsiTgList, errColumnList);
        }
        return iscsiTargetList;
    }

    private void displayIscsiTargetErrorTable(List<SJmoIscsiTargetInfo> iscsiTgList, List<SJctrErrorColumnData> errColumnList) {
        Collections.sort(iscsiTgList, new SJctrIscsiTargetAliasComparator());
        SJctrEditIscsiTargetsErrorTableModel errTable = new SJctrEditIscsiTargetsErrorTableModel();
        errTable.setDataController(this);
        errTable.setBasicDataList(iscsiTgList);
        errTable.initGuidance(this.getComUtility());
        errTable.setBasicData(this);
        errTable.makeDataModel();
        SJctrRelatedDispDataObject relObj = this.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(relObj);
        errDc.setParameter(errTable, errColumnList);
        SJctrError errInfo = errDc.getRepresentativeError(errColumnList);
        SJcException exp = errInfo.createException();
        exp.setErrDisp(relObj);
        throw exp;
    }

    private SJctrCheckBoxDataModel getCheckBoxDataModelinTitle(String titleKey) {
        SJctrCheckBoxDataModel checkBox = null;
        SJctrSimpleDataModel title = (SJctrSimpleDataModel)this.getDataObjectModel(titleKey);
        if (title != null) {
            checkBox = (SJctrCheckBoxDataModel)title.getDataModel(KEY_CHECKBOX);
        }
        return checkBox;
    }

    private boolean isSelectCheckBoxinTitle(String titleKey) {
        boolean ret = false;
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(titleKey);
        if (checkBox != null) {
            ret = checkBox.isSelect();
        }
        return ret;
    }

    private void initializeIscsiTargetAliasArea(String iscsiTargetAlias) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_ISCSI_TARGET_ALIAS_TITLE);
        checkBox.setSelect(false);
        SJctrTextBoxDataModel targetAliasText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TEXT);
        targetAliasText.setValue("");
        targetAliasText.setLabel("(-)");
        if (this.isDuplicatePort) {
            checkBox.setEnable(false);
            targetAliasText.setEnable(false);
        } else {
            targetAliasText.setValue(iscsiTargetAlias);
            targetAliasText.setLabel(this.getComUtility().getGuidance("ISCSITGT_ALIAS_MAX_CHAR"));
        }
    }

    private void initializeIscsiTargetNameArea(String iscsiTargetNameType, String iscsiTargetName) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_ISCSI_TARGET_NAME_TITLE);
        checkBox.setSelect(false);
        SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_TYPE_RADIO);
        SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_NAME_TEXT);
        targetNameText.setValue("");
        targetNameText.setLabel("(-)");
        if (this.isDuplicatePort) {
            checkBox.setEnable(false);
            targetNameRadio.setEnable(false);
            targetNameText.setEnable(false);
        } else if (SJctrIscsiUtility.isIqn(iscsiTargetNameType)) {
            targetNameRadio.setSelect(KEY_RADIO_IQN);
            targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_IQN_SET_MAX_CHAR"));
            targetNameText.setValue(iscsiTargetName.replaceFirst("iqn.", ""));
        } else if (SJctrIscsiUtility.isEui(iscsiTargetNameType)) {
            targetNameRadio.setSelect(KEY_RADIO_EUI);
            targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_EUI_SET_MAX_CHAR"));
            targetNameText.setValue(iscsiTargetName.replaceFirst("eui.", ""));
        } else {
            targetNameText.setEnable(false);
        }
    }

    private void initializeHostModeArea(boolean disAgreeHostMode, int hostMode, BitSet disAgreeHostModeOpts, BitSet hostModeOpts) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_HOST_MODE_TITLE);
        checkBox.setSelect(false);
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HOST_MODE_COMBO);
        if (disAgreeHostMode) {
            comboBox.addItem(Integer.toString(-1), "");
        }
        boolean bReserveOption = SJctrIscsiUtility.getHostModeReserveOption(this);
        Pattern pattern = Pattern.compile(HM_RESERVE_FORMAT);
        for (int byHostMode = 0; byHostMode < 80; byHostMode = (int)((byte)(byHostMode + 1))) {
            String strHostMode = this.getComUtility().getPortUtility().toHostModeDisplay((byte)byHostMode);
            if (!bReserveOption && pattern.matcher(strHostMode).matches() && byHostMode != hostMode) continue;
            comboBox.addItem(Byte.toString((byte)byHostMode), strHostMode);
        }
        if (disAgreeHostMode) {
            comboBox.setSelectedIndex(0);
        } else {
            comboBox.setSelection(Integer.toString(hostMode));
        }
        SJctrHostModeOptionsTableModel hostModeOptionsTable = (SJctrHostModeOptionsTableModel)this.getDataObjectModel(KEY_HOST_MODE_OPT_TABLE);
        hostModeOptionsTable.setBasicDataList(this.makeHMOptBasicData(bReserveOption, disAgreeHostModeOpts, hostModeOpts));
    }

    private List<SJctrHostModeOptionTableKey> makeHMOptBasicData(boolean bReserve, BitSet disAgreeOpts, BitSet hostModeOpts) {
        SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
        ArrayList<SJctrHostModeOptionTableKey> retList = new ArrayList<SJctrHostModeOptionTableKey>();
        for (int optionNum = 0; optionNum < 128; ++optionNum) {
            if (!disAgreeOpts.get(optionNum)) {
                if (!hostModeOpts.get(optionNum)) {
                    boolean bReserveStr;
                    if (!bReserve && (bReserveStr = portUtil.toExplanationDisplay(optionNum).equals("Reserved"))) continue;
                    retList.add(new SJctrHostModeOptionTableKey(optionNum, 0));
                    continue;
                }
                retList.add(new SJctrHostModeOptionTableKey(optionNum, 1));
                continue;
            }
            retList.add(new SJctrHostModeOptionTableKey(optionNum, 2));
        }
        return retList;
    }

    private void initializeChapAuthArea(boolean disAgreeChapAuth, int chapAuth) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_CHAP_AUTH_TITLE);
        checkBox.setSelect(false);
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_COMBO);
        if (disAgreeChapAuth) {
            comboBox.addItem("", "");
        }
        SJctrIscsiUtility utility = this.getComUtility().getIscsiUtility();
        for (int nSetValue : SJctrIscsiDataMacro.TARGET_AUTH_SW_LIST) {
            comboBox.addItem(String.valueOf(nSetValue), utility.getIscsiTargetAutheString(nSetValue));
        }
        if (disAgreeChapAuth) {
            comboBox.setSelectedIndex(0);
        } else {
            comboBox.setSelection(String.valueOf(chapAuth));
        }
    }

    private void initializeAuthModeArea(int authMode) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_AUTH_MODE_TITLE);
        checkBox.setSelect(false);
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        if (this.isDuplicatePort && this.isExistEmptyUserName) {
            radioBtnGrp.setEnable(KEY_RADIO_MUTUAL, false);
            radioBtnGrp.setSelect(KEY_RADIO_UNIDIRECT);
        } else if (authMode == 0) {
            radioBtnGrp.setSelect(KEY_RADIO_UNIDIRECT);
        } else if (authMode == 1) {
            radioBtnGrp.setSelect(KEY_RADIO_MUTUAL);
        }
    }

    private void initializeUserNameArea(String userName) {
        SJctrCheckBoxDataModel checkBox = this.getCheckBoxDataModelinTitle(KEY_USER_NAME_TITLE);
        checkBox.setSelect(false);
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TEXT);
        if (this.isDuplicatePort) {
            checkBox.setEnable(false);
            textBox.setEnable(false);
            textBox.setLabel("(-)");
        } else {
            textBox.setValue(userName);
            textBox.setLabel(this.getComUtility().getGuidance("ISCSI_USER_NAME_SET_MAX_CHAR"));
        }
    }

    private void initializeSecretArea() {
        SJctrCheckBoxDataModel secretCheckBox = this.getCheckBoxDataModelinTitle(KEY_SECRET_TITLE);
        SJctrCheckBoxDataModel reEnterCheckBox = this.getCheckBoxDataModelinTitle(KEY_REENT_SECRET_TITLE);
        secretCheckBox.setSelect(false);
        reEnterCheckBox.setSelect(false);
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT);
        SJctrTextBoxDataModel reEnterTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_REENT_SECRET_TEXT);
        secretTextBox.setTrim(false);
        reEnterTextBox.setTrim(false);
        if (this.isDuplicatePort && this.isExistEmptyUserName) {
            secretCheckBox.setEnable(false);
            reEnterCheckBox.setEnable(false);
            secretTextBox.setEnable(false);
            reEnterTextBox.setEnable(false);
            secretTextBox.setLabel("(-)");
        } else {
            secretTextBox.setValue("");
            reEnterTextBox.setValue("");
            secretTextBox.setLabel(this.getComUtility().getGuidance("ISCSI_SECRET_SET_MAX_CHAR"));
        }
        SJctrSimpleDataModel reEnter = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_REENT_SECRET_TITLE);
        ((SJctrDataObject)reEnter.getManageData()).setData("COM_DISPSTATE", 1);
    }

    private void actionTargetNameRadioBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_NAME_TEXT);
            SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_TYPE_RADIO);
            SJctrComUtility comUtil = this.getComUtility();
            SJctrIscsiUtility iscsiUtil = comUtil.getIscsiUtility();
            if (targetNameRadio.getSelect().equals(KEY_RADIO_IQN)) {
                SJmoSubsystemInfo subsysInfo = SJctrIscsiUtility.getSJmoSubsystemInfo(this);
                targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_IQN_SET_MAX_CHAR"));
                String defaultName = iscsiUtil.getDefTargetIqnTopName(subsysInfo);
                List<?> selectedIscsiTgList = this.getCache(KEY_NEW_TARGETS);
                if (selectedIscsiTgList.size() == 1) {
                    SJmoIscsiTargetInfo editIscsiTarget = (SJmoIscsiTargetInfo)selectedIscsiTgList.get(0);
                    defaultName = defaultName + SJctrIscsiUtility.getDefTargetIqnUnderName(editIscsiTarget.getSPort(), editIscsiTarget.getSIscsiTarget());
                }
                targetNameText.setValue(defaultName);
                targetNameText.setEnable(true);
            } else if (targetNameRadio.getSelect().equals(KEY_RADIO_EUI)) {
                targetNameText.setLabel(this.getComUtility().getGuidance("ISCSI_EUI_SET_MAX_CHAR"));
                targetNameText.setValue("");
                targetNameText.setEnable(true);
            } else {
                this.getLogUty().putlog("actionTargetNameRadioBtn", "iSCSI Target Name Radio button is not selected.");
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void actionHostModeOptEnableBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.actionHostModeOptBtn(1);
    }

    private void actionHostModeOptDisableBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.actionHostModeOptBtn(0);
    }

    private void actionHostModeOptBtn(int status) {
        try {
            SJctrHostModeOptionsTableModel hostModeOptionsTable = (SJctrHostModeOptionsTableModel)this.getDataObjectModel(KEY_HOST_MODE_OPT_TABLE);
            List<Object> selRowList = hostModeOptionsTable.getSelectedRowData();
            SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HOST_MODE_COMBO);
            SJctrIscsiUtility.checkNotifyOpenVmsOpt33Dialog(selRowList, status, this, comboBox);
            for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : selRowList) {
                sJctrHostModeOptionTableKey.setIOptionStatus(status);
            }
            hostModeOptionsTable.doRefresh();
            hostModeOptionsTable.addRowSelectionList(selRowList);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
    }

    private void actionChangeEvent(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
    }

    @Override
    public boolean checkEndData() {
        try {
            ArrayList selectedIscsiTgList = new ArrayList();
            selectedIscsiTgList.addAll(this.getCache(KEY_NEW_TARGETS));
            SJcSystemUty.execGarbageCollection();
            ArrayList<SJmoIscsiTargetInfo> editIscsiTgList = new ArrayList<SJmoIscsiTargetInfo>(selectedIscsiTgList.size());
            for (SJmoIscsiTargetInfo selectedIscsiTg : selectedIscsiTgList) {
                editIscsiTgList.add(this.copyIscsiTgInfo(selectedIscsiTg));
            }
            SJcSystemUty.execGarbageCollection();
            SJctrEditIscsiTargetsConfirmData confirmData = new SJctrEditIscsiTargetsConfirmData();
            if (this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_ALIAS_TITLE)) {
                this.collectIscsiTargetAliasArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_ISCSI_TARGET_ALIAS_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_NAME_TITLE)) {
                this.collectIscsiTargetNameArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_ISCSI_TARGET_NAME_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_HOST_MODE_TITLE)) {
                this.collectHostModeArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_HOST_MODE_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_CHAP_AUTH_TITLE)) {
                this.collectChapAuthArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_CHAP_AUTH_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_AUTH_MODE_TITLE)) {
                this.collectAuthModeArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_AUTH_MODE_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_USER_NAME_TITLE)) {
                this.collectUserNameArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_USER_NAME_TITLE);
            }
            if (this.isSelectCheckBoxinTitle(KEY_SECRET_TITLE)) {
                this.collectSecretArea(editIscsiTgList);
                confirmData.setEditParamKey(KEY_SECRET_TITLE);
            }
            Collections.sort(editIscsiTgList, new SJctrIscsiTargetAliasComparator());
            confirmData.setIscsiTargetList(editIscsiTgList);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditIscsiTargetsConfirmData> confirmDataList = new ArrayList<SJctrEditIscsiTargetsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditIscsiTargetsConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
            List<SJmoPortDetail> portDetailList = this.getCache(SJmoGetPortDetail.class);
            SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
            iscsiUtil.checkPortSecurityMsg(portDetailList, selectedIscsiTgList, this);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    private SJmoIscsiTargetInfo copyIscsiTgInfo(SJmoIscsiTargetInfo olgTgInfo) {
        SJmoIscsiTargetInfo newTgInfo = new SJmoIscsiTargetInfo();
        newTgInfo.setSPort(olgTgInfo.getSPort());
        newTgInfo.setSIscsiTarget(olgTgInfo.getSIscsiTarget());
        newTgInfo.setStrIscsiTargetAlias(olgTgInfo.getStrIscsiTargetAlias());
        newTgInfo.setStrIscsiTargetName(olgTgInfo.getStrIscsiTargetName());
        newTgInfo.setIHostMode(olgTgInfo.getIHostMode());
        newTgInfo.setBtOption((BitSet)olgTgInfo.getBtOption().clone());
        newTgInfo.setiUserAuthentSwitch(olgTgInfo.getiUserAuthentSwitch());
        newTgInfo.setiAuthentMode(olgTgInfo.getiAuthentMode());
        newTgInfo.setStrTargetUserName(olgTgInfo.getStrTargetUserName());
        newTgInfo.setAlIscsiName(olgTgInfo.getAlIscsiName());
        newTgInfo.setAlUserInfo(olgTgInfo.getAlUserInfo());
        return newTgInfo;
    }

    private void checkInitialError() {
        SJctrTextBoxDataModel reEnterTextBox;
        String strReEnter;
        SJctrTextBoxDataModel secretTextBox;
        String string;
        SJctrTextBoxDataModel userNameTextBox;
        SJctrTextBoxDataModel tgAliasTextBox;
        if (this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_ALIAS_TITLE) && (tgAliasTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TEXT)).getValue().length() == 0) {
            throw SJctrIscsiUtility.makeException(206196);
        }
        if (this.isSelectCheckBoxinTitle(KEY_HOST_MODE_TITLE)) {
            SJctrHostModeOptionsTableModel hostModeOptTbl = (SJctrHostModeOptionsTableModel)this.getDataObjectModel(KEY_HOST_MODE_OPT_TABLE);
            List<Object> optionInfoList = hostModeOptTbl.getAllRowData();
            for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : optionInfoList) {
                if (sJctrHostModeOptionTableKey.getIOptionStatus() != 2) continue;
                throw SJctrIscsiUtility.makeException(206230);
            }
        }
        boolean isEditTgUserName = this.isSelectCheckBoxinTitle(KEY_USER_NAME_TITLE);
        boolean isEditTgSecret = this.isSelectCheckBoxinTitle(KEY_SECRET_TITLE);
        if (this.isExistEmptyUserName) {
            boolean chapEditAndCheck;
            SJctrRadioButtonGroupDataModel sJctrRadioButtonGroupDataModel;
            boolean chapEditXorCheck = isEditTgUserName ^ isEditTgSecret;
            if (chapEditXorCheck) {
                throw SJctrIscsiUtility.makeException(206224);
            }
            if (this.isSelectCheckBoxinTitle(KEY_AUTH_MODE_TITLE) && (sJctrRadioButtonGroupDataModel = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO)).isSelect(KEY_RADIO_MUTUAL) && !(chapEditAndCheck = isEditTgUserName & isEditTgSecret)) {
                throw SJctrIscsiUtility.makeException(206223);
            }
        }
        if (isEditTgUserName && (userNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TEXT)).getValue().length() == 0) {
            throw SJctrIscsiUtility.makeException(206197);
        }
        if (isEditTgSecret && !(string = (secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT)).getValue()).equals(strReEnter = (reEnterTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_REENT_SECRET_TEXT)).getValue())) {
            throw SJctrIscsiUtility.makeException(206221);
        }
    }

    private void checkEachIscsiTarget(List<SJmoIscsiTargetInfo> selIscsiTgList) {
        boolean needDuplicateCheck;
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        boolean bl = needDuplicateCheck = this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_ALIAS_TITLE) || this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_NAME_TITLE) || this.isSelectCheckBoxinTitle(KEY_USER_NAME_TITLE);
        if (needDuplicateCheck && (this.aliasCheckMap == null || this.tgNameCheckMap == null || this.tgChapCheckMap == null)) {
            this.createDuplicateCheckMap(selIscsiTgList);
        }
        SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
        SJmoSubsystemInfo subsysInfo = SJctrIscsiUtility.getSJmoSubsystemInfo(this);
        for (SJmoIscsiTargetInfo selIscsiTg : selIscsiTgList) {
            if (!(this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_ALIAS_TITLE) && !this.checkIscsiTargetAliasInput(selIscsiTg, iscsiUtil, errColumnList) || this.isSelectCheckBoxinTitle(KEY_ISCSI_TARGET_NAME_TITLE) && !this.checkIscsiTargetNameInput(selIscsiTg, subsysInfo, iscsiUtil, errColumnList) || this.isSelectCheckBoxinTitle(KEY_HOST_MODE_TITLE) && !this.checkHostModeInput(selIscsiTg, errColumnList) || !this.isSelectCheckBoxinTitle(KEY_USER_NAME_TITLE)) && this.checkTargetChapUserNameInput(selIscsiTg, errColumnList)) continue;
        }
        if (errColumnList.size() > 0) {
            this.displayIscsiTargetErrorTable(selIscsiTgList, errColumnList);
        }
    }

    private void createDuplicateCheckMap(List<SJmoIscsiTargetInfo> selIscsiTgList) {
        this.aliasCheckMap = new HashMap<Short, Set<String>>(selIscsiTgList.size());
        this.tgNameCheckMap = new HashMap<Short, Set<String>>(selIscsiTgList.size());
        this.tgChapCheckMap = new HashMap<Short, Set<String>>(selIscsiTgList.size());
        List<SJmoPortIscsiTargetInfo> ptIscsiTgList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
        for (SJmoIscsiTargetInfo selIscsiTg : selIscsiTgList) {
            SJmoPortIscsiTargetInfo ptIscsiTgInfo = (SJmoPortIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortId(ptIscsiTgList, selIscsiTg.getSPort());
            if (ptIscsiTgInfo == null) continue;
            ArrayList<SJmoIscsiTargetInfo> tgInfoList = ptIscsiTgInfo.getAlPortIscsiTarget();
            HashSet<String> aliasSet = new HashSet<String>();
            HashSet<String> tgNameSet = new HashSet<String>();
            HashSet<String> tgChapSet = new HashSet<String>();
            for (SJmoIscsiTargetInfo tgInfo : tgInfoList) {
                if (tgInfo.compareTo(selIscsiTg) == 0) continue;
                aliasSet.add(tgInfo.getStrIscsiTargetAlias());
                tgNameSet.add(tgInfo.getStrIscsiTargetName());
                String tgChap = tgInfo.getStrTargetUserName();
                if (tgChap.length() <= 0) continue;
                tgChapSet.add(tgChap);
            }
            this.aliasCheckMap.put(selIscsiTg.getSPort(), aliasSet);
            this.tgNameCheckMap.put(selIscsiTg.getSPort(), tgNameSet);
            this.tgChapCheckMap.put(selIscsiTg.getSPort(), tgChapSet);
        }
    }

    private boolean checkIscsiTargetAliasInput(SJmoIscsiTargetInfo selIscsiTg, SJctrIscsiUtility iscsiUtil, List<SJctrErrorColumnData> errColumnList) {
        Set<String> aliasSet;
        SJctrErrorColumnData errColumnData;
        String defIscsiTargetAlias;
        boolean ret = true;
        SJctrTextBoxDataModel aliasTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TEXT);
        String inputAlias = aliasTextBox.getValue();
        short portId = selIscsiTg.getSPort();
        if (selIscsiTg.getSIscsiTarget() != 0 && inputAlias.equals(defIscsiTargetAlias = iscsiUtil.getDefIscsiTargetAlias(portId))) {
            errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206205));
            errColumnList.add(errColumnData);
            ret = false;
        }
        if (ret && (aliasSet = this.aliasCheckMap.get(portId)).contains(inputAlias)) {
            errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206206));
            errColumnList.add(errColumnData);
            ret = false;
        }
        return ret;
    }

    private boolean checkIscsiTargetNameInput(SJmoIscsiTargetInfo selIscsiTg, SJmoSubsystemInfo subsysInfo, SJctrIscsiUtility iscsiUtil, List<SJctrErrorColumnData> errColumnList) {
        Set<String> tgNameSet;
        SJctrErrorColumnData errColumnData;
        String defIscsiTargetName;
        boolean ret = true;
        SJctrTextBoxDataModel tgNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_NAME_TEXT);
        String inputTgName = this.compIscsiTargetName(tgNameTextBox.getValue());
        short portId = selIscsiTg.getSPort();
        if (selIscsiTg.getSIscsiTarget() != 0 && inputTgName.equals(defIscsiTargetName = iscsiUtil.getDefIscsiTargetName(portId, subsysInfo))) {
            errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206207));
            errColumnList.add(errColumnData);
            ret = false;
        }
        if (ret && (tgNameSet = this.tgNameCheckMap.get(portId)).contains(inputTgName)) {
            errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206208));
            errColumnList.add(errColumnData);
            ret = false;
        }
        return ret;
    }

    private boolean checkTargetChapUserNameInput(SJmoIscsiTargetInfo selIscsiTg, List<SJctrErrorColumnData> errColumnList) {
        boolean ret = true;
        SJctrTextBoxDataModel userNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TEXT);
        String inputUserName = userNameTextBox.getValue();
        Set<String> tgChapSet = this.tgChapCheckMap.get(selIscsiTg.getSPort());
        if (tgChapSet.contains(inputUserName)) {
            SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206218));
            errColumnList.add(errColumnData);
            ret = false;
        }
        return ret;
    }

    private boolean checkHostModeInput(SJmoIscsiTargetInfo selIscsiTg, List<SJctrErrorColumnData> errColumnList) {
        boolean ret = true;
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HOST_MODE_COMBO);
        String str = comboBox.getSelection();
        byte hostMode = Byte.valueOf(str);
        if (hostMode == 76) {
            if (this.disableUvmHostModeTargetSet == null) {
                this.createAssignAtypeVolTargetSet();
            }
            if (this.disableUvmHostModeTargetSet.contains(selIscsiTg)) {
                SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(selIscsiTg, SJctrIscsiUtility.makeError(206233));
                errColumnList.add(errColumnData);
                ret = false;
            }
        }
        return ret;
    }

    private void createAssignAtypeVolTargetSet() {
        this.disableUvmHostModeTargetSet = new HashSet<SJmoIscsiTargetIndex>();
        List<SJmoLdevDetail> ldevDetailList = SJctrIscsiUtility.getSJmoLdevDetail(this);
        List<SJmoPortLunInfo> portLunInfoList = SJctrIscsiUtility.getSJmoPortLunInfo(this);
        List<?> selectedIscsiTgList = this.getCache(KEY_NEW_TARGETS);
        block0: for (SJmoIscsiTargetInfo iscsiTgInfo : selectedIscsiTgList) {
            SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)SJctrIscsiUtility.getPortInfoByPortId(portLunInfoList, iscsiTgInfo.getSPort());
            if (portLunInfo == null) {
                this.getLogUty().putlog("createAssignAtypeVolTargetSet", "SJmoPortLunInfo to iSCSI Target is not found. Target#" + iscsiTgInfo.getIndexKey());
                continue;
            }
            ArrayList lunDetailList = portLunInfo.getAlHostGroupLun(iscsiTgInfo.getSIscsiTarget());
            for (SJmoPortLunDetail lunDetailInfo : lunDetailList) {
                SJmoLdevIndex ldevIdx = new SJmoLdevIndex();
                ldevIdx.setLdevIndex(lunDetailInfo.getSLDKC(), lunDetailInfo.getSCU(), lunDetailInfo.getSLDEV());
                int searchIdx = Collections.binarySearch(ldevDetailList, ldevIdx);
                if (searchIdx < 0) {
                    this.getLogUty().putlog("createAssignAtypeVolTargetSet", "SJmoLdevDetail is not found. LDEV#" + ldevIdx.getIndexKey());
                    continue;
                }
                SJmoLdevDetail ldevDetail = ldevDetailList.get(searchIdx);
                if (SJctrLdevUtility.isATypeVolume(ldevDetail)) continue;
                this.disableUvmHostModeTargetSet.add(iscsiTgInfo);
                continue block0;
            }
        }
    }

    private String compIscsiTargetName(String targetName) {
        String retString = "";
        SJctrRadioButtonGroupDataModel targetNameRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_TYPE_RADIO);
        if (targetNameRadio.getSelect().equals(KEY_RADIO_IQN)) {
            retString = "iqn." + targetName.toLowerCase();
        } else if (targetNameRadio.getSelect().equals(KEY_RADIO_EUI)) {
            retString = "eui." + targetName.toUpperCase();
        } else {
            this.getLogUty().putlog("collectIscsiTargetNameArea", "iSCSI Target Name radio button is not selected");
            SJctrIscsiUtility.makeException(107003);
        }
        return retString;
    }

    private void collectIscsiTargetAliasArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrTextBoxDataModel targetAliasText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_ALIAS_TEXT);
        String targetAlias = targetAliasText.getValue();
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setStrIscsiTargetAlias(targetAlias);
        }
    }

    private void collectIscsiTargetNameArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrTextBoxDataModel targetNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ISCSI_TARGET_NAME_TEXT);
        String targetName = this.compIscsiTargetName(targetNameText.getValue());
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setStrIscsiTargetName(targetName);
        }
    }

    private void collectHostModeArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_HOST_MODE_COMBO);
        SJctrHostModeOptionsTableModel hostModeOptionsTable = (SJctrHostModeOptionsTableModel)this.getDataObjectModel(KEY_HOST_MODE_OPT_TABLE);
        List<Object> allRowList = hostModeOptionsTable.getAllRowData();
        BitSet btSetData = new BitSet();
        for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : allRowList) {
            if (sJctrHostModeOptionTableKey.getIOptionStatus() != 1) continue;
            btSetData.set(sJctrHostModeOptionTableKey.getSOptionNo());
        }
        for (SJmoIscsiTargetInfo sJmoIscsiTargetInfo : targetInfoList) {
            sJmoIscsiTargetInfo.setIHostMode(Byte.valueOf(comboBox.getSelection()).byteValue());
            sJmoIscsiTargetInfo.setBtOption(btSetData);
        }
    }

    private void collectChapAuthArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_COMBO);
        int chapAuth = -1;
        try {
            chapAuth = Integer.parseInt(comboBox.getSelection());
        }
        catch (NumberFormatException nfe) {
            this.getLogUty().putlog("collectChapAuthArea", "An error occurs in processing of paseint.");
            throw SJctrIscsiUtility.makeException(107003);
        }
        ArrayList<SJmoChapUserInfo> emptyList = new ArrayList<SJmoChapUserInfo>(0);
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setiUserAuthentSwitch(chapAuth);
            if (chapAuth != 2) continue;
            targetInfo.setAlUserInfo(emptyList);
        }
    }

    private void collectAuthModeArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrRadioButtonGroupDataModel radioBtnGrp = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_AUTH_MODE_RADIO);
        int nSetType = -1;
        if (radioBtnGrp.getSelect().equals(KEY_RADIO_UNIDIRECT)) {
            nSetType = 0;
        } else if (radioBtnGrp.getSelect().equals(KEY_RADIO_MUTUAL)) {
            nSetType = 1;
        } else {
            this.getLogUty().putlog("collectAuthModeArea", "Authentication Mode radio button is not selected.");
            throw SJctrIscsiUtility.makeException(107003);
        }
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setiAuthentMode(nSetType);
        }
    }

    private void collectUserNameArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrTextBoxDataModel userNameBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_USER_NAME_TEXT);
        String userName = userNameBox.getValue();
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setStrTargetUserName(userName);
        }
    }

    private void collectSecretArea(List<SJmoIscsiTargetInfo> targetInfoList) {
        SJctrTextBoxDataModel secretTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_SECRET_TEXT);
        String secret = secretTextBox.getValue();
        for (SJmoIscsiTargetInfo targetInfo : targetInfoList) {
            targetInfo.setStrTargetSecret(secret);
        }
    }

    private void actionHostModePullDown(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrHostModeOptionsTableModel hostModeOptionsTable = (SJctrHostModeOptionsTableModel)this.getDataObjectModel(KEY_HOST_MODE_OPT_TABLE);
        List<Object> allRowList = hostModeOptionsTable.getAllRowData();
        for (SJctrHostModeOptionTableKey sJctrHostModeOptionTableKey : allRowList) {
            sJctrHostModeOptionTableKey.setIOptionStatus(0);
        }
        hostModeOptionsTable.doRefresh();
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        boolean ret = false;
        this.checkInitialError();
        ArrayList<SJmoIscsiTargetInfo> selectedIscsiTgList = new ArrayList<SJmoIscsiTargetInfo>();
        selectedIscsiTgList.addAll(this.getCache(KEY_NEW_TARGETS));
        this.checkEachIscsiTarget(selectedIscsiTgList);
        int msgID = this.getChapAuthChengeMsgId(selectedIscsiTgList);
        switch (msgID) {
            case 206241: {
                this.dispAuthenticationDisableMsg(msgEvent, dstModel);
                ret = true;
                break;
            }
            case 206245: {
                this.dispMsgDialogChapAuthChangeEnable(msgEvent, dstModel, msgID);
                ret = true;
                break;
            }
        }
        return ret;
    }

    private void dispAuthenticationDisableMsg(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        String strFuncID = Integer.toString(12);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(206241);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)SJctrEditIscsiTargetsDC.this.getDataObjectModel(SJctrEditIscsiTargetsDC.KEY_CHAP_AUTH_COMBO);
                comboBox.setDirty();
                SJctrEditIscsiTargetsDC.this.finishEvent(msgEvent, dstModel);
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private int getChapAuthChengeMsgId(List<SJmoIscsiTargetInfo> tgList) {
        int ret = -1;
        if (this.isSelectCheckBoxinTitle(KEY_CHAP_AUTH_TITLE)) {
            List<?> oldConfirmDataList = this.getCache(SJctrEditIscsiTargetsConfirmData.class);
            int oldChapAuth = -1;
            if (oldConfirmDataList != null) {
                SJctrEditIscsiTargetsConfirmData oldConfirmData = (SJctrEditIscsiTargetsConfirmData)oldConfirmDataList.get(0);
                List<SJmoIscsiTargetInfo> oldIscsiTargetInfoList = oldConfirmData.getIscsiTargetList();
                SJmoIscsiTargetInfo oldIscsiTargetInfo = oldIscsiTargetInfoList.get(0);
                oldChapAuth = oldIscsiTargetInfo.getiUserAuthentSwitch();
            }
            int chapAuth = -1;
            try {
                SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CHAP_AUTH_COMBO);
                chapAuth = Integer.parseInt(comboBox.getSelection());
            }
            catch (NumberFormatException nfe) {
                this.getLogUty().putlog("isDispAuthenticationDisableMsg", "An error occurs in processing of paseint.");
                throw SJctrIscsiUtility.makeException(107004);
            }
            if (oldChapAuth != chapAuth) {
                if (chapAuth == 2) {
                    ret = 206241;
                } else if (chapAuth == 1) {
                    for (SJmoIscsiTargetInfo iscsiTg : tgList) {
                        if (iscsiTg.getAlUserInfo().size() != 0) continue;
                        ret = 206245;
                        break;
                    }
                }
            }
        }
        return ret;
    }

    private void dispMsgDialogChapAuthChangeEnable(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel, int msgId) {
        String strFuncID = Integer.toString(12);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(msgId);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrComboBoxDataModel comboBox = (SJctrComboBoxDataModel)SJctrEditIscsiTargetsDC.this.getDataObjectModel(SJctrEditIscsiTargetsDC.KEY_CHAP_AUTH_COMBO);
                comboBox.setDirty();
                SJctrEditIscsiTargetsDC.this.finishEvent(msgEvent, dstModel);
            }
        });
        this.addUpdateDisp(related);
    }

    public static enum EDIT_ISCSI_TARGET_MSG implements SJctrNotifyState
    {
        SEL_CHANGE,
        SEL_TARGET,
        SEL_HOST_MODE,
        SEL_ENABLE,
        SEL_DISABLE;

    }
}

