/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.discoveryiscsitarget;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoDiscoveryComparator;
import sanproject.sn2.controller.com.concrete.SJctrIPAddressInputDataModel;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.addiscsipath.SJctrIscsiTargetPathInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.discoveryiscsitarget.SJctrDiscoveryIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.discoveryiscsitarget.SJctrGetThroughRmiDataDiscoveryIscsiTarget;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.discoveryiscsitarget.SJctrSelectedDiscoveryListTableDataModel;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrDiscoveryIscsiTargetDC
extends SJctrDialogDataController {
    protected static final int DISP_ID = 33595541;
    protected static final String DISP_TITLE = "DISCOVERY_ISCSI_TGT";
    public static final String KEY_PORT_LIST = "PORT_LIST";
    public static final String KEY_DICSCOVERY_PATH_LIST = "DICSCOVERY_PATH_LIST";
    private static final String KEY_CMB_PORT_ID = "CMB_PORT_ID";
    private static final String KEY_CMB_VIRTUAL_PORT_ID = "CMB_VIRTUAL_PORT_ID";
    private static final String KEY_IP_ADDRESS_MODEL = "IP_ADDRESS_MODEL";
    private static final String KEY_RADIO_IP_ADDRESS = "RADIO_IP_ADDRESS";
    private static final String KEY_TXT_IP_ADDRESS = "TXT_IP_ADDRESS";
    private static final String KEY_TXT_TCP_PORT_NUM = "TXT_TCP_PORT_NUM";
    private static final String KEY_BTN_ADD = "BTN_ADD";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_BTN_REMOVE = "BTN_REMOVE";
    private static final String REMOTE_TCP_PORT_MIN_NUM = "1";
    public static final String REMOTE_TCP_PORT_MAX_NUM = "65535";

    public SJctrDiscoveryIscsiTargetDC() throws SJcException {
        super(33595541);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrComboBoxDataModel cmbAuth = new SJctrComboBoxDataModel();
        this.addDataObjectModel(KEY_CMB_PORT_ID, cmbAuth);
        cmbAuth.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrDiscoveryIscsiTargetDC.this.fireMessageEvent(DISCOVERY_ISCSI_TGT_MSG.CHANGE_LOCAL_PORT);
                }
            }
        });
        SJctrComboBoxDataModel cmbVport = new SJctrComboBoxDataModel();
        this.addDataObjectModel(KEY_CMB_VIRTUAL_PORT_ID, cmbVport);
        SJctrIPAddressInputDataModel ipAddressModel = new SJctrIPAddressInputDataModel(KEY_RADIO_IP_ADDRESS, KEY_TXT_IP_ADDRESS);
        this.addDataObjectModel(KEY_IP_ADDRESS_MODEL, ipAddressModel);
        SJctrTextBoxDataModel txtTcpPortNum = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_TXT_TCP_PORT_NUM, txtTcpPortNum);
        SJctrButtonDataModel addBtn = new SJctrButtonDataModel();
        addBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrDiscoveryIscsiTargetDC.this.fireMessageEvent(DISCOVERY_ISCSI_TGT_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_ADD, addBtn);
        SJctrSelectedDiscoveryListTableDataModel tbl = new SJctrSelectedDiscoveryListTableDataModel();
        tbl.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, tbl);
        SJctrButtonDataModel removeBtn = new SJctrButtonDataModel();
        removeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrDiscoveryIscsiTargetDC.this.fireMessageEvent(DISCOVERY_ISCSI_TGT_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel(KEY_BTN_REMOVE, removeBtn);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    protected void initListener() {
        this.addMessageEventListener(DISCOVERY_ISCSI_TGT_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDiscoveryIscsiTargetDC.this.AddAction();
            }
        });
        this.addMessageEventListener(DISCOVERY_ISCSI_TGT_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDiscoveryIscsiTargetDC.this.RemoveAction();
            }
        });
        this.addMessageEventListener(DISCOVERY_ISCSI_TGT_MSG.CHANGE_LOCAL_PORT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDiscoveryIscsiTargetDC.this.LocalPortIdPullDownAction();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> usablePortList = this.getProxy().getCache("CASH_USABLE_PORT_LIST");
        List<?> mPortDetailList = this.getProxy().getCache(SJmoGetPortDetail.class.getName());
        List<?> mPortPathlList = this.getProxy().getCache(SJmoGetPortIscsiTargetPathInfo.class.getName());
        if (null == usablePortList || null == mPortDetailList || null == mPortPathlList) {
            this.logUty.putlog("checkStartData", "Cash data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == usablePortList.size() || 0 == mPortDetailList.size()) {
            this.logUty.putlog("checkStartData", "Cash data list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        try {
            SJctrComboBoxDataModel cmbPort = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_PORT_ID);
            List<?> usablePortList = this.getProxy().getCache("CASH_USABLE_PORT_LIST");
            for (SJmoPortDetail portDetail : usablePortList) {
                cmbPort.addItem(String.valueOf(portDetail.getSPort()), SJctrIscsiUtility.getIscsiTargetPortIdString(portDetail));
            }
            cmbPort.setSelectedIndex(0);
            SJctrComboBoxDataModel cmbVport = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_VIRTUAL_PORT_ID);
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(Short.valueOf(cmbPort.getSelection()));
            int searchIndex = Collections.binarySearch(usablePortList, portIndex);
            SJmoPortDetail portDtl = (SJmoPortDetail)usablePortList.get(searchIndex);
            this.createVirtualPortList(cmbVport, portDtl);
            SJctrIPAddressInputDataModel ipAddressData = (SJctrIPAddressInputDataModel)this.getDataObjectModel(KEY_IP_ADDRESS_MODEL);
            ipAddressData.initItems();
            ipAddressData.setVersion(0);
            SJctrTextBoxDataModel txtTcpPortNum = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_TCP_PORT_NUM);
            txtTcpPortNum.setMin(REMOTE_TCP_PORT_MIN_NUM);
            txtTcpPortNum.setMax(REMOTE_TCP_PORT_MAX_NUM);
        }
        catch (SJcException e) {
            SJctrError err = new SJctrError(12, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public boolean checkEndData() {
        try {
            List<Object> rtnList = new ArrayList();
            SJctrSelectedDiscoveryListTableDataModel tbl = (SJctrSelectedDiscoveryListTableDataModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> tblData = tbl.getAllRowData();
            SanRequest rmiRequestData = this.createRmiRequestData(tblData);
            SanResponse result = this.getSanResponseModelDirect(rmiRequestData);
            if (SJctrIscsiUtility.hasErrorSanResponse(result)) {
                this.displayErrorTable(result);
            } else {
                rtnList = this.createDiscoveryIsciTargetList(result);
                rtnList = this.removeIscsiPathUseRemoteCopy(rtnList);
            }
            this.putCache(KEY_DICSCOVERY_PATH_LIST, rtnList);
        }
        catch (SJcException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkEndData", e.getMessage());
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
        catch (SanDataException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkEndData", e.getMessage());
            throw SJctrIscsiUtility.makeException(107004);
        }
        return true;
    }

    private List<SJctrIscsiTargetPathInfo> removeIscsiPathUseRemoteCopy(List<SJctrIscsiTargetPathInfo> discoveryList) {
        List<?> mPortPathlList = this.getProxy().getCache(SJmoGetPortIscsiTargetPathInfo.class.getName());
        SJctrIscsiTargetPathInfoComparator comparatorObj = new SJctrIscsiTargetPathInfoComparator();
        ArrayList<SJctrIscsiTargetPathInfo> iteDiscoveryList = new ArrayList<SJctrIscsiTargetPathInfo>();
        iteDiscoveryList.addAll(discoveryList);
        Iterator ite = iteDiscoveryList.iterator();
        while (ite.hasNext()) {
            SJmoIscsiTargetPathInfo mPathInfo;
            SJctrIscsiTargetPathInfo discoveryInfo = (SJctrIscsiTargetPathInfo)ite.next();
            Object objPort = SJctrIscsiUtility.getPortInfoByPortId(mPortPathlList, discoveryInfo.getSPort());
            if (objPort == null) continue;
            SJmoPortIscsiTargetPathInfo portPathInfo = (SJmoPortIscsiTargetPathInfo)objPort;
            ArrayList<SJmoIscsiTargetPathInfo> mPathList = new ArrayList<SJmoIscsiTargetPathInfo>(portPathInfo.getAlPortIscsiTargetPath());
            Collections.sort(mPathList, comparatorObj);
            int index = Collections.binarySearch(mPathList, discoveryInfo, comparatorObj);
            if (index < 0 || (mPathInfo = (SJmoIscsiTargetPathInfo)mPathList.get(index)).getIFunction() == 0) continue;
            ite.remove();
        }
        return iteDiscoveryList;
    }

    private List<SJctrIscsiTargetPathInfo> createDiscoveryIsciTargetList(SanResponse result) throws SanDataException {
        ArrayList<SJctrIscsiTargetPathInfo> rtnPathList = new ArrayList<SJctrIscsiTargetPathInfo>();
        SanList iscsiPathList = result.getList("iScsiPaths");
        for (SanObject pathInfo : iscsiPathList) {
            SanObject localPort = pathInfo.getObj("iScsiPort");
            SanObject remotePort = pathInfo.getObj("RemoteiScsiPort");
            SanObject virtualPort = localPort.getObj("iScsiVirtualPort");
            SanList remoteTargetList = remotePort.getList("RemoteiScsiTargets");
            for (SanObject targetInfo : remoteTargetList) {
                SJctrIscsiTargetPathInfo iscsiPathInfo = new SJctrIscsiTargetPathInfo();
                iscsiPathInfo.setSPort((short)localPort.getInt("Id"));
                if (virtualPort != null) {
                    iscsiPathInfo.setIVirtualPortID(virtualPort.getInt("Id"));
                } else {
                    iscsiPathInfo.setIVirtualPortID(-1);
                }
                int ipType = remotePort.getInt("IpType");
                iscsiPathInfo.setIIpType(ipType);
                if (ipType == 0) {
                    iscsiPathInfo.setIIpv4Address(remotePort.getIntArray("Ipv4Address"));
                } else if (ipType == 1) {
                    iscsiPathInfo.setIIpv6Address(remotePort.getIntArray("Ipv6Address"));
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "createDiscoveryIsciTargetList", "IP Type is Invalid. IP Type = " + ipType);
                }
                iscsiPathInfo.setITcpPortNumber(remotePort.getInt("TcpPortNumber"));
                iscsiPathInfo.setStrTargetName(targetInfo.getString("Name"));
                rtnPathList.add(iscsiPathInfo);
            }
        }
        return rtnPathList;
    }

    private void displayErrorTable(SanResponse result) throws SanDataException {
        List<SJctrDiscoveryIscsiTargetInfo> iscsiPortErrList = this.createDiscoveryIscsiTargetErrorInfoList(result);
        SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = this.getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrDiscoveryIscsiTargetInfo> errBasicList = new ArrayList<SJctrDiscoveryIscsiTargetInfo>();
        Collections.sort(iscsiPortErrList, new SJctrIscsiTargetPathInfoDiscoveryComparator());
        for (SJctrDiscoveryIscsiTargetInfo errInfo : iscsiPortErrList) {
            SJctrError errElement = errInfo.getErrorInfo();
            errBasicList.add(errInfo);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(errInfo, errElement);
            newErrList.add(errData);
        }
        SJctrSelectedDiscoveryListTableDataModel errTbl = new SJctrSelectedDiscoveryListTableDataModel();
        errTbl.setDataController(this);
        errTbl.setPaging(false);
        errTbl.setBasicDataList(errBasicList);
        errTbl.initGuidance(this.getComUtility());
        errTbl.createModelDirect();
        errTbl.divideModelData(this.getProxy().getModelDataMap());
        errTbl.makeDataModel();
        errTbl.setBasicData(SJmoGetPortDetail.class, this.getProxy().getCache(SJmoGetPortDetail.class.getName()));
        errDC.setParameter(errTbl, newErrList);
        SJctrError err = errDC.getRepresentativeError(newErrList, 7);
        SJcException exp = err.createException();
        exp.setErrDisp(errDisp);
        throw exp;
    }

    private List<SJctrDiscoveryIscsiTargetInfo> createDiscoveryIscsiTargetErrorInfoList(SanResponse result) throws SanDataException {
        ArrayList<SJctrDiscoveryIscsiTargetInfo> iscsiPortErrList = new ArrayList<SJctrDiscoveryIscsiTargetInfo>();
        SanList iscsiPathList = result.getList("iScsiPaths");
        int errorIndex = 0;
        for (SanObject iscsiPath : iscsiPathList) {
            SanObject errInfo = iscsiPath.getObj("ErrorInfo");
            int[] errMsgId = errInfo.getIntArray("MessageId");
            if (0 == errMsgId[1]) continue;
            SJctrDiscoveryIscsiTargetInfo errorPortInfo = new SJctrDiscoveryIscsiTargetInfo();
            SanObject iscsiPort = iscsiPath.getObj("iScsiPort");
            SanObject remotePort = iscsiPath.getObj("RemoteiScsiPort");
            errorPortInfo.setSPort((short)iscsiPort.getInt("Id"));
            SanObject iscsiVport = iscsiPort.getObj("iScsiVirtualPort");
            if (iscsiVport != null) {
                errorPortInfo.setIVirtualPortID(iscsiVport.getInt("Id"));
            }
            int ipType = remotePort.getInt("IpType");
            errorPortInfo.setIIpType(ipType);
            if (ipType == 0) {
                errorPortInfo.setIIpv4Address(remotePort.getIntArray("Ipv4Address"));
            } else if (ipType == 1) {
                errorPortInfo.setIIpv6Address(remotePort.getIntArray("Ipv6Address"));
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "createDiscoveryIscsiTargetErrorInfoList", "IP Type is Invalid. IP Type = " + ipType);
            }
            errorPortInfo.setITcpPortNumber(remotePort.getInt("TcpPortNumber"));
            SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId, errorIndex);
            errorPortInfo.setErrorInfo(iscsiError);
            ++errorIndex;
            iscsiPortErrList.add(errorPortInfo);
        }
        return iscsiPortErrList;
    }

    private SanResponse getSanResponseModelDirect(SanRequest sanRequest) {
        SJctrGetThroughRmiDataDiscoveryIscsiTarget requestKind;
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetThroughRmiDataDiscoveryIscsiTarget kind = requestKind = new SJctrGetThroughRmiDataDiscoveryIscsiTarget(sanRequest);
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(set);
        List<?> rmiDataList = map.get(directWrapper);
        SanResponse rmiObj = (SanResponse)rmiDataList.get(0);
        if (rmiObj == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSanResponseModelDirect", "SanResponse object is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return rmiObj;
    }

    private SanRequest createRmiRequestData(List<SJctrDiscoveryIscsiTargetInfo> tblData) throws SanDataException {
        SJmoGetAgent modelAgent = this.getOwner().getModelAgent();
        SanRequest sanRequest = modelAgent.newRequest("iSCSIdiscoverRemoteiScsiTargets");
        SanList reqList = sanRequest.newList("iScsiPaths");
        for (SJmoIscsiTargetPathInfo sJmoIscsiTargetPathInfo : tblData) {
            SanObject iscsiPathObj = reqList.addObj();
            SanObject portObj = iscsiPathObj.newObj("iScsiPort");
            portObj.putInt("Id", (int)sJmoIscsiTargetPathInfo.getSPort());
            SanObject remotePortObj = iscsiPathObj.newObj("RemoteiScsiPort");
            if (sJmoIscsiTargetPathInfo.getIVirtualPortID() != -1) {
                SanObject vportObj = portObj.newObj("iScsiVirtualPort");
                vportObj.putInt("Id", sJmoIscsiTargetPathInfo.getIVirtualPortID());
            }
            remotePortObj.putInt("IpType", sJmoIscsiTargetPathInfo.getIIpType());
            if (sJmoIscsiTargetPathInfo.getIIpType() == 0) {
                remotePortObj.putIntArray("Ipv4Address", sJmoIscsiTargetPathInfo.getIIpv4Address());
            } else if (sJmoIscsiTargetPathInfo.getIIpType() == 1) {
                remotePortObj.putIntArray("Ipv6Address", sJmoIscsiTargetPathInfo.getIIpv6Address());
            } else {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getDiscoveryList", "Selection radio button is not IPv4 or IPv6.");
            }
            remotePortObj.putInt("TcpPortNumber", sJmoIscsiTargetPathInfo.getITcpPortNumber());
        }
        return sanRequest;
    }

    private void AddAction() {
        SJctrComboBoxDataModel cmbPort = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_PORT_ID);
        SJctrComboBoxDataModel cmbVport = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_VIRTUAL_PORT_ID);
        SJctrIPAddressInputDataModel ipDataModel = (SJctrIPAddressInputDataModel)this.getDataObjectModel(KEY_IP_ADDRESS_MODEL);
        SJctrTextBoxDataModel txtTcpPortNum = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TXT_TCP_PORT_NUM);
        SJctrSelectedDiscoveryListTableDataModel tbl = (SJctrSelectedDiscoveryListTableDataModel)this.getDataObjectModel(KEY_TABLE);
        ArrayList<Object> rowDataList = new ArrayList<Object>(tbl.getAllRowData());
        Collections.sort(rowDataList, new SJctrIscsiTargetPathInfoDiscoveryComparator());
        SJctrDiscoveryIscsiTargetInfo addInfo = new SJctrDiscoveryIscsiTargetInfo();
        addInfo.setSPort(Short.valueOf(cmbPort.getSelection()));
        int vportId = -1;
        if (cmbVport.getSelection() != null) {
            vportId = Integer.valueOf(cmbVport.getSelection());
        }
        addInfo.setIVirtualPortID(vportId);
        int ipType = ipDataModel.getVersion();
        addInfo.setIIpType(ipType);
        String regAdd = ipDataModel.getRegularAddress();
        if (ipType == 0) {
            addInfo.setIIpv4Address(SJctrPortUtility.splitIPv4String(regAdd));
        } else if (ipType == 1) {
            addInfo.setIIpv6Address(SJctrIscsiUtility.splitIPv6String(regAdd));
        }
        addInfo.setITcpPortNumber(Integer.valueOf(txtTcpPortNum.getValue()));
        int searchIndex = Collections.binarySearch(rowDataList, addInfo, new SJctrIscsiTargetPathInfoDiscoveryComparator());
        if (searchIndex >= 0) {
            throw SJctrIscsiUtility.makeException(206273);
        }
        ArrayList<SJctrDiscoveryIscsiTargetInfo> addList = new ArrayList<SJctrDiscoveryIscsiTargetInfo>();
        addList.add(addInfo);
        tbl.addRowDataTop(addList);
        tbl.setDirty();
        this.updateFooter();
    }

    private void RemoveAction() {
        SJctrSelectedDiscoveryListTableDataModel tbl = (SJctrSelectedDiscoveryListTableDataModel)this.getDataObjectModel(KEY_TABLE);
        tbl.removeSelectedRowData();
        tbl.setDirty();
        this.updateFooter();
    }

    private void LocalPortIdPullDownAction() {
        SJctrComboBoxDataModel cmbPort = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_PORT_ID);
        List<?> usablePortList = this.getProxy().getCache("CASH_USABLE_PORT_LIST");
        SJctrComboBoxDataModel cmbVport = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CMB_VIRTUAL_PORT_ID);
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(Short.valueOf(cmbPort.getSelection()));
        int searchIndex = Collections.binarySearch(usablePortList, portIndex);
        SJmoPortDetail portDtl = (SJmoPortDetail)usablePortList.get(searchIndex);
        this.createVirtualPortList(cmbVport, portDtl);
    }

    private void createVirtualPortList(SJctrComboBoxDataModel cmbVport, SJmoPortDetail portDtl) {
        cmbVport.removeAllItems();
        if (portDtl.getIVPortMode() != 1) {
            cmbVport.setEnable(false);
        } else {
            cmbVport.setEnable(true);
            short sVPortNum = portDtl.getSVPortCount();
            short[] sVPortIDs = portDtl.getSVPortIDs();
            String strVPortID = "";
            for (short sVPcnt = 0; sVPcnt < sVPortNum; sVPcnt = (short)(sVPcnt + 1)) {
                strVPortID = String.valueOf(sVPortIDs[sVPcnt]);
                cmbVport.addItem(strVPortID, strVPortID);
            }
            cmbVport.setSelectedIndex(0);
        }
    }

    public static enum DISCOVERY_ISCSI_TGT_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE,
        CHANGE_LOCAL_PORT;

    }
}

