/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.initiator.removeportchapusers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.removeportchapusers.SJctrRemovePortChapUsersAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.removeportchapusers.SJctrRemovePortChapUsersConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.initiator.removeportchapusers.SJctrRemovePortChapUsersConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrRemovePortChapUsersSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "REMOVE_PORT_CHAP_USERS";
    private static final Class<?> CONFIRM_DC = SJctrRemovePortChapUsersConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrRemovePortChapUsersAC applyCntl = new SJctrRemovePortChapUsersAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<?> selectedPortList = dc.getProxy().getCache("KEY_SELECTED_PORT_ID");
            if (null == selectedPortList) {
                dc.getLogUty().putlog("constructConfirmData", "selectedPortList is null.");
                throw SJctrIscsiUtility.makeException(107001);
            }
            if (0 == selectedPortList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of selectedPortList is zero.");
                throw SJctrIscsiUtility.makeException(107001);
            }
            List<SJmoPortDetail> portDetailList = SJctrIscsiUtility.getSJmoPortDetailList(dc);
            List<SJmoRSGgetAllRsgs> allRsgList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(dc);
            List<SJmoPortIscsiTargetPathInfo> portIscsiPathList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(dc);
            ArrayList<SJmoPortDetail> transDatalist = new ArrayList<SJmoPortDetail>();
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, allRsgList.get(0));
            for (SJmoPortDetail portInfo : selectedPortList) {
                SJmoPortDetail transPortInfo = new SJmoPortDetail();
                transPortInfo = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portInfo);
                if (null == transPortInfo) {
                    dc.getLogUty().putlog("constructConfirmData", "Inherited port detail info is not exist.");
                    throw SJctrIscsiUtility.makeException(206512);
                }
                if (!SJctrIscsiUtility.isRsgPortIndex(portInfo, rsgUtil)) {
                    dc.getLogUty().putlog("constructConfirmData", "Inherited port detail is not assigned RSG.");
                    throw SJctrIscsiUtility.makeException(206266);
                }
                transDatalist.add(transPortInfo);
            }
            this.checkRemovePortList(transDatalist, dc, portIscsiPathList);
            SJctrRemovePortChapUsersConfirmData confirmData = new SJctrRemovePortChapUsersConfirmData();
            ArrayList<SJctrRemovePortChapUsersConfirmData> confirmDataList = new ArrayList<SJctrRemovePortChapUsersConfirmData>();
            Collections.sort(transDatalist);
            confirmData.setRemovePortsList(transDatalist);
            confirmData.setNeedData(dc);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrRemovePortChapUsersConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    private void checkRemovePortList(List<SJmoPortDetail> transDatalist, SJctrWizardWindowDC dc, List<SJmoPortIscsiTargetPathInfo> portIscsiPathList) {
        for (SJmoPortDetail newPortInfo : transDatalist) {
            if (!SJctrIscsiUtility.isIscsiPort(newPortInfo)) {
                dc.getLogUty().putlog("checkRemovePortList", "Inherited port kind is not iSCSI.");
                throw SJctrIscsiUtility.makeException(206270);
            }
            if ("".equals(newPortInfo.getStrUserName())) {
                dc.getLogUty().putlog("checkRemovePortList", "Inherited port detail is not set CHAPUserName.");
                throw SJctrIscsiUtility.makeException(206267);
            }
            SJmoPortIscsiTargetPathInfo portIscsiPathInfo = new SJmoPortIscsiTargetPathInfo();
            portIscsiPathInfo = (SJmoPortIscsiTargetPathInfo)SJctrIscsiUtility.getPortInfoByPortIndex(portIscsiPathList, newPortInfo);
            if (portIscsiPathInfo == null || !SJctrIscsiUtility.isIscsiTargetAuthChap(portIscsiPathInfo.getAlPortIscsiTargetPath())) continue;
            dc.getLogUty().putlog("checkRemovePortList", "Target CHAP authmode is CHAP in inherited port detail");
            throw SJctrIscsiUtility.makeException(206269);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }
}

