/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.testcommunicationstatuses;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrCommStatusInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.testcommunicationstatuses.SJctrCommunicationStatusesTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.testcommunicationstatuses.SJctrGetThroughRmiDataTestCommunication;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrTestCommunicationStatusesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33599509;
    private static final String KEY_COMBO_PORT = "COM_COMBO_LOCAL_PORT_FROM";
    private static final String KEY_RADIO_IP = "COM_RADIO_IP";
    private static final String KEY_RADIO_IPV4 = "COM_RADIO_IPV4";
    private static final String KEY_RADIO_IPV6 = "COM_RADIO_IPV6";
    private static final String KEY_TEXT_IP = "COM_TEXT_IP";
    private static final String KEY_TABLE_COMMUN_STATUSES = "COM_TABLE";
    private static final String KEY_BTN_TEST = "COM_BTN_TEST";
    private static final String KEY_IPV6_MODE_AVAILABLE = "COM_IPV6_MODE_AVAILABLE";
    private static final int ISCSI_EXEC_PING_IPV4_SIZE = 4;
    private static final int ISCSI_EXEC_PING_IPV6_SIZE = 8;

    public SJctrTestCommunicationStatusesDC() {
        super(33599509);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_COMBO_PORT, SJctrIscsiUtility.addItemSelectEventListener(new SJctrComboBoxDataModel(), TESTCOMNSTAT_MSG.PULLDOWN_LOCAL_PORT_ID));
        this.addDataObjectModel(KEY_TEXT_IP, new SJctrTextBoxDataModel());
        SJctrRadioButtonGroupDataModel radioBtn = new SJctrRadioButtonGroupDataModel();
        radioBtn.add(KEY_RADIO_IPV4);
        radioBtn.add(KEY_RADIO_IPV6);
        radioBtn.setSelect(KEY_RADIO_IPV4);
        this.addDataObjectModel(KEY_BTN_TEST, SJctrIscsiUtility.addItemSelectEventListener(radioBtn, TESTCOMNSTAT_MSG.RADIO_IP));
        this.addDataObjectModel(KEY_RADIO_IP, radioBtn);
        SJctrButtonDataModel testBtn = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BTN_TEST, SJctrIscsiUtility.addItemSelectEventListener(testBtn, TESTCOMNSTAT_MSG.BTN_TEST));
        this.addDataObjectModel(KEY_TABLE_COMMUN_STATUSES, new SJctrCommunicationStatusesTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(TESTCOMNSTAT_MSG.PULLDOWN_LOCAL_PORT_ID, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTestCommunicationStatusesDC.this.actionLocalPortIdPulldown(event, dstModel);
            }
        });
        this.addMessageEventListener(TESTCOMNSTAT_MSG.RADIO_IP, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTestCommunicationStatusesDC.this.actionRadioBtn(event, dstModel);
            }
        });
        this.addMessageEventListener(TESTCOMNSTAT_MSG.BTN_TEST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTestCommunicationStatusesDC.this.actionTestBtn(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetPortDetail kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoPortDetail> portDetailList = SJctrIscsiUtility.getSJmoPortDetailList(this);
            SJctrComboBoxDataModel comboPortId = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COMBO_PORT);
            for (SJmoPortDetail portDetail : portDetailList) {
                if (!SJctrIscsiUtility.isIscsiPort(portDetail) || portDetail.getIVPortMode() == 1) continue;
                String strSPort = String.valueOf(portDetail.getSPort());
                comboPortId.addItem(strSPort, portDetail.getStrPortDisplayName());
            }
            Map<String, HashMap<String, Object>> portItemMap = comboPortId.getItemMap();
            if (portItemMap.isEmpty()) {
                this.logUty.putlog("checkConstructData", "Target iSCSI Port does not exist.");
                throw SJctrIscsiUtility.makeException(206235);
            }
            comboPortId.setSelectedIndex(0);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
        return true;
    }

    private void actionLocalPortIdPulldown(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<SJmoPortDetail> portDetailList = SJctrIscsiUtility.getSJmoPortDetailList(this);
        int selectedPortId = this.getSelectedPortId();
        boolean ipv6Mode = true;
        SJmoPortIndex keyPort = new SJmoPortIndex();
        keyPort.setSPort((short)selectedPortId);
        int index = Collections.binarySearch(portDetailList, keyPort);
        if (index < 0) {
            this.logUty.putlog("actionLocalPortIdPulldown", "Port id does not exist.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SJmoPortDetail portDetail = portDetailList.get(index);
        ipv6Mode = portDetail.getBV6Mode();
        if (!ipv6Mode) {
            SJctrRadioButtonGroupDataModel radioIpAddress = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_RADIO_IP);
            radioIpAddress.setSelect(KEY_RADIO_IPV4);
        }
        this.getManageData().setData(KEY_IPV6_MODE_AVAILABLE, ipv6Mode);
    }

    private void actionRadioBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTextBoxDataModel targetIpAddressText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXT_IP);
        targetIpAddressText.setValue("");
        targetIpAddressText.setDirty();
    }

    private void actionTestBtn(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            String host = this.getIPAddressTextValue();
            InetAddress address = null;
            try {
                address = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "actionTestBtn", "An Exception has occured.(InetAddress#getByName), " + e.getMessage());
                throw SJctrIscsiUtility.makeException(107001);
            }
            if (this.isUnsupportedIPAddress(address)) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "actionTestBtn", "Input IP address is unsupported. : " + host);
                throw SJctrIscsiUtility.makeException(206234);
            }
            SJmoGetAgent modelAgent = this.getOwner().getModelAgent();
            SanRequest pingRequest = this.createExecPingRequest(modelAgent);
            SanResponse pingResult = this.getSanResponseModelDirect(pingRequest);
            if (SJctrIscsiUtility.hasErrorSanResponse(pingResult)) {
                this.logUty.putlog("actionTestBtn", "An error has occurred.");
                throw SJctrIscsiUtility.createExceptionKeyValueError(pingResult);
            }
            List<SJctrCommStatusInfo> commStatusInfoList = this.createExecPingResultList(pingResult);
            SJctrCommunicationStatusesTableModel communicationStatusesTableModel = (SJctrCommunicationStatusesTableModel)this.getDataObjectModel(KEY_TABLE_COMMUN_STATUSES);
            communicationStatusesTableModel.setBasicDataList(commStatusInfoList);
            communicationStatusesTableModel.doRefresh();
        }
        catch (SJcException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "actionTestBtn", e.getMessage());
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107004);
        }
        catch (SanDataException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "actionTestBtn", e.getMessage());
            throw SJctrIscsiUtility.makeException(107004);
        }
    }

    private SanRequest createExecPingRequest(SJmoGetAgent modelAgent) throws SanDataException {
        SanRequest sanRequest = modelAgent.newRequest("iSCSIexecPing");
        SanObject reqObjiScsiPort = sanRequest.newObj("iScsiPort");
        reqObjiScsiPort.putInt("Id", this.getSelectedPortId());
        SanObject reqObjDestination = reqObjiScsiPort.newObj("Destination");
        String selectRadioIpAddress = this.getSelectIpAddressType();
        int ipType = 0;
        String keyIpAddress = "";
        int[] ipaddress = null;
        if (selectRadioIpAddress.equals(KEY_RADIO_IPV4)) {
            ipType = 0;
            keyIpAddress = "Ipv4Address";
            ipaddress = this.getIpv4Address();
        } else if (selectRadioIpAddress.equals(KEY_RADIO_IPV6)) {
            ipType = 1;
            keyIpAddress = "Ipv6Address";
            ipaddress = this.getIpv6Address();
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "createExecPingRequest", "Selection radio button is not IPv4 or IPv6.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        reqObjDestination.putInt("IpType", ipType);
        reqObjDestination.putIntArray(keyIpAddress, ipaddress);
        return sanRequest;
    }

    private String getSelectIpAddressType() {
        String strIP;
        InetAddress inetAddress;
        byte[] address;
        String ipAddressType = this.getSelectedRadioButton();
        if (ipAddressType.equals(KEY_RADIO_IPV6) && (address = (inetAddress = this.getInetAddress(strIP = this.getIPAddressTextValue())).getAddress()).length == 4) {
            ipAddressType = KEY_RADIO_IPV4;
        }
        return ipAddressType;
    }

    private int[] getIpv4Address() {
        String strIPv4 = this.getIPAddressTextValue();
        InetAddress inetAddress = this.getInetAddress(strIPv4);
        byte[] address = inetAddress.getAddress();
        int[] rmiIPv4 = new int[4];
        for (int i = 0; i < rmiIPv4.length; ++i) {
            rmiIPv4[i] = address[i] & 0xFF;
        }
        return rmiIPv4;
    }

    private int[] getIpv6Address() {
        String strIPv6 = this.getIPAddressTextValue();
        InetAddress inetAddress = this.getInetAddress(strIPv6);
        byte[] address = inetAddress.getAddress();
        int[] rmiIPv6 = new int[8];
        for (int i = 0; i < rmiIPv6.length; ++i) {
            int addressIndex = i * 2;
            rmiIPv6[i] = (address[addressIndex] & 0xFF) << 8 | address[addressIndex + 1] & 0xFF;
        }
        return rmiIPv6;
    }

    private int getSelectedPortId() {
        SJctrComboBoxDataModel comboPortId = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COMBO_PORT);
        String strName = comboPortId.getSelection();
        int portId = Integer.parseInt(strName);
        return portId;
    }

    private List<SJctrCommStatusInfo> createExecPingResultList(SanResponse responseData) throws SanDataException {
        ArrayList<SJctrCommStatusInfo> commStatusInfoList = new ArrayList<SJctrCommStatusInfo>();
        SanList resultList = responseData.getList("PingResults");
        for (int i = 0; i < resultList.size(); ++i) {
            SanObject resultObj = resultList.getObj(i);
            boolean result = resultObj.getBoolean("PingResult");
            int listNo = i + 1;
            SJctrCommStatusInfo statusInfo = null;
            statusInfo = result ? new SJctrCommStatusInfo(listNo, 0) : new SJctrCommStatusInfo(listNo, 1);
            commStatusInfoList.add(statusInfo);
        }
        return commStatusInfoList;
    }

    private boolean isUnsupportedIPAddress(InetAddress address) {
        boolean ret = false;
        if (address.isMulticastAddress()) {
            ret = true;
        }
        return ret;
    }

    private String getSelectedRadioButton() {
        SJctrRadioButtonGroupDataModel radioIpAddress = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_RADIO_IP);
        String selectRadioIpAddress = radioIpAddress.getSelect();
        return selectRadioIpAddress;
    }

    private String getIPAddressTextValue() {
        SJctrTextBoxDataModel targetIpAddressText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXT_IP);
        String strIpv = targetIpAddressText.getValue();
        return strIpv;
    }

    private InetAddress getInetAddress(String ipaddress) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ipaddress);
        }
        catch (UnknownHostException e) {
            throw SJctrIscsiUtility.makeException(107001);
        }
        return address;
    }

    public SanResponse getSanResponseModelDirect(SanRequest sanRequest) {
        SJctrGetThroughRmiDataTestCommunication requestKind = new SJctrGetThroughRmiDataTestCommunication(sanRequest);
        List<SanResponse> rmiDataList = this.getSJmoThroughRmiDataList(requestKind);
        SanResponse rmiObj = rmiDataList.get(0);
        if (rmiObj == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSanResponseModelDirect", "SanResponse object is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return rmiObj;
    }

    public List<SanResponse> getSJmoThroughRmiDataList(SJmoGetThroughRmiData kind_IF) {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetThroughRmiData kind = kind_IF;
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = this.getProxy().getDataInf(set);
        List<SanResponse> rmiData = map.get(directWrapper);
        return rmiData;
    }

    public static enum TESTCOMNSTAT_MSG implements SJctrNotifyState
    {
        PULLDOWN_LOCAL_PORT_ID,
        BTN_TEST,
        RADIO_IP;

    }
}

