/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.viewloginiscsinamestatus;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrIscsiNameWithAliasComparator;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameInfoIncludeLoginStatus;
import sanproject.sn2.controller.wizard.lunm.iscsi.viewloginiscsinamestatus.SJctrGetThroughRmiDataViewLoginIscsiName;
import sanproject.sn2.controller.wizard.lunm.iscsi.viewloginiscsinamestatus.SJctrViewLoginIscsiNamesTableModel;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;

public class SJctrViewLoginIscsiNameStatusDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664537;
    private static final String KEY_TABLE = "COM_TABLE";

    public SJctrViewLoginIscsiNameStatusDC() {
        super(34664537);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrViewLoginIscsiNamesTableModel table = new SJctrViewLoginIscsiNamesTableModel();
        this.addDataObjectModel(KEY_TABLE, table);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetAgent modelAgent = this.getOwner().getModelAgent();
        SanRequest sanRequest = this.createLUNMreadAllPortiScsiInfoExSanRequest(modelAgent);
        SJctrGetThroughRmiDataViewLoginIscsiName kind = new SJctrGetThroughRmiDataViewLoginIscsiName(sanRequest);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SanResponse sanResponse = this.getSanResponse();
            if (SJctrIscsiUtility.hasErrorSanResponse(sanResponse)) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "checkConstructData", "An error has occurred.");
                throw SJctrIscsiUtility.createExceptionKeyValueError(sanResponse);
            }
            SanList iScsiPortList = sanResponse.getList("iScsiPorts");
            List<SJctrIscsiNameInfoIncludeLoginStatus> basicDataList = this.getBasicDataList(iScsiPortList);
            SJctrViewLoginIscsiNamesTableModel loginTable = (SJctrViewLoginIscsiNamesTableModel)this.getDataObjectModel(KEY_TABLE);
            Collections.sort(basicDataList, new SJctrIscsiNameWithAliasComparator());
            loginTable.setBasicDataList(basicDataList);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
        catch (SanDataException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkConstructData", e.getMessage());
            throw SJctrIscsiUtility.makeException(107002);
        }
        return true;
    }

    private List<SJctrIscsiNameInfoIncludeLoginStatus> getBasicDataList(SanList iScsiPortList) throws SanDataException {
        ArrayList<SJctrIscsiNameInfoIncludeLoginStatus> basicDataList = new ArrayList<SJctrIscsiNameInfoIncludeLoginStatus>();
        for (SanObject iScsiPort : iScsiPortList) {
            short portId = (short)iScsiPort.getInt("Id");
            List<SJmoIscsiTargetInfo> iScsiTargetList = this.getSortedIscsiTargetInfoList(iScsiPort.getList("iScsiTargets"), portId);
            Map<String, String> remoteNickNameMap = this.getRemoteiScsiNamesNickNameMap(iScsiPort.getList("RemoteiScsiNames"));
            SanList loginHistoryList = iScsiPort.getList("LoginiScsiNamesHistory");
            basicDataList.addAll(this.getLoginHistoryBasicDataList(portId, loginHistoryList, iScsiTargetList, remoteNickNameMap));
        }
        return basicDataList;
    }

    private List<SJctrIscsiNameInfoIncludeLoginStatus> getLoginHistoryBasicDataList(short portId, SanList loginHistoryList, List<SJmoIscsiTargetInfo> iScsiTargetList, Map<String, String> remoteNickNameMap) throws SanDataException {
        ArrayList<SJctrIscsiNameInfoIncludeLoginStatus> basicDataList = new ArrayList<SJctrIscsiNameInfoIncludeLoginStatus>();
        SJmoIscsiTargetInfo keyTargetInfo = new SJmoIscsiTargetInfo();
        keyTargetInfo.setSPort(portId);
        for (SanObject loginHistory : loginHistoryList) {
            SanList loginHistoryiScsiTargets = loginHistory.getList("iScsiTargets");
            for (SanObject iScsiTargetInLogin : loginHistoryiScsiTargets) {
                String loginHistoryName;
                String hbaName;
                short loginHistoryTargetId = (short)iScsiTargetInLogin.getInt("Id");
                keyTargetInfo.setSIscsiTarget(loginHistoryTargetId);
                SJmoIscsiTargetInfo iscsiTargetInfo = this.getIscsiTargetsInfo(iScsiTargetList, keyTargetInfo);
                if (iscsiTargetInfo == null) {
                    iscsiTargetInfo = new SJmoIscsiTargetInfo();
                    iscsiTargetInfo.setSPort(portId);
                    iscsiTargetInfo.setStrIscsiTargetName("");
                    iscsiTargetInfo.setStrIscsiTargetAlias("");
                    iscsiTargetInfo.setSIscsiTarget(loginHistoryTargetId);
                }
                if ((hbaName = remoteNickNameMap.get(loginHistoryName = loginHistory.getString("Name"))) == null) {
                    hbaName = "";
                }
                SJmoIscsiName iscsiName = new SJmoIscsiName();
                iscsiName.setStrIscsiName(loginHistoryName);
                iscsiName.setStrIscsiNickName(hbaName);
                iscsiName.setSPort(portId);
                boolean loginStatus = iScsiTargetInLogin.getBoolean("LoginStatus");
                SJctrIscsiNameInfoIncludeLoginStatus iscsiNameInfoIncludeLoginStatus = new SJctrIscsiNameInfoIncludeLoginStatus(iscsiName, iscsiTargetInfo, loginStatus);
                basicDataList.add(iscsiNameInfoIncludeLoginStatus);
            }
        }
        return basicDataList;
    }

    private SJmoIscsiTargetInfo getIscsiTargetsInfo(List<SJmoIscsiTargetInfo> iScsiTargetInfoList, SJmoIscsiTargetInfo keyTargetInfo) throws SanDataException {
        SJmoIscsiTargetInfo targetInfo = null;
        int index = Collections.binarySearch(iScsiTargetInfoList, keyTargetInfo);
        if (index >= 0) {
            targetInfo = iScsiTargetInfoList.get(index);
        }
        return targetInfo;
    }

    private Map<String, String> getRemoteiScsiNamesNickNameMap(SanList remoteiScsiNames) throws SanDataException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (SanObject iScsiName : remoteiScsiNames) {
            retMap.put(iScsiName.getString("Name"), iScsiName.getString("NickName"));
        }
        return retMap;
    }

    private List<SJmoIscsiTargetInfo> getSortedIscsiTargetInfoList(SanList iScsiTargetsList, short portId) throws SanDataException {
        ArrayList<SJmoIscsiTargetInfo> retList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SanObject iScsiTarget : iScsiTargetsList) {
            SJmoIscsiTargetInfo iscsiModel = new SJmoIscsiTargetInfo();
            iscsiModel.setSPort(portId);
            iscsiModel.setSIscsiTarget((short)iScsiTarget.getInt("Id"));
            iscsiModel.setStrIscsiTargetName(iScsiTarget.getString("Name"));
            iscsiModel.setStrIscsiTargetAlias(iScsiTarget.getString("Alias"));
            retList.add(iscsiModel);
        }
        Collections.sort(retList);
        return retList;
    }

    private SanRequest createLUNMreadAllPortiScsiInfoExSanRequest(SJmoGetAgent modelAgent) {
        SanRequest sanRequest = modelAgent.newRequest("LUNMreadAllPortiScsiInfoEx");
        return sanRequest;
    }

    private SanResponse getSanResponse() {
        List<?> rmiDataList = this.getCache(SJctrGetThroughRmiDataViewLoginIscsiName.class);
        if (rmiDataList == null || rmiDataList.size() == 0) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSanResponse", "SanResponse list is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        SanResponse rmiObj = (SanResponse)rmiDataList.get(0);
        if (rmiObj == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSanResponse", "SanResponse object is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return rmiObj;
    }
}

