/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsConfirmTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsData;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJctrMapLunsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 0x100110F;
    private static final String KEY_TABLE = "COM_TABLE";

    public SJctrMapLunsConfirmDC() throws SJcException {
        super(0x100110F);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        List<Comparable> list;
        List<?> confirmDataList = this.getCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA);
        if (confirmDataList != null && confirmDataList.size() == 1) {
            SJctrMapLunsData mapLunsData = (SJctrMapLunsData)confirmDataList.get(0);
            list = mapLunsData.getLdevDetail();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no LdevDetail.");
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
            this.logUty.putlog("checkStartData", "LdevDetail = " + list.size());
            list = mapLunsData.getLdevLuseInfo();
            if (list == null) {
                this.logUty.putlog("checkStartData", "There is no LdevLuseInfo.");
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
            this.logUty.putlog("checkStartData", "LdevLuseInfo = " + list.size());
            list = mapLunsData.getPortDetail();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no PortDetail.");
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
            this.logUty.putlog("checkStartData", "PortDetail = " + list.size());
            list = mapLunsData.getPortHostGroup();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no Target PortHostGroup.");
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
            this.logUty.putlog("checkStartData", "Target PortHostGroup = " + list.size());
            list = mapLunsData.getPortLunInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no PortLunInfo.");
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
        } else {
            this.logUty.putlog("checkStartData", "There is no MapLunsData.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        this.logUty.putlog("checkStartData", "PortLunInfo = " + list.size());
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap confirmData = new HashMap();
        confirmData.put(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA.getName(), this.getCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA));
        return confirmData;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
    }

    private SJctrMapLunsData getMapLunsData() {
        List<?> confirmDataList = this.getCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA);
        SJctrMapLunsData mapLunsData = (SJctrMapLunsData)confirmDataList.get(0);
        return mapLunsData;
    }

    private void initDataModel() {
        SJctrMapLunsConfirmTableModel confirmTable = new SJctrMapLunsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, confirmTable);
    }

    @Override
    public List<SJmoRscUtil> getRscUtil() {
        List<SJmoRscUtil> rscUtilList = this.getCache(SJctrMapLUNsSubWizard.KEY_LUN_UTIL_DATA);
        return rscUtilList;
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        SJctrMapLunsData confirmData = (SJctrMapLunsData)this.getCache(SJctrMapLUNsSubWizard.KEY_MAP_LUNS_DATA).get(0);
        SJctrMapLunsConfirmTableModel table = (SJctrMapLunsConfirmTableModel)this.getDataObjectModel(KEY_TABLE);
        table.setModelDataFromConfirmData(confirmData);
        table.makeDataModel();
        List tempList = (List)destErrorList.get(1);
        List errorList = (List)tempList.get(0);
        List<SJmoLdevNicknameInfo> rowDataList = confirmData.getLdevNicknameInfo();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(rowDataList.size());
        for (int index = 0; index < rowDataList.size(); ++index) {
            if (((SJctrError)errorList.get(index)).getError() == 0) continue;
            SJmoLdevNicknameInfo nick = rowDataList.get(index);
            SJmoLdevIndex errKey = new SJmoLdevIndex();
            errKey.setLdevIndex(nick.getSLdkc(), nick.getSCu(), nick.getSLdev());
            SJctrError err = new SJctrError(((SJctrError)errorList.get(index)).getFunc(), ((SJctrError)errorList.get(index)).getModule(), ((SJctrError)errorList.get(index)).getError());
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(errKey, err);
            errList.add(errColumn);
        }
        SJctrLdevIndexComparator COMPARATOR = new SJctrLdevIndexComparator();
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(table, errList, COMPARATOR);
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }
}

