/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrAvailableLdevTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrSelectHostGroupDC;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrSelectLdevTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrSelectLdevDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1001101;
    private static final String GUID_TITLE = "DISP_ML1_TITLE";
    private static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    private static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_TABLE = "COM_TABLE";
    private List<SJmoLdevDetail> checkedLdevList;
    private List<SJctrErrorColumnData> errorDataList;
    private int selectableLdevCount;
    private Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> initializedHgMap;
    private Set<SJmoHostGroupInfo> initializedSelectHg;
    private SJctrRelatedDispDataObject additionalMessage;
    SJctrResourceGroupUtility rsgUtil;
    private Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> initializedItMap;
    private Set<SJmoIscsiTargetInfo> initializedSelectIt;
    public static int EDITHG_ERR1 = 105297;
    public static int EDITHG_ERR2 = 105298;
    public static final int EC_COEXISTENCE_OF_LDEV = 205053;
    public static int EDITHG_ERR_SysRSG_HG = 205164;
    public static int EDITHG_ERR_SysRSG_LDEV = 205165;

    public SJctrSelectLdevDC() throws SJcException {
        super(0x1001101);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        this.checkSelectLdev();
        this.checkSelectHostGroup();
        this.checkSelectIscsiTarget();
        return true;
    }

    private void checkSelectLdev() {
        int size = 0;
        List<?> list = this.getCache("KEY_SELECT_LDEV_INDEX");
        if (list != null) {
            size = list.size();
            if (size > SJctrPortUtility.PORT_LUN_MAX) {
                this.logUty.putlog("checkStartData", "Select LDEV = " + size, 30000);
                SJctrError error = new SJctrError(10, 22, 105089);
                throw error.createException();
            }
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (obj instanceof SJmoLdevIndex) continue;
                this.logUty.putlog("checkStartData", "Error object = " + obj, 40000);
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
        }
        this.logUty.putlog("checkStartData", "Select LDEV = " + size);
    }

    private void checkSelectHostGroup() {
        int size = 0;
        List<?> list = this.getCache("KEY_SELECT_HG_INDEX");
        if (list != null) {
            size = list.size();
            if (size > 64) {
                this.logUty.putlog("checkStartData", "Select PortHostGroup = " + size, 30000);
                SJctrError error = new SJctrError(10, 22, 105091);
                String[] msgArg = new String[]{Integer.toString(64)};
                error.setMsgArgument(msgArg);
                throw error.createException();
            }
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (obj instanceof SJctrPortHGIndex) continue;
                this.logUty.putlog("checkStartData", "Error object = " + obj, 40000);
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
        }
        this.logUty.putlog("checkStartData", "Select PortHostGroup = " + size);
    }

    private void checkSelectIscsiTarget() {
        int size = 0;
        List<?> list = this.getCache("KEY_SELECT_IT_INDEX");
        if (list != null) {
            size = list.size();
            if (size > 64) {
                this.logUty.putlog("checkStartData", "Select PortHostGroup = " + size, 30000);
                SJctrError error = new SJctrError(10, 22, SJctrMapLUNsSubWizard.MSG_SEL_IT_OVER);
                String[] msgArg = new String[]{Integer.toString(64)};
                error.setMsgArgument(msgArg);
                throw error.createException();
            }
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (obj instanceof SJmoIscsiTargetIndex) continue;
                this.logUty.putlog("checkStartData", "Error object = " + obj, 40000);
                SJctrError error = new SJctrError(10, 22, 107001);
                throw error.createException();
            }
        }
        this.logUty.putlog("checkStartData", "Select IscsiTargetGroup = " + size);
    }

    @Override
    public boolean checkConstructData() {
        SJctrError error;
        SJctrErrorDataController errorDialog;
        SJctrRelatedDispDataObject related;
        List<SJmoPortLunDetail> selectLunDetail;
        boolean bCapacityFlg = true;
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        List<Object> selectLdevList = this.getCache("KEY_SELECT_LDEV_INDEX");
        if (selectLdevList == null) {
            selectLdevList = Collections.emptyList();
        }
        this.logUty.putlog("checkConstructData", "Select LDEV = " + selectLdevList.size());
        List<Object> selectHgIndex = this.getCache("KEY_SELECT_HG_INDEX");
        if (selectHgIndex == null) {
            selectHgIndex = Collections.emptyList();
        }
        this.logUty.putlog("checkConstructData", "Select PortHostGroup = " + selectHgIndex.size());
        List<Object> selectItIndex = this.getCache("KEY_SELECT_IT_INDEX");
        if (selectItIndex == null) {
            selectItIndex = Collections.emptyList();
        }
        this.logUty.putlog("checkConstructData", "Select PortIscsiTarget = " + selectItIndex.size());
        List<SJmoLdevDetail> ldevList = this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_INFO);
        if (ldevList == null) {
            this.logUty.putlog("checkConstructData", "LdevDetail = null");
            SJctrError error2 = new SJctrError(10, 22, 107002);
            throw error2.createException();
        }
        this.logUty.putlog("checkConstructData", "LdevDetail = " + ldevList.size());
        List<SJmoLdevGuardInfo> guardList = this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_GUARD);
        if (guardList == null) {
            this.logUty.putlog("checkConstructData", "LdevGuardInfo = null");
            SJctrError error3 = new SJctrError(10, 22, 107002);
            throw error3.createException();
        }
        this.logUty.putlog("checkConstructData", "LdevGuardInfo = " + guardList.size());
        List<SJmoPortHostGroupInfo> phgList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_HG_INFO);
        List<SJmoPortIscsiTargetInfo> ptItList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_IT_INFO);
        if (phgList == null || ptItList == null) {
            if (phgList == null) {
                this.logUty.putlog("checkConstructData", "PortHostGroupInfo = null");
            } else {
                this.logUty.putlog("checkConstructData", "PortIscsiTargetInfo = null");
            }
            SJctrError error4 = new SJctrError(10, 22, 107002);
            throw error4.createException();
        }
        this.logUty.putlog("checkConstructData", "PortHostGroupInfo = " + phgList.size());
        this.logUty.putlog("checkConstructData", "PortIscsiTargetInfo = " + ptItList.size());
        List<SJmoPortAttributeInfo> attributeList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_ATTRIBUTE);
        if (attributeList == null) {
            this.logUty.putlog("checkConstructData", "PortAttributeInfo = null");
            SJctrError error5 = new SJctrError(10, 22, 107002);
            throw error5.createException();
        }
        this.logUty.putlog("checkConstructData", "PortAttributeInfo = " + attributeList.size());
        List<SJmoPortLunInfo> lunList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_LUN);
        if (lunList == null) {
            this.logUty.putlog("checkConstructData", "PortLunInfo = null");
            SJctrError error6 = new SJctrError(10, 22, 107002);
            throw error6.createException();
        }
        this.logUty.putlog("checkConstructData", "PortLunInfo = " + lunList.size());
        List<?> ldevNickList = this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_NICKNAME);
        if (ldevNickList == null) {
            this.logUty.putlog("checkConstructData", "LdevNicknameInfo = null");
            SJctrError error7 = new SJctrError(10, 22, 107002);
            throw error7.createException();
        }
        this.logUty.putlog("checkConstructData", "LdevNicknameInfo = " + ldevNickList.size());
        List<?> rsgDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_ALL_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            this.logUty.putlog("checkConstructData", "SJmoRSGgetAllRsgs = null");
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<SJmoPortDetail> portList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        if (portList == null) {
            this.logUty.putlog("checkConstructData", "PortDetail = null");
            SJctrError error8 = new SJctrError(10, 22, 107002);
            throw error8.createException();
        }
        this.logUty.putlog("checkConstructData", "PortDetail = " + portList.size());
        this.errorDataList = new ArrayList<SJctrErrorColumnData>(selectLdevList.size());
        Set<SJmoLdevDetail> selectSet = this.checkEquip(selectLdevList, ldevList);
        if (selectSet.size() > 0) {
            this.checkRsgLdev(selectSet, this.rsgUtil);
        }
        LinkedHashSet<SJmoLdevDetail> detailSet = new LinkedHashSet<SJmoLdevDetail>(ldevList);
        this.checkSystemRSG(selectSet, detailSet, this.rsgUtil);
        this.checkVolumeType(selectSet, detailSet);
        this.checkLuse(selectSet, detailSet);
        this.checkHIHSMReserve(selectSet, detailSet);
        this.checkPool(selectSet, detailSet);
        this.checkPoolOnlyLDEV(selectSet, detailSet);
        this.checkVirtualizationMode(selectSet, detailSet);
        this.checkSystemDisk(selectSet, detailSet);
        this.checkJournal(selectSet, detailSet);
        this.checkLockDisk(selectSet, detailSet);
        this.checkLdevGuardReserve(selectSet, detailSet, guardList);
        this.checkFPTVol(selectSet, detailSet);
        ArrayList<SJctrErrorColumnData> hgErrorList = new ArrayList<SJctrErrorColumnData>();
        Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap = SJctrSelectHostGroupDC.createPortHgMap(phgList, this.logUty);
        Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableItMap = SJctrSelectHostGroupDC.createPortItMap(ptItList, this.logUty);
        LinkedHashSet<SJmoHostGroupInfo> selectHgInfo = new LinkedHashSet();
        LinkedHashSet<SJmoIscsiTargetInfo> selectItInfo = new LinkedHashSet();
        ArrayList<SJctrErrorColumnData> itErrorList = new ArrayList<SJctrErrorColumnData>();
        if (selectHgIndex.size() > 0) {
            selectHgInfo = SJctrSelectHostGroupDC.checkEquipHostGroup(phgList, selectHgIndex, hgErrorList, this.logUty);
            SJctrSelectHostGroupDC.checkPortAttribute(selectHgInfo, availableMap, attributeList, hgErrorList, this.logUty);
            SJctrSelectHostGroupDC.checkHNASUserDefaultHG(selectHgInfo, availableMap, portList, hgErrorList, this.logUty);
            if (selectHgInfo.size() > 0) {
                this.checkRsgHostGroup(selectHgInfo, this.rsgUtil, availableMap, hgErrorList);
            }
            selectLunDetail = this.createMappedLun(selectHgInfo, availableMap, lunList, hgErrorList);
            this.checkLunPath(selectSet, detailSet, selectLunDetail);
            this.checkHostMode(selectSet, detailSet, selectHgInfo);
            boolean t10piDisabled = this.hasT10PIModeDisabled(selectHgInfo, portList);
            if (t10piDisabled) {
                this.checkT10PI(selectSet, detailSet);
            }
            this.selectableLdevCount = this.getSelectableCount(selectHgInfo, lunList);
        } else if (selectItIndex.size() > 0) {
            selectItInfo = SJctrSelectHostGroupDC.checkEquipIscsiTarget(ptItList, selectItIndex, itErrorList, this.logUty);
            SJctrSelectHostGroupDC.checkPortAttributeIscsi(selectItInfo, availableItMap, attributeList, itErrorList, this.logUty);
            if (selectItInfo.size() > 0) {
                this.checkRsgIscsiTarget(selectItInfo, this.rsgUtil, availableItMap, itErrorList);
            }
            selectLunDetail = this.createMappedLunIscsi(selectItInfo, availableItMap, lunList, itErrorList);
            this.checkLunPath(selectSet, detailSet, selectLunDetail);
            this.checkHostModeIscsi(selectSet, detailSet, selectItInfo);
            this.checkT10PI(selectSet, detailSet);
            this.selectableLdevCount = this.getSelectableCountIscsi(selectItInfo, lunList);
        } else {
            this.selectableLdevCount = SJctrPortUtility.PORT_LUN_MAX;
            this.initializedSelectHg = new LinkedHashSet<SJmoHostGroupInfo>();
            this.initializedSelectIt = new LinkedHashSet<SJmoIscsiTargetInfo>();
        }
        this.initializedHgMap = availableMap;
        this.initializedSelectHg = selectHgInfo;
        this.initializedItMap = availableItMap;
        this.initializedSelectIt = selectItInfo;
        ArrayList<SJmoLdevDetail> list = new ArrayList<SJmoLdevDetail>(detailSet);
        this.setCheckedLdevList(list);
        list = new ArrayList<SJmoLdevDetail>(selectSet);
        Collections.sort(list);
        for (SJmoLdevDetail ldevDtl : list) {
            if (bOpenFlg && bMFFlg) break;
            if (SJctrLdevUtility.isOpenVolume(ldevDtl)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrLdevUtility.isMFVolume(ldevDtl)) continue;
            bMFFlg = true;
        }
        SJctrSelectLdevTableModel table = (SJctrSelectLdevTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        table.setBasicDataList(list);
        this.logUty.putlog("checkConstructData", "Selected Table = " + list.size());
        this.putCache("KEY_TARGET_LDEV_INFO", list);
        list = new ArrayList<SJmoLdevDetail>(selectSet);
        ArrayList<SJmoLdevNicknameInfo> nicknameList = new ArrayList<SJmoLdevNicknameInfo>();
        for (SJmoLdevDetail ldevdtl : list) {
            SJmoLdevNicknameInfo selectNicknameInfo;
            int n = Collections.binarySearch(ldevNickList, ldevdtl);
            if (n >= 0) {
                selectNicknameInfo = (SJmoLdevNicknameInfo)ldevNickList.get(n);
            } else {
                selectNicknameInfo = new SJmoLdevNicknameInfo();
                selectNicknameInfo.setLdevIndex(ldevdtl.getSLdkc(), ldevdtl.getSCu(), ldevdtl.getSLdev());
            }
            nicknameList.add(selectNicknameInfo);
        }
        Collections.sort(nicknameList);
        this.putCache("KEY_TARGET_LDEV_NICKNAME", nicknameList);
        detailSet.removeAll(selectSet);
        list = new ArrayList<SJmoLdevDetail>(detailSet);
        table = (SJctrAvailableLdevTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<SJmoLdevIndex> rsgLdevList = this.rsgUtil.extractLdev(list);
        Collections.sort(rsgLdevList);
        for (SJmoLdevDetail sJmoLdevDetail : rsgLdevList) {
            if (bOpenFlg && bMFFlg) break;
            if (SJctrLdevUtility.isOpenVolume(sJmoLdevDetail)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrLdevUtility.isMFVolume(sJmoLdevDetail)) continue;
            bMFFlg = true;
        }
        table.setBasicDataList(rsgLdevList);
        this.logUty.putlog("checkConstructData", "Available Table = " + rsgLdevList.size());
        SJctrAvailableLdevTableModel availableTbl = (SJctrAvailableLdevTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectLdevTableModel selectedTbl = (SJctrSelectLdevTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        availableTbl.setCapacityFlg(bCapacityFlg);
        selectedTbl.setCapacityFlg(bCapacityFlg);
        availableTbl.setMainframeVolumeFlg(bMFFlg);
        selectedTbl.setMainframeVolumeFlg(bMFFlg);
        availableTbl.setOpenVolumeFlg(bOpenFlg);
        selectedTbl.setOpenVolumeFlg(bOpenFlg);
        if (!(!this.isConnectTask() || this.errorDataList.isEmpty() && hgErrorList.isEmpty() && itErrorList.isEmpty())) {
            this.getLogUty().putlog("ConnectTaskError", "LDEV: " + this.errorDataList.size() + ", HG: " + hgErrorList.size());
            this.errorDataList.clear();
            hgErrorList.clear();
            itErrorList.clear();
            this.addConnectTaskMessage();
        }
        if (this.errorDataList.size() > 0) {
            this.logUty.putlog("checkConstructData", "Error Dialog Data = " + this.errorDataList.size());
            related = this.createDialog(SJctrErrorDataController.class, null);
            errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
            SJctrTableDataModel sJctrTableDataModel = this.createErrorDialogTable(ldevList);
            errorDialog.setParameter(sJctrTableDataModel, this.errorDataList, new SJctrLdevIndexComparator());
            error = errorDialog.getRepresentativeError(this.errorDataList, 4);
            this.errorDataList = null;
            SJcException ex = error.createException();
            ex.setErrDisp(related);
            throw ex;
        }
        if (!itErrorList.isEmpty()) {
            this.logUty.putlog("checkConstructData", "Error Dialog Data = " + itErrorList.size());
            related = this.createDialog(SJctrErrorDataController.class, null);
            errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
            SJctrTableDataModel sJctrTableDataModel = SJctrSelectHostGroupDC.createErrorDialogIscsiTable(ptItList, this, this.getComUtility());
            errorDialog.setParameter(sJctrTableDataModel, itErrorList);
            error = errorDialog.getRepresentativeError(itErrorList, 4);
            SJcException ex = error.createException();
            ex.setErrDisp(related);
            throw ex;
        }
        if (!hgErrorList.isEmpty()) {
            this.logUty.putlog("checkConstructData", "Error Dialog Data = " + hgErrorList.size());
            related = this.createDialog(SJctrErrorDataController.class, null);
            errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
            SJctrTableDataModel sJctrTableDataModel = SJctrSelectHostGroupDC.createErrorDialogTable(phgList, this, this.getComUtility());
            errorDialog.setParameter(sJctrTableDataModel, hgErrorList);
            error = errorDialog.getRepresentativeError(hgErrorList, 4);
            SJcException ex = error.createException();
            ex.setErrDisp(related);
            throw ex;
        }
        return true;
    }

    SJctrTableDataModel createErrorDialogTable(List<SJmoLdevDetail> list) {
        SJctrSelectLdevTableModel table = new SJctrSelectLdevTableModel();
        table.setDataController(this);
        table.setPaging(false);
        table.initGuidance(this.getComUtility());
        table.createModelDirect();
        table.divideModelData(this.getProxy().getModelDataMap());
        table.setBasicDataList(list);
        table.makeDataModel();
        return table;
    }

    @Override
    public boolean checkEndData() {
        ArrayList<Cloneable> list;
        LinkedHashMap<SJmoPortIndex, SJctrPortHostGroupTableKey> availableMap;
        ArrayList errorList = new ArrayList();
        List<?> list2 = this.getCache("KEY_TARGET_LDEV_INFO");
        if (list2 == null || list2.size() <= 0) {
            this.logUty.putlog("checkEndData", "There is no Target LdevDetail.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        this.logUty.putlog("checkEndData", "Target LdevDetail = " + list2.size());
        if (this.initializedHgMap != null) {
            availableMap = new LinkedHashMap<SJmoHostGroupInfo, SJctrPortHostGroupTableKey>(this.initializedHgMap);
            list = new ArrayList<Cloneable>(1);
            list.add(availableMap);
            this.putCache("KEY_PORT_HG_MAP", list);
        }
        if (this.initializedSelectHg != null) {
            LinkedHashSet<SJmoHostGroupInfo> selectHgInfo = new LinkedHashSet<SJmoHostGroupInfo>(this.initializedSelectHg);
            list = new ArrayList(1);
            list.add(selectHgInfo);
            this.putCache("KEY_SELECT_HG_SET", list);
        }
        if (this.initializedItMap != null) {
            availableMap = new LinkedHashMap<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey>(this.initializedItMap);
            list = new ArrayList(1);
            list.add(availableMap);
            this.putCache("KEY_PORT_IT_MAP", list);
        }
        if (this.initializedSelectIt != null) {
            LinkedHashSet<SJmoIscsiTargetInfo> selectItInfo = new LinkedHashSet<SJmoIscsiTargetInfo>(this.initializedSelectIt);
            list = new ArrayList(1);
            list.add(selectItInfo);
            this.putCache("KEY_SELECT_IT_SET", list);
        }
        return errorList.size() == 0;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel nextButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.NEXT);
        nextButton.setChangeCheck(false);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", GUID_TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLdevGuardInfo();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public void setCheckedLdevList(List<SJmoLdevDetail> list) {
        this.checkedLdevList = list;
    }

    private void initDataModel() {
        SJctrSelectLdevTableModel table = new SJctrAvailableLdevTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, table);
        table = new SJctrSelectLdevTableModel();
        this.addDataObjectModel(KEY_TABLE_SELECTED, table);
        table.setPaging(false);
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectLdevDC.this.fireMessageEvent(SELECT_LDEV_MSG.ADD);
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectLdevDC.this.fireMessageEvent(SELECT_LDEV_MSG.REMOVE);
            }
        });
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
        SJctrSimpleDataModel child = new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>();
                if (SJctrSelectLdevDC.this.additionalMessage != null) {
                    retList.add(SJctrSelectLdevDC.this.additionalMessage);
                    SJctrSelectLdevDC.this.additionalMessage = null;
                }
                return retList;
            }
        };
        this.addDataObjectModel("COM_CHILD", child);
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_LDEV_MSG.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel availableTable = (SJctrTableDataModel)SJctrSelectLdevDC.this.getDataObjectModel(SJctrSelectLdevDC.KEY_TABLE_AVAILABLE);
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrSelectLdevDC.this.getDataObjectModel(SJctrSelectLdevDC.KEY_TABLE_SELECTED);
                int selectCount = selectedTable.getRowCount();
                if ((selectCount += availableTable.getSelectedRowCount()) > SJctrSelectLdevDC.this.selectableLdevCount) {
                    SJctrError error = new SJctrError(10, 22, 105089);
                    throw error.createException();
                }
                List<Object> list = availableTable.removeSelectedRowData();
                selectedTable.addRowDataTop(list);
                SJctrSelectLdevDC.this.logUty.putlog("ADD Action", "Add data = " + list.size());
                SJctrSelectLdevDC.this.logUty.putlog("ADD Action", "Available : Selected = " + availableTable.getRowCount() + " : " + selectedTable.getRowCount());
                List<?> targetList = SJctrSelectLdevDC.this.getCache("KEY_TARGET_LDEV_INFO");
                ArrayList<Object> cacheStoreLdevList = new ArrayList<Object>(list.size() + targetList.size());
                cacheStoreLdevList.addAll(list);
                cacheStoreLdevList.addAll(targetList);
                Collections.sort(cacheStoreLdevList);
                SJctrSelectLdevDC.this.putCache("KEY_TARGET_LDEV_INFO", cacheStoreLdevList);
                List<?> ldevNickList = SJctrSelectLdevDC.this.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_NICKNAME);
                ArrayList<SJmoLdevNicknameInfo> nicknameList = new ArrayList<SJmoLdevNicknameInfo>();
                for (SJmoLdevDetail sJmoLdevDetail : list) {
                    int index = Collections.binarySearch(ldevNickList, sJmoLdevDetail);
                    SJmoLdevNicknameInfo selectNicknameInfo = null;
                    if (index >= 0) {
                        SJmoLdevNicknameInfo ldevNick = (SJmoLdevNicknameInfo)ldevNickList.get(index);
                        try {
                            selectNicknameInfo = (SJmoLdevNicknameInfo)ldevNick.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            SJctrSelectLdevDC.this.logUty.putlog("doMessageAction", "clone(): " + ldevNick);
                            SJctrError error = new SJctrError(10, 22, 107002);
                            throw error.createException();
                        }
                    } else {
                        selectNicknameInfo = new SJmoLdevNicknameInfo();
                        selectNicknameInfo.setLdevIndex(sJmoLdevDetail.getSLdkc(), sJmoLdevDetail.getSCu(), sJmoLdevDetail.getSLdev());
                    }
                    nicknameList.add(selectNicknameInfo);
                }
                List<?> targetList2 = SJctrSelectLdevDC.this.getCache("KEY_TARGET_LDEV_NICKNAME");
                nicknameList.addAll(targetList2);
                Collections.sort(nicknameList);
                SJctrSelectLdevDC.this.putCache("KEY_TARGET_LDEV_NICKNAME", nicknameList);
                SJctrSelectLdevDC.this.updateFooter();
                SJctrSelectLdevDC.this.setDirtyAll();
            }
        });
        this.addMessageEventListener(SELECT_LDEV_MSG.REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                int index;
                SJmoLdevDetail ldevDetail;
                int i;
                SJctrTableDataModel availableTable = (SJctrTableDataModel)SJctrSelectLdevDC.this.getDataObjectModel(SJctrSelectLdevDC.KEY_TABLE_AVAILABLE);
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrSelectLdevDC.this.getDataObjectModel(SJctrSelectLdevDC.KEY_TABLE_SELECTED);
                List<Object> list = selectedTable.removeSelectedRowData();
                availableTable.addRowDataTop(list);
                SJctrSelectLdevDC.this.logUty.putlog("REMOVE Action", "Remove data = " + list.size());
                SJctrSelectLdevDC.this.logUty.putlog("REMOVE Action", "Available : Selected = " + availableTable.getRowCount() + " : " + selectedTable.getRowCount());
                List<?> cacheList = SJctrSelectLdevDC.this.getCache("KEY_TARGET_LDEV_INFO");
                ArrayList targetList = new ArrayList(cacheList);
                Collections.sort(targetList);
                Collections.sort(list);
                for (i = list.size() - 1; i >= 0; --i) {
                    ldevDetail = (SJmoLdevDetail)list.get(i);
                    index = Collections.binarySearch(targetList, ldevDetail);
                    if (index >= 0) {
                        targetList.remove(index);
                        continue;
                    }
                    SJctrSelectLdevDC.this.logUty.putlog("REMOVE Action", "Not found from cache list: " + ldevDetail);
                }
                SJctrSelectLdevDC.this.putCache("KEY_TARGET_LDEV_INFO", targetList);
                cacheList = SJctrSelectLdevDC.this.getCache("KEY_TARGET_LDEV_NICKNAME");
                targetList = new ArrayList(cacheList);
                Collections.sort(targetList);
                Collections.sort(list);
                for (i = list.size() - 1; i >= 0; --i) {
                    ldevDetail = (SJmoLdevDetail)list.get(i);
                    index = Collections.binarySearch(targetList, ldevDetail);
                    if (index >= 0) {
                        targetList.remove(index);
                        continue;
                    }
                    SJctrSelectLdevDC.this.logUty.putlog("REMOVE Action", "Not found from cache list: " + ldevDetail);
                }
                SJctrSelectLdevDC.this.putCache("KEY_TARGET_LDEV_NICKNAME", targetList);
                SJctrSelectLdevDC.this.updateFooter();
                SJctrSelectLdevDC.this.setDirtyAll();
            }
        });
    }

    private Set<SJmoLdevDetail> checkEquip(List<SJmoLdevIndex> selectList, List<SJmoLdevDetail> detailList) {
        this.logUty.putlog("checkEquip", "Selected index list = " + selectList.size());
        LinkedHashSet<SJmoLdevDetail> set = new LinkedHashSet<SJmoLdevDetail>();
        for (SJmoLdevIndex ldevIndex : selectList) {
            int index = Collections.binarySearch(detailList, ldevIndex);
            if (index >= 0) {
                SJmoLdevDetail detail = detailList.get(index);
                set.add(detail);
                continue;
            }
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkEquip", "Not equip LDEV: " + ldevIndex);
            SJctrError error = new SJctrError(10, 22, 106519);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevIndex, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkEquip", "Selected equipment list = " + set.size());
        return set;
    }

    private void checkRsgLdev(Set<SJmoLdevDetail> selectSet, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>(selectSet);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        for (SJmoLdevDetail ldevDetail : ldevList) {
            boolean delFlg;
            ldevIndex.setLdevIndex(ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev());
            int rsgId = rsgUtil.getRsgId(ldevIndex);
            boolean rsgFlg = rsgUtil.chkResourceGroup(rsgId);
            if (rsgFlg || !(delFlg = selectSet.remove(ldevDetail))) continue;
            SJctrError error = new SJctrError(10, 22, EDITHG_ERR2);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
    }

    private void checkRsgHostGroup(Set<SJmoHostGroupInfo> selectHgInfo, SJctrResourceGroupUtility rsgUtil, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJctrErrorColumnData> hgErrorList) {
        ArrayList<SJmoHostGroupInfo> hgList = new ArrayList<SJmoHostGroupInfo>(selectHgInfo);
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (SJmoHostGroupInfo hgInfo : hgList) {
            boolean delFlg;
            hgIndex.setSPort(hgInfo.getSPort());
            hgIndex.setSHostGroup(hgInfo.getSHostGroup());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                boolean delFlg2 = selectHgInfo.remove(hgInfo);
                if (!delFlg2) continue;
                SJctrPortHostGroupTableKey tableKey = availableMap.get(hgInfo);
                SJctrError error = new SJctrError(10, 22, EDITHG_ERR1);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                hgErrorList.add(errorData);
                continue;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
            if (!sysRsgFlg || !(delFlg = selectHgInfo.remove(hgInfo))) continue;
            SJctrPortHostGroupTableKey tableKey = availableMap.get(hgInfo);
            SJctrError error = new SJctrError(10, 22, EDITHG_ERR_SysRSG_HG);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            hgErrorList.add(errorData);
        }
    }

    private void checkRsgIscsiTarget(Set<SJmoIscsiTargetInfo> selectItInfo, SJctrResourceGroupUtility rsgUtil, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJctrErrorColumnData> hgErrorList) {
        ArrayList<SJmoIscsiTargetInfo> itList = new ArrayList<SJmoIscsiTargetInfo>(selectItInfo);
        SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
        for (SJmoIscsiTargetInfo itInfo : itList) {
            boolean delFlg;
            itIndex.setSPort(itInfo.getSPort());
            itIndex.setSHostGroup(itInfo.getSIscsiTarget());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(itIndex, rsgUtil);
            if (rsgFlg || !(delFlg = selectItInfo.remove(itInfo))) continue;
            SJctrPortHostGroupTableKey tableKey = availableMap.get(itInfo);
            SJctrError error = new SJctrError(10, 22, EDITHG_ERR1);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            hgErrorList.add(errorData);
        }
    }

    private void checkSystemRSG(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet, SJctrResourceGroupUtility rsgUtil) {
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev());
            boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(ldevIndex);
            if (!sysRsgFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrError error = new SJctrError(10, 22, EDITHG_ERR_SysRSG_LDEV);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
    }

    private void checkVolumeType(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkVolumeType", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            byte volType = ldevDetail.getByVolumeFlag();
            if (volType == 2 || volType == 3) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkVolumeType", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 108017);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkVolumeType", "output = " + detailSet.size());
    }

    private void checkLuse(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkLuse", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            short luseNum = ldevDetail.getSLUSEEmlCount();
            if (luseNum > 0) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkLuse", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkLuse", "output = " + detailSet.size());
    }

    private void checkHIHSMReserve(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkHIHSMReserve", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean checkFlg = ldevDetail.getbHIHSMReserve();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkHIHSMReserve", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkHIHSMReserve", "output = " + detailSet.size());
    }

    private void checkPool(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkPool", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean checkFlg = ldevDetail.getbPoolVol();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkPool", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 108012);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkPool", "output = " + detailSet.size());
    }

    private void checkPoolOnlyLDEV(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkPoolOnlyLDEV", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            boolean checkFlg;
            SJmoLdevDetail ldevDetail = ite.next();
            boolean bl = checkFlg = ldevDetail.getBPoolOnlyLDEV() && ldevDetail.getBDM();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkPoolOnlyLDEV", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 205202);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkPoolOnlyLDEV", "output = " + detailSet.size());
    }

    private void checkVirtualizationMode(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkVirtualizationMode", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            boolean checkFlg;
            SJmoLdevDetail ldevDetail = ite.next();
            boolean bl = checkFlg = ldevDetail.getBVirtSupport() && ldevDetail.getBVirtMode();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkVirtualizationMode", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 205207);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkVirtualizationMode", "output = " + detailSet.size());
    }

    private void checkSystemDisk(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkSystemDisk", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean checkFlg = ldevDetail.getbSystemDisk();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkSystemDisk", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkSystemDisk", "output = " + detailSet.size());
    }

    private void checkJournal(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkJournal", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean checkFlg = ldevDetail.getbJNLVolume();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkJournal", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 108011);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkJournal", "output = " + detailSet.size());
    }

    private void checkLockDisk(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkLockDisk", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean checkFlg = ldevDetail.getBLockVolume();
            if (!checkFlg) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkLockDisk", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 108015);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLockDisk", "output = " + detailSet.size());
    }

    private void checkLdevGuardReserve(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet, List<SJmoLdevGuardInfo> guardList) {
        this.logUty.putlog("checkLdevGuardReserve", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            byte guard = 0;
            int index = Collections.binarySearch(guardList, ldevDetail);
            if (index >= 0) {
                SJmoLdevGuardInfo guardInfo = guardList.get(index);
                guard = guardInfo.getByLdevGuardStatus();
            } else {
                this.logUty.putlog("checkLdevGuardReserve", "Not found LdevGuardInfo: " + ldevDetail);
            }
            if ((guard & 8) == 0) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkLdevGuardReserve", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 108006);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLdevGuardReserve", "output = " + detailSet.size());
    }

    private void checkFPTVol(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkFPTVol", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            boolean checkFlg;
            SJmoLdevDetail ldevDetail = ite.next();
            if (ldevDetail.getByVolumeType() != 3 || !(checkFlg = ldevDetail.getBFPTVol())) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkFPTVol", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 205220);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkFPTVol", "output = " + detailSet.size());
    }

    private List<SJmoPortLunDetail> createMappedLun(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> portLunList, List<SJctrErrorColumnData> hgErrorList) {
        List<SJmoPortLunDetail> retList = Collections.emptyList();
        if (!selectHgInfo.isEmpty() && !portLunList.isEmpty()) {
            retList = new ArrayList();
            Comparator<SJmoPortIndex> portComp = new Comparator<SJmoPortIndex>(){

                @Override
                public int compare(SJmoPortIndex o1, SJmoPortIndex o2) {
                    return o1.getSPort() - o2.getSPort();
                }
            };
            List<List<SJmoHostGroupInfo>> portList = this.createHostGroupPerPort(selectHgInfo);
            int portListSize = portList.size();
            for (int i = 0; i < portListSize; ++i) {
                List<SJmoHostGroupInfo> hgList = portList.get(i);
                int hgListSize = hgList.size();
                if (hgListSize == 0) {
                    this.logUty.putlog("createMappedLun", "HostGroup list size = 0", 40000);
                    continue;
                }
                SJmoHostGroupInfo hgInfo = hgList.get(0);
                int index = Collections.binarySearch(portLunList, hgInfo, portComp);
                if (index < 0) continue;
                SJmoPortLunInfo portLunInfo = portLunList.get(index);
                int lunCount = portLunInfo.getAlPortLun().size();
                if (lunCount >= SJctrPortUtility.PORT_LUN_MAX) {
                    for (int count = 0; count < hgListSize; ++count) {
                        SJmoHostGroupInfo key = hgList.get(count);
                        SJctrPortHostGroupTableKey tableKey = availableMap.get(key);
                        selectHgInfo.remove(key);
                        availableMap.remove(key);
                        SJctrError error = new SJctrError(10, 22, 105207);
                        SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                        hgErrorList.add(errorData);
                    }
                }
                for (int j = 0; j < hgListSize; ++j) {
                    SJmoHostGroupInfo hg = hgList.get(j);
                    ArrayList lunDetailList = portLunInfo.getAlHostGroupLun(hg.getSHostGroup());
                    retList.addAll(lunDetailList);
                }
            }
        }
        this.logUty.putlog("createMappedLun", "Mapped Lun = " + retList.size());
        return retList;
    }

    private List<SJmoPortLunDetail> createMappedLunIscsi(Set<SJmoIscsiTargetInfo> selectItInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> portLunList, List<SJctrErrorColumnData> itErrorList) {
        List<SJmoPortLunDetail> retList = Collections.emptyList();
        if (!selectItInfo.isEmpty() && !portLunList.isEmpty()) {
            retList = new ArrayList();
            Comparator<SJmoPortIndex> portComp = new Comparator<SJmoPortIndex>(){

                @Override
                public int compare(SJmoPortIndex o1, SJmoPortIndex o2) {
                    return o1.getSPort() - o2.getSPort();
                }
            };
            List<List<SJmoIscsiTargetInfo>> portList = this.createIscsiTargetPerPort(selectItInfo);
            int portListSize = portList.size();
            for (int i = 0; i < portListSize; ++i) {
                List<SJmoIscsiTargetInfo> itList = portList.get(i);
                int itListSize = itList.size();
                if (itListSize == 0) {
                    this.logUty.putlog("createMappedLun", "IscsiTarget list size = 0", 40000);
                    continue;
                }
                SJmoIscsiTargetInfo hgInfo = itList.get(0);
                int index = Collections.binarySearch(portLunList, hgInfo, portComp);
                if (index < 0) continue;
                SJmoPortLunInfo portLunInfo = portLunList.get(index);
                int lunCount = portLunInfo.getAlPortLun().size();
                if (lunCount >= SJctrPortUtility.PORT_LUN_MAX) {
                    for (int count = 0; count < itListSize; ++count) {
                        SJmoIscsiTargetInfo key = itList.get(count);
                        SJctrPortHostGroupTableKey tableKey = availableMap.get(key);
                        selectItInfo.remove(key);
                        availableMap.remove(key);
                        SJctrError error = new SJctrError(10, 22, 105207);
                        SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                        itErrorList.add(errorData);
                    }
                }
                for (int j = 0; j < itListSize; ++j) {
                    SJmoIscsiTargetInfo hg = itList.get(j);
                    ArrayList lunDetailList = portLunInfo.getAlHostGroupLun(hg.getSIscsiTarget());
                    retList.addAll(lunDetailList);
                }
            }
        }
        this.logUty.putlog("createMappedLun", "Mapped Lun = " + retList.size());
        return retList;
    }

    private List<List<SJmoHostGroupInfo>> createHostGroupPerPort(Set<SJmoHostGroupInfo> selectHgInfo) {
        List<List<SJmoHostGroupInfo>> portList = Collections.emptyList();
        if (!selectHgInfo.isEmpty()) {
            portList = new ArrayList<List<SJmoHostGroupInfo>>(SJctrPortUtility.PORT_MAX);
            ArrayList<SJmoHostGroupInfo> targetList = new ArrayList<SJmoHostGroupInfo>(selectHgInfo);
            Collections.sort(targetList);
            List hgList = Collections.emptyList();
            SJmoPortIndex nowInfo = null;
            int listSize = targetList.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)targetList.get(i);
                if (nowInfo != null && nowInfo.getSPort() == hgInfo.getSPort()) {
                    hgList.add(hgInfo);
                    continue;
                }
                hgList = new ArrayList(SJctrPortUtility.PORT_HOSTGROUP_MAX);
                hgList.add(hgInfo);
                portList.add(hgList);
                nowInfo = hgInfo;
            }
        }
        return portList;
    }

    private List<List<SJmoIscsiTargetInfo>> createIscsiTargetPerPort(Set<SJmoIscsiTargetInfo> selectItInfo) {
        List<List<SJmoIscsiTargetInfo>> portList = Collections.emptyList();
        if (!selectItInfo.isEmpty()) {
            portList = new ArrayList<List<SJmoIscsiTargetInfo>>(SJctrPortUtility.PORT_MAX);
            ArrayList<SJmoIscsiTargetInfo> targetList = new ArrayList<SJmoIscsiTargetInfo>(selectItInfo);
            Collections.sort(targetList);
            List itList = Collections.emptyList();
            SJmoPortIndex nowInfo = null;
            int listSize = targetList.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)targetList.get(i);
                if (nowInfo != null && nowInfo.getSPort() == itInfo.getSPort()) {
                    itList.add(itInfo);
                    continue;
                }
                itList = new ArrayList(SJctrPortUtility.PORT_ISCSITARGET_MAX);
                itList.add(itInfo);
                portList.add(itList);
                nowInfo = itInfo;
            }
        }
        return portList;
    }

    private void checkLunPath(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet, List<SJmoPortLunDetail> selectLunDetail) {
        this.logUty.putlog("checkLunPath", "input  = " + detailSet.size());
        if (!selectLunDetail.isEmpty()) {
            TreeSet<Object> mappedLun = new TreeSet<Object>(new SJctrLdevIndexComparator());
            int listSize = selectLunDetail.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoPortLunDetail lunDetail = selectLunDetail.get(i);
                mappedLun.add(lunDetail);
            }
            Iterator<SJmoLdevDetail> ite = detailSet.iterator();
            while (ite.hasNext()) {
                SJmoLdevDetail ldevDetail = ite.next();
                boolean checkFlg = mappedLun.contains(ldevDetail);
                if (!checkFlg) continue;
                ite.remove();
            }
        }
        this.logUty.putlog("checkLunPath", "output = " + detailSet.size());
    }

    private void checkHostMode(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet, Set<SJmoHostGroupInfo> selectHgInfo) {
        this.logUty.putlog("checkHostMode", "input  = " + detailSet.size());
        if (this.isUvmHostMode(selectHgInfo)) {
            Iterator<SJmoLdevDetail> ite = detailSet.iterator();
            while (ite.hasNext()) {
                SJmoLdevDetail ldevDetail = ite.next();
                boolean checkFlg = SJctrLdevUtility.isATypeVolume(ldevDetail);
                if (checkFlg) continue;
                ite.remove();
            }
        }
        this.logUty.putlog("checkHostMode", "output = " + detailSet.size());
    }

    private boolean isUvmHostMode(Set<SJmoHostGroupInfo> selectHgInfo) {
        boolean result = false;
        for (SJmoHostGroupInfo hostGroup : selectHgInfo) {
            byte hostMode = hostGroup.getByHostMode();
            if (hostMode != 76) continue;
            result = true;
            break;
        }
        this.logUty.putlog("isUvmHostMode", Boolean.toString(result));
        return result;
    }

    private void checkHostModeIscsi(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet, Set<SJmoIscsiTargetInfo> selectItInfo) {
        this.logUty.putlog("checkHostMode", "input  = " + detailSet.size());
        if (this.isUvmHostModeIscsi(selectItInfo)) {
            Iterator<SJmoLdevDetail> ite = detailSet.iterator();
            while (ite.hasNext()) {
                SJmoLdevDetail ldevDetail = ite.next();
                boolean checkFlg = SJctrLdevUtility.isATypeVolume(ldevDetail);
                if (checkFlg) continue;
                ite.remove();
            }
        }
        this.logUty.putlog("checkHostMode", "output = " + detailSet.size());
    }

    private boolean isUvmHostModeIscsi(Set<SJmoIscsiTargetInfo> selectItInfo) {
        boolean result = false;
        for (SJmoIscsiTargetInfo iscsiTarget : selectItInfo) {
            Integer iscsiHostMode = new Integer(iscsiTarget.getIHostMode());
            byte hostMode = iscsiHostMode.byteValue();
            if (hostMode != 76) continue;
            result = true;
            break;
        }
        this.logUty.putlog("isUvmHostMode", Boolean.toString(result));
        return result;
    }

    private boolean hasT10PIModeDisabled(Set<SJmoHostGroupInfo> selectHgInfo, List<SJmoPortDetail> portList) {
        boolean result = false;
        SJmoPortIndex portIndex = new SJmoPortIndex();
        for (SJmoHostGroupInfo hgInfo : selectHgInfo) {
            SJmoPortDetail portDetail;
            int t10piMode;
            short sPort = hgInfo.getSPort();
            portIndex.setSPort(sPort);
            int index = Collections.binarySearch(portList, portIndex);
            if (index < 0 || (t10piMode = (portDetail = portList.get(index)).getIT10Pi()) == 1) continue;
            result = true;
            break;
        }
        this.logUty.putlog("hasT10PIModeDisabled", Boolean.toString(result));
        return result;
    }

    private void checkT10PI(Set<SJmoLdevDetail> selectSet, Set<SJmoLdevDetail> detailSet) {
        this.logUty.putlog("checkT10PI", "input  = " + detailSet.size());
        Iterator<SJmoLdevDetail> ite = detailSet.iterator();
        while (ite.hasNext()) {
            SJmoLdevDetail ldevDetail = ite.next();
            boolean t10Pi = ldevDetail.getBT10pi();
            if (!t10Pi) continue;
            ite.remove();
            boolean delFlg = selectSet.remove(ldevDetail);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectLdevDC", "checkVolumeType", "Off the subject: " + ldevDetail);
            SJctrError error = new SJctrError(10, 22, 206295);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(ldevDetail, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkT10PI", "output = " + detailSet.size());
    }

    private int getSelectableCount(Set<SJmoHostGroupInfo> selectHgInfo, List<SJmoPortLunInfo> lunDetail) {
        int resultCount = SJctrPortUtility.PORT_LUN_MAX;
        int[] hgCount = this.getSelectHostGroupCount(selectHgInfo);
        int[] ldevCount = this.getMappingLunCount(lunDetail);
        for (int i = 0; i < SJmoDataMacro_IF.MAX_PORT_LDKC; ++i) {
            if (hgCount[i] == 0) continue;
            int count = SJctrPortUtility.PORT_LUN_MAX - ldevCount[i];
            resultCount = Math.min(resultCount, count /= hgCount[i]);
        }
        this.logUty.putlog("getSelectableCount", "Selectable Count = " + resultCount);
        return resultCount;
    }

    private int getSelectableCountIscsi(Set<SJmoIscsiTargetInfo> selectItInfo, List<SJmoPortLunInfo> lunDetail) {
        int resultCount = SJctrPortUtility.PORT_LUN_MAX;
        int[] hgCount = this.getSelectIscsiTargetCount(selectItInfo);
        int[] ldevCount = this.getMappingLunCount(lunDetail);
        for (int i = 0; i < SJmoDataMacro_IF.MAX_PORT_LDKC; ++i) {
            if (hgCount[i] == 0) continue;
            int count = SJctrPortUtility.PORT_LUN_MAX - ldevCount[i];
            resultCount = Math.min(resultCount, count /= hgCount[i]);
        }
        this.logUty.putlog("getSelectableCountIscsi", "Selectable Count = " + resultCount);
        return resultCount;
    }

    private int[] getSelectHostGroupCount(Set<SJmoHostGroupInfo> selectHgInfo) {
        int[] hgCount = new int[SJmoDataMacro_IF.MAX_PORT_LDKC];
        if (!selectHgInfo.isEmpty()) {
            for (SJmoHostGroupInfo hg : selectHgInfo) {
                short port;
                short s = port = hg.getSPort();
                hgCount[s] = hgCount[s] + 1;
            }
        }
        return hgCount;
    }

    private int[] getSelectIscsiTargetCount(Set<SJmoIscsiTargetInfo> selectItInfo) {
        int[] itCount = new int[SJmoDataMacro_IF.MAX_PORT_LDKC];
        if (!selectItInfo.isEmpty()) {
            for (SJmoIscsiTargetInfo it : selectItInfo) {
                short port;
                short s = port = it.getSPort();
                itCount[s] = itCount[s] + 1;
            }
        }
        return itCount;
    }

    private int[] getMappingLunCount(List<SJmoPortLunInfo> lunDetail) {
        int[] ldevCount = new int[SJmoDataMacro_IF.MAX_PORT_LDKC];
        if (!lunDetail.isEmpty()) {
            int listSize = lunDetail.size();
            for (int i = 0; i < listSize; ++i) {
                SJmoPortLunInfo portLun = lunDetail.get(i);
                short port = portLun.getSPort();
                ldevCount[port] = portLun.getAlPortLun().size();
            }
        }
        return ldevCount;
    }

    private boolean isConnectTask() {
        boolean result = false;
        SJctrWizardWindowDC topWiz = this.getTopWizard();
        if (topWiz != null) {
            result = topWiz.isBack();
        }
        return result;
    }

    private void addConnectTaskMessage() {
        SJcMessage msg = new SJcMessage(Integer.toString(10), Integer.toString(22), Integer.toString(105277));
        this.additionalMessage = this.createMsgDialog(msg);
    }

    public static enum SELECT_LDEV_MSG implements SJctrNotifyState
    {
        ADD,
        REMOVE;

    }
}

