/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_MonMonitoringCU;
import sanproject.serverux.arg.monitor.SetPPCWWNRegistDelete;
import sanproject.serverux.arg.monitor.SetPPCWWNRegistEntry;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorAvailablePortsInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorCUInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;
import sanproject.sn2.model.connector.kind.SJmoGetNonPortSetPPCExistenceInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.monitor.SJmoNonPortSetPPCExistenceInfo;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrOptionMonitorUtility {
    public static final int MONITORING_CU_BOUNDARY_HM800S = 8;
    public static final int MONITORING_CU_BOUNDARY_HM800M = 16;
    public static final int MONITORING_CU_BOUNDARY_HM800H = 32;
    public static final int MONITORING_CU_BOUNDARY = 64;
    public static final int MONITORING_CU_MAX = 255;
    public static final int MONITORING_WWN_MAX = 2048;
    public static final int MONITORING_WWN_MAX_PORT = 32;
    public static final int MONITORING_INTERVAL_MIN_5 = 300;
    public static final int MONITORING_INTERVAL_MIN_10 = 600;
    public static final int MONITORING_INTERVAL_MIN_15 = 900;
    public static final int MONITORING_INTERVAL_MAX = 15;
    public static final int MONITORING_SET_TYPE_MON_SW_CUS = 0;
    public static final int MONITORING_SET_TYPE_MON_SW = 1;
    public static final int MONITORING_SET_TYPE_MON_CUS = 2;
    public static final int MONITORING_GRAPHPANEL_OBJECT_MAX = 8;
    public static final int MONITORING_OBJECT_MAX = 16;
    public static final int AC_LEAD_TIME_MONMONITORING = 3;
    public static final int AC_LEAD_TIME_MONITORING_WWN = 15;
    public static final int DEF_UNUSED_MON_WWN_NOT_EXIST = 0;
    public static final int DEF_UNUSED_MON_WWN_EXIST = 1;
    private static final int DEF_INTERNAL_PG_NO_START = 1;
    public static int DEF_INTERNAL_PG_NO_END = SJmoDataMacro_IF.PGKIND_INTERNAL_MAX;
    private static final int DEF_EXTERNAL_PG_NO_START = 101;
    private static final int DEF_EXTERNAL_PG_NO_END = 16484;
    private static final int DEF_FICON_DM_PG_NO_START = 16641;
    private static final int DEF_FICON_DM_PG_NO_END = 17152;
    public static final String ACT_PPC = "ACT_OLDGUI_PPC";
    public static final int SELECTED_MP_NUMBER = 1;
    public static final int SELECT_GET_DATATYPE = 1;
    public static final int GETDATA_NUMBER_OF_OWNERINFO = 20;
    public static final int GET_LDEV_NUMBER_FROM_OWNERINFO = 0;
    public static final int SIZE_INCLUDE_OWNER_AND_LDEVNAME = 2;
    public static final int SIZE_LIST_KEY_VIEW_MP_INFO = 2;
    public static final int RMIDATA_OPEN_TARGET = 0;
    public static final int RMIDATA_OPEN_INITIATOR = 1;
    public static final int RMIDATA_OPEN_EXTERNAL = 2;
    public static final int RMIDATA_MF_TARGET = 3;
    public static final int RMIDATA_MF_EXTERNAL = 4;
    public static final int RMIDATA_BACKEND = 5;
    public static final int RMIDATA_SYSTEM = 6;
    public static final int DIGIT_NUM_JNL_ID_NO = 3;

    public static List<?> getCache(SJctrDataController dc, Class<?> key) {
        if (dc instanceof SJctrWizardDataController) {
            return ((SJctrWizardDataController)dc).getCache(key);
        }
        return dc.getProxy().getCache(key);
    }

    public static MonMonitoringInfoLDKC getMonMonitoringInfoLDKC(SJctrDataController dc) {
        List<?> rmiData = SJctrOptionMonitorUtility.getCache(dc, SJmoGetMonMonitoringInfoLDKC.class);
        if (null == rmiData) {
            dc.getLogUty().putlog("getMonMonitoringInfoLDKC", "RMIData of monitor options is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (rmiData.size() == 0) {
            dc.getLogUty().putlog("getMonMonitoringInfoLDKC", "Size of RMIData data list is zero.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        MonMonitoringInfoLDKC monInfo = (MonMonitoringInfoLDKC)((SJmoThroughRmiData)rmiData.get(0)).getObjRmi();
        if (null == monInfo) {
            dc.getLogUty().putlog("getMonMonitoringInfoLDKC", "Information of monitor options is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return monInfo;
    }

    public static List<SJmoPPCALLPortWWNInfo> getPPCALLPortWWNInfo(SJctrDataController dc) {
        List<SJmoPPCALLPortWWNInfo> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPPCALLPortWWNInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getPPCALLPortWWNInfo", "Information of monitored WWNs is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortWwnInfo> getSJmoPortWwnInfo(SJctrDataController dc) {
        List<SJmoPortWwnInfo> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPortWwnInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortWwnInfo", "Information of logined WWNs is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortHostGroupInfo> getSJmoPortHostGroupInfo(SJctrDataController dc) {
        List<SJmoPortHostGroupInfo> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPortHostGroupInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortHostGroupInfo", "Information of WWNs registered to LUN Manager is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortDetail> getSJmoPortDetail(SJctrDataController dc) {
        List<SJmoPortDetail> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPortDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortDetail", "Information of port detail is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevDetail> getSJmoLdevDetail(SJctrDataController dc) {
        List<SJmoLdevDetail> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetLdevDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevDetail", "Information of LDEVs is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPgDetail> getSJmoPgDetail(SJctrDataController dc) {
        List<SJmoPgDetail> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPgDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgDetail", "Information of parity groups is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPgScatteredInfo> getSJmoPgScatteredInfo(SJctrDataController dc) {
        List<SJmoPgScatteredInfo> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPgScatteredInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgScatteredInfo", "Information of scattered parity groups is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPgLdevInfo> getSJmoPgLdevInfo(SJctrDataController dc) {
        List<SJmoPgLdevInfo> info = SJctrOptionMonitorUtility.getCache(dc, SJmoGetPgLdevInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgLdevInfo", "Information of LDEVs in parity group is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static SJmoNonPortSetPPCExistenceInfo getSJmoNonPortSetPPCExistenceInfo(SJctrDataController dc) {
        List<?> infoList = SJctrOptionMonitorUtility.getCache(dc, SJmoGetNonPortSetPPCExistenceInfo.class);
        if (null == infoList) {
            dc.getLogUty().putlog("getSJmoNonPortSetPPCExistenceInfo", "DataList of unused monitered wwn is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (infoList.size() == 0) {
            dc.getLogUty().putlog("getSJmoNonPortSetPPCExistenceInfo", "Size of data list is zero.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoNonPortSetPPCExistenceInfo info = (SJmoNonPortSetPPCExistenceInfo)infoList.get(0);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoNonPortSetPPCExistenceInfo", "Information of unused monitered wwn is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static int[] getCUNumberOfLdevs(List<? extends SJmoLdevIndex> ldevs) {
        int[] cuLdevs = new int[SJmoDataMacro_IF.CUMAX_LDKC];
        for (int cus = 0; cus < cuLdevs.length; ++cus) {
            cuLdevs[cus] = 0;
        }
        for (SJmoLdevIndex sJmoLdevIndex : ldevs) {
            short cuNo = sJmoLdevIndex.getSCu();
            if (0 > cuNo || cuNo >= cuLdevs.length) continue;
            short s = cuNo;
            cuLdevs[s] = cuLdevs[s] + 1;
        }
        return cuLdevs;
    }

    public static int getMonitoringCUCount(MonMonitoringInfoLDKC monInfo) {
        Robj_interface_MonMonitoringCU[] monCuInfo;
        int monCuCount = 0;
        for (Robj_interface_MonMonitoringCU monCu : monCuInfo = monInfo.getTargetCU()) {
            if (!monCu.isTarget()) continue;
            ++monCuCount;
        }
        return monCuCount;
    }

    public static int getMonitoringLDEVCount(MonMonitoringInfoLDKC monInfo, List<SJmoLdevDetail> ldevDetails) {
        int monLdevCount = 0;
        Robj_interface_MonMonitoringCU[] monCuInfo = monInfo.getTargetCU();
        block0: for (SJmoLdevDetail ldevDetail : ldevDetails) {
            for (Robj_interface_MonMonitoringCU monCu : monCuInfo) {
                if (monCu.getSCU() != ldevDetail.getSCu()) continue;
                if (!monCu.isTarget()) continue block0;
                ++monLdevCount;
                continue block0;
            }
        }
        return monLdevCount;
    }

    public static int getMonitoringWWNCount(List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortDetail> portDetails) {
        int monWwnCount = 0;
        for (SJmoPPCALLPortWWNInfo wwnInfo : monWwns) {
            int portId = wwnInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            monWwnCount += wwnInfo.getWwns().size();
        }
        return monWwnCount;
    }

    public static SJmoPortDetail getAvailableMonPort(int portId, List<? extends SJmoPortDetail> portDetails) {
        SJmoPortDetail availablePort = null;
        for (SJmoPortDetail sJmoPortDetail : portDetails) {
            if (sJmoPortDetail.getIndex() != portId) continue;
            if (!SJctrOptionMonitorUtility.isMonitorSupportPortType(sJmoPortDetail) && !SJctrPortUtility.isHnasPort(sJmoPortDetail)) break;
            availablePort = sJmoPortDetail;
            break;
        }
        return availablePort;
    }

    public static boolean isAvailableMonPort(int portId, List<? extends SJmoPortDetail> portDetails) {
        boolean availablePort = false;
        if (null != SJctrOptionMonitorUtility.getAvailableMonPort(portId, portDetails)) {
            availablePort = true;
        }
        return availablePort;
    }

    public static boolean isMonitorSupportPortType(SJmoPortDetail portDetail) {
        boolean ret = false;
        ret = SJctrPortUtility.isFibrePort(portDetail) ? true : SJctrPortUtility.isFcoePort(portDetail);
        return ret;
    }

    public static boolean isISCSIPort(SJmoPortDetail portDetail) {
        boolean ret = false;
        byte kind = portDetail.getByPortKindNo();
        if (kind == 5) {
            ret = true;
        }
        return ret;
    }

    public static boolean isOverMonitoringWWNsMax(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected) {
        boolean maxOver = false;
        if (2048 < add.size() + selected.size()) {
            maxOver = true;
        }
        return maxOver;
    }

    public static boolean isOverMonitoringWWNsMaxAddNew(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected, List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortDetail> portDetails) {
        boolean maxOver = false;
        if (2048 < add.size() + selected.size() + SJctrOptionMonitorUtility.getMonitoringWWNCount(monWwns, portDetails)) {
            maxOver = true;
        }
        return maxOver;
    }

    public static List<SJctrMonitorPortWWNInfo> getOverMonitoringWWNsMaxPorts(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected) {
        Map<SJmoPortDetail, Integer> portWwnCount = SJctrOptionMonitorUtility.getAddSelectedPortMap(add, selected);
        ArrayList<SJctrMonitorPortWWNInfo> returnList = new ArrayList<SJctrMonitorPortWWNInfo>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            Integer addCountPerPort = portWwnCount.get(sJctrMonitorPortWWNInfo.getPortDetail());
            if (null == addCountPerPort || 32 >= addCountPerPort) continue;
            returnList.add(sJctrMonitorPortWWNInfo);
        }
        return returnList;
    }

    private static Map<SJmoPortDetail, Integer> getAddSelectedPortMap(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected) {
        SJmoPortDetail portDetail;
        HashMap<SJmoPortDetail, Integer> portWwnCount = new HashMap<SJmoPortDetail, Integer>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            portDetail = sJctrMonitorPortWWNInfo.getPortDetail();
            if (portWwnCount.containsKey(portDetail)) {
                portWwnCount.put(portDetail, (Integer)portWwnCount.get(portDetail) + 1);
                continue;
            }
            portWwnCount.put(portDetail, 1);
        }
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : selected) {
            portDetail = sJctrMonitorPortWWNInfo.getPortDetail();
            if (!portWwnCount.containsKey(portDetail)) continue;
            portWwnCount.put(portDetail, (Integer)portWwnCount.get(portDetail) + 1);
        }
        return portWwnCount;
    }

    public static List<SJctrMonitorPortWWNInfo> getOverMonitoringWWNsMaxPortsAddNew(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected, List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortDetail> portDetails) {
        Map<SJmoPortDetail, Integer> portWwnCount = SJctrOptionMonitorUtility.getAddSelectedPortMap(add, selected);
        for (SJmoPPCALLPortWWNInfo monWwnInfo : monWwns) {
            SJmoPortDetail sJmoPortDetail = SJctrOptionMonitorUtility.getAvailableMonPort(monWwnInfo.getIndex(), portDetails);
            if (null == sJmoPortDetail) continue;
            ArrayList<SJmoWwn> monWwnList = monWwnInfo.getWwns();
            if (!portWwnCount.containsKey(sJmoPortDetail)) continue;
            portWwnCount.put(sJmoPortDetail, portWwnCount.get(sJmoPortDetail) + monWwnList.size());
        }
        ArrayList<SJctrMonitorPortWWNInfo> returnList = new ArrayList<SJctrMonitorPortWWNInfo>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            Integer addCountPerPort = portWwnCount.get(sJctrMonitorPortWWNInfo.getPortDetail());
            if (null == addCountPerPort || 32 >= addCountPerPort) continue;
            returnList.add(sJctrMonitorPortWWNInfo);
        }
        return returnList;
    }

    public static boolean isDuplicationWWNName(List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected) {
        HashMap<String, String> wwnNames = new HashMap<String, String>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : selected) {
            SJmoWwn sJmoWwn = sJctrMonitorPortWWNInfo.getWwn();
            String hbaWwn = SJctrComUtility.toWWNDisplay(sJmoWwn);
            String wwnName = sJmoWwn.getStrWWNNickName();
            wwnNames.put(wwnName, hbaWwn);
        }
        boolean dupulication = false;
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            SJmoWwn wwnInfo = sJctrMonitorPortWWNInfo.getWwn();
            String hbaWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
            String wwnName = wwnInfo.getStrWWNNickName();
            if (0 == wwnName.length()) continue;
            String selHbaWwn = (String)wwnNames.get(wwnName);
            if (null != selHbaWwn) {
                if (hbaWwn.equalsIgnoreCase(selHbaWwn)) continue;
                dupulication = true;
                break;
            }
            wwnNames.put(wwnName, hbaWwn);
        }
        return dupulication;
    }

    public static boolean isDuplicationWWNNameEditWWN(SJmoWwn chgWwnInfo, List<SJmoPPCALLPortWWNInfo> monPortWwns, List<SJmoPortDetail> portDetails) {
        String chgHbaWwn = SJctrComUtility.toWWNDisplay(chgWwnInfo);
        String chgWwnName = chgWwnInfo.getStrWWNNickName();
        if (0 == chgWwnName.length()) {
            return false;
        }
        for (SJmoPPCALLPortWWNInfo monPortWwnInfo : monPortWwns) {
            int portNo = monPortWwnInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portNo, portDetails)) continue;
            ArrayList<SJmoWwn> monWwns = monPortWwnInfo.getWwns();
            for (SJmoWwn monWwnInfo : monWwns) {
                String monHbaWwn;
                String monWwnName = monWwnInfo.getStrWWNNickName();
                if (!monWwnName.equals(chgWwnName) || (monHbaWwn = SJctrComUtility.toWWNDisplay(monWwnInfo)).equalsIgnoreCase(chgHbaWwn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDuplicationWWNNameAddNew(String hbaWwn, String wwnName, List<? extends SJctrMonitorPortWWNInfo> selected, List<SJmoPPCALLPortWWNInfo> monPortWwns, List<SJmoPortDetail> portDetails) {
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : selected) {
            SJmoWwn wwnInfo = sJctrMonitorPortWWNInfo.getWwn();
            if (!(hbaWwn.equalsIgnoreCase(SJctrComUtility.toWWNDisplay(wwnInfo)) ? !wwnName.equals(wwnInfo.getStrWWNNickName()) : wwnName.equals(wwnInfo.getStrWWNNickName()) && 0 != wwnName.length())) continue;
            return true;
        }
        if (0 == wwnName.length()) {
            return false;
        }
        for (SJmoPPCALLPortWWNInfo sJmoPPCALLPortWWNInfo : monPortWwns) {
            int portId = sJmoPPCALLPortWWNInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList<SJmoWwn> wwnInfoList = sJmoPPCALLPortWWNInfo.getWwns();
            for (SJmoWwn wwnInfo : wwnInfoList) {
                if (!wwnName.equals(wwnInfo.getStrWWNNickName()) || hbaWwn.equalsIgnoreCase(SJctrComUtility.toWWNDisplay(wwnInfo))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOverMonitoringCUsMax(List<? extends SJctrMonitorCUInfo> add, List<? extends SJctrMonitorCUInfo> selected, MonMonitoringInfoLDKC monInfo) {
        int maxMonCu = SJmoDataMacro_IF.CUMAX_LDKC;
        if (monInfo.isStatus()) {
            int interval = monInfo.getInterval();
            switch (interval) {
                case 300: 
                case 600: 
                case 900: {
                    break;
                }
                default: {
                    maxMonCu = SJctrOptionMonitorUtility.getMonitoringCUBoundary();
                }
            }
        }
        boolean maxOver = false;
        if (maxMonCu < add.size() + selected.size()) {
            maxOver = true;
        }
        return maxOver;
    }

    public static SetPPCWWNRegistEntry createEntryMonWWNs(List<? extends SJctrMonitorPortWWNInfo> entryList) {
        Map<String, SJctrPPCWWNRegistData> setWwns = SJctrOptionMonitorUtility.createSettingWWNsMap(entryList);
        SetPPCWWNRegistEntry registEntry = new SetPPCWWNRegistEntry();
        for (SJctrPPCWWNRegistData setData : setWwns.values()) {
            byte[] hbaWwn = setData.getHbaWwn();
            String wwnName = setData.getWwnName();
            List<Integer> ports = setData.getPorts();
            int[] portIds = new int[ports.size()];
            for (int portCount = 0; portCount < portIds.length; ++portCount) {
                portIds[portCount] = ports.get(portCount);
            }
            registEntry.addEntryData(hbaWwn, wwnName, portIds);
        }
        return registEntry;
    }

    private static Map<String, SJctrPPCWWNRegistData> createSettingWWNsMap(List<? extends SJctrMonitorPortWWNInfo> setList) {
        HashMap<String, SJctrPPCWWNRegistData> setWwns = new HashMap<String, SJctrPPCWWNRegistData>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : setList) {
            SJmoWwn wwn = sJctrMonitorPortWWNInfo.getWwn();
            byte[] hbaWwn = wwn.getByWWN();
            String hbaWwnStr = SJctrComUtility.toWWNDisplay(wwn);
            String wwnName = sJctrMonitorPortWWNInfo.getWwn().getStrWWNNickName();
            int portId = sJctrMonitorPortWWNInfo.getPortDetail().getIndex();
            SJctrPPCWWNRegistData registData = (SJctrPPCWWNRegistData)setWwns.get(hbaWwnStr);
            if (null == registData) {
                SJctrPPCWWNRegistData setdata = new SJctrPPCWWNRegistData(hbaWwn, wwnName, portId);
                setWwns.put(hbaWwnStr, setdata);
                continue;
            }
            registData.addPorts(portId);
        }
        return setWwns;
    }

    public static SetPPCWWNRegistDelete createDeleteMonWWNs(List<? extends SJctrMonitorPortWWNInfo> deleteList) {
        Map<String, SJctrPPCWWNRegistData> setWwns = SJctrOptionMonitorUtility.createSettingWWNsMap(deleteList);
        SetPPCWWNRegistDelete registDelete = new SetPPCWWNRegistDelete();
        for (SJctrPPCWWNRegistData setData : setWwns.values()) {
            byte[] hbaWwn = setData.getHbaWwn();
            List<Integer> ports = setData.getPorts();
            int[] portIds = new int[ports.size()];
            for (int portCount = 0; portCount < portIds.length; ++portCount) {
                portIds[portCount] = ports.get(portCount);
            }
            registDelete.addWWNData(hbaWwn, portIds);
        }
        return registDelete;
    }

    public static boolean isDuplicationHBAWWNEditWWN(String hbaWwn, List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortDetail> portDetails) {
        for (SJmoPPCALLPortWWNInfo wwnPortInfo : monWwns) {
            int portId = wwnPortInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList<SJmoWwn> wwnList = wwnPortInfo.getWwns();
            for (SJmoWwn wwnInfo : wwnList) {
                String compHbaWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
                if (!hbaWwn.equalsIgnoreCase(compHbaWwn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDuplicationHBAWWNAddnew(String hbaWwn, List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected, List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortWwnInfo> loginWwns, List<SJmoPortHostGroupInfo> lunmWwns, List<SJmoPortDetail> portDetails) {
        String compHbaWwn;
        ArrayList<Integer> addPortIdList = new ArrayList<Integer>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            addPortIdList.add(sJctrMonitorPortWWNInfo.getPortDetail().getIndex());
        }
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : selected) {
            int portId;
            String compHbaWwn2 = SJctrComUtility.toWWNDisplay(sJctrMonitorPortWWNInfo.getWwn());
            if (!hbaWwn.equalsIgnoreCase(compHbaWwn2) || !addPortIdList.contains(portId = sJctrMonitorPortWWNInfo.getPortDetail().getIndex())) continue;
            return true;
        }
        for (SJmoPPCALLPortWWNInfo sJmoPPCALLPortWWNInfo : monWwns) {
            int portId = sJmoPPCALLPortWWNInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList<SJmoWwn> wwnList = sJmoPPCALLPortWWNInfo.getWwns();
            for (SJmoWwn wwnInfo : wwnList) {
                compHbaWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
                if (!hbaWwn.equalsIgnoreCase(compHbaWwn)) continue;
                return true;
            }
        }
        for (SJmoPortWwnInfo sJmoPortWwnInfo : loginWwns) {
            int portId = sJmoPortWwnInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList wwnList = sJmoPortWwnInfo.getAlPortWwn();
            for (SJmoWwn wwnInfo : wwnList) {
                compHbaWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
                if (!hbaWwn.equalsIgnoreCase(compHbaWwn)) continue;
                return true;
            }
        }
        for (SJmoPortHostGroupInfo sJmoPortHostGroupInfo : lunmWwns) {
            int portId = sJmoPortHostGroupInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList hgList = sJmoPortHostGroupInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hostGroupInfo : hgList) {
                ArrayList wwnList = hostGroupInfo.getAlHostGroupWwn();
                for (SJmoWwn wwnInfo : wwnList) {
                    String compHbaWwn3 = SJctrComUtility.toWWNDisplay(wwnInfo);
                    if (!hbaWwn.equalsIgnoreCase(compHbaWwn3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDuplicationHBAWWNAddTo(String hbaWwn, List<? extends SJctrMonitorPortWWNInfo> add, List<? extends SJctrMonitorPortWWNInfo> selected, List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortDetail> portDetails) {
        ArrayList<Integer> addPortIdList = new ArrayList<Integer>();
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : add) {
            addPortIdList.add(sJctrMonitorPortWWNInfo.getPortDetail().getIndex());
        }
        for (SJctrMonitorPortWWNInfo sJctrMonitorPortWWNInfo : selected) {
            int portId;
            String compHbaWwn = SJctrComUtility.toWWNDisplay(sJctrMonitorPortWWNInfo.getWwn());
            if (!hbaWwn.equalsIgnoreCase(compHbaWwn) || !addPortIdList.contains(portId = sJctrMonitorPortWWNInfo.getPortDetail().getIndex())) continue;
            return true;
        }
        for (SJmoPPCALLPortWWNInfo sJmoPPCALLPortWWNInfo : monWwns) {
            int portId = sJmoPPCALLPortWWNInfo.getIndex();
            if (!SJctrOptionMonitorUtility.isAvailableMonPort(portId, portDetails)) continue;
            ArrayList<SJmoWwn> wwnList = sJmoPPCALLPortWWNInfo.getWwns();
            for (SJmoWwn wwnInfo : wwnList) {
                String compHbaWwn = SJctrComUtility.toWWNDisplay(wwnInfo);
                if (!hbaWwn.equalsIgnoreCase(compHbaWwn) || !addPortIdList.contains(portId)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<SJctrMonitorAvailablePortsInfo> fillterAvailableMonPorts(List<SJmoPPCALLPortWWNInfo> monWwns, List<SJmoPortWwnInfo> loginWwns, List<SJmoPortHostGroupInfo> lunmWwns, List<SJmoPortDetail> portDetails) {
        ArrayList<SJctrMonitorAvailablePortsInfo> portsInfo = new ArrayList<SJctrMonitorAvailablePortsInfo>();
        for (SJmoPortDetail portDetail : portDetails) {
            String hbaWwnStr;
            ArrayList wwnList;
            if (!SJctrOptionMonitorUtility.isMonitorSupportPortType(portDetail) && !SJctrPortUtility.isHnasPort(portDetail)) continue;
            ArrayList<String> portMonWwns = new ArrayList<String>();
            ArrayList<String> portNonMonWwns = new ArrayList<String>();
            int portId = portDetail.getIndex();
            for (SJmoPPCALLPortWWNInfo sJmoPPCALLPortWWNInfo : monWwns) {
                if (sJmoPPCALLPortWWNInfo.getIndex() != portId) continue;
                wwnList = sJmoPPCALLPortWWNInfo.getWwns();
                for (SJmoWwn wwnInfo : wwnList) {
                    hbaWwnStr = SJctrComUtility.toWWNDisplay(wwnInfo);
                    portMonWwns.add(hbaWwnStr);
                }
            }
            if (portMonWwns.size() >= 32) continue;
            for (SJmoPortWwnInfo sJmoPortWwnInfo : loginWwns) {
                if (sJmoPortWwnInfo.getIndex() != portId) continue;
                wwnList = sJmoPortWwnInfo.getAlPortWwn();
                for (SJmoWwn wwnInfo : wwnList) {
                    hbaWwnStr = SJctrComUtility.toWWNDisplay(wwnInfo);
                    if (portMonWwns.contains(hbaWwnStr)) continue;
                    portNonMonWwns.add(hbaWwnStr);
                }
            }
            for (SJmoPortHostGroupInfo sJmoPortHostGroupInfo : lunmWwns) {
                if (sJmoPortHostGroupInfo.getIndex() != portId) continue;
                ArrayList hgList = sJmoPortHostGroupInfo.getAlPortHostGroup();
                for (SJmoHostGroupInfo hostGroupInfo : hgList) {
                    ArrayList wwnList2 = hostGroupInfo.getAlHostGroupWwn();
                    for (SJmoWwn wwnInfo : wwnList2) {
                        String hbaWwnStr2 = SJctrComUtility.toWWNDisplay(wwnInfo);
                        if (portMonWwns.contains(hbaWwnStr2) || portNonMonWwns.contains(hbaWwnStr2)) continue;
                        portNonMonWwns.add(hbaWwnStr2);
                    }
                }
            }
            SJctrMonitorAvailablePortsInfo tableData = new SJctrMonitorAvailablePortsInfo(portDetail, portMonWwns.size(), portNonMonWwns.size());
            portsInfo.add(tableData);
        }
        return portsInfo;
    }

    public static boolean isMonParityGroup(int pgFB4No) {
        boolean ret = false;
        if (1 <= pgFB4No && pgFB4No <= DEF_INTERNAL_PG_NO_END) {
            ret = true;
        } else if (101 <= pgFB4No && pgFB4No <= 16484) {
            ret = true;
        } else if (16641 <= pgFB4No && pgFB4No <= 17152) {
            ret = true;
        }
        return ret;
    }

    public static boolean isMonParityGroupLong(int pgFB4No) {
        return SJctrOptionMonitorUtility.isInternal(pgFB4No);
    }

    public static boolean isInternal(int pgFB4No) {
        boolean ret = false;
        if (1 <= pgFB4No && pgFB4No <= DEF_INTERNAL_PG_NO_END) {
            ret = true;
        }
        return ret;
    }

    public static boolean isExternal(int fb4) {
        boolean ret = false;
        if (101 <= fb4 && fb4 <= 16484) {
            ret = true;
        } else if (16641 <= fb4 && fb4 <= 17152) {
            ret = true;
        }
        return ret;
    }

    public static String getCUNumberString(int cuNo) {
        String str = SJctrComUtility.toHexString(cuNo, 2, true);
        return str;
    }

    public static SJcException convMonitorLogicalErr(SJcException err, int msgID) {
        SJcMessage msgObj = err.getMsg();
        if (msgObj.getModuleID().equals(Integer.toString(22)) && msgObj.getFunctionID().equals(Integer.toString(51)) && msgObj.getMsgID().equals(Integer.toString(107001))) {
            SJctrError errObj = new SJctrError(51, 22, msgID);
            err = errObj.createException();
        }
        return err;
    }

    public static String changeKernelNumToStrOf(SJctrComUtility util, int kernelKind) {
        String ret = "?";
        switch (kernelKind) {
            case 0: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.OPEN_TARGET);
                break;
            }
            case 1: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.OPEN_INITIATOR);
                break;
            }
            case 2: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.OPEN_EXTERNAL);
                break;
            }
            case 3: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.MF_TARGET);
                break;
            }
            case 4: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.MF_EXTERNAL);
                break;
            }
            case 5: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.BACKEND);
                break;
            }
            case 6: {
                ret = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(util, SJctrOptionMonitorGuidance.SYSTEM);
                break;
            }
        }
        return ret;
    }

    public static String getJnlIdString(int jnlGrpId) {
        String str = SJctrComUtility.toHexString(jnlGrpId, 3, true);
        return str;
    }

    public static boolean isProductModel_S() {
        boolean ret = false;
        if (SJctrDataController.isHM() && SJsncProductModelUty.getProductModel() == 20) {
            ret = true;
        }
        return ret;
    }

    public static boolean isProductModel_M() {
        boolean ret = false;
        if (SJctrDataController.isHM() && SJsncProductModelUty.getProductModel() == 40) {
            ret = true;
        }
        return ret;
    }

    public static boolean isProductModel_H() {
        boolean ret = false;
        if (SJctrDataController.isHM() && SJsncProductModelUty.getProductModel() == 60) {
            ret = true;
        }
        return ret;
    }

    public static int getMonitoringCUBoundary() {
        int ret = 64;
        if (SJctrOptionMonitorUtility.isProductModel_S()) {
            ret = 8;
        } else if (SJctrOptionMonitorUtility.isProductModel_M()) {
            ret = 16;
        } else if (SJctrOptionMonitorUtility.isProductModel_H()) {
            ret = 32;
        }
        return ret;
    }

    private static class SJctrPPCWWNRegistData {
        private byte[] hbaWwn;
        private String wwnName;
        private List<Integer> ports = new ArrayList<Integer>();

        public SJctrPPCWWNRegistData(byte[] hbaWwn, String wwnName, int portId) {
            this.hbaWwn = hbaWwn;
            this.wwnName = wwnName;
            this.ports.add(portId);
        }

        public byte[] getHbaWwn() {
            return this.hbaWwn;
        }

        public String getWwnName() {
            return this.wwnName;
        }

        public List<Integer> getPorts() {
            return this.ports;
        }

        public void addPorts(int port) {
            this.ports.add(port);
        }
    }
}

