/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.graph.param;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrPlotDataInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.graph.SJctrSelectedObjectInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetMonitorInfoCollection;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public abstract class SJctrGetPlotParam {
    protected List<SJctrPlotDataInfo> rowDatas = new ArrayList<SJctrPlotDataInfo>();
    protected int mondataType;
    protected Date startDate;
    protected Date endDate;
    protected SJctrDataController dc;
    protected SJctrLogUty logUty = new SJctrLogUty();
    protected static final int KILO_BYTE = 1024;
    protected static final int KILO_UNIT = 1000;
    protected static final long RESPONSE_TIME_INVALID = -3L;

    public SJctrDataController getDc() {
        return this.dc;
    }

    public void setDc(SJctrDataController dc) {
        this.dc = dc;
    }

    public double perKiloByte(long data) {
        double ret = data;
        if (data > 0L) {
            ret = this.scaleFix((double)data / 1024.0);
        }
        return ret;
    }

    public double scaleFix(double data) {
        double ret = 0.0;
        if (data > 0.0 && 0.01 > data) {
            ret = 0.01;
        } else {
            BigDecimal dec = new BigDecimal(data);
            BigDecimal retDec = dec.setScale(2, 1);
            ret = retDec.doubleValue();
        }
        return ret;
    }

    public double perKilo(long data) {
        double ret = data;
        if (data > 0L) {
            ret = this.scaleFix((double)data / 1000.0);
        }
        return ret;
    }

    public long responseFix(long data) {
        long ret = data;
        if (data == -3L) {
            ret = 0L;
        }
        return ret;
    }

    protected MonitorInfoCollection getDataInf(Object[] args) {
        SJmoThroughRmiData rmiData;
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetMonitorInfoCollection kind = new SJmoGetMonitorInfoCollection(args);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        wrapper.setCacheMode(false);
        set.add(wrapper);
        this.logUty.putlog("getDataInf", "dc.getProxy().getDataInf() Start");
        Map<SJctrGetDirectWrapper, List<?>> map = this.dc.getProxy().getDataInf(set);
        this.logUty.putlog("getDataInf", "dc.getProxy().getDataInf() End");
        List<?> rmiDataList = map.get(wrapper);
        MonitorInfoCollection monitorInfo = null;
        if (rmiDataList != null && rmiDataList.size() > 0) {
            rmiData = (SJmoThroughRmiData)rmiDataList.get(0);
            if (rmiData == null) {
                this.logUty.putlog("getDataInf", "rmiData is null");
                SJctrError error = new SJctrError(51, 22, 107001);
                throw error.createException();
            }
        } else {
            this.logUty.putlog("getDataInf", "rmiDataList is null or empty");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        monitorInfo = (MonitorInfoCollection)rmiData.getObjRmi();
        if (monitorInfo == null) {
            this.logUty.putlog("getDataInf", "monitorInfo is null");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
        return monitorInfo;
    }

    public void chkPerformData(String object, String monDataType, String objectName, Object data) {
        if (data == null) {
            this.logUty.putlog("chkPerformData", "performance data is null[" + object + "," + monDataType + "," + objectName + "]");
            SJctrError error = new SJctrError(51, 22, 107001);
            throw error.createException();
        }
    }

    protected String convStr(long data) {
        String ret = null;
        if (data >= 0L) {
            ret = String.valueOf(data);
        }
        return ret;
    }

    protected String convStr(double data) {
        String ret = null;
        if (data >= 0.0) {
            ret = String.valueOf(data);
        }
        return ret;
    }

    protected String convStr(int data) {
        String ret = null;
        if (data >= 0) {
            ret = String.valueOf(data);
        }
        return ret;
    }

    public void addRowData(SJctrSelectedObjectInfo rowData, int panelNo) {
        SJctrPlotDataInfo protData = new SJctrPlotDataInfo();
        protData.setPlotDatas(new ArrayList<String>());
        protData.setRowData(rowData);
        protData.setPanelNo(panelNo);
        this.rowDatas.add(protData);
    }

    public abstract void getModelData();

    public List<SJctrPlotDataInfo> getProtData() {
        return this.rowDatas;
    }

    public int getMondataType() {
        return this.mondataType;
    }

    public void setMondataType(int mondataType) {
        this.mondataType = mondataType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}

