/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.ownership.tempmonitor;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.ownership.SJctrChassisIdColumnTempMonitorInfo;
import sanproject.sn2.controller.com.column.ownership.SJctrMeasureLocationColumnDkcAmbTempInfo;
import sanproject.sn2.controller.com.column.ownership.SJctrTempColumnDkcAmbientInfo;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipGuidance;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.controller.wizard.ownership.tempmonitor.SJctrTempMonitorTableRecordInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPowerInfo;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoPowerInfo;

public class SJctrDkcAmbTempTableModel
extends SJctrTableDataModel {
    private static final String KEY_COL_CHASSIS_ID = "COL_CHASSIS_ID";
    private static final String KEY_COL_MEASURELOCATION = "COM_COL_MEASURE_LOCATION";
    private static final String KEY_COL_TEMP_DEGREES = "COM_COL_TEMP_DEGREES";

    public SJctrDkcAmbTempTableModel() {
        this.setPaging(false);
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrChassisIdColumnTempMonitorInfo(KEY_COL_CHASSIS_ID));
        this.addColumn(new SJctrMeasureLocationColumnDkcAmbTempInfo(KEY_COL_MEASURELOCATION));
        this.addColumn(new SJctrTempColumnDkcAmbientInfo(KEY_COL_TEMP_DEGREES));
        this.setPrimaryColumn(KEY_COL_CHASSIS_ID);
        this.setPrimaryClass(SJctrTempMonitorTableRecordInfo.class);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetAllDKCInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPowerInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        String strFuncName = "getBasicDataList";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        List<?> powerInfoList = this.getBasicDataMap().get(SJmoGetPowerInfo.class);
        if (powerInfoList != null && powerInfoList.size() > 0) {
            SJmoPowerInfo powerInfo = (SJmoPowerInfo)powerInfoList.get(0);
            if (powerInfo != null) {
                List<SJctrTempMonitorTableRecordInfo> subTableData = this.subGetBasicDataList(powerInfo);
                tableData.addAll(subTableData);
            } else {
                this.getLogUty().putlog(strFuncName, "powerInfo is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "powerInfoList is null or size 0");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subGetBasicDataList(SJmoPowerInfo powerInfo) {
        String strFuncName = "subGetBasicDataList";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        List<?> allDkcInfoList = this.getBasicDataMap().get(SJmoGetAllDKCInfo.class);
        if (allDkcInfoList != null && allDkcInfoList.size() > 0) {
            for (SJmoAllDKCInfo allDkcInfo : allDkcInfoList) {
                if (allDkcInfo != null) {
                    ArrayList<SJmoDKCInfo> dkcInfoList = allDkcInfo.getDKCInfo();
                    List<SJctrTempMonitorTableRecordInfo> subTableData = this.subSubGetBasicDataList(dkcInfoList, powerInfo);
                    tableData.addAll(subTableData);
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "allDkcInfo is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "allDkcInfoList is null or size 0");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subSubGetBasicDataList(List<SJmoDKCInfo> dkcInfoList, SJmoPowerInfo powerInfo) {
        String strFuncName = "subGetBasicDataList";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (dkcInfoList != null && dkcInfoList.size() > 0) {
            for (SJmoDKCInfo dkcInfo : dkcInfoList) {
                if (dkcInfo != null) {
                    int iChassisId = dkcInfo.getDKCNo();
                    String strLocationId = "";
                    int bTemperature = -128;
                    for (int iCluster = 1; iCluster <= 2; ++iCluster) {
                        if (iChassisId == 0 && iCluster == 1) {
                            strLocationId = SJctrOwnerShipGuidance.getOwnerShipGuidanceStr(this.getComUtility(), SJctrOwnerShipGuidance.CLUSTER_1);
                            bTemperature = powerInfo.getTempDKC0CL1();
                        } else if (iChassisId == 0 && iCluster == 2) {
                            strLocationId = SJctrOwnerShipGuidance.getOwnerShipGuidanceStr(this.getComUtility(), SJctrOwnerShipGuidance.CLUSTER_2);
                            bTemperature = powerInfo.getTempDKC0CL2();
                        } else if (iChassisId == 1 && iCluster == 1) {
                            strLocationId = SJctrOwnerShipGuidance.getOwnerShipGuidanceStr(this.getComUtility(), SJctrOwnerShipGuidance.CLUSTER_1);
                            bTemperature = powerInfo.getTempDKC1CL1();
                        } else if (iChassisId == 1 && iCluster == 2) {
                            strLocationId = SJctrOwnerShipGuidance.getOwnerShipGuidanceStr(this.getComUtility(), SJctrOwnerShipGuidance.CLUSTER_2);
                            bTemperature = powerInfo.getTempDKC1CL2();
                        } else {
                            this.getLogUty().putlog(strFuncName, "unsupported chassis & cluster");
                        }
                        String strChassisId = SJctrOwnerShipUtility.toChassisIdDisplay(this.getComUtility(), iChassisId);
                        String strPrimaryKey = Integer.toString(iChassisId);
                        SJctrTempMonitorTableRecordInfo record = new SJctrTempMonitorTableRecordInfo(strPrimaryKey, strChassisId, strLocationId, bTemperature);
                        tableData.add(record);
                    }
                    continue;
                }
                this.getLogUty().putlog(strFuncName, "dkcInfo is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "dkcInfoList is null or size 0");
        }
        return tableData;
    }
}

