/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.ownership.tempmonitor;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.ownership.SJctrChassisIdColumnTempMonitorInfo;
import sanproject.sn2.controller.com.column.ownership.SJctrMeasureLocationColumnDkuIntTempInfo;
import sanproject.sn2.controller.com.column.ownership.SJctrTempColumnDkuInternalInfo;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.ownership.tempmonitor.SJctrTempMonitorTableRecordInfo;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetMNTreadEnvironmentalMonitoringInfo;
import sanproject.sn2.model.data.ownership.SJmoMNTreadEnvironmentalMonitoringInfo;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrDkuIntTempTableModel
extends SJctrTableDataModel {
    private static final String KEY_COL_CHASSIS_ID = "COL_CHASSIS_ID";
    private static final String KEY_COL_MEASURELOCATION = "COM_COL_MEASURE_LOCATION";
    private static final String KEY_COL_TEMP_DEGREES = "COM_COL_TEMP_DEGREES";
    private static final String KEY_VALUE_STORAGE_SYSTEM = "StorageSystem";
    private static final String KEY_VALUE_CHASSIS = "Chassis";
    private static final String KEY_VALUE_TYPE = "Type";
    private static final String KEY_VALUE_LOCATION = "Location";
    private static final String KEY_VALUE_ID = "Id";
    private static final String KEY_VALUE_TEMPERATURE = "Temperature";
    private static final String KEY_VALUE_COMPONENTS = "Components";
    private static final int TYPE_COMP_DKU = 11;
    private static final int TYPE_COMP_HDU = 1102;
    private static final int TYPE_COMP_DKUPS = 4;
    private static final int TYPE_COMP_DB = 10;
    private static final int TYPE_COMP_DBPS = 3;

    public SJctrDkuIntTempTableModel() {
        this.setPaging(false);
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrChassisIdColumnTempMonitorInfo(KEY_COL_CHASSIS_ID));
        this.addColumn(new SJctrMeasureLocationColumnDkuIntTempInfo(KEY_COL_MEASURELOCATION));
        this.addColumn(new SJctrTempColumnDkuInternalInfo(KEY_COL_TEMP_DEGREES));
        this.setPrimaryColumn(KEY_COL_CHASSIS_ID);
        this.setPrimaryClass(SJctrTempMonitorTableRecordInfo.class);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetMNTreadEnvironmentalMonitoringInfo kind = new SJmoGetMNTreadEnvironmentalMonitoringInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        String strFuncName = "getBasicDataList";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        List<?> modelList = this.getBasicDataMap().get(SJmoGetMNTreadEnvironmentalMonitoringInfo.class);
        if (modelList != null && modelList.size() > 0) {
            SJmoMNTreadEnvironmentalMonitoringInfo mntReadEnvMonInfo = (SJmoMNTreadEnvironmentalMonitoringInfo)modelList.get(0);
            if (mntReadEnvMonInfo != null) {
                SanResponse rmiMntReadEnvMonInfo = mntReadEnvMonInfo.getMntReadEnvMonInfo();
                this.getDataController();
                boolean bIsHM = SJctrDataController.isHM();
                if (!bIsHM) {
                    List<SJctrTempMonitorTableRecordInfo> subTableData = this.subRaidGetBasicDataList(rmiMntReadEnvMonInfo);
                    tableData.addAll(subTableData);
                } else {
                    List<SJctrTempMonitorTableRecordInfo> subTableData = this.subHmGetBasicDataList(rmiMntReadEnvMonInfo);
                    tableData.addAll(subTableData);
                }
            } else {
                this.getLogUty().putlog(strFuncName, "mntReadEnvMonInfo is null");
            }
        } else {
            this.getLogUty().putlog(strFuncName, "modelList is null or size 0");
        }
        Collections.sort(tableData);
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subRaidGetBasicDataList(SanResponse rmiMntReadEnvMonInfo) {
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData;
        block8: {
            String strFuncName = "subRaidGetBasicDataList";
            tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
            if (rmiMntReadEnvMonInfo != null) {
                try {
                    SanObject storageSystem = rmiMntReadEnvMonInfo.getObj(KEY_VALUE_STORAGE_SYSTEM);
                    if (storageSystem != null) {
                        SanList chassisList = storageSystem.getList(KEY_VALUE_CHASSIS);
                        if (chassisList != null && chassisList.size() > 0) {
                            for (SanObject chassis : chassisList) {
                                tableData.addAll(this.subRaidGetBasicDataList2(chassis));
                            }
                        } else {
                            this.getLogUty().putlog(strFuncName, "chassisList is null or size 0");
                        }
                        break block8;
                    }
                    this.getLogUty().putlog(strFuncName, "storageSystem is null");
                }
                catch (SanDataException e) {
                    this.getLogUty().putlog(strFuncName, "SanDataException is occured", e, 40000);
                }
            } else {
                this.getLogUty().putlog(strFuncName, "rmiMntReadEnvMonInfo is null");
            }
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subRaidGetBasicDataList2(SanObject chassis) throws SanDataException {
        String strFuncName = "subRaidGetBasicDataList2";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (chassis != null) {
            int iTypeDku = chassis.getInt(KEY_VALUE_TYPE);
            if (iTypeDku == 11) {
                int iIdDku = chassis.getInt(KEY_VALUE_ID);
                String strLocationDku = chassis.getString(KEY_VALUE_LOCATION);
                SanList compList = chassis.getList(KEY_VALUE_COMPONENTS);
                if (compList != null && compList.size() > 0) {
                    for (SanObject comp : compList) {
                        tableData.addAll(this.subRaidGetBasicDataList3(comp, iIdDku, strLocationDku));
                    }
                } else {
                    this.getLogUty().putlog(strFuncName, "compList is null or size 0");
                }
            }
        } else {
            this.getLogUty().putlog(strFuncName, "chassis is null");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subRaidGetBasicDataList3(SanObject comp, int iIdDku, String strLocationDku) throws SanDataException {
        String strFuncName = "subRaidGetBasicDataList3";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (comp != null) {
            int iTypeHdu = comp.getInt(KEY_VALUE_TYPE);
            if (iTypeHdu == 1102) {
                int iIdHdu = comp.getInt(KEY_VALUE_ID);
                SanList subCompList = comp.getList(KEY_VALUE_COMPONENTS);
                if (subCompList != null && subCompList.size() > 0) {
                    for (SanObject subComp : subCompList) {
                        tableData.addAll(this.subRaidGetBasicDataList4(subComp, iIdDku, strLocationDku, iIdHdu));
                    }
                } else {
                    this.getLogUty().putlog(strFuncName, "subCompList is null or size 0");
                }
            }
        } else {
            this.getLogUty().putlog(strFuncName, "comp is null");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subRaidGetBasicDataList4(SanObject subComp, int iIdDku, String strLocationDku, int iIdHdu) throws SanDataException {
        String strFuncName = "subRaidGetBasicDataList4";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (subComp != null) {
            int iTypeDkups = subComp.getInt(KEY_VALUE_TYPE);
            if (iTypeDkups == 4) {
                int iIdDkups = subComp.getInt(KEY_VALUE_ID);
                String strLocationDkups = subComp.getString(KEY_VALUE_LOCATION);
                Integer integerTempDkups = (Integer)subComp.getMember(KEY_VALUE_TEMPERATURE);
                int iTemp = -128;
                if (integerTempDkups != null) {
                    iTemp = integerTempDkups;
                }
                int iPrimaryKey = iIdDku << 16 | iIdHdu << 8 | iIdDkups;
                String strPrimaryKey = SJmoUtility.itoh(iPrimaryKey, 6);
                tableData.add(new SJctrTempMonitorTableRecordInfo(strPrimaryKey, strLocationDku, strLocationDkups, iTemp));
            }
        } else {
            this.getLogUty().putlog(strFuncName, "subcomp is null");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subHmGetBasicDataList(SanResponse rmiMntReadEnvMonInfo) {
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData;
        block11: {
            boolean AFA_Flg = false;
            String strFuncName = "subHmGetBasicDataList";
            tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
            int tblDataNum = this.getNumOfDB();
            if (rmiMntReadEnvMonInfo != null) {
                try {
                    SanObject storageSystem = rmiMntReadEnvMonInfo.getObj(KEY_VALUE_STORAGE_SYSTEM);
                    if (storageSystem != null) {
                        SanList chassisList = storageSystem.getList(KEY_VALUE_CHASSIS);
                        int dbCnt = 0;
                        if (chassisList != null && chassisList.size() > 0) {
                            for (SanObject chassis : chassisList) {
                                int iTypeDb = chassis.getInt(KEY_VALUE_TYPE);
                                if (iTypeDb != 10) continue;
                                String strLocationDku = chassis.getString(KEY_VALUE_LOCATION);
                                if (strLocationDku.indexOf("&") != -1) {
                                    if (!AFA_Flg) {
                                        AFA_Flg = true;
                                    } else {
                                        AFA_Flg = false;
                                        ++dbCnt;
                                        continue;
                                    }
                                }
                                if (dbCnt < tblDataNum) {
                                    tableData.addAll(this.subHmGetBasicDataList2(chassis));
                                    ++dbCnt;
                                    continue;
                                }
                                break block11;
                            }
                            break block11;
                        }
                        this.getLogUty().putlog(strFuncName, "chassisList is null or size 0");
                        break block11;
                    }
                    this.getLogUty().putlog(strFuncName, "storageSystem is null");
                }
                catch (SanDataException e) {
                    this.getLogUty().putlog(strFuncName, "SanDataException is occured", e, 40000);
                }
            } else {
                this.getLogUty().putlog(strFuncName, "rmiMntReadEnvMonInfo is null");
            }
        }
        return tableData;
    }

    private int getNumOfDB() {
        int rtn = 0;
        int iHMKind = SJsncProductModelUty.getProductModel();
        switch (iHMKind) {
            case 20: {
                rtn = 8;
                break;
            }
            case 40: {
                rtn = 24;
                break;
            }
            case 60: {
                rtn = 48;
                break;
            }
        }
        return rtn;
    }

    private List<SJctrTempMonitorTableRecordInfo> subHmGetBasicDataList2(SanObject chassis) throws SanDataException {
        String strFuncName = "subHmGetBasicDataList2";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (chassis != null) {
            int iTypeDb = chassis.getInt(KEY_VALUE_TYPE);
            if (iTypeDb == 10) {
                int iIdDb = chassis.getInt(KEY_VALUE_ID);
                String strLocationDb = chassis.getString(KEY_VALUE_LOCATION);
                SanList compList = chassis.getList(KEY_VALUE_COMPONENTS);
                if (compList != null && compList.size() > 0) {
                    for (SanObject comp : compList) {
                        tableData.addAll(this.subHmGetBasicDataList3(comp, iIdDb, strLocationDb));
                    }
                } else {
                    this.getLogUty().putlog(strFuncName, "compList is null or size 0");
                }
            }
        } else {
            this.getLogUty().putlog(strFuncName, "chassis is null");
        }
        return tableData;
    }

    private List<SJctrTempMonitorTableRecordInfo> subHmGetBasicDataList3(SanObject comp, int iIdDb, String strLocationDb) throws SanDataException {
        String strFuncName = "subHmGetBasicDataList3";
        ArrayList<SJctrTempMonitorTableRecordInfo> tableData = new ArrayList<SJctrTempMonitorTableRecordInfo>();
        if (comp != null) {
            int iTypeDbps = comp.getInt(KEY_VALUE_TYPE);
            if (iTypeDbps == 3) {
                int iIdDbps = comp.getInt(KEY_VALUE_ID);
                String strLocationDbps = comp.getString(KEY_VALUE_LOCATION);
                Integer iTempDbps = (Integer)comp.getMember(KEY_VALUE_TEMPERATURE);
                int iTemp = -128;
                if (iTempDbps != null) {
                    iTemp = iTempDbps;
                }
                int iPrimaryKey = iIdDb << 8 | iIdDbps;
                String strPrimaryKey = SJmoUtility.itoh(iPrimaryKey, 4);
                tableData.add(new SJctrTempMonitorTableRecordInfo(strPrimaryKey, strLocationDb, strLocationDbps, iTemp));
            }
        } else {
            this.getLogUty().putlog(strFuncName, "comp is null");
        }
        return tableData;
    }
}

