/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrWarnPGPoolAssignedCapColumnFromPGDetail
extends SJctrCapacityColumn {
    private Map<String, Long> pageNumMap = null;
    private Map<String, Long> lbaNumMap = null;
    private static final String HALF_SPACE = " ";

    public SJctrWarnPGPoolAssignedCapColumnFromPGDetail(String key) {
        super(key);
        this.setPartsId("POOL_ASSIGNED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public boolean hasDpVolume(Map<Class<?>, List<?>> basicData) {
        return true;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> retList = new ArrayList<Object>();
        SJmoPgDetail pgDtl = (SJmoPgDetail)index;
        retList.add(pgDtl);
        List<?> poolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(0);
        retList.add(poolDtl);
        List poolVolList = null;
        Map pgPoolVolMap = (Map)basicData.get(SJctrPoolUtility.KEY_PG_POOLVOL).get(0);
        poolVolList = (List)pgPoolVolMap.get(pgDtl);
        retList.add(poolVolList);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (this.pageNumMap == null || this.lbaNumMap == null) {
            int rowCount = this.getTable().getRowCount();
            this.pageNumMap = new HashMap<String, Long>(rowCount);
            this.lbaNumMap = new HashMap<String, Long>(rowCount);
        }
        long assignedCapPage = 0L;
        if (dataList != null && dataList.size() >= 3) {
            SJmoPgDetail pgDtl = (SJmoPgDetail)dataList.get(0);
            List poolVolList = (List)dataList.get(2);
            assignedCapPage = SJctrPoolUtility.getCapPOOLAssigned(poolVolList);
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(pgDtl.getFB4());
            pgIndex.setPG(pgDtl.getPG());
            this.pageNumMap.put(pgIndex.toString(), assignedCapPage);
            SJctrCapacityUtility capUtil = this.getTable().getComUtility().getCapacityUtility();
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(1);
            long pageSize = poolDtl.getPageSize();
            long assignedCapKb = assignedCapPage * pageSize;
            long assignedCapLba = capUtil.valueOf(assignedCapKb, SJctrCapacityUtility.UNIT.KB);
            this.lbaNumMap.put(pgIndex.toString(), assignedCapLba);
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.GB;
            if (select.length() > 0) {
                unit = SJctrCapacityUtility.UNIT.valueOf(select);
            }
            StringBuffer buf = new StringBuffer();
            if (unit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                buf.append(assignedCapPage);
            } else {
                buf.append(capUtil.toString(assignedCapLba, unit));
            }
            buf.append(HALF_SPACE);
            buf.append(capUtil.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPgDetail pgDtl = (SJmoPgDetail)this.getPrimaryKeyObject(dat);
        Long lbaCap = this.lbaNumMap.get(pgDtl.toString());
        if (lbaCap == null) {
            return -2L;
        }
        return lbaCap;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoPgDetail pgDtl = (SJmoPgDetail)this.getPrimaryKeyObject(dat);
        Long pageCap = this.pageNumMap.get(pgDtl.toString());
        if (pageCap == null) {
            return -2L;
        }
        return pageCap;
    }
}

