/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.createpools;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.common.Robj_interface_POOLsetLaneAOUVolData;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serversx.data.RJiLDKCIndex;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVolData;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVol_IN;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVol_OUT;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_IN;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_OUT;
import sanproject.serverux.dataimpl.RJiResourceName;
import sanproject.serverux.dataimpl.RJiSetResourceNameResult;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.model.data.group.SJmoPoolIndex;

public class SJctrCreatePoolsFptVolParentAC
extends SJctrApplyController {
    private static final long serialVersionUID = 7399101323520828369L;
    private List<SJctrPoolDetail> poolList;
    private int iApplyType = 0;
    public static final int APPLY_NONDATA = -1;
    private static final int APPLY_TYPE_ADDFPT = 0;
    private static final int APPLY_TYPE_TIERLEVEL_FPTVOL = 1;
    private static final int APPLY_TYPE_LDEVNAME_FPTVOL = 2;
    private List<SJctrError> resultData;
    private boolean bHM = false;

    public SJctrCreatePoolsFptVolParentAC(List<SJctrPoolDetail> poolList, int iApplyType, boolean bHM) {
        ArrayList<SJctrPoolDetail> wkPoolList = new ArrayList<SJctrPoolDetail>();
        for (int i = 0; i < poolList.size(); ++i) {
            SJctrPoolDetail pool = poolList.get(i);
            if (!pool.isPoolDedup()) continue;
            wkPoolList.add(pool);
        }
        Collections.sort(wkPoolList);
        this.poolList = wkPoolList;
        this.iApplyType = iApplyType;
        this.bHM = bHM;
    }

    public List<SJctrPoolDetail> getPooList() {
        return this.poolList;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<Object> rtn = new ArrayList<Object>();
        switch (this.iApplyType) {
            case 0: {
                rtn.add(this.getApplyData_FPT());
                break;
            }
            case 1: {
                rtn.add(this.getTierLevelData());
                break;
            }
            case 2: {
                rtn.add(this.getLdevNameData());
            }
        }
        return rtn;
    }

    private SanRequest getApplyData_FPT() {
        SJctrLogUty.info(this.title, "getApplyData_FPT", "START");
        SanRequest request = this.newRequest("VVOLupdatePoolDeduplication");
        try {
            request.putBoolean("Deduplication", true);
            SanList pools = request.newList("Pools");
            for (int iPool = 0; iPool < this.poolList.size(); ++iPool) {
                SJctrPoolDetail inPool = this.poolList.get(iPool);
                SanObject wkPool = pools.addObj();
                wkPool.putInt("Id", inPool.getPoolId());
                ArrayList ldevList = inPool.getFptList();
                SanList ldevs = wkPool.newList("ThinProvisioningVolumes");
                for (int i = 0; i < ldevList.size(); ++i) {
                    SJctrLDEVDetail ldev = (SJctrLDEVDetail)ldevList.get(i);
                    SanObject ldevParameter = ldevs.addObj();
                    int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                    ldevParameter.putIntArray("Id", id);
                    if (!this.bHM) {
                        ldevParameter.putInt("Ssid", ldev.getISSID());
                    }
                    SJctrLogUty.info(this.title, "getApplyData_FPT", "LDEVID=" + ldev.getIndexKey() + ",MpUnitId=" + ldev.getByCurrentMPBladeID() + ",Ssid=" + ldev.getISSID() + ",Clpr=" + ldev.getSCLPR());
                }
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        SJctrLogUty.info(this.title, "getApplyData_FPT", "END");
        return request;
    }

    private POOLsetLaneAOUVol_IN getTierLevelData() {
        POOLsetLaneAOUVol_IN rtn = new POOLsetLaneAOUVol_IN();
        ArrayList<SJctrLDEVDetail> LDEVList = this.getTierLevelDataList();
        Robj_interface_POOLsetLaneAOUVolData[] data = new POOLsetLaneAOUVolData[LDEVList.size()];
        for (int i = 0; i < LDEVList.size(); ++i) {
            SJctrLDEVDetail Detail = LDEVList.get(i);
            data[i] = new POOLsetLaneAOUVolData();
            ((POOLsetLaneAOUVolData)data[i]).setSPoolId((short)Detail.getIRelationPoolID());
            ((RJiLDKCIndex)((Object)data[i])).setSLDKC(Detail.getSLdkc());
            ((RJiCUIndex)((Object)data[i])).setSCU(Detail.getSCu());
            ((RJiLDEVIndex)((Object)data[i])).setSLDEV(Detail.getSLdev());
            ((POOLsetLaneAOUVolData)data[i]).setSTierLevel(Detail.getSTierLevel());
            ((POOLsetLaneAOUVolData)data[i]).setSNewPageAssignmentTier(Detail.getSNewPageAssgin());
            ((POOLsetLaneAOUVolData)data[i]).setSRelocationPriority(Detail.getSRelPriority());
        }
        rtn.setObjAOUVolData(data);
        return rtn;
    }

    private ArrayList<SJctrLDEVDetail> getTierLevelDataList() {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        List<SJctrLDEVDetail> ldevList = this.getLdevList();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            if (ldev.getSTierLevel() == -1) continue;
            rtn.add(ldev);
        }
        return rtn;
    }

    public RJiRESOURCEsetName_IN getLdevNameData() {
        RJiRESOURCEsetName_IN input = new RJiRESOURCEsetName_IN();
        List<SJctrLDEVDetail> ldevList = this.getLdevList();
        Robj_interface_RJiResourceName[] resouce = new RJiResourceName[ldevList.size()];
        for (int i = 0; i < ldevList.size(); ++i) {
            resouce[i] = new RJiResourceName();
            SJctrLDEVDetail ldev = ldevList.get(i);
            ((RJiResourceName)resouce[i]).setNumber(SJctrCVSUtility.getLdevNumber(ldev));
            ((RJiResourceName)resouce[i]).setType(1);
            ((RJiResourceName)resouce[i]).setName(ldev.getStrLdevName());
        }
        input.setResourceName(resouce);
        return input;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrLogUty.info(this.title, "setApplyResult", resultObject.toString());
        super.setApplyResult(resultObject);
        this.resultData = new ArrayList<SJctrError>();
        boolean bErrFlg = false;
        if (resultObject instanceof SanResponse) {
            bErrFlg = this.setErrData_FPT((SanResponse)resultObject);
        }
        if (resultObject instanceof POOLsetLaneAOUVol_OUT) {
            bErrFlg = this.setErrData_TierLane((POOLsetLaneAOUVol_OUT)resultObject);
        }
        if (resultObject instanceof RJiRESOURCEsetName_OUT) {
            bErrFlg = this.setErrData_LdevName((RJiRESOURCEsetName_OUT)resultObject);
        }
        if (!bErrFlg) {
            this.resultData = new ArrayList<SJctrError>();
        }
    }

    private boolean setErrData_FPT(SanResponse kvResponse) {
        boolean bErrFlg = false;
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (errorInfo.hasLowerNodeError()) {
                SJctrError error = errorInfo.createError();
                this.setError(error);
                SanList kvResultPools = kvResponse.getList("Pools");
                for (int i = 0; i < kvResultPools.size(); ++i) {
                    SanObject pool = kvResultPools.getObj(i);
                    SJctrKeyValueErrorInfo poolErr = new SJctrKeyValueErrorInfo(pool.getObj("ErrorInfo"));
                    if (poolErr.getErrorCode() == 0) continue;
                    SJctrError wkPoolErr = poolErr.createError();
                    SJctrPoolError poolIndexErr = new SJctrPoolError(wkPoolErr.getFunc(), wkPoolErr.getModule(), wkPoolErr.getMsg());
                    SJmoPoolIndex poolIdx = new SJmoPoolIndex();
                    poolIdx.setPoolId(pool.getInt("Id"));
                    poolIndexErr.setkeyData(poolIdx);
                    poolIndexErr.setStrAssignTableKey("COM_TABLE");
                    this.resultData.add(poolIndexErr);
                }
            } else {
                if (errorInfo.isOverAll()) {
                    this.setError(errorInfo.createError());
                    return true;
                }
                return false;
            }
            bErrFlg = true;
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
            bErrFlg = true;
        }
        return bErrFlg;
    }

    private boolean setErrData_TierLane(POOLsetLaneAOUVol_OUT resultObject) {
        boolean bErrFlg = false;
        int iJcount = 0;
        this.resultData = new ArrayList<SJctrError>();
        POOLsetLaneAOUVol_OUT result = resultObject;
        POOLsetLaneAOUVolData[] data = (POOLsetLaneAOUVolData[])result.getObjAOUVolData();
        List<SJctrLDEVDetail> ldevList = this.getLdevList();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            SJctrError error = new SJctrError(30, 5, 0);
            for (int j = iJcount; j < data.length; ++j) {
                if (ldev.getSLdkc() != data[j].getSLDKC() || ldev.getSCu() != data[j].getSCU() || ldev.getSLdev() != data[j].getSLDEV()) continue;
                long iError = data[j].getLErrorCode();
                error.setError((int)iError);
                if (iError != 0L && !bErrFlg) {
                    this.setError(error);
                    bErrFlg = true;
                }
                iJcount = j;
                break;
            }
            this.resultData.add(error);
        }
        return bErrFlg;
    }

    private boolean setErrData_LdevName(RJiRESOURCEsetName_OUT resultObject) {
        boolean rtn = false;
        RJiSetResourceNameResult[] addVol = resultObject.getDataObject();
        for (int i = 0; i < addVol.length; ++i) {
            int[] iError = addVol[i].getError();
            SJctrError result = new SJctrError(30, 5, iError[1]);
            this.resultData.add(result);
            if (iError[1] == 0 || rtn) continue;
            this.setError(result);
            rtn = true;
        }
        return rtn;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    public ArrayList<SJctrApplyController> getACList() {
        ArrayList<SJctrApplyController> rtn = new ArrayList<SJctrApplyController>();
        rtn.add(new SJctrCreatePoolsFptVolParentAC(this.poolList, 0, this.bHM));
        rtn.add(new SJctrCreatePoolsFptVolParentAC(this.poolList, 2, this.bHM));
        if (this.getTierLevelDataList().size() > 0) {
            rtn.add(new SJctrCreatePoolsFptVolParentAC(this.poolList, 1, this.bHM));
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        int leadTime = 0;
        List<SJctrLDEVDetail> ldevList = this.getLdevList();
        switch (this.iApplyType) {
            case 0: {
                leadTime = (ldevList.size() / 800 + 1) * 80;
                break;
            }
            case 1: {
                leadTime = 45 + this.getTierLevelDataList().size() / 5;
                leadTime += this.getTierLevelDataList().size() / 1024;
                break;
            }
            case 2: {
                leadTime = 100;
            }
        }
        return leadTime;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private List<SJctrLDEVDetail> getLdevList() {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        for (int i = 0; i < this.poolList.size(); ++i) {
            rtn.addAll(this.poolList.get(i).getFptList());
        }
        Collections.sort(rtn);
        return rtn;
    }
}

