/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.deletepools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrPoolAttributeColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolCapacityColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolDriveTypeColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolNameColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolRaidLevelColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolThresholdColumn;
import sanproject.sn2.controller.com.column.SJctrPoolThresholdColumnFromPoolDetail;
import sanproject.sn2.controller.com.column.SJctrPoolVolumesNumColumnFromPoolDetail;
import sanproject.sn2.controller.com.comparator.SJctrPoolIndexForPoolNameComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.column.SJctrThresold2FromPoolDetailColumn;
import sanproject.sn2.controller.wizard.pool.deletepools.SJctrDeletePoolsDC;
import sanproject.sn2.controller.wizard.pool.deletepools.SJctrDeletePoolsEventListener;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;

public class SJctrDeletePoolsTableModel
extends SJctrTableDataModel {
    public SJctrDeletePoolsTableModel() {
        this.initDataModel();
    }

    @Override
    protected void initTable() {
        SJctrPoolThresholdColumn parent_PoolThreshold = null;
        this.addColumn(new SJctrPoolNameColumnFromPoolDetail("COM_COL_POOLNAME"));
        this.addColumn(new SJctrPoolRaidLevelColumnFromPoolDetail("COM_COL_RAIDLEV"));
        this.addColumn(new SJctrPoolCapacityColumnFromPoolDetail("COM_COL_POOLCAP"));
        this.addColumn(new SJctrPoolAttributeColumnFromPoolDetail("COM_COL_ATTR"));
        this.addColumn(new SJctrPoolDriveTypeColumnFromPoolDetail("COM_COL_DRIVETYPE"));
        this.addColumn(new SJctrPoolThresholdColumn("COM_COL_THRES"));
        parent_PoolThreshold = (SJctrPoolThresholdColumn)super.getColumnInfo("COM_COL_THRES");
        parent_PoolThreshold.addColumn(new SJctrPoolThresholdColumnFromPoolDetail("COM_COL_THRES_WARNING"));
        parent_PoolThreshold.addColumn(new SJctrThresold2FromPoolDetailColumn("COM_COL_THRES_DEPLETION"));
        this.addColumn(new SJctrPoolVolumesNumColumnFromPoolDetail("COM_COL_PLVOL_NUM"));
    }

    private void initDataModel() {
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        this.addDataModel("COM_BUTTON_GROUP", buttonGroup);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        buttonGroup.addDataModel("COM_DETAIL", detailButton);
        SJctrDeletePoolsEventListener dpEvtLsnr = new SJctrDeletePoolsEventListener(this);
        detailButton.addItemSelectListener(dpEvtLsnr);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        ArrayList<Object> mainKeyList = new ArrayList();
        SJctrDeletePoolsDC dpDC = (SJctrDeletePoolsDC)this.getDataController();
        ArrayList poolDtlList = new ArrayList(dpDC.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        List<SJmoPoolNameInfo> poolNameInfoList = dpDC.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        if (null == poolDtlList || 0 == poolDtlList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "CacheData is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        Collections.sort(poolDtlList, new SJctrPoolIndexForPoolNameComparator(poolNameInfoList));
        mainKeyList = poolDtlList;
        boolean bCapacityFlg = true;
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        for (int iCnt = 0; !(iCnt >= mainKeyList.size() || bOpenFlg && bMFFlg); ++iCnt) {
            SJmoPoolDetail poolDetail = (SJmoPoolDetail)mainKeyList.get(iCnt);
            if (SJctrPoolUtility.isOpenPool(poolDetail)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrPoolUtility.isMainframePool(poolDetail)) continue;
            bMFFlg = true;
        }
        this.setCapacityFlg(bCapacityFlg);
        this.setMainframeVolumeFlg(bMFFlg);
        this.setOpenVolumeFlg(bOpenFlg);
        this.setDpVolumeFlg(true);
        return mainKeyList;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void makeCapacityUnitInfo() {
    }
}

