/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDC;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrEditPoolsThresholdArea
extends SJctrSimpleDataModel {
    private SJctrCheckBoxDataModel thresholdCheck = new SJctrCheckBoxDataModel();
    private SJctrTextBoxDataModel warThresholdTextBox = new SJctrTextBoxDataModel();
    private SJctrEditPoolsDC edPDC = null;
    private SJctrComUtility comUtil = null;

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.addDataModel("COM_CHECKBOX", this.thresholdCheck);
        this.addDataModel("COM_THRESHOLD", this.warThresholdTextBox);
        this.comUtil = util;
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
    }

    public void initWarningThreshold(boolean bDepEnable) {
        ArrayList<Object> poolDtlList = new ArrayList();
        int iMinThreshold = 1;
        int iMaxThreshold = 100;
        int iMinDepletion = 100;
        int iMaxPoolUsedRate = 0;
        boolean bWarThresholdMix = false;
        String strDefWarThresholdText = new String("");
        int sDefWarningThreshold = 0;
        boolean bEnableSysThreshold = false;
        this.warThresholdTextBox.setEnable(true);
        this.thresholdCheck.setEnable(true);
        this.clearData();
        poolDtlList = new ArrayList(this.edPDC.getCache("KEY_CLASS_EDIT_DATA"));
        sDefWarningThreshold = this.comUtil.getPoolUtility().isSysThresChangeWarThres((SJmoPoolDetail)poolDtlList.get(0)) ? ((SJmoPoolDetail)poolDtlList.get(0)).getPoolFixThreshold() : ((SJmoPoolDetail)poolDtlList.get(0)).getPoolThreshold();
        for (int iCnt = 0; iCnt < poolDtlList.size(); ++iCnt) {
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(iCnt);
            short ichkWarThreshold = poolDtl.getPoolThreshold();
            if (this.comUtil.getPoolUtility().isSysThresChangeWarThres(poolDtl)) {
                ichkWarThreshold = poolDtl.getPoolFixThreshold();
                bEnableSysThreshold = true;
            }
            if (poolDtl.getPoolKind() == 8) {
                iMinThreshold = 20;
                iMaxThreshold = 95;
            } else if (poolDtl.getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON) {
                if (iMinDepletion > poolDtl.getSPoolDepletionThreshold()) {
                    iMinDepletion = poolDtl.getSPoolDepletionThreshold();
                }
            } else if (this.comUtil.getPoolUtility().isSysThresChangeDepThres(poolDtl)) {
                if (iMinDepletion > poolDtl.getPoolFixThreshold()) {
                    iMinDepletion = poolDtl.getPoolFixThreshold();
                }
            } else if (iMinDepletion > poolDtl.getPoolThreshold()) {
                iMinDepletion = poolDtl.getPoolThreshold();
            }
            int lPoolUsedRate = this.comUtil.getPoolUtility().getPoolUsed(poolDtl);
            if (lPoolUsedRate > iMaxPoolUsedRate) {
                iMaxPoolUsedRate = lPoolUsedRate;
            }
            if (sDefWarningThreshold == ichkWarThreshold) continue;
            bWarThresholdMix = true;
        }
        if (iMaxPoolUsedRate > iMinThreshold) {
            iMinThreshold = iMaxPoolUsedRate;
        }
        if (!bDepEnable && iMaxThreshold > iMinDepletion) {
            iMaxThreshold = iMinDepletion;
        }
        if (iMaxPoolUsedRate > iMaxThreshold) {
            this.disableWarThresholdText();
            return;
        }
        if (iMinThreshold > iMaxThreshold) {
            this.disableWarThresholdText();
            return;
        }
        if (!bWarThresholdMix && sDefWarningThreshold >= iMaxPoolUsedRate && !bEnableSysThreshold) {
            strDefWarThresholdText = new String(SJctrComUtility.toDecString(sDefWarningThreshold));
        }
        this.warThresholdTextBox.setValue(strDefWarThresholdText);
        this.warThresholdTextBox.setMin(SJctrComUtility.toDecString(iMinThreshold));
        this.warThresholdTextBox.setMax(SJctrComUtility.toDecString(iMaxThreshold));
    }

    String getStrWarThreshold() {
        return this.warThresholdTextBox.getValue();
    }

    public boolean getSelCheckBox() {
        boolean bRtn = true;
        bRtn = this.thresholdCheck.isSelect();
        return bRtn;
    }

    public void disableWarThresholdText() {
        this.warThresholdTextBox.setValue("");
        this.warThresholdTextBox.setMin("");
        this.warThresholdTextBox.setMax("");
        this.warThresholdTextBox.setEnable(false);
        this.thresholdCheck.setEnable(false);
        this.warThresholdTextBox.clearData();
    }

    public void setWarningThresholdMin(String min) {
        this.warThresholdTextBox.setMin(min);
    }

    public void setWarningThresholdMax(String max) {
        this.warThresholdTextBox.setMax(max);
    }

    public void setWarningThresholdValue(String value) {
        this.warThresholdTextBox.setValue(value);
    }

    public void setSelectWarningThresholdCheckBox(boolean flg) {
        this.thresholdCheck.setSelect(flg);
    }
}

