/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.edittieringpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.common.Robj_interface_POOLsetTieringPolicy;
import sanproject.serverux.dataimpl.POOLsetTieringPolicy;
import sanproject.serverux.dataimpl.POOLsetTieringPolicy_IN;
import sanproject.serverux.dataimpl.POOLsetTieringPolicy_OUT;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;

public class SJctrEditTieringPoliciesAC
extends SJctrApplyController {
    private static final long serialVersionUID = -6452809680688545202L;
    private List<SJctrError> resultData = null;
    private List<SJmoPoolTieringPolicy> tieringPolicyList = null;
    private Set<Short> tieringPolicyCheckPolicyIdSet = null;
    private Set<Short> allocationThresholdCheckPolicyIdSet = null;
    private static final double POLICY_SETTIME = 0.0015;

    public void setApplyList(List<SJmoPoolTieringPolicy> tieringPolicyList, Set<Short> tieringPolicyCheckPolicyIdSet, Set<Short> allocationThresholdCheckPolicyIdSet) {
        this.tieringPolicyList = tieringPolicyList;
        this.tieringPolicyCheckPolicyIdSet = tieringPolicyCheckPolicyIdSet;
        this.allocationThresholdCheckPolicyIdSet = allocationThresholdCheckPolicyIdSet;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<POOLsetTieringPolicy_IN> applyList = new ArrayList<POOLsetTieringPolicy_IN>();
        POOLsetTieringPolicy_IN setTierPolicy_IN = new POOLsetTieringPolicy_IN();
        Robj_interface_POOLsetTieringPolicy[] setTierPolicyArray = new POOLsetTieringPolicy[this.tieringPolicyList.size()];
        for (int index = 0; index < this.tieringPolicyList.size(); ++index) {
            SJmoPoolTieringPolicy tieringPolicy = this.tieringPolicyList.get(index);
            POOLsetTieringPolicy setTierPolicy = new POOLsetTieringPolicy();
            setTierPolicy.setSPolicyId(tieringPolicy.getPolicyId());
            if (this.tieringPolicyCheckPolicyIdSet.contains(tieringPolicy.getPolicyId())) {
                setTierPolicy.setStrPolicyName(tieringPolicy.getStrPolicyName());
            }
            if (this.allocationThresholdCheckPolicyIdSet.contains(tieringPolicy.getPolicyId())) {
                setTierPolicy.setST1Max(tieringPolicy.getST1Max());
                setTierPolicy.setST1Min(tieringPolicy.getST1Min());
                setTierPolicy.setST3Max(tieringPolicy.getST3Max());
                setTierPolicy.setST3Min(tieringPolicy.getST3Min());
            }
            setTierPolicyArray[index] = setTierPolicy;
        }
        setTierPolicy_IN.setDataObject(setTierPolicyArray);
        applyList.add(setTierPolicy_IN);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        if (resultObject instanceof POOLsetTieringPolicy_OUT) {
            SJctrError error;
            POOLsetTieringPolicy_OUT out = (POOLsetTieringPolicy_OUT)resultObject;
            POOLsetTieringPolicy[] setTierPolicyArray = (POOLsetTieringPolicy[])out.getDataObject();
            HashSet<Integer> mix = new HashSet<Integer>(setTierPolicyArray.length);
            HashMap<Short, SJctrError> errorMap = new HashMap<Short, SJctrError>(this.tieringPolicyList.size());
            for (int index = 0; index < setTierPolicyArray.length; ++index) {
                POOLsetTieringPolicy setTierPolicy = setTierPolicyArray[index];
                int retError = (int)setTierPolicy.getLErrorCode();
                if (retError != SJctrPoolUtility.RESULT_NORMAL) {
                    mix.add(retError);
                }
                error = new SJctrError(30, 5, retError);
                short policyId = setTierPolicy.getSPolicyId();
                errorMap.put(policyId, error);
            }
            this.resultData = new ArrayList<SJctrError>(this.tieringPolicyList.size());
            for (SJmoPoolTieringPolicy tieringPolicy : this.tieringPolicyList) {
                short policyId = tieringPolicy.getPolicyId();
                error = (SJctrError)errorMap.get(policyId);
                if (error == null) continue;
                this.resultData.add(error);
            }
            int errfunc = 0;
            int errmodule = 0;
            int errcode = SJctrPoolUtility.RESULT_NORMAL;
            if (mix.size() == 0) {
                errfunc = 30;
                errmodule = 5;
                errcode = SJctrPoolUtility.RESULT_NORMAL;
            } else if (mix.size() == 1) {
                errfunc = 30;
                errmodule = 5;
                Object[] errArray = mix.toArray();
                errcode = (Integer)errArray[0];
            } else {
                errfunc = 201;
                errmodule = 22;
                errcode = 106061;
            }
            SJctrError result = new SJctrError(errfunc, errmodule, errcode);
            this.setError(result);
        }
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public int getLeadTime() {
        double setTime = (double)this.tieringPolicyList.size() * 0.0015;
        setTime = Math.ceil(setTime);
        return 45 + (int)setTime;
    }
}

