/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.restorepools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.comparator.SJctrPoolIndexComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.controller.wizard.pool.restorepools.SJctrRestorPoolsConfirmTableModel;
import sanproject.sn2.model.data.group.SJmoPoolIndex;

public class SJctrRestorePoolsConfirmDC
extends SJctrConfirmDataController {
    public static final int DISP_ID = 17870931;
    public static final String KEY_TABLE = "COM_TABLE";

    public SJctrRestorePoolsConfirmDC() {
        super(17870931);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrRestorPoolsConfirmTableModel());
    }

    public boolean checkStartData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        List<?> setpoolList = wizard.getCache("KEY_POOL_RECOVER");
        if (null == setpoolList || 0 == setpoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Select Pool(PoolVol) is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return bRetChk;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap mapKey = new HashMap();
        List<?> confDataPoolDtl = this.getCache("KEY_POOL_RECOVER");
        mapKey.put("KEY_POOL_RECOVER", confDataPoolDtl);
        List<?> confDataPoolNameInf = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        mapKey.put(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO.getName(), confDataPoolNameInf);
        List<?> versionList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName());
        mapKey.put(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName(), versionList);
        return mapKey;
    }

    @Override
    public void getConfirmWithStatus(List<Object> objList) {
        SJctrRestorPoolsConfirmTableModel resPoolTbl = (SJctrRestorPoolsConfirmTableModel)this.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> poolErrClmList = new ArrayList<SJctrErrorColumnData>();
        ArrayList poolNameInfList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        resPoolTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO, poolNameInfList);
        List<?> versionList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName());
        if (versionList != null) {
            resPoolTbl.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION, versionList);
        }
        resPoolTbl.makeDataModel();
        List poolErrList = (List)objList.get(0);
        for (int iCnt = 0; iCnt < poolErrList.size(); ++iCnt) {
            ArrayList errList = new ArrayList((List)poolErrList.get(iCnt));
            for (int iListCnt = 0; iListCnt < errList.size(); ++iListCnt) {
                SJctrPoolError poolErr = (SJctrPoolError)errList.get(iListCnt);
                SJmoPoolIndex keyObj = (SJmoPoolIndex)poolErr.getkeyData();
                SJctrErrorColumnData errClm = new SJctrErrorColumnData(keyObj, poolErr);
                if (!poolErr.getStrAssignTableKey().equals(KEY_TABLE)) continue;
                poolErrClmList.add(errClm);
            }
        }
        Collections.sort(poolErrClmList, new SJctrPoolIndexComparator());
        SJctrErrorTableModel errTblMdl = new SJctrErrorTableModel();
        errTblMdl.setOpenVolumeFlg(resPoolTbl.hasOpenVolume());
        errTblMdl.setMainframeVolumeFlg(resPoolTbl.hasMainframeVolume());
        errTblMdl.setDpVolumeFlg(resPoolTbl.hasDpVolume());
        this.addDataObjectModel(KEY_TABLE, errTblMdl);
        errTblMdl.initialize(resPoolTbl, poolErrClmList, new SJctrPoolIndexComparator());
    }
}

