/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetTiPairInfo;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.replication.SJctrTiPvolMuComparator;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrTIPVolSnapshotGroupInfo;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter_PVol;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter_PVolMU;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter_SSGrp;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoSnapshotSetInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrTIPairGetExecuter {
    protected SJctrWizardDataController dc = null;
    protected List<SJmoPoolNameInfo> poolNameList = Collections.emptyList();
    protected SJmoSnapshotSetInfoMgr ssGrpMgr = null;
    protected SJmoTiSnapshotPairList tiSSPairList = null;
    protected List<SJctrTIPVolSnapshotGroupInfo> tiPVolMuSSGrpInfo = Collections.emptyList();
    protected SJmoTiPvolStatus tiPVolStatus = null;
    protected Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = Collections.emptyMap();
    protected SJctrTiPvolMuComparator PVOLMU_COMP = new SJctrTiPvolMuComparator();

    public static SJctrTIPairGetExecuter createTIPairGetExecuter_PVol() {
        return new SJctrTIPairGetExecuter_PVol();
    }

    public static SJctrTIPairGetExecuter createTIPairGetExecuter_SSGrp() {
        return new SJctrTIPairGetExecuter_SSGrp();
    }

    public static SJctrTIPairGetExecuter createTIPairGetExecuter_PVolMU() {
        return new SJctrTIPairGetExecuter_PVolMU();
    }

    public abstract boolean checkInputData(List<?> var1);

    public void setModelData(List<SJmoPoolNameInfo> poolNameList, SJmoSnapshotSetInfoMgr ssGrpMgr, SJmoTiSnapshotPairList tiSSPairList, SJmoTiPvolStatus tiPVolStatus, Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap) {
        this.poolNameList = poolNameList;
        this.ssGrpMgr = ssGrpMgr;
        this.tiSSPairList = tiSSPairList;
        this.tiPVolStatus = tiPVolStatus;
        this.ldevLUPathMap = ldevLUPathMap;
        this.tiPVolMuSSGrpInfo = SJctrTIPVolSnapshotGroupInfo.createData(tiSSPairList);
    }

    public abstract boolean checkConstractData();

    protected abstract List<SJctrCreateTIPairInfo> getTIPair();

    protected boolean checkGetInfo(List<SJctrCreateTIPairInfo> tiPairList) {
        return true;
    }

    protected List<?> getCache(Class<?> key) {
        return this.dc.getCache(key);
    }

    protected abstract SJmoGetKind_IF createGetInputData();

    protected SJmoThroughRmiData getThroughRmiData() {
        SJmoGetKind_IF kind = this.createGetInputData();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData throughRmiData = null;
        try {
            throughRmiData = (SJmoThroughRmiData)this.dc.getModelData(directWrapper).get(0);
        }
        catch (Exception exp) {
            SJctrCreateTIPairUtility.createError(207007);
        }
        return throughRmiData;
    }

    protected List<SJctrCreateTIPairInfo> createAvailablePairList(MRCFgetTiPairInfo[] tiPairInfoArray) {
        if (tiPairInfoArray == null) {
            return new ArrayList<SJctrCreateTIPairInfo>();
        }
        ArrayList<SJctrCreateTIPairInfo> retList = new ArrayList<SJctrCreateTIPairInfo>(tiPairInfoArray.length);
        HashMap<Integer, SJmoPoolNameInfo> poolNameMap = new HashMap<Integer, SJmoPoolNameInfo>(this.poolNameList.size());
        Object[] tiPVolInfoArray = this.tiPVolStatus.getTiPvolInfo();
        SJmoTiPvolMu pVolMu = SJctrCreateTIPairUtility.createTiPVolMuInfo();
        SJmoLdevIndex sVolIndex = new SJmoLdevIndex();
        for (MRCFgetTiPairInfo tiPairInfo : tiPairInfoArray) {
            if ((tiPairInfo.getVolflg() & 2L) == 0L) continue;
            RJiLDEVIndex rmiPVolIndex = tiPairInfo.getPvol();
            SJmoLdevIndex pVolIndex = new SJmoLdevIndex();
            pVolIndex.setLdevIndex(rmiPVolIndex.getSLDKC(), rmiPVolIndex.getSCU(), rmiPVolIndex.getSLDEV());
            RJiLDEVIndex rmiSVolIndex = tiPairInfo.getSvol();
            sVolIndex.setLdevIndex(rmiSVolIndex.getSLDKC(), rmiSVolIndex.getSCU(), rmiSVolIndex.getSLDEV());
            int pVolIndexKey = SJctrReplicationUtility.getLdevIndexKey(pVolIndex);
            SJmoPortLunDetail pVolLuPath = null;
            List<SJmoPortLunDetail> luPathList = this.ldevLUPathMap.get(pVolIndexKey);
            if (luPathList != null && !luPathList.isEmpty()) {
                pVolLuPath = luPathList.get(0);
            }
            short muNum = tiPairInfo.getMu();
            pVolMu.setLdevIndex(pVolIndex.getSLdkc(), pVolIndex.getSCu(), pVolIndex.getSLdev());
            pVolMu.setMu(muNum);
            int searchIndex = Collections.binarySearch(this.tiPVolMuSSGrpInfo, pVolMu, this.PVOLMU_COMP);
            SJmoSnapshotSetInfo snapshotGrpInfo = null;
            if (searchIndex >= 0) {
                SJctrTIPVolSnapshotGroupInfo pVolMuSSGrpInfo = this.tiPVolMuSSGrpInfo.get(searchIndex);
                SJmoTiSnapshotPair ssGrpPairInfo = pVolMuSSGrpInfo.getTiSSPairInfo();
                int ssGrpId = (int)ssGrpPairInfo.getSnapshotID();
                snapshotGrpInfo = this.ssGrpMgr.getSnapshotSetInfo(ssGrpId);
            }
            SJmoLdevIndex rootVolIndex = new SJmoLdevIndex();
            RJiLDEVIndex rmiRootVol = tiPairInfo.getRootLdev();
            rootVolIndex.setLdevIndex(rmiRootVol.getSLDKC(), rmiRootVol.getSCU(), rmiRootVol.getSLDEV());
            searchIndex = Arrays.binarySearch(tiPVolInfoArray, rootVolIndex);
            if (searchIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createAvailablePairList", "PVOL LUPath notFound. PVOL" + SJctrComUtility.toHexString(pVolIndexKey));
                continue;
            }
            Object tiPVolInfo = tiPVolInfoArray[searchIndex];
            int poolId = ((SJmoTiPvolInfo)tiPVolInfo).getPoolid();
            SJmoPoolNameInfo poolNameInfo = (SJmoPoolNameInfo)poolNameMap.get(poolId);
            if (poolNameInfo == null) {
                SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                poolIndex.setPoolId(poolId);
                searchIndex = Collections.binarySearch(this.poolNameList, poolIndex);
                if (searchIndex < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createAvailablePairList", "POOL notFound . POOL ID:" + SJctrComUtility.toDecString(poolId));
                    continue;
                }
                poolNameInfo = this.poolNameList.get(searchIndex);
                poolNameMap.put(poolId, poolNameInfo);
            }
            short pairStatus = SJctrReplicationUtility.changeTIPairStatus(tiPairInfo);
            Date ssDate = tiPairInfo.getSnapshotDate();
            boolean bCascade = tiPairInfo.getCascade();
            boolean bClone = tiPairInfo.getClone();
            SJctrCreateTIPairInfo createPairInfo = new SJctrCreateTIPairInfo(pVolLuPath, pVolIndex, sVolIndex, snapshotGrpInfo, poolNameInfo, muNum, pairStatus, ssDate, bCascade, bClone, rootVolIndex);
            retList.add(createPairInfo);
        }
        Collections.sort(retList);
        return retList;
    }

    public List<SJctrCreateTIPairInfo> getAvailablePairInfo(SJctrWizardDataController dc) {
        this.dc = dc;
        this.checkConstractData();
        List<SJctrCreateTIPairInfo> pairList = this.getTIPair();
        this.checkGetInfo(pairList);
        return pairList;
    }

    protected List<SJctrCreateTIPairInfo> checkRSGInfoFromSelectedPairList(List<SJctrCreateTIPairInfo> tiPairList) {
        SJctrUserController uc = this.dc.getOwner();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(this.dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this.dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        boolean RSflg = true;
        for (SJctrCreateTIPairInfo pair : tiPairList) {
            RSflg = SJctrReplicationUtility.checkLocalPairResource(pair.getPVolIndex(), resourceLdevs);
            if (RSflg) continue;
            uc.getLogUty().putlog("checkRSGInfoFromSelectedPairList", "Selected pairs cannot use. P-VOL = " + pair.getPVolIndex().getSLdkc() + ":" + pair.getPVolIndex().getSCu() + ":" + pair.getPVolIndex().getSLdev() + "  MU# = " + pair.getMuNum());
            SJctrError err = new SJctrError(209, 22, 206329);
            SJcException exp = err.createException();
            throw exp;
        }
        return tiPairList;
    }
}

