/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrEmulationCapacityComparator;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;

public class SJctrSVOLManager
implements Serializable {
    private static final long serialVersionUID = 3163173508917676517L;
    private List<SJmoLdevDetail> ldevDtlList = null;
    private List<SJmoLdevLuseInfo> ldevLuseList = null;
    private ArrayList<sVolGroupInfo> sVolGroupList = null;
    private ArrayList<sVolGroupInfo> sVolLuseGroupList = null;
    private SJctrEmulationCapacityComparator cmp;
    private final int EMUFUNC_MASK = 61440;
    private final int EMUATTR_MASK = 3840;
    private final int EMUSERIESESIZE_MASK = 255;

    public SJctrSVOLManager(List<SJmoLdevDetail> ldevDtlList, List<SJmoLdevLuseInfo> ldevLuseList) {
        this.ldevDtlList = ldevDtlList;
        this.ldevLuseList = ldevLuseList;
        this.cmp = new SJctrEmulationCapacityComparator();
    }

    public void initialize(List<SJmoLdevDetail> sVolList) {
        Collections.sort(sVolList);
        Collections.sort(sVolList, this.cmp);
        this.sVolGroupList = new ArrayList(sVolList.size());
        ArrayList<sVolGroupInfo> tmpGrpList = new ArrayList<sVolGroupInfo>(sVolList.size());
        for (SJmoLdevDetail sVol : sVolList) {
            short luseCnt = sVol.getSLUSEEmlCount();
            if (luseCnt == 1) {
                sVolGroupInfo sVolGroup;
                int index = Collections.binarySearch(this.sVolGroupList, sVol);
                if (index >= 0) {
                    sVolGroup = this.sVolGroupList.get(index);
                    sVolGroup.setSVOL(sVol);
                    continue;
                }
                sVolGroup = new sVolGroupInfo(sVol);
                this.sVolGroupList.add(sVolGroup);
                continue;
            }
            if (luseCnt <= 1) continue;
            ArrayList<Long> luseCapList = new ArrayList<Long>(36);
            this.getLUSECapacityList(sVol, luseCapList);
            if (luseCapList.size() != luseCnt) continue;
            sVolGroupInfo sVolLuseGrp = new sVolGroupInfo(sVol, luseCapList);
            tmpGrpList.add(sVolLuseGrp);
        }
        if (!tmpGrpList.isEmpty()) {
            this.sVolLuseGroupList = new ArrayList(tmpGrpList.size());
            Collections.sort(tmpGrpList);
            for (sVolGroupInfo tmpGrp : tmpGrpList) {
                int index = Collections.binarySearch(this.sVolLuseGroupList, tmpGrp);
                if (index >= 0) {
                    sVolGroupInfo sVolGroup = this.sVolLuseGroupList.get(index);
                    SJmoLdevDetail sVol = tmpGrp.getsVolList().get(0);
                    sVolGroup.setSVOL(sVol);
                    continue;
                }
                this.sVolLuseGroupList.add(tmpGrp);
            }
        } else {
            this.sVolLuseGroupList = new ArrayList();
        }
        this.sVolGroupList.trimToSize();
        this.sVolLuseGroupList.trimToSize();
    }

    public List<SJmoLdevDetail> getsVolList(SJmoLdevDetail pVol, SJmoLdevIndex rootVol, List<SJmoLdevIndex> pairVolList, List<Long> luseCapList) {
        List<Object> retList = null;
        short luseCnt = pVol.getSLUSEEmlCount();
        if (luseCnt == 1) {
            int index = Collections.binarySearch(this.sVolGroupList, pVol);
            if (index >= 0) {
                sVolGroupInfo sVolGroup = this.sVolGroupList.get(index);
                luseCapList.add(pVol.getLLDEVLBASize());
                retList = sVolGroup.getsVolList();
            }
        } else if (luseCnt > 1) {
            this.getLUSECapacityList(pVol, luseCapList);
            sVolGroupInfo serchData = new sVolGroupInfo(pVol, luseCapList);
            int index = Collections.binarySearch(this.sVolLuseGroupList, serchData);
            if (index >= 0) {
                sVolGroupInfo sVolGroup = this.sVolLuseGroupList.get(index);
                retList = sVolGroup.getsVolList();
            }
        }
        if (retList == null) {
            retList = new ArrayList();
        }
        return retList;
    }

    public Object getSVolGrObject(SJmoLdevDetail pVol, List<Long> luseCapList) {
        sVolGroupInfo serchData;
        int index;
        sVolGroupInfo sVolGroup = null;
        short luseCnt = pVol.getSLUSEEmlCount();
        if (luseCnt == 1) {
            int index2 = Collections.binarySearch(this.sVolGroupList, pVol);
            if (index2 >= 0) {
                sVolGroup = this.sVolGroupList.get(index2);
            }
        } else if (luseCnt > 1 && (index = Collections.binarySearch(this.sVolLuseGroupList, serchData = new sVolGroupInfo(pVol, luseCapList))) >= 0) {
            sVolGroup = this.sVolLuseGroupList.get(index);
        }
        return sVolGroup;
    }

    private void getLUSECapacityList(SJmoLdevIndex ldev, List<Long> capList) {
        int topVolIndex = Collections.binarySearch(this.ldevDtlList, ldev);
        if (topVolIndex >= 0) {
            SJmoLdevDetail topLdevdtl = this.ldevDtlList.get(topVolIndex);
            capList.add(topLdevdtl.getLLDEVLBASize());
            int luseIndex = Collections.binarySearch(this.ldevLuseList, ldev);
            if (luseIndex >= 0) {
                SJmoLdevLuseInfo ldevLuseInfo = this.ldevLuseList.get(luseIndex);
                ArrayList luseLdevList = ldevLuseInfo.getAlLUSELdevIndex();
                for (SJmoLdevIndex luseLdev : luseLdevList) {
                    int dtlIndex = Collections.binarySearch(this.ldevDtlList, luseLdev);
                    if (dtlIndex < 0) {
                        capList.clear();
                        break;
                    }
                    SJmoLdevDetail luseLdevdtl = this.ldevDtlList.get(dtlIndex);
                    capList.add(luseLdevdtl.getLLDEVLBASize());
                }
            }
        }
    }

    public List<List<SJmoLdevDetail>> getSIMFsVolList(SJmoLdevDetail pVol, List<SJmoLdevIndex> pairVolList, List<Long> capList) {
        Integer checkEmu = pVol.getIEmulationType();
        capList.add(pVol.getLLDEVLBASize());
        ArrayList<List<SJmoLdevDetail>> retList = new ArrayList<List<SJmoLdevDetail>>();
        for (sVolGroupInfo sVolGrp : this.sVolGroupList) {
            int emuType = sVolGrp.getEmulationType();
            if (!checkEmu.equals(emuType) || !sVolGrp.checkSameCapacity(capList)) continue;
            retList.add(sVolGrp.getsVolList());
        }
        return retList;
    }

    private static class sVolGroupInfo
    implements Comparable {
        protected int iEmulationType;
        protected long lLDEVLBASize;
        private List<Long> luseCapList;
        protected List<SJmoLdevDetail> sVolList;

        public sVolGroupInfo(SJmoLdevDetail ldevDtl) {
            this.setParam(ldevDtl);
            this.luseCapList = new ArrayList<Long>();
            this.luseCapList.add(ldevDtl.getLLDEVLBASize());
        }

        public sVolGroupInfo(SJmoLdevDetail ldevDtl, List<Long> luseCapList) {
            this.setParam(ldevDtl);
            this.luseCapList = luseCapList;
        }

        private void setParam(SJmoLdevDetail ldevDtl) {
            this.iEmulationType = ldevDtl.getIEmulationType();
            this.lLDEVLBASize = ldevDtl.getLLDEVLBASize();
            this.sVolList = new ArrayList<SJmoLdevDetail>();
            this.sVolList.add(ldevDtl);
        }

        public void setSVOL(SJmoLdevDetail ldevdtl) {
            this.sVolList.add(ldevdtl);
        }

        public List<SJmoLdevDetail> getsVolList() {
            return this.sVolList;
        }

        public int getEmulationType() {
            return this.iEmulationType;
        }

        public int compareTo(Object obj) {
            int ret = 0;
            if (obj instanceof SJmoLdevDetail) {
                SJmoLdevDetail ldevDtl = (SJmoLdevDetail)obj;
                ret = this.iEmulationType - ldevDtl.getIEmulationType();
                if (ret == 0) {
                    ret = this.compCapacity(this.lLDEVLBASize, ldevDtl.getLLDEVLBASize());
                }
            } else {
                int luseNum;
                sVolGroupInfo sVolGrp = (sVolGroupInfo)obj;
                ret = this.iEmulationType - sVolGrp.iEmulationType;
                if (ret == 0 && (ret = (luseNum = this.luseCapList.size()) - sVolGrp.luseCapList.size()) == 0) {
                    for (int luseCnt = 0; luseCnt < luseNum; ++luseCnt) {
                        Long cap1 = this.luseCapList.get(luseCnt);
                        Long cap2 = sVolGrp.luseCapList.get(luseCnt);
                        ret = this.compCapacity(cap1, cap2);
                        if (ret != 0) break;
                    }
                }
            }
            return ret;
        }

        public boolean checkSameCapacity(List<Long> capaList) {
            boolean ret = true;
            int luseNum = this.luseCapList.size();
            if (luseNum != capaList.size()) {
                ret = false;
            }
            if (ret) {
                for (int luseCnt = 0; luseCnt < luseNum; ++luseCnt) {
                    Long cap1 = this.luseCapList.get(luseCnt);
                    Long cap2 = capaList.get(luseCnt);
                    if (this.compCapacity(cap1, cap2) == 0) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }

        protected int compCapacity(long capa1, long capa2) {
            int ret = 0;
            long capDif = capa1 - capa2;
            ret = capDif == 0L ? 0 : (capDif > 0L ? 1 : -1);
            return ret;
        }
    }
}

