/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.selectsecondaryvols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairSVOLInfo;
import sanproject.sn2.controller.wizard.replication.local.createpairs.selectsecondaryvols.SJctrSelectSecondaryVolsDC;

public class SJctrLDEVCapacityDataModel
extends SJctrComboBoxDataModel {
    private Map<String, copacityInfo> capacityMap = null;
    private int tortalRequireNum = 0;
    private SJctrComUtility comUtil = null;
    private Set<String> changeSet = null;
    public static final String ALL_NAME = "ALL";
    private final String GUID_ALL = "ALL";
    private final String GUID_REMAINING = "REMAINING";
    private final String GUID_LUSE = "LUSE";
    private SJctrItemSelectListener itemSelectListener = null;

    public void initLDEVCapacity(List<SJctrCreatePairSVOLInfo> sVolInfoList) {
        this.comUtil = this.getComUtility();
        this.tortalRequireNum = 0;
        SJctrComUtility comUtil = this.getComUtility();
        this.removeAllItems();
        this.addItem(ALL_NAME, "");
        this.capacityMap = new HashMap<String, copacityInfo>(sVolInfoList.size());
        ArrayList<String> strCapacityList = new ArrayList<String>(sVolInfoList.size());
        this.changeSet = new HashSet<String>(sVolInfoList.size());
        for (SJctrCreatePairSVOLInfo sVolInfo : sVolInfoList) {
            int requirSVolNum = sVolInfo.getRequirSVolNum();
            List<Long> capList = sVolInfo.getLuseCapList();
            String strCapacity = this.getStrCapacity(capList);
            copacityInfo capInfo = this.capacityMap.get(strCapacity);
            if (capInfo == null) {
                capInfo = new copacityInfo(requirSVolNum, capList);
                this.capacityMap.put(strCapacity, capInfo);
                strCapacityList.add(strCapacity);
                continue;
            }
            capInfo.addCopacityInfo(requirSVolNum, capList);
        }
        for (String strCapacity : strCapacityList) {
            copacityInfo capInfo = this.capacityMap.get(strCapacity);
            int requirNum = capInfo.getRequirSVolNum();
            String label = this.createDispLabel(strCapacity, requirNum);
            this.addItem(strCapacity, label);
            this.tortalRequireNum += capInfo.getRequirSVolNum();
        }
        this.changeLabel(ALL_NAME, this.tortalRequireNum);
        this.setSelection(ALL_NAME);
    }

    public void addSVOL(List<Long> capList) {
        String strCap = this.getStrCapacity(capList);
        this.changeSet.add(strCap);
        copacityInfo capInfo = this.capacityMap.get(strCap);
        capInfo.addSVOL();
        --this.tortalRequireNum;
    }

    public void removeSVOL(List<Long> capList) {
        String strCap = this.getStrCapacity(capList);
        this.changeSet.add(strCap);
        copacityInfo capInfo = this.capacityMap.get(strCap);
        capInfo.removeSVOL();
        ++this.tortalRequireNum;
    }

    public void refLDEVCapacity() {
        for (String strCap : this.changeSet) {
            copacityInfo capInfo = this.capacityMap.get(strCap);
            int requirSVolNum = capInfo.getRequirSVolNum();
            this.changeLabel(strCap, requirSVolNum);
        }
        this.changeLabel(ALL_NAME, this.tortalRequireNum);
        this.setDirty();
        this.changeSet.clear();
    }

    private String getStrCapacity(List<Long> capList) {
        String strCapacity = "";
        long tortalCap = 0L;
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        for (Long cap : capList) {
            tortalCap += cap.longValue();
        }
        SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(tortalCap);
        strCapacity = capaUtil.toString(tortalCap, unit);
        strCapacity = strCapacity + unit.toString();
        if (capList.size() > 1) {
            strCapacity = strCapacity + "(" + this.comUtil.getGuidance("LUSE") + ")";
        }
        return strCapacity;
    }

    public List<List<Long>> getCapacityList(String name) {
        copacityInfo capInfo = this.capacityMap.get(name);
        List<List<Long>> retList = capInfo.getCapacityList();
        return retList;
    }

    private String createDispLabel(String name, int requireSVolNum) {
        String label = name;
        if (requireSVolNum > 0) {
            label = label + " - " + this.comUtil.getGuidance("REMAINING") + ": " + Integer.toString(requireSVolNum);
        }
        return label;
    }

    public void changeLabel(String name, int requireSVolNum) {
        HashMap<String, Object> item = this.getItem(name);
        if (item != null) {
            String setName = "";
            setName = name.equals(ALL_NAME) ? this.comUtil.getGuidance(ALL_NAME) : name;
            String label = this.createDispLabel(setName, requireSVolNum);
            item.put("label", label);
        }
    }

    public int getTortalRequireNum() {
        return this.tortalRequireNum;
    }

    public void initListener() {
        if (this.itemSelectListener == null) {
            this.itemSelectListener = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect()) {
                        SJctrLDEVCapacityDataModel.this.fireMessageEvent(SJctrSelectSecondaryVolsDC.SELECTSVOL_MSG.CHG_LDEVCAP);
                    }
                }
            };
            this.addItemSelectListener(this.itemSelectListener);
        }
    }

    public class copacityInfo {
        private int requirSVolNum = 0;
        private List<List<Long>> capList = null;

        public copacityInfo(int requirSVolNum, List<Long> luseCapList) {
            this.requirSVolNum = requirSVolNum;
            this.capList = new ArrayList<List<Long>>();
            this.capList.add(luseCapList);
        }

        public void addCopacityInfo(int requirSVolNum, List<Long> luseCapList) {
            this.requirSVolNum += requirSVolNum;
            this.capList.add(luseCapList);
        }

        public int getRequirSVolNum() {
            return this.requirSVolNum;
        }

        public void addSVOL() {
            --this.requirSVolNum;
        }

        public void removeSVOL() {
            ++this.requirSVolNum;
        }

        public List<List<Long>> getCapacityList() {
            return this.capList;
        }
    }
}

