/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrLdevCapacityColumnFromPortLunDetail
extends SJctrCapacityColumn {
    protected SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
    protected Map<Integer, SJmoLdevDetail> ldevDtlMap = Collections.emptyMap();

    public SJctrLdevCapacityColumnFromPortLunDetail(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoLdevDetail> list = new ArrayList<SJmoLdevDetail>();
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)index;
        this.ldevIndex.setLdevIndex(luPathInfo.getSLDKC(), luPathInfo.getSCU(), luPathInfo.getSLDEV());
        SJmoLdevDetail ldevDtl = this.getLdevDetailInfo(this.ldevIndex, modelData);
        if (this.ldevDtlMap.isEmpty()) {
            this.ldevDtlMap = new HashMap<Integer, SJmoLdevDetail>(this.getTable().getRowCount());
        }
        this.ldevDtlMap.put(SJctrReplicationUtility.getLdevIndexKey(luPathInfo), ldevDtl);
        list.add(ldevDtl);
        return list;
    }

    protected SJmoLdevDetail getLdevDetailInfo(SJmoLdevIndex ldevIndex, Map<Class<?>, List<?>> modelData) {
        SJmoLdevDetail ldevDtl = null;
        List<?> ldevDtlList = modelData.get(SJmoGetLdevDetail.class);
        int searchLdev = Collections.binarySearch(ldevDtlList, ldevIndex);
        if (searchLdev >= 0) {
            ldevDtl = (SJmoLdevDetail)ldevDtlList.get(searchLdev);
        }
        return ldevDtl;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        if (!dataList.isEmpty()) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)dataList.get(0);
            if (ldevDetail == null) {
                return "?";
            }
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = select.length() == 0 ? SJctrCapacityUtility.UNIT.GB : SJctrCapacityUtility.UNIT.valueOf(select);
            SJctrCapacityUtility util = this.getTable().getComUtility().getCapacityUtility();
            StringBuilder buf = new StringBuilder(util.toString(ldevDetail.getLLDEVLBASize(), unit, ldevDetail.getIEmulationType()));
            buf.append(" ");
            buf.append(util.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long capacity = 0L;
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)this.getPrimaryKeyObject(dat);
        SJmoLdevDetail ldevDtl = this.ldevDtlMap.get(SJctrReplicationUtility.getLdevIndexKey(luPathInfo));
        if (ldevDtl != null) {
            capacity = ldevDtl.getLLDEVLBASize();
        }
        return capacity;
    }
}

