/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.reservectgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrCTGInfo;
import sanproject.sn2.controller.wizard.replication.local.reservectgs.SJctrReserveConsistencyGroupsConfirmData;
import sanproject.sn2.controller.wizard.replication.local.reservectgs.SJctrReserveConsistencyGroupsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationConsistencyGroupInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationConsistencyGroupInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationConsistencyGroupInfoMgr;

public class SJctrReserveConsistencyGroupsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830721;
    private static final String DISP_TITLE = "RESERVE_CTG";
    private static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE_CTG";
    private static final String KEY_TABLE_SELECT = "COM_TABLE_SELECT_CTG";
    protected static final String KEY_ADD = "COM_ADD";
    protected static final String KEY_REMOVE = "COM_REMOVE";

    public SJctrReserveConsistencyGroupsDC() {
        super(17830721);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrReserveConsistencyGroupsTableModel());
        SJctrReserveConsistencyGroupsTableModel selectedTable = new SJctrReserveConsistencyGroupsTableModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECT, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReserveConsistencyGroupsDC.this.fireMessageEvent(RSV_CTG_MSG.SELECT_ADD);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReserveConsistencyGroupsDC.this.fireMessageEvent(RSV_CTG_MSG.SELECT_REMOVE);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetLocalReplicationConsistencyGroupInfoMgr kind = new SJmoGetLocalReplicationConsistencyGroupInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoLocalReplicationConsistencyGroupInfo[] ctgInfoList;
            ArrayList<SJctrCTGInfo> tableDataList = new ArrayList<SJctrCTGInfo>();
            SJmoLocalReplicationConsistencyGroupInfoMgr ctgRowData = SJctrReplicationUtility.getSJmoLocalReplicationConsistencyGroupInfoMgr(this);
            for (SJmoLocalReplicationConsistencyGroupInfo ctgInfo : ctgInfoList = ctgRowData.getLocalReplicationCtgInfoList()) {
                boolean status;
                int ctgid;
                if (null == ctgInfo || 128 <= (ctgid = ctgInfo.getICtgId()) || (status = ctgInfo.isCtgStatus((short)128))) continue;
                SJctrCTGInfo rowData = new SJctrCTGInfo(ctgInfo);
                tableDataList.add(rowData);
            }
            if (tableDataList.size() == 0) {
                this.logUty.putlog("checkConstructData", "There is no CTG that can reserve.");
                SJctrError err = new SJctrError(209, 22, 106149);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrReserveConsistencyGroupsTableModel ctgsTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
            ctgsTable.setBasicDataList(tableDataList);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrReserveConsistencyGroupsConfirmData confirmData = new SJctrReserveConsistencyGroupsConfirmData();
            SJctrReserveConsistencyGroupsTableModel selectedCTGsTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
            List<Object> selectedList = selectedCTGsTable.getAllRowData();
            Collections.sort(selectedList);
            confirmData.setCTGsInfo(selectedList);
            ArrayList<SJctrReserveConsistencyGroupsConfirmData> confirmDataList = new ArrayList<SJctrReserveConsistencyGroupsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrReserveConsistencyGroupsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    protected void initListener() {
        this.addMessageEventListener(RSV_CTG_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReserveConsistencyGroupsDC.this.addAction(event, dstModel);
            }
        });
        this.addMessageEventListener(RSV_CTG_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrReserveConsistencyGroupsDC.this.removeAction(event, dstModel);
            }
        });
    }

    protected void addAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrReserveConsistencyGroupsTableModel availableTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> addData = availableTable.removeSelectedRowData();
        SJctrReserveConsistencyGroupsTableModel selectedTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
        selectedTable.addRowDataTop(addData);
        this.updateFooter();
        this.setDirtyAll();
    }

    protected void removeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrReserveConsistencyGroupsTableModel selectedTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SELECT);
        List<Object> removeData = selectedTable.removeSelectedRowData();
        SJctrReserveConsistencyGroupsTableModel availableTable = (SJctrReserveConsistencyGroupsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        availableTable.addRowDataTop(removeData);
        this.updateFooter();
        this.setDirtyAll();
    }

    public static enum RSV_CTG_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE;

    }
}

