/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.resyncpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.local.resyncpairs.SJctrResyncPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.local.resyncpairs.SJctrResyncPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830689;
    private static final String DISP_TITLE = "RESYNC_PAIRS";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_RESYNCTYPE_COMBO = "COM_RESYNCTYPE";
    private static final String KEY_COPYPACE_COMBO = "COM_COPYPACE";
    private static final String KEY_COM_WAR_INFO = "COM_WAR_INFO";
    private static final String KEY_COM_WAR_CROSS_OVER_INFO = "COM_CLPR_QR";
    private static final int CLPR_CROSS_OVER = 1;
    private static final int CLPR_CROSS_NOT_OVER = 0;

    public SJctrResyncPairsDC() {
        super(17830689);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrResyncPairsTableModel());
        SJctrComboBoxDataModel comboObjRs = new SJctrComboBoxDataModel();
        comboObjRs.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResyncPairsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addDataObjectModel(KEY_RESYNCTYPE_COMBO, comboObjRs);
        SJctrComboBoxDataModel comboObjCp = new SJctrComboBoxDataModel();
        comboObjCp.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResyncPairsDC.this.setFinishChangeCheck(true);
            }
        });
        this.addDataObjectModel(KEY_COPYPACE_COMBO, comboObjCp);
        this.addDataObjectModel(KEY_COM_WAR_INFO, new SJctrSimpleDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotSetInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_SVOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoLocalReplicationPairVolInfoMgr allPairInfo = SJctrReplicationUtility.getSJmoLocalReplicationPairVolInfoMgr(this);
            List<SJmoLocalReplicationPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_SVOL");
            SJctrReplicationUtility.chkCacheLReplicaDetailData(this);
            List<SJmoLocalReplicationPairVolInfo> pairExist = this.checkExistPairVol(viewData, allPairInfo, this);
            int copytype = this.checkCopyTypeForLocalPairVol(pairExist);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            int checkSimfPair = -1;
            if (copytype == 0) {
                checkSimfPair = SJctrReplicationUtility.checkSimfPairMixFiconAndNormal(pairExist, ldevDetailList);
            }
            SJctrReplicationUtility.checkPpLicenseForLocalPairVolList(this.getOwner(), copytype);
            int pairStatusChkResult = this.checkPairStatusAndAbleResync(pairExist, allPairInfo, copytype);
            boolean reverseflg = true;
            boolean quickResultflg = true;
            if (1 == (pairStatusChkResult & 1)) {
                reverseflg = false;
                quickResultflg = false;
            }
            if (reverseflg && 2 == (pairStatusChkResult & 2)) {
                quickResultflg = false;
            }
            int clpr = 0;
            if (4 == (pairStatusChkResult & 4)) {
                clpr = 1;
            }
            SJctrSimpleDataModel warinfo = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_COM_WAR_INFO);
            ((SJctrDataObject)warinfo.getManageData()).setData(KEY_COM_WAR_CROSS_OVER_INFO, clpr);
            Collections.sort(pairExist, new SJctrLocalPairInfoComparator());
            this.setAvailableTableData(pairExist);
            SJctrComboBoxDataModel comboObjRs = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_RESYNCTYPE_COMBO);
            this.createResyncTypeComboBox(comboObjRs, copytype, reverseflg, quickResultflg, checkSimfPair);
            SJctrComboBoxDataModel comboObjCp = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYPACE_COMBO);
            this.createCopyPaceComboBox(comboObjCp, copytype);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    public List<SJmoLocalReplicationPairVolInfo> checkExistPairVol(List<SJmoLocalReplicationPairVolInfo> viewData, SJmoLocalReplicationPairVolInfoMgr allPairInfo, SJctrWizardDataController dc) {
        return SJctrReplicationUtility.checkAndGetExistPairVolInfo(viewData, allPairInfo);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrResyncPairsConfirmData confirmData = new SJctrResyncPairsConfirmData();
            SJctrComboBoxDataModel selectedResyncTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_RESYNCTYPE_COMBO);
            String strResyncType = selectedResyncTypeCombo.getSelection();
            SJctrComboBoxDataModel selectedCopyPaceCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYPACE_COMBO);
            String strCopyPace = selectedCopyPaceCombo.getSelection();
            SJctrResyncPairsTableModel selectedPairsTable = (SJctrResyncPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = selectedPairsTable.getAllRowData();
            int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVol((SJmoLocalReplicationPairVolInfo)selectedList.get(0));
            confirmData.setCopytype((short)copytype);
            short copypace = this.comvCopyPace(strCopyPace);
            for (SJmoLocalReplicationPairVolInfo sJmoLocalReplicationPairVolInfo : selectedList) {
                sJmoLocalReplicationPairVolInfo.setSCopyPace(copypace);
            }
            confirmData.setCopypace(copypace);
            confirmData.setResynctype(this.comvResyncType(strResyncType, copytype));
            confirmData.setPairsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrResyncPairsConfirmData> confirmDataList = new ArrayList<SJctrResyncPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrResyncPairsConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void createResyncTypeComboBox(SJctrComboBoxDataModel comboObj, int copytype, boolean statusflg, boolean qrflg, int checkSimfPair) {
        if (null == comboObj) {
            this.logUty.putlog("createResyncTypeComboBox", "ComboBox object is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == copytype || 1 == copytype) {
            if (4 == checkSimfPair) {
                comboObj.addItem("MIGRATION_PRIMARY_SECONDARY", this.getComUtility().getGuidance("MIGRATION_PRIMARY_SECONDARY"));
                comboObj.setSelection("MIGRATION_PRIMARY_SECONDARY");
                comboObj.setEnable(true);
            } else {
                if (statusflg) {
                    comboObj.addItem("NORMAL_COPY_PR_SC", this.getComUtility().getGuidance("NORMAL_COPY_PR_SC"));
                    comboObj.addItem("NORMAL_COPY_SC_PR", this.getComUtility().getGuidance("NORMAL_COPY_SC_PR"));
                    comboObj.addItem("QUICK_RESYNC_PR_SC", this.getComUtility().getGuidance("QUICK_RESYNC_PR_SC"));
                    if (qrflg) {
                        comboObj.addItem("QUICK_RESYNC_SC_PR", this.getComUtility().getGuidance("QUICK_RESYNC_SC_PR"));
                    }
                } else {
                    comboObj.addItem("NORMAL_COPY_PR_SC", this.getComUtility().getGuidance("NORMAL_COPY_PR_SC"));
                    comboObj.addItem("QUICK_RESYNC_PR_SC", this.getComUtility().getGuidance("QUICK_RESYNC_PR_SC"));
                }
                comboObj.setSelection("NORMAL_COPY_PR_SC");
                comboObj.setEnable(true);
            }
        } else if (2 == copytype || 3 == copytype) {
            if (statusflg) {
                comboObj.addItem("NORMAL_COPY_PR_SC", this.getComUtility().getGuidance("NORMAL_COPY_PR_SC"));
                comboObj.addItem("NORMAL_COPY_SC_PR", this.getComUtility().getGuidance("NORMAL_COPY_SC_PR"));
            } else {
                comboObj.addItem("NORMAL_COPY_PR_SC", this.getComUtility().getGuidance("NORMAL_COPY_PR_SC"));
            }
            comboObj.setSelection("NORMAL_COPY_PR_SC");
            comboObj.setEnable(true);
        } else {
            this.logUty.putlog("createResyncTypeComboBox", "Copy Type is invalid.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void createCopyPaceComboBox(SJctrComboBoxDataModel comboObj, int copytype) {
        if (null == comboObj) {
            this.logUty.putlog("createCopyPaceComboBox", "ComboBox object is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == copytype || 1 == copytype) {
            comboObj.addItem("FASTER_CP", this.getComUtility().getGuidance("FASTER_CP"));
            comboObj.addItem("MEDIUM_CP", this.getComUtility().getGuidance("MEDIUM_CP"));
            comboObj.addItem("LOWER_CP", this.getComUtility().getGuidance("LOWER_CP"));
            comboObj.setSelection("MEDIUM_CP");
            comboObj.setEnable(true);
        } else if (2 == copytype || 3 == copytype) {
            comboObj.addItem("BAR", this.getComUtility().getGuidance("BAR"));
            comboObj.setSelection("BAR");
            comboObj.setEnable(false);
        } else {
            this.logUty.putlog("createCopyPaceComboBox", "Copy Type is invalid.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private short comvResyncType(String strResync, int copytype) {
        int rtnResync = -1;
        if (null != strResync) {
            if (0 == copytype || 1 == copytype) {
                if (strResync.equals("NORMAL_COPY_PR_SC")) {
                    rtnResync = 0;
                } else if (strResync.equals("NORMAL_COPY_SC_PR")) {
                    rtnResync = 1;
                } else if (strResync.equals("QUICK_RESYNC_PR_SC")) {
                    rtnResync = 64;
                } else if (strResync.equals("QUICK_RESYNC_SC_PR")) {
                    rtnResync = 129;
                } else if (strResync.equals("MIGRATION_PRIMARY_SECONDARY")) {
                    rtnResync = -1;
                }
            } else if (2 == copytype || 3 == copytype) {
                if (strResync.equals("NORMAL_COPY_PR_SC")) {
                    rtnResync = 3;
                } else if (strResync.equals("NORMAL_COPY_SC_PR")) {
                    rtnResync = 4;
                }
            } else {
                this.logUty.putlog("comvResyncType", "Copy Type is invalid.");
            }
        }
        return (short)rtnResync;
    }

    protected short comvCopyPace(String strcopypace) {
        int rtncopy = -1;
        if (null != strcopypace) {
            if (strcopypace.equals("MEDIUM_CP")) {
                rtncopy = 0;
            } else if (strcopypace.equals("LOWER_CP")) {
                rtncopy = 1;
            } else if (strcopypace.equals("FASTER_CP")) {
                rtncopy = 2;
            }
        }
        return (short)rtncopy;
    }

    private void setAvailableTableData(List<SJmoLocalReplicationPairVolInfo> pairInfo) {
        SJctrResyncPairsTableModel ResyncTable = (SJctrResyncPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        ResyncTable.setBasicDataList(pairInfo);
    }

    private int checkCopyTypeForLocalPairVol(List<SJmoLocalReplicationPairVolInfo> pairExist) {
        if (null == pairExist) {
            this.logUty.putlog("checkCopyTypeForLocalPairVol", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVolList(pairExist);
        if (-1 == copytype) {
            this.logUty.putlog("checkCopyTypeForLocalPairVol", "Selected pair is mix.");
            SJctrError err = new SJctrError(209, 22, 106114);
            SJcException exp = err.createException();
            throw exp;
        }
        return copytype;
    }

    protected int checkPairStatusAndAbleResync(List<SJmoLocalReplicationPairVolInfo> pairExist, SJmoLocalReplicationPairVolInfoMgr allPairVolInfo, int copytype) {
        if (null == pairExist || null == allPairVolInfo) {
            this.logUty.putlog("checkPairStatus", "Pair info is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoLdevDetail> ldevinfolist = SJctrReplicationUtility.getSJmoLdevDetail(this);
        int ret = SJctrReplicationUtility.checkLocalPairVolStatusResync(pairExist, allPairVolInfo, ldevinfolist, copytype);
        return ret;
    }
}

