/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addjournals.com;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.com.SJctrExctgJnlGrpMapKeyComparator;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrExctgStorageSystemUtility {
    public static final int EXCTG_JNL_MAP_STORAGE_KEY_SIZE = 2;

    public static Map getExctgJnlGrpModelMap(List<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlGrpList) {
        if (exctgJnlGrpList == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getEXCTGJnlGrpModelMap", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashMap map = new HashMap();
        for (SJmoUniversalReplicatorEXCTGJnlGrp exctgJnlGrp : exctgJnlGrpList) {
            ArrayList<Object> key = new ArrayList<Object>(2);
            key.add(exctgJnlGrp.getModelId());
            int sn = Integer.parseInt(exctgJnlGrp.getSN());
            key.add(String.valueOf(sn));
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> entryJnlList = (ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp>)map.get(key);
            if (entryJnlList == null) {
                entryJnlList = new ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp>();
                map.put(key, entryJnlList);
            }
            entryJnlList.add(exctgJnlGrp);
        }
        return map;
    }

    public static List[] getSortedExctgJnlGrpMapKeysList(Map map, SJmoSubsystemInfo subsysInfo, SJctrComUtility comUtil) {
        if (map == null || subsysInfo == null || comUtil == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSortedEXCTGJnlGrpMapKeysList", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List localKeyList = SJctrExctgStorageSystemUtility.createExctgJnlGrpMapLocalKey(subsysInfo, comUtil.getRemoteReplicationUtility());
        return SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(map, localKeyList);
    }

    public static List[] getSortedExctgJnlGrpMapKeysList(Map map, List localKeyList) {
        if (map == null || localKeyList == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "getSortedEXCTGJnlGrpMapKeysList", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        Set keys = map.keySet();
        List[] keyList = keys.toArray(new List[0]);
        if (map.get(localKeyList) == null) {
            Arrays.sort(keyList, new SJctrExctgJnlGrpMapKeyComparator());
        } else {
            Arrays.sort(keyList, new SJctrExctgJnlGrpMapKeyComparator(localKeyList));
        }
        return keyList;
    }

    public static List createExctgJnlGrpMapLocalKey(SJmoSubsystemInfo subsysInfo, SJctrRemoteReplicationUtility remoteReplicaUty) {
        if (subsysInfo == null || remoteReplicaUty == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "createEXCTGJnlGrpMapLocalStorageKey", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<Object> localKey = new ArrayList<Object>(2);
        localKey.add(remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo));
        localKey.add(subsysInfo.getDKCSNString());
        return localKey;
    }

    public static List getKey(List[] keys, int index) {
        List key = null;
        if (keys.length > 0 && index >= 0 && index < keys.length) {
            key = keys[index];
        }
        return key;
    }

    public static List<SJmoUniversalReplicatorEXCTGJnlGrp> checkAndGetSJmoUniversalReplicatorExctgJnlGrp(List<SJmoUniversalReplicatorEXCTGJnlGrp> localJnlList, SJctrDataController dc) {
        if (localJnlList == null || dc == null) {
            SJctrLogUty.error(SJctrRemoteReplicationUtility.class.getSimpleName(), "checkAndGetSJmoUniversalReplicatorEXCTGJnlGrp", "Arguments are invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> enableLocalJnlList = new ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp>();
        SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc);
        SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(dc);
        for (SJmoUniversalReplicatorEXCTGJnlGrp localJnl : localJnlList) {
            SJmoUniversalReplicatorJnlGrp modelJnlGrp = allJnlInfo.getJnlGroup(localJnl.getJnlGrpId());
            if (modelJnlGrp != null) {
                if (!SJctrRemoteReplicationUtility.hasTopJnlVolRs(modelJnlGrp, rsgUty)) continue;
                enableLocalJnlList.add(localJnl);
                continue;
            }
            dc.getLogUty().putlog("checkAndGetSJmoUniversalReplicatorExctgJnlGrp", "Journal data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206510);
        }
        return enableLocalJnlList;
    }

    public static int getSerialNumberDigitNumber(int modelId) {
        int digit;
        switch (modelId) {
            case 5: 
            case 6: 
            case 7: {
                digit = 5;
                break;
            }
            case 19: {
                digit = 6;
                break;
            }
            default: {
                digit = 5;
            }
        }
        return digit;
    }

    public static enum StorageSystemInfo {
        COM_STORAGE_SYSTEM_INFO1(0),
        COM_STORAGE_SYSTEM_INFO2(1),
        COM_STORAGE_SYSTEM_INFO3(2),
        COM_STORAGE_SYSTEM_INFO4(3);

        private int index;

        private StorageSystemInfo(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

