/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addremoteconn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.SJctrAddRemoteConnectionConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfoComparator;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteSSIDDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrAddRemoteConnectionDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16798465;
    private static final String DISP_TITLE = "ADD_REMOTE_CONN";
    private static final String KEY_SELECT_INDEX_MODEL = "COM_SELECT_INDEX_MODEL";
    private static final String KEY_SELECT_INDEX = "COM_SELECT_INDEX";
    private static final String KEY_EVENT_TYPE = "COM_EVENT_TYPE";
    private static final int EVENT_REMOVESSID = 1;
    private static final int EVENT_REMOVEPATH = 2;
    private static final String KEY_MODEL_NAME_CHANGE_EVENT = "COM_MODEL_NAME_CHANGE_EVENT";
    private static final String KEY_SELECTED_MODEL_ID = "COM_SELECTED_MODEL_ID";
    private static final String KEY_SELECTED_CONN_TYPE = "COM_SELECTED_CONN_TYPE";
    private static final String KEY_AVA_LOCAL_CU_LIST = "COM_AVA_LOCAL_CU_LIST";
    private static final String KEY_REMOTE_MODEL_NAME_LIST = "COM_REMOTE_MODEL_NAME_LIST";
    protected static final int FREEZE_OPT = 0;
    private static final int MODEL_NAME_MAP_ID = 0;
    private static final int MODEL_NAME_MAP_NAME = 1;
    private static final int INITIAL_SSID_TEXTBOX_COUNT = 1;
    private static final int INITIAL_PORTID_AREA_COUNT = 2;

    public SJctrAddRemoteConnectionDC() {
        super(16798465);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrRadioButtonGroupDataModel connTypeRadio = new SJctrRadioButtonGroupDataModel();
        connTypeRadio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                    SJctrAddRemoteConnectionDC.this.fireMessageEvent(ADD_REMOTE_CONN_MSG.CHANGED_RADIO_CONN_TYPE);
                }
            }
        });
        this.addDataObjectModel("COM_CONNECT_TYPE", connTypeRadio);
        connTypeRadio.add("COM_CONNECT_TYPE_SYS");
        connTypeRadio.add("COM_CONNECT_TYPE_CU");
        SJctrLocalStorageSysDataModel localSysModel = new SJctrLocalStorageSysDataModel();
        this.addDataObjectModel("COM_LOCAL_STORAGE_SYS_PANEL", localSysModel);
        SJctrRemoteStorageSysDataModel remoteSysModel = new SJctrRemoteStorageSysDataModel();
        this.addDataObjectModel("COM_REMOTE_STORAGE_SYS_PANEL", remoteSysModel);
        SJctrRemotePathDataModel remotePathModel = new SJctrRemotePathDataModel();
        this.addDataObjectModel("COM_REMOTE_PATHS_PANEL", remotePathModel);
        SJctrTextBoxDataModel rioMIHTimeText = new SJctrTextBoxDataModel();
        rioMIHTimeText.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_RIO_MIH_TIME", rioMIHTimeText);
        SJctrTextBoxDataModel roudTripTimeText = new SJctrTextBoxDataModel();
        roudTripTimeText.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_ROUND_TRIP_TIME", roudTripTimeText);
        SJctrRadioButtonGroupDataModel freezeOptRadio = new SJctrRadioButtonGroupDataModel();
        freezeOptRadio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_FREEZE_OPTION", freezeOptRadio);
        freezeOptRadio.add("COM_ENABLE");
        freezeOptRadio.add("COM_DISABLE");
        SJctrSimpleDataModel selectIndexModel = new SJctrSimpleDataModel();
        selectIndexModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer eventType;
                if (setObject instanceof SJctrDataObject && (eventType = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrAddRemoteConnectionDC.KEY_EVENT_TYPE)) != null) {
                    int event = eventType;
                    Integer index = (Integer)data.getData(SJctrAddRemoteConnectionDC.KEY_SELECT_INDEX);
                    if (index != null) {
                        SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)SJctrAddRemoteConnectionDC.this.getDataObjectModel(SJctrAddRemoteConnectionDC.KEY_SELECT_INDEX_MODEL);
                        ((SJctrDataObject)selectIndexModel.getManageData()).setData(SJctrAddRemoteConnectionDC.KEY_SELECT_INDEX, index);
                        switch (event) {
                            case 1: {
                                SJctrAddRemoteConnectionDC.this.fireMessageEvent(ADD_REMOTE_CONN_MSG.PUSH_REMOVE_SSID);
                                break;
                            }
                            case 2: {
                                SJctrAddRemoteConnectionDC.this.fireMessageEvent(ADD_REMOTE_CONN_MSG.PUSH_REMOVE_PATH);
                                break;
                            }
                            default: {
                                SJctrAddRemoteConnectionDC.this.logUty.putlog("initDataModel", "event type is unknown");
                            }
                        }
                    }
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_INDEX_MODEL, selectIndexModel);
        SJctrSimpleDataModel chgModelNameEve = new SJctrSimpleDataModel();
        chgModelNameEve.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrAddRemoteConnectionDC.this.fireMessageEvent(ADD_REMOTE_CONN_MSG.SELECT_REMOTE_MODEL);
            }
        });
        this.addDataObjectModel(KEY_MODEL_NAME_CHANGE_EVENT, chgModelNameEve);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_REMOTE_CONN_MSG.CHANGED_RADIO_CONN_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.chgConnectionTypeAction(event, dstModel);
            }
        });
        this.addMessageEventListener(ADD_REMOTE_CONN_MSG.SELECT_REMOTE_MODEL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.chgModelAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(ADD_REMOTE_CONN_MSG.PUSH_REMOVE_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                SJctrAddRemoteConnectionDC.this.removeSSIDAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemoteStorageSysDataModel.REMOTE_SYS_MSG.PUSH_ADD_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.addSSIDAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.CAHNGE_MIN_NUM_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.chgMinNumberPathAction(event, dstModel);
            }
        });
        this.addMessageEventListener(ADD_REMOTE_CONN_MSG.PUSH_REMOVE_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                SJctrAddRemoteConnectionDC.this.removeRemotePathAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.PUSH_ADD_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.addPathAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.CHANGED_RADIO_SELECT_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemoteConnectionDC.this.chgSelectTypeAction(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            this.disableEventListner();
            List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoPortAttributeInfo> portAtrInfoList = SJctrRemoteReplicationUtility.getSJmoPortAttributeInfo(this);
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgInfoList);
            List<SJmoLdevDetail> allLdev = SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
            SJmoRemoteReplicationMRCUInfo[] mrcuInfoList = mrcuInfoMgr.getMRCUInfoList();
            SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = mrcuInfoMgr.getMRCUFreeInfo();
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
            SJctrRadioButtonGroupDataModel connTypeRadio = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
            connTypeRadio.setSelect("COM_CONNECT_TYPE_SYS");
            if (this.checkSystemConnectionMAXCount(mrcuFreeInfo.getTrueCopyRCUInfoList())) {
                connTypeRadio.setEnable("COM_CONNECT_TYPE_SYS", false);
                connTypeRadio.setSelect("COM_CONNECT_TYPE_CU");
            }
            if (this.checkCUConnectionMAXCount(mrcuInfoList)) {
                connTypeRadio.setEnable("COM_CONNECT_TYPE_CU", false);
            }
            if (!connTypeRadio.isEnable("COM_CONNECT_TYPE_SYS") && !connTypeRadio.isEnable("COM_CONNECT_TYPE_CU")) {
                this.logUty.putlog("checkConstructData", "System Connection and CU Connection is Maximum.");
                SJctrError err = new SJctrError(210, 22, 206019);
                SJcException exp = err.createException();
                throw exp;
            }
            List<String> localCUList = this.createLocalCUList(mrcuInfoList, allLdev);
            if (0 == localCUList.size()) {
                connTypeRadio.setEnable("COM_CONNECT_TYPE_CU", false);
                if (!connTypeRadio.isEnable("COM_CONNECT_TYPE_SYS")) {
                    this.logUty.putlog("checkConstructData", "System Connection is Maximum, and no available Local CU.");
                    SJctrError err = new SJctrError(210, 22, 206020);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            this.putCache(KEY_AVA_LOCAL_CU_LIST, localCUList);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
            List<SJmoPortDetail> localPortIDList = SJctrRemoteReplicationUtility.createLocalPortIDList(portDtlList, portAtrInfoList, rsgUtil);
            if (0 == localPortIDList.size()) {
                this.logUty.putlog("checkConstructData", "No available Local PortID.");
                SJctrError err = new SJctrError(210, 22, 206021);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoPortDetail> localPortFibreKindList = SJctrRemoteReplicationUtility.getTargetKindPortDetailList(localPortIDList, SJctrRemoteReplicationDataMacro.FIBRE_PORT_KIND);
            List<SJmoPortDetail> localPortIscsiKindList = SJctrRemoteReplicationUtility.getTargetKindPortDetailList(localPortIDList, SJctrRemoteReplicationDataMacro.ISCSI_PORT_KIND);
            this.putCache("COM_AVA_LOCAL_PORT_ID_LIST", localPortFibreKindList);
            this.putCache("COM_AVA_LOCAL_ISCSI_PORT_ID_LIST", localPortIscsiKindList);
            int connType = this.convConnectType(connTypeRadio.getSelect());
            if (connType == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            this.getManageData().setData(KEY_SELECTED_CONN_TYPE, connType);
            SJctrLocalStorageSysDataModel localSysModel = SJctrRemoteConnectionUtility.getLocalStorageSysModel(this);
            int localModelID = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
            ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_MODEL", this.getOwner().getProductName());
            ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_SERIAL_NO", subsysInfo.getDKCSNString());
            SJctrComboBoxDataModel localCUPulldown = SJctrRemoteConnectionUtility.getLocalCUPullDownModel(this);
            this.createLocalCUPulldownList(localCUPulldown, localCUList, connType);
            this.createRemoteModelComboBox(localModelID, connType);
            this.createRemoteSysAndPathModel(localModelID, connType);
            this.initOptionsPanel(connType);
            this.enableEventListner();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
            SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            SJctrRadioButtonGroupDataModel connTypeRadio = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
            int conType = this.convConnectType(connTypeRadio.getSelect());
            if (conType == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            int localCU = -1;
            int remoteCU = -1;
            int[] ssid = new int[4];
            int pathGrp = 0;
            short ldkc = 0;
            int ssidCount = 0;
            if (conType == 0) {
                SJctrComboBoxDataModel localCUPulldown = SJctrRemoteConnectionUtility.getLocalCUPullDownModel(this);
                try {
                    localCU = Integer.parseInt(localCUPulldown.getSelection(), 16);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("checkEndData", "The error occurred at the Local CU getting. NumberFormatException : " + ne.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
                SJctrTextBoxDataModel remoteCUTextBox = SJctrRemoteConnectionUtility.getRemoteCUTextModel(this);
                try {
                    remoteCU = Integer.parseInt(remoteCUTextBox.getValue(), 16);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("checkEndData", "The error occurred at the Remote CU getting. NumberFormatException : " + ne.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
                ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
                ssid = SJctrRemoteConnectionUtility.getSSIDListFromWizard(this);
            } else {
                SJctrComboBoxDataModel pathGrpPulldown = SJctrRemoteConnectionUtility.getPathGroupIDPullDownModel(this);
                try {
                    pathGrp = Integer.parseInt(pathGrpPulldown.getSelection(), 16);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("checkEndData", "The error occurred at the PathGroupID getting. NumberFormatException : " + ne.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
            }
            SJctrTextBoxDataModel remoteModelText = SJctrRemoteConnectionUtility.getRemoteModelTextModel(this);
            String modelName = remoteModelText.getValue();
            int remoteModelID = this.getRemoteModelID(modelName);
            if (remoteModelID == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            SJctrTextBoxDataModel snTextBox = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
            String sn = snTextBox.getValue();
            sn = this.toPaddingZeroSerialNumber(remoteModelID, sn);
            SJctrComboBoxDataModel minPathPulldown = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
            int minPath = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(minPathPulldown);
            int[] enableLineArray = new int[8];
            int[][] portID = new int[8][2];
            int portIDCount = 0;
            for (int pid = 0; pid < 8; ++pid) {
                SJctrComboBoxDataModel localPortIDModel = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, pid);
                SJctrComboBoxDataModel remotePortIDModel = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, pid);
                if (localPortIDModel.getSelectedIndex() == -1 || remotePortIDModel.getSelectedIndex() == -1 || localPortIDModel.getSelectedIndex() == 0 || remotePortIDModel.getSelectedIndex() == 0) continue;
                portID[++portIDCount - 1][0] = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortIDModel);
                portID[portIDCount - 1][1] = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel);
                enableLineArray[portIDCount - 1] = pid;
            }
            SJctrTextBoxDataModel rioMIHTimeText = SJctrRemoteConnectionUtility.getRioMihTimeTextModel(this);
            int rioMIHTime = 0;
            try {
                rioMIHTime = Integer.parseInt(rioMIHTimeText.getValue());
            }
            catch (NumberFormatException ne) {
                this.logUty.putlog("checkEndData", "The error occurred at the RIO MIH TIME getting. NumberFormatException : " + ne.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            SJctrTextBoxDataModel roundTripTimeText = SJctrRemoteConnectionUtility.getRoudTripTimeTextModel(this);
            int roundTripTime = 0;
            try {
                roundTripTime = Integer.parseInt(roundTripTimeText.getValue());
            }
            catch (NumberFormatException ne) {
                this.logUty.putlog("checkEndData", "The error occurred at the ROUND TRIP TIME getting. NumberFormatException : " + ne.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            SJctrRadioButtonGroupDataModel freezeOptRadio = SJctrRemoteConnectionUtility.getFreezeOptionRadio(this);
            int freezeOpt = -1;
            freezeOpt = conType == 1 ? 0 : this.convFreezeOption(freezeOptRadio.getSelect());
            if (freezeOpt == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            SJmoRemoteReplicationRCUInfo rcuInfo = new SJmoRemoteReplicationRCUInfo();
            ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>();
            SJmoRemoteReplicationRCUOptionInfo rCUOption = new SJmoRemoteReplicationRCUOptionInfo();
            rcuInfo.setICUFree(conType);
            rcuInfo.setSCu((short)remoteCU);
            rcuInfo.setIControllerID(remoteModelID);
            rcuInfo.setSCUNo((short)localCU);
            rcuInfo.setStrSN(sn);
            rcuInfo.setINumofSSID(ssidCount);
            rcuInfo.setISSID(ssid);
            rcuInfo.setIRCUID(pathGrp);
            rcuInfo.setSLdkc(ldkc);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            int selectType = remotePathModel.getSelectType();
            ArrayList<SJctrRemoteReplicationTargetPathInfo> targetPathInfoList = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
            for (int pid = 0; pid < portIDCount; ++pid) {
                SJmoRemoteReplicationRCUPathInfo pathInfo = new SJmoRemoteReplicationRCUPathInfo();
                pathInfo.setSPort((short)portID[pid][0]);
                pathInfo.setIRCUPortNo((short)portID[pid][1]);
                pathInfoList.add(pathInfo);
                SJctrRemoteReplicationTargetPathInfo remotePathInfo = this.createRemoteTargetPathInfo(portID[pid], enableLineArray[pid], selectType, this);
                if (selectType == 1) {
                    String name = SJctrRemoteConnectionUtility.createRemoteReplicationiScsiName(remoteModelID, portID[pid][1], sn, subsysInfo.getDKCSNString());
                    remotePathInfo.setStrTargetName(name);
                }
                targetPathInfoList.add(remotePathInfo);
            }
            Collections.sort(pathInfoList);
            Collections.sort(targetPathInfoList, new SJctrRemoteReplicationTargetPathInfoComparator());
            rCUOption.setINumofMimPath(minPath);
            rCUOption.setIRIOMIHTime(rioMIHTime);
            rCUOption.setIRtTime(roundTripTime);
            rCUOption.setIFreezeOption(freezeOpt);
            rcuInfo.setPathInfoList(pathInfoList);
            rcuInfo.setRCUOption(rCUOption);
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            SJctrAddRemoteConnectionConfirmData confirmData = new SJctrAddRemoteConnectionConfirmData();
            confirmData.setRCUInfo(rcuInfoList);
            confirmData.setRemotePathInfoList(targetPathInfoList);
            ArrayList<SJctrAddRemoteConnectionConfirmData> confirmDataList = new ArrayList<SJctrAddRemoteConnectionConfirmData>();
            confirmDataList.add(confirmData);
            confirmData.setNeedData(this);
            this.putCache(SJctrAddRemoteConnectionConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void chgConnectionTypeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            List<String> localCUList = this.getCache(KEY_AVA_LOCAL_CU_LIST);
            List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
            SJctrRadioButtonGroupDataModel connTypeRadio = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
            int connType = this.convConnectType(connTypeRadio.getSelect());
            if (connType == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            this.getManageData().setData(KEY_SELECTED_CONN_TYPE, connType);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
            SJctrComboBoxDataModel localCUPulldown = SJctrRemoteConnectionUtility.getLocalCUPullDownModel(this);
            int localModelID = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
            this.createLocalCUPulldownList(localCUPulldown, localCUList, connType);
            this.createRemoteModelComboBox(localModelID, connType);
            this.initRemoteSysAndPathModel(localModelID, connType);
            this.initOptionsPanel(connType);
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void chgModelAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            SJctrRadioButtonGroupDataModel connTypeRadio = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
            int connType = this.convConnectType(connTypeRadio.getSelect());
            if (connType == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            SJctrTextBoxDataModel remoteModelText = SJctrRemoteConnectionUtility.getRemoteModelTextModel(this);
            String modelName = remoteModelText.getValue();
            int remoteModelID = this.getRemoteModelID(modelName);
            if (remoteModelID == -1) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            this.getManageData().setData(KEY_SELECTED_MODEL_ID, remoteModelID);
            boolean dispMsg = this.isDispMsgDialogIscsiPortUnsupported(remoteModelID);
            if (!dispMsg) {
                this.initRemoteSysAndPathModel(remoteModelID, connType);
            }
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void removeSSIDAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
            Integer ssidIndex = (Integer)((SJctrDataObject)selectIndexModel.getManageData()).getData(KEY_SELECT_INDEX);
            if (ssidIndex == null) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            SJctrRemoteConnectionUtility.removeSSIDPanel(this, ssidIndex);
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void addSSIDAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            SJctrRemoteConnectionUtility.addSSIDPanel(this);
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void chgMinNumberPathAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
            SJctrComboBoxDataModel minimumPathCombo = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
            String minimumPathCountStr = SJctrComboBoxDataModel.Item.getLabel(minimumPathCombo.getItem(minimumPathCombo.getSelection()));
            int minimumPathCount = 0;
            try {
                minimumPathCount = Integer.parseInt(minimumPathCountStr);
            }
            catch (NumberFormatException ne) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            if (pathCount < minimumPathCount) {
                int addPathCount = minimumPathCount - pathCount;
                List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
                if (localPortIDList != null) {
                    int modelID = (Integer)this.getManageData().getData(KEY_SELECTED_MODEL_ID);
                    for (int addIndex = 0; addIndex < addPathCount; ++addIndex) {
                        SJctrRemoteConnectionUtility.addPathPanel(this, modelID, localPortIDList, this.getComUtility());
                    }
                } else {
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
                }
            }
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void removeRemotePathAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
            Integer pathIndex = (Integer)((SJctrDataObject)selectIndexModel.getManageData()).getData(KEY_SELECT_INDEX);
            if (pathIndex == null) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            SJctrRemoteConnectionUtility.removePathPanel(this, pathIndex);
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void addPathAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            this.disableEventListner();
            List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
            Integer modelID = (Integer)this.getManageData().getData(KEY_SELECTED_MODEL_ID);
            if (localPortIDList == null || modelID == null) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
            }
            SJctrRemoteConnectionUtility.addPathPanel(this, modelID, localPortIDList, this.getComUtility());
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private boolean checkSystemConnectionMAXCount(List<SJmoRemoteReplicationRCUInfo> rcuInfo) {
        boolean bSystem = false;
        if (64 <= rcuInfo.size()) {
            bSystem = true;
        }
        return bSystem;
    }

    private boolean checkCUConnectionMAXCount(SJmoRemoteReplicationMRCUInfo[] mrcuInfoList) {
        boolean bCU = false;
        int connCount = 0;
        for (SJmoRemoteReplicationMRCUInfo mrcuInfo : mrcuInfoList) {
            if (null == mrcuInfo) continue;
            connCount += mrcuInfo.getTrueCopyRCUInfoList().size();
        }
        if (1020 <= connCount) {
            bCU = true;
        }
        return bCU;
    }

    private List<String> createLocalCUList(SJmoRemoteReplicationMRCUInfo[] mrcuInfoList, List<SJmoLdevDetail> allLdev) {
        ArrayList<String> localCUList = new ArrayList<String>();
        List<Short> cuList = SJctrRemoteReplicationUtility.getMFLDEVExistCuList(allLdev);
        for (int cuIndex = 0; cuIndex < mrcuInfoList.length; ++cuIndex) {
            int index;
            SJmoRemoteReplicationMRCUInfo mrcuInfo = mrcuInfoList[cuIndex];
            if (null == mrcuInfo || 4 <= mrcuInfo.getTrueCopyRCUInfoList().size() || (index = Collections.binarySearch(cuList, mrcuInfo.getSCu())) < 0) continue;
            localCUList.add(SJctrComUtility.toHexString(mrcuInfo.getSCu(), 2, true));
        }
        return localCUList;
    }

    private void createLocalCUPulldownList(SJctrComboBoxDataModel comboObj, List<String> cuList, int connType) {
        comboObj.removeAllItems();
        if (connType == 1) {
            comboObj.addItem("-");
            comboObj.setEnable(false);
            comboObj.setSelectedIndex(0);
        } else {
            for (String strCuNo : cuList) {
                comboObj.addItem(strCuNo);
            }
            comboObj.setEnable(true);
            comboObj.setSelectedIndex(0);
        }
    }

    private void createRemoteModelComboBox(int modelID, int connType) {
        SJctrComboBoxDataModel remoteModelCombo = SJctrRemoteConnectionUtility.getRemoteModelComboModel(this);
        SJctrTextBoxDataModel remoteText = SJctrRemoteConnectionUtility.getRemoteModelTextModel(this);
        HashMap<Integer, String[]> modelNameMap = new HashMap<Integer, String[]>();
        String[] modelNameHM700 = new String[]{Integer.toString(19), SJctrRemoteReplicationUtility.getModelNameString(19, this.getComUtility())};
        modelNameMap.put(19, modelNameHM700);
        String[] modelNameRAID800 = new String[]{Integer.toString(7), SJctrRemoteReplicationUtility.getModelNameString(7, this.getComUtility())};
        modelNameMap.put(7, modelNameRAID800);
        String[] modelNameHM800 = new String[]{Integer.toString(18), SJctrRemoteReplicationUtility.getModelNameString(18, this.getComUtility())};
        modelNameMap.put(18, modelNameHM800);
        ArrayList<HashMap<Integer, String[]>> modelList = new ArrayList<HashMap<Integer, String[]>>();
        modelList.add(modelNameMap);
        this.putCache(KEY_REMOTE_MODEL_NAME_LIST, modelList);
        remoteModelCombo.removeAllItems();
        remoteModelCombo.addItem(((String[])modelNameMap.get(18))[0], ((String[])modelNameMap.get(18))[1]);
        remoteModelCombo.addItem(((String[])modelNameMap.get(19))[0], ((String[])modelNameMap.get(19))[1]);
        remoteModelCombo.addItem(((String[])modelNameMap.get(7))[0], ((String[])modelNameMap.get(7))[1]);
        remoteModelCombo.setSelection(Integer.toString(modelID));
        remoteText.setValue(((String[])modelNameMap.get(modelID))[1]);
        this.getManageData().setData(KEY_SELECTED_MODEL_ID, modelID);
        remoteModelCombo.setEnable(true);
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_MODEL_MIN_MAX", "(6-255)");
    }

    private void createRemoteSysAndPathModel(int modelID, int connectType) {
        this.commonRemoteSysAndPathModel(modelID, connectType);
        SJctrComboBoxDataModel minPathPulldown = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
        this.createMinPathPullDown(minPathPulldown, 1, 8);
    }

    private void initRemoteSysAndPathModel(int modelID, int connectType) {
        this.commonRemoteSysAndPathModel(modelID, connectType);
        SJctrComboBoxDataModel minPathPulldown = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
        minPathPulldown.setSelectedIndex(0);
    }

    private void commonRemoteSysAndPathModel(int modelID, int connectType) {
        String serialMinMax = "?";
        serialMinMax = SJctrDataController.isHM() ? "(0-" + SJctrComUtility.toPaddingZeroString(999999, 6) + ")" : "(0-" + SJctrComUtility.toPaddingZeroString(99999, 5) + ")";
        int cuComboMax = 254;
        int cuComboMin = 0;
        int displayType = 255;
        switch (modelID) {
            case 7: {
                serialMinMax = "(1-" + SJctrComUtility.toPaddingZeroString(99999, 5) + ")";
                cuComboMin = 0;
                cuComboMax = 254;
                displayType = 7;
                break;
            }
            case 6: {
                serialMinMax = "(1-" + SJctrComUtility.toPaddingZeroString(99999, 5) + ")";
                cuComboMin = 0;
                cuComboMax = 254;
                displayType = 6;
                break;
            }
            case 19: {
                serialMinMax = "(200001-" + SJctrComUtility.toPaddingZeroString(265535, 6) + ")";
                cuComboMin = 0;
                cuComboMax = 63;
                displayType = 19;
                break;
            }
            case 18: {
                serialMinMax = "(400001-" + SJctrComUtility.toPaddingZeroString(499999, 6) + ")";
                displayType = 18;
                break;
            }
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        SJctrTextBoxDataModel serialNumberText = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
        serialNumberText.setValue("");
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_SERIAL_NO_MIN_MAX", serialMinMax);
        this.createRemoteCUComboBox(cuComboMin, cuComboMax, connectType);
        this.initSSIDPanel(connectType);
        SJctrComboBoxDataModel pathGroupIDPulldown = SJctrRemoteConnectionUtility.getPathGroupIDPullDownModel(this);
        this.createPathGroupPullDown(pathGroupIDPulldown, 0, 255, connectType);
        if (connectType == 1) {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_MIN_NUM_OF_PATHS_HELP", this.getComUtility().getGuidance("MIN_NUM_PATH_EXPLAIN"));
        } else {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_MIN_NUM_OF_PATHS_HELP", "");
        }
        List<?> localPortFibreKindList = this.getProxy().getCache("COM_AVA_LOCAL_PORT_ID_LIST");
        List<?> localPortIscsiKindList = this.getProxy().getCache("COM_AVA_LOCAL_ISCSI_PORT_ID_LIST");
        SJctrRemoteConnectionUtility.setEnableStatusSelectTypeRadio(localPortFibreKindList, localPortIscsiKindList, displayType, this);
        SJctrRemoteConnectionUtility.setSelectStatusSelectTypeRadio(localPortFibreKindList, displayType, this);
        this.initRemotePathPanel(displayType);
    }

    private void createRemoteCUComboBox(int min, int max, int connType) {
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        SJctrComboBoxDataModel remoteCUCombo = SJctrRemoteConnectionUtility.getRemoteCUComboModel(this);
        remoteCUCombo.removeAllItems();
        if (connType == 1) {
            remoteCUCombo.addItem("-");
            remoteCUCombo.setEnable(false);
            remoteCUCombo.setSelectedIndex(0);
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_MIN_MAX", "(-)");
        } else {
            for (int i = min; i <= max; ++i) {
                String str = SJctrComUtility.toHexString(i, 2, true);
                remoteCUCombo.addItem(str);
            }
            remoteCUCombo.setEnable(true);
            remoteCUCombo.setSelectedIndex(0);
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_MIN_MAX", "(" + SJctrComUtility.toHexString(min, 2, true) + "-" + SJctrComUtility.toHexString(max, 2, true) + ")");
            SJctrTextBoxDataModel remoteCUText = (SJctrTextBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_CU_VALU");
            remoteCUText.setValue(remoteCUCombo.getSelection());
        }
    }

    private void initSSIDPanel(int connType) {
        SJctrRemoteStorageSysDataModel remoteModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        ((SJctrDataObject)remoteModel.getManageData()).setData("COM_DISP_SSID_COUNT", 1);
        for (int sid = 0; sid < 1; ++sid) {
            SJctrTextBoxDataModel ssidTxt = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(this, sid);
            ssidTxt.setValue("");
            SJctrButtonDataModel addButton = SJctrRemoteConnectionUtility.getRemoteAddSSIDButtonModel(this);
            SJctrRemoteSSIDDataModel ssid = SJctrRemoteConnectionUtility.getRemoteSSIDModel(this, sid);
            if (connType == 1) {
                ssidTxt.setEnable(false);
                addButton.setEnable(false);
                ((SJctrDataObject)ssid.getManageData()).setData("COM_REMOTE_TEXT_SSID_MIN_MAX", "(-)");
                continue;
            }
            ssidTxt.setEnable(true);
            addButton.setEnable(true);
            ((SJctrDataObject)ssid.getManageData()).setData("COM_REMOTE_TEXT_SSID_MIN_MAX", SJctrRemoteConnectionUtility.getSSIDEnableRangeString());
        }
    }

    private void createPathGroupPullDown(SJctrComboBoxDataModel comboObj, int min, int max, int connType) {
        comboObj.removeAllItems();
        if (connType == 1) {
            for (int i = min; i <= max; ++i) {
                String str = SJctrComUtility.toHexString(i, 2, true);
                comboObj.addItem(str);
            }
            comboObj.setEnable(true);
        } else {
            comboObj.addItem("-");
            comboObj.setEnable(false);
        }
        comboObj.setSelectedIndex(0);
    }

    private void createMinPathPullDown(SJctrComboBoxDataModel comboObj, int min, int max) {
        for (int i = min; i <= max; ++i) {
            String str = SJctrComUtility.toDecString(i);
            comboObj.addItem(str);
        }
        comboObj.setEnable(true);
        comboObj.setSelectedIndex(0);
    }

    private void initRemotePathPanel(int remoteModelID) {
        List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
        int pid = 0;
        for (int i = 0; i < 8; ++i) {
            SJctrComboBoxDataModel initLcoalPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, i);
            SJctrComboBoxDataModel initRemotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, i);
            SJctrTextBoxDataModel initRemotePortIDTextObj = SJctrRemoteConnectionUtility.getRemotePortIDTextModel(this, i);
            initLcoalPortcomboObj.removeAllItems();
            initRemotePortcomboObj.removeAllItems();
            initRemotePortIDTextObj.setValue("");
        }
        if (localPortIDList != null) {
            for (pid = 0; pid < 2; ++pid) {
                SJctrRemoteConnectionUtility.createPortIDPanel(this, remoteModelID, localPortIDList, this.getComUtility(), pid);
            }
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        ((SJctrDataObject)pathModel.getManageData()).setData("COM_DISP_PATH_COUNT", pid);
    }

    private void initOptionsPanel(int connType) {
        SJctrTextBoxDataModel rioMIHTimeText = SJctrRemoteConnectionUtility.getRioMihTimeTextModel(this);
        rioMIHTimeText.setValue(Integer.toString(15));
        rioMIHTimeText.setMin(Integer.toString(10));
        rioMIHTimeText.setMax(Integer.toString(100));
        SJctrTextBoxDataModel roundTripTimeTxt = SJctrRemoteConnectionUtility.getRoudTripTimeTextModel(this);
        roundTripTimeTxt.setValue(Integer.toString(1));
        roundTripTimeTxt.setLabel(this.getComUtility().getGuidance("ROUND_TRIP_TIME_EXPLAIN"));
        SJctrRadioButtonGroupDataModel freezeOptionRadio = SJctrRemoteConnectionUtility.getFreezeOptionRadio(this);
        if (connType == 1) {
            freezeOptionRadio.add("COM_ENABLE");
            freezeOptionRadio.add("COM_DISABLE");
            freezeOptionRadio.setEnable(false);
        } else {
            freezeOptionRadio.setSelect("COM_DISABLE");
            freezeOptionRadio.setEnable(true);
        }
    }

    private int convConnectType(String strConnType) {
        int connType = -1;
        if (null != strConnType) {
            if (strConnType.equals("COM_CONNECT_TYPE_SYS")) {
                connType = 1;
            } else if (strConnType.equals("COM_CONNECT_TYPE_CU")) {
                connType = 0;
            } else {
                this.logUty.putlog("convConnectType", "Connection Type can not change.");
            }
        }
        return connType;
    }

    private int convFreezeOption(String strFreezeOpt) {
        int freezeOpt = -1;
        if (null != strFreezeOpt) {
            if (strFreezeOpt.equals("COM_ENABLE")) {
                freezeOpt = 1;
            } else if (strFreezeOpt.equals("COM_DISABLE")) {
                freezeOpt = 0;
            } else {
                this.logUty.putlog("convFreezeOption", "Freeze Option can not change.");
            }
        }
        return freezeOpt;
    }

    private int getRemoteModelID(String modelName) {
        HashMap modelNameMap;
        int remoteModelID = -1;
        if (modelName == null || modelName.equals("")) {
            return remoteModelID;
        }
        List<?> modelNameList = this.getCache(KEY_REMOTE_MODEL_NAME_LIST);
        if (modelNameList != null && (modelNameMap = (HashMap)modelNameList.get(0)) != null) {
            if (modelName.equals(((String[])modelNameMap.get(19))[0]) || modelName.equals(((String[])modelNameMap.get(19))[1])) {
                remoteModelID = 19;
            } else if (modelName.equals(((String[])modelNameMap.get(7))[0]) || modelName.equals(((String[])modelNameMap.get(7))[1])) {
                remoteModelID = 7;
            } else if (modelName.equals(((String[])modelNameMap.get(18))[0]) || modelName.equals(((String[])modelNameMap.get(18))[1])) {
                remoteModelID = 18;
            } else {
                try {
                    remoteModelID = Integer.parseInt(modelName);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("getRemoteModelID", "The error occurred at the Remote Model ID changing. NumberFormatException : " + ne.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
                }
            }
        }
        return remoteModelID;
    }

    private void disableEventListner() {
        SJctrRadioButtonGroupDataModel radConnType = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
        SJctrSimpleDataModel comboModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_MODEL_NAME_CHANGE_EVENT);
        SJctrComboBoxDataModel comboMinPath = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
        SJctrSimpleDataModel buttonRemove = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
        SJctrButtonDataModel buttonAddSSID = SJctrRemoteConnectionUtility.getRemoteAddSSIDButtonModel(this);
        SJctrButtonDataModel buttonAddPath = SJctrRemoteConnectionUtility.getRemoteAddPathButtonModel(this);
        SJctrRadioButtonGroupDataModel radSelectType = SJctrRemoteConnectionUtility.getSelectTypeRadio(this);
        radConnType.setEnableListener(false);
        comboModel.setEnableListener(false);
        comboMinPath.setEnableListener(false);
        buttonRemove.setEnableListener(false);
        buttonAddSSID.setEnableListener(false);
        buttonAddPath.setEnableListener(false);
        radSelectType.setEnableListener(false);
    }

    private void enableEventListner() {
        SJctrRadioButtonGroupDataModel radConnType = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
        SJctrSimpleDataModel comboModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_MODEL_NAME_CHANGE_EVENT);
        SJctrComboBoxDataModel comboMinPath = SJctrRemoteConnectionUtility.getMinNumPathPullDownModel(this);
        SJctrSimpleDataModel buttonRemove = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
        SJctrButtonDataModel buttonAddSSID = SJctrRemoteConnectionUtility.getRemoteAddSSIDButtonModel(this);
        SJctrButtonDataModel buttonAddPath = SJctrRemoteConnectionUtility.getRemoteAddPathButtonModel(this);
        SJctrRadioButtonGroupDataModel radSelectType = SJctrRemoteConnectionUtility.getSelectTypeRadio(this);
        radConnType.setEnableListener(true);
        comboModel.setEnableListener(true);
        comboMinPath.setEnableListener(true);
        buttonRemove.setEnableListener(true);
        buttonAddSSID.setEnableListener(true);
        buttonAddPath.setEnableListener(true);
        radSelectType.setEnableListener(true);
    }

    private boolean chkRCUInformationDuplicate(SJmoRemoteReplicationRCUInfo chkRCUInfo, int conType) {
        if (null == chkRCUInfo) {
            SJctrLogUty.error("SJctrRemoteReplicationUtility", "chkRCUInformationDuplicate", "chkRCUInfo is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean result = false;
        SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
        if (conType == 0) {
            SJmoRemoteReplicationMRCUInfo[] mrcuInfoList = mrcuInfoMgr.getMRCUInfoList();
            for (int cuIndx = 0; cuIndx < mrcuInfoList.length; ++cuIndx) {
                ArrayList<SJmoRemoteReplicationRCUInfo> cuRCUInfoList;
                SJmoRemoteReplicationMRCUInfo mrcuInfo = mrcuInfoList[cuIndx];
                if (null == mrcuInfo || (cuRCUInfoList = mrcuInfo.getTrueCopyRCUInfoList()).size() == 0) continue;
                Collections.sort(cuRCUInfoList);
                int index = Collections.binarySearch(cuRCUInfoList, chkRCUInfo);
                if (index < 0) continue;
                result = true;
                break;
            }
        } else {
            SJmoRemoteReplicationMRCUInfo mrcuFreeInfo = mrcuInfoMgr.getMRCUFreeInfo();
            ArrayList<SJmoRemoteReplicationRCUInfo> sysRCUInfoList = mrcuFreeInfo.getTrueCopyRCUInfoList();
            if (sysRCUInfoList.size() > 0) {
                Collections.sort(sysRCUInfoList);
                int index = Collections.binarySearch(sysRCUInfoList, chkRCUInfo);
                if (index >= 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    private String toPaddingZeroSerialNumber(int modelID, String sn) {
        int digit;
        switch (modelID) {
            case 6: 
            case 7: {
                digit = 5;
                break;
            }
            case 19: {
                digit = 6;
                break;
            }
            case 18: {
                digit = 6;
                break;
            }
            default: {
                digit = SJctrDataController.isHM() ? 6 : 5;
            }
        }
        while (sn.length() < digit) {
            sn = "0" + sn;
        }
        return sn;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.checkSettingError();
        boolean dispWarning = false;
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        if (remotePathModel.getSelectType() == 0) {
            return dispWarning;
        }
        int portIDCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        ArrayList<Integer> indexList = new ArrayList<Integer>(portIDCount);
        for (int i = 0; i < portIDCount; ++i) {
            indexList.add(i);
        }
        SJctrTextBoxDataModel remoteModelText = SJctrRemoteConnectionUtility.getRemoteModelTextModel(this);
        String modelName = remoteModelText.getValue();
        int remoteModelID = this.getRemoteModelID(modelName);
        if (remoteModelID == -1) {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
        }
        SJctrTextBoxDataModel snTextBox = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
        String sn = snTextBox.getValue();
        SJctrRemoteReplicationTargetPathInfo targetPathInfo = SJctrRemoteConnectionUtility.getExistIscsiTargetPathInfo(indexList, remoteModelID, sn, this);
        if (targetPathInfo != null) {
            this.dispMsgDialogExistsiScsiName(event, dstModel);
            dispWarning = true;
        }
        return dispWarning;
    }

    private void dispMsgDialogExistsiScsiName(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        String strFuncID = Integer.toString(210);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(206280);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemotePathDataModel remotePathDataModel = (SJctrRemotePathDataModel)SJctrAddRemoteConnectionDC.this.getDataObjectModel("COM_REMOTE_PATHS_PANEL");
                remotePathDataModel.setDirty();
                SJctrAddRemoteConnectionDC.this.finishEvent(msgEvent, dstModel);
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private void chgSelectTypeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            int dispPathCount;
            this.disableEventListner();
            SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            int portIdCount = dispPathCount = ((Integer)((SJctrDataObject)pathModel.getManageData()).getData("COM_DISP_PATH_COUNT")).intValue();
            if (dispPathCount <= 1) {
                portIdCount = 2;
            }
            int remoteModelID = (Integer)this.getManageData().getData(KEY_SELECTED_MODEL_ID);
            List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
            for (int i = 0; i < portIdCount; ++i) {
                SJctrRemoteConnectionUtility.createPortIDPanel(this, remoteModelID, localPortIDList, this.getComUtility(), i);
            }
            ((SJctrDataObject)pathModel.getManageData()).setData("COM_DISP_PATH_COUNT", portIdCount);
            this.enableEventListner();
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    public SJctrRemoteReplicationTargetPathInfo createRemoteTargetPathInfo(int[] portID, int index, int selectType, SJctrDataController dc) {
        SJctrRemoteReplicationTargetPathInfo remotePathInfo = new SJctrRemoteReplicationTargetPathInfo();
        remotePathInfo.setPortType(selectType);
        remotePathInfo.setSPort((short)portID[0]);
        remotePathInfo.setRemotePortId(portID[1]);
        if (selectType == 1) {
            SJctrComboBoxDataModel ipAddressTypeModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(dc, index);
            SJctrTextBoxDataModel ipAddressModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(dc, index);
            SJctrTextBoxDataModel tcpPortNumModel = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(dc, index);
            int ipType = Integer.parseInt(ipAddressTypeModel.getSelection());
            remotePathInfo.setIIpType(ipType);
            if (ipType == 0) {
                remotePathInfo.setIIpv4Address(SJctrRemoteReplicationUtility.getIpv4Address(ipAddressModel.getValue()));
            } else {
                remotePathInfo.setIIpv6Address(SJctrIscsiUtility.splitIPv6String(ipAddressModel.getValue()));
            }
            remotePathInfo.setITcpPortNumber(Integer.parseInt(tcpPortNumModel.getValue()));
        }
        return remotePathInfo;
    }

    private void checkSettingError() {
        this.checkPortIdDuplicate();
        this.checkRcuDuplicate();
    }

    private void checkPortIdDuplicate() {
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        int[][] portID = new int[8][2];
        int portIDCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        for (int pid = 0; pid < portIDCount; ++pid) {
            SJctrComboBoxDataModel localPortIDModel = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, pid);
            portID[pid][0] = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortIDModel);
            SJctrComboBoxDataModel remotePortIDModel = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, pid);
            portID[pid][1] = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel);
        }
        if (SJctrRemoteReplicationUtility.chkRemoteConPortIDDuplicate(portID, portIDCount)) {
            this.getLogUty().putlog("checkPortIdDuplicate", "Port ID Pair is duplicating.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206080);
        }
    }

    private void checkRcuDuplicate() {
        int localCU = -1;
        int remoteCU = -1;
        int[] ssid = new int[4];
        int pathGrp = 0;
        short ldkc = 0;
        int ssidCount = 0;
        SJctrRadioButtonGroupDataModel connTypeRadio = SJctrRemoteConnectionUtility.getConnectionTypeRadio(this);
        int conType = this.convConnectType(connTypeRadio.getSelect());
        if (conType == 0) {
            SJctrComboBoxDataModel localCUPulldown = SJctrRemoteConnectionUtility.getLocalCUPullDownModel(this);
            localCU = Integer.parseInt(localCUPulldown.getSelection(), 16);
            SJctrTextBoxDataModel remoteCUTextBox = SJctrRemoteConnectionUtility.getRemoteCUTextModel(this);
            remoteCU = Integer.parseInt(remoteCUTextBox.getValue(), 16);
            SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
            ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
            ssid = SJctrRemoteConnectionUtility.getSSIDListFromWizard(this);
        } else {
            SJctrComboBoxDataModel pathGrpPulldown = SJctrRemoteConnectionUtility.getPathGroupIDPullDownModel(this);
            pathGrp = Integer.parseInt(pathGrpPulldown.getSelection(), 16);
        }
        SJctrTextBoxDataModel remoteModelText = SJctrRemoteConnectionUtility.getRemoteModelTextModel(this);
        String modelName = remoteModelText.getValue();
        int remoteModelID = this.getRemoteModelID(modelName);
        SJctrTextBoxDataModel snTextBox = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
        String sn = snTextBox.getValue();
        SJmoRemoteReplicationRCUInfo rcuInfo = new SJmoRemoteReplicationRCUInfo();
        rcuInfo.setICUFree(conType);
        rcuInfo.setSCu((short)remoteCU);
        rcuInfo.setIControllerID(remoteModelID);
        rcuInfo.setSCUNo((short)localCU);
        rcuInfo.setStrSN(sn);
        rcuInfo.setINumofSSID(ssidCount);
        rcuInfo.setISSID(ssid);
        rcuInfo.setIRCUID(pathGrp);
        rcuInfo.setSLdkc(ldkc);
        if (this.chkRCUInformationDuplicate(rcuInfo, conType)) {
            this.getLogUty().putlog("checkRcuDuplicate", "RCU is duplicating.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206082);
        }
    }

    private boolean isDispMsgDialogIscsiPortUnsupported(int remoteModelID) {
        List<?> fibrePortList;
        boolean dispMsg = false;
        if (!SJctrRemoteReplicationDataMacro.REMOTE_CONNECTION_ISCSI_PORT_ENABLE_MODEL_ID.contains(remoteModelID) && (fibrePortList = this.getCache("COM_AVA_LOCAL_PORT_ID_LIST")).isEmpty()) {
            String strFuncID = Integer.toString(210);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(206282);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrUserController uc = SJctrAddRemoteConnectionDC.this.getOwner();
                    SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrAddRemoteConnectionDC.class);
                    SJctrAddRemoteConnectionDC dc = (SJctrAddRemoteConnectionDC)uc.getDataController(wizardWindowRelateDisp);
                    SJctrTextBoxDataModel prevTextModel = SJctrRemoteConnectionUtility.getRemoteModelPrevTextModel(dc);
                    String prevString = prevTextModel.getValue();
                    SJctrTextBoxDataModel textModel = SJctrRemoteConnectionUtility.getRemoteModelTextModel(dc);
                    textModel.setValue(prevString);
                    int prevRemoteModelID = SJctrAddRemoteConnectionDC.this.getRemoteModelID(prevString);
                    dc.getManageData().setData(SJctrAddRemoteConnectionDC.KEY_SELECTED_MODEL_ID, prevRemoteModelID);
                    SJctrAddRemoteConnectionDC.this.updateFooter();
                    SJctrAddRemoteConnectionDC.this.setDirtyAll();
                }
            });
            this.addUpdateDisp(related);
            dispMsg = true;
        }
        return dispMsg;
    }

    private static enum ADD_REMOTE_CONN_MSG implements SJctrNotifyState
    {
        CHANGED_RADIO_CONN_TYPE,
        SELECT_REMOTE_MODEL,
        PUSH_REMOVE_SSID,
        PUSH_REMOVE_PATH;

    }
}

