/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs.ha;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sanproject.common.Robj_interface_RJiHAsetCreatePair;
import sanproject.serverux.dataimpl.RCErrorInf;
import sanproject.serverux.dataimpl.RJiHAsetCreatePair;
import sanproject.serverux.dataimpl.RJiHAsetCreatePair_IN;
import sanproject.serverux.dataimpl.RJiHAsetCreatePair_OUT;
import sanproject.serverux.dataimpl.RJiHAsetCreatePairsList;
import sanproject.serverux.dataimpl.RJiHAsetLU;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationHaPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.ha.SJctrCreateHaPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.ha.SJctrCreateHaPairsConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;

public class SJctrCreateHaPairsAC
extends SJctrOperationHaPairBaseAC {
    private static final long serialVersionUID = 1760268678667256261L;
    private String localSn = "";

    public void setApplyData(SJctrCreateHaPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.localSn = confirmData.getLocalSN();
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        String METHOD = "applyStart";
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            HashMap<String, SJctrError> mapError = new HashMap<String, SJctrError>();
            ArrayList<?> aluaSetList = this.getSetList();
            SanResponse aluaResult = null;
            if (aluaSetList.size() > 0) {
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateAluaMode)");
                aluaResult = (SanResponse)supplier.applyStart(this.getLockId(), aluaSetList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateAluaMode)");
            }
            this.putAluaError(mapError, aluaResult);
            Object createPairResult = null;
            if (this.applyInfo.size() == mapError.size()) {
                SJctrLogUty.info(this.title, "applyStart", "GAD Create Pair do not apply, because All AluaMode update was errors.");
            } else {
                ArrayList<?> createPairSetList = this.getSetList(mapError);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (RJiHAsetCreatePair)");
                createPairResult = supplier.applyStart(this.getLockId(), createPairSetList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (RJiHAsetCreatePair)");
                if (createPairResult instanceof RJiHAsetCreatePair_OUT) {
                    RCErrorInf errInfo = (RCErrorInf)((RJiHAsetCreatePair_OUT)createPairResult).getDataObject();
                    this.putPairError(mapError, errInfo);
                } else {
                    SJctrLogUty.info(this.title, "applyStart", "instance of createPairResult is invalid.");
                    SJctrError error = new SJctrError(210, 22, 107001);
                    this.setError(error);
                    return;
                }
            }
            this.setApplyResult(mapError);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        int applyCount = 0;
        SJdsSupplierAgent supplierAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SanRequest sanRequest = supplierAgent.newRequest("LUNMupdateAluaMode");
        try {
            SanList ldevs = sanRequest.newList("Ldevs");
            for (SJmoHAPairVolInfo aluLdev : this.applyInfo) {
                SJctrCreateHaPairVolInfo pairInfo = (SJctrCreateHaPairVolInfo)aluLdev;
                if (pairInfo.getAluaModeSelection() == 0) continue;
                SanObject ldev = ldevs.addObj();
                int[] idArray = new int[]{pairInfo.getSLdkc(), pairInfo.getSCu(), pairInfo.getSLdev()};
                ldev.putIntArray("Id", idArray);
                boolean aluaMode = pairInfo.getAluaMode() == 1;
                ldev.putBoolean("AluaMode", aluaMode);
                ++applyCount;
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error("SJctrCreateHaPairsAC", "getSetList", "The error occurred during request parameter generation processing of Key-Value." + sdEx.getMessage());
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (applyCount > 0) {
            applyList.add(sanRequest);
        }
        return applyList;
    }

    public ArrayList<?> getSetList(Map<String, SJctrError> mapError) {
        ArrayList<RJiHAsetCreatePair> rmiPairList = new ArrayList<RJiHAsetCreatePair>();
        for (SJmoHAPairVolInfo haPair : this.applyInfo) {
            SJmoHAPairVolInfo ldevIndex;
            if (mapError != null && mapError.containsKey((ldevIndex = haPair).getIndexKey())) continue;
            SJctrCreateHaPairVolInfo pairInfo = (SJctrCreateHaPairVolInfo)haPair;
            RJiHAsetCreatePair rmiPair = new RJiHAsetCreatePair();
            rmiPair.setLU_P(this.getPLU(pairInfo));
            rmiPair.setLU_S(this.getSLU(pairInfo));
            rmiPair.setSN_P(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.localSn), 5));
            rmiPair.setSN_S(pairInfo.getStrPairSN());
            int ssid = pairInfo.getLocalExistenceSsid();
            if (ssid != -1) {
                rmiPair.setSSID_P(ssid);
            }
            rmiPair.setModel_S(pairInfo.getIPairModel());
            rmiPair.setCopyPace(pairInfo.getICopyPace());
            rmiPair.setQuorumDisable(false);
            rmiPair.setQuorumID(pairInfo.getIQuorumID());
            rmiPair.setMirror(pairInfo.getIMuNo());
            boolean hasGroup = pairInfo.hasGroup();
            rmiPair.setGroupEnable(hasGroup);
            if (hasGroup) {
                rmiPair.setGroup(pairInfo.getIGroup());
            } else {
                rmiPair.setGroup(0);
            }
            rmiPair.setPathGrp(pairInfo.getIPathGroup());
            rmiPair.setCreateMode(pairInfo.getInitCopyType());
            rmiPair.setSuspended(1);
            rmiPairList.add(rmiPair);
        }
        Robj_interface_RJiHAsetCreatePair[] createHaPair = rmiPairList.toArray(new RJiHAsetCreatePair[rmiPairList.size()]);
        RJiHAsetCreatePairsList haPairList = new RJiHAsetCreatePairsList();
        haPairList.setPairParam(createHaPair);
        RJiHAsetCreatePair_IN inputIF = new RJiHAsetCreatePair_IN();
        inputIF.setPairParam(haPairList);
        ArrayList<RJiHAsetCreatePair_IN> applyList = new ArrayList<RJiHAsetCreatePair_IN>(1);
        applyList.add(inputIF);
        return applyList;
    }

    private RJiHAsetLU getSLU(SJctrCreateHaPairVolInfo pairInfo) {
        RJiHAsetLU lu = new RJiHAsetLU();
        SJmoLuIndex luIndex = pairInfo.getPairLU();
        lu.setPort(luIndex.getSPort());
        lu.setHostGroup(luIndex.getSHostGroup());
        lu.setLUN(luIndex.getILUN());
        return lu;
    }

    private RJiHAsetLU getPLU(SJctrCreateHaPairVolInfo pairInfo) {
        RJiHAsetLU lu = new RJiHAsetLU();
        lu.setPort(pairInfo.getLunDetail().getSPort());
        lu.setHostGroup(pairInfo.getLunDetail().getSHostGroup());
        lu.setLUN(pairInfo.getLunDetail().getSLUN());
        lu.setLDKC(pairInfo.getPVolIndex().getSLdkc());
        lu.setCU(pairInfo.getPVolIndex().getSCu());
        lu.setLDEV(pairInfo.getPVolIndex().getSLdev());
        return lu;
    }
}

