/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs.model;

import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrBaseSecondaryVolumeDataModel
extends SJctrSimpleDataModel {
    protected static final int DIGIT_CU = 2;
    private static final int DIGIT_LDEV = 2;
    private static final int DIGIT_HG_ID = 2;
    private static final int DIGIT_LUN_HEX = 4;
    private static final int SELECT_TOP_INDEX = 0;

    public SJctrBaseSecondaryVolumeDataModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataModel("COM_PORT_ID", new SJctrComboBoxDataModel());
        this.addDataModel("COM_HG_ID", new SJctrComboBoxDataModel());
        this.addDataModel("COM_HG_ID_RANGE", new SJctrTextLabelDataModel());
        this.addDataModel("COM_LUN_ID", new SJctrComboBoxDataModel());
        this.addDataModel("COM_LUN_ID_RANGE", new SJctrTextLabelDataModel());
        this.addDataModel("COM_LUN_ID_RANGE_DIGIT", new SJctrTextLabelDataModel());
        this.addDataModel("COM_CU_TXT", new SJctrTextBoxDataModel());
        this.addDataModel("COM_CU_LIST", new SJctrComboBoxDataModel());
        this.addDataModel("COM_LDEV", new SJctrComboBoxDataModel());
    }

    @Override
    public void makeDataModel() {
        String digitStr;
        String lunMaxStr;
        String lunMinStr;
        super.makeDataModel();
        SJctrComboBoxDataModel remoteHgIdModel = (SJctrComboBoxDataModel)this.getDataModel("COM_HG_ID");
        for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_HTG; ++i) {
            remoteHgIdModel.addItem(String.valueOf(i), SJctrComUtility.toHexString(i, 2, true));
        }
        remoteHgIdModel.setSelectedIndex(0);
        String hgLabelStr = "(" + SJctrComUtility.toHexString(0, 2, true) + "-" + SJctrComUtility.toHexString(SJmoDataMacro_IF.NUM_MAX_HTG, 2, true) + ")";
        SJctrTextLabelDataModel hgLabelModel = (SJctrTextLabelDataModel)this.getDataModel("COM_HG_ID_RANGE");
        hgLabelModel.setLabel(hgLabelStr);
        boolean isLunDec = SJctrRemoteReplicationUtility.isLunDec(this.getDataController().getOwner().getUserSession());
        SJctrComboBoxDataModel remoteLunIdModel = (SJctrComboBoxDataModel)this.getDataModel("COM_LUN_ID");
        for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_LUN; ++i) {
            String lunStr = null;
            lunStr = isLunDec ? String.valueOf(i) : SJctrComUtility.toHexString(i, 4, true);
            remoteLunIdModel.addItem(String.valueOf(i), lunStr);
        }
        remoteLunIdModel.setSelectedIndex(0);
        if (isLunDec) {
            lunMinStr = String.valueOf(0);
            lunMaxStr = String.valueOf(SJmoDataMacro_IF.NUM_MAX_LUN);
            digitStr = this.getComUtility().getGuidance("DECIMAL_INPUT");
        } else {
            lunMinStr = SJctrComUtility.toHexString(0, 4, true);
            lunMaxStr = SJctrComUtility.toHexString(SJmoDataMacro_IF.NUM_MAX_LUN, 4, true);
            digitStr = this.getComUtility().getGuidance("HEXADECIMAL_INPUT");
        }
        String lunLabelStr = "(" + lunMinStr + "-" + lunMaxStr + ",";
        String digitLabelStr = digitStr + ")";
        SJctrTextLabelDataModel lunLabelModel = (SJctrTextLabelDataModel)this.getDataModel("COM_LUN_ID_RANGE");
        SJctrTextLabelDataModel digitLabelModel = (SJctrTextLabelDataModel)this.getDataModel("COM_LUN_ID_RANGE_DIGIT");
        lunLabelModel.setLabel(lunLabelStr);
        digitLabelModel.setLabel(digitLabelStr);
        SJctrComboBoxDataModel remoteLdevModel = (SJctrComboBoxDataModel)this.getDataModel("COM_LDEV");
        for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_LDEV_CU; ++i) {
            remoteLdevModel.addItem(String.valueOf(i), SJctrComUtility.toHexString(i, 2, true));
        }
        remoteLdevModel.setSelectedIndex(0);
        ((SJctrDataObject)this.getManageData()).setData("COM_LUN_ID_DEC", isLunDec);
    }

    public void makeRemotePortIdModel(int controllerId) {
        SJctrComboBoxDataModel portIdModel = (SJctrComboBoxDataModel)this.getDataModel("COM_PORT_ID");
        SJctrRemoteReplicationUtility.createRemotePortID(portIdModel, controllerId, this.getComUtility());
        portIdModel.removeItem("");
    }

    public SJctrComboBoxDataModel getPortIdModel() {
        return (SJctrComboBoxDataModel)this.getDataModel("COM_PORT_ID");
    }

    public SJctrComboBoxDataModel getHgIdModel() {
        return (SJctrComboBoxDataModel)this.getDataModel("COM_HG_ID");
    }

    public SJctrComboBoxDataModel getLunIdModel() {
        return (SJctrComboBoxDataModel)this.getDataModel("COM_LUN_ID");
    }

    public SJctrTextBoxDataModel getCuTextModel() {
        return (SJctrTextBoxDataModel)this.getDataModel("COM_CU_TXT");
    }

    public SJctrComboBoxDataModel getCuListModel() {
        return (SJctrComboBoxDataModel)this.getDataModel("COM_CU_LIST");
    }

    public SJctrComboBoxDataModel getLdevModel() {
        return (SJctrComboBoxDataModel)this.getDataModel("COM_LDEV");
    }

    public void updateRemoteCuPulldownModel(int controllerId) {
        int maxCu = SJctrRemoteReplicationUtility.getMaxCuNum(controllerId);
        SJctrComboBoxDataModel remoteCuModel = this.getCuListModel();
        remoteCuModel.removeAllItems();
        for (int i = 0; i <= maxCu; ++i) {
            remoteCuModel.addItem(String.valueOf(i), SJctrComUtility.toHexString(i, 2, true));
        }
        remoteCuModel.setSelectedIndex(0);
        remoteCuModel.setDirtyAll();
    }
}

