/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editjournalopts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.SJctrEditJournalOptionsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.model.SJctrCacheModeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.model.SJctrInflowControlDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.model.SJctrTimerTypeDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrEditJournalOptionsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101511;
    private static final String DISP_TITLE = "EDIT_JNL_OPTIONS";
    private static final String KEY_COPY_TYPE_STRING = "COM_COPY_TYPE_STRING";
    private static final String KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION = "COM_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION";
    private static final String KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL = "COM_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL";
    private static final int ATTRIBUTE_ALL_SAME_VALUE = 1;

    public SJctrEditJournalOptionsDC() {
        super(0x1101511);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_INFLOW_CONTROL_INF", new SJctrInflowControlDataModel());
        this.addDataObjectModel("COM_CACHE_MODE_INF", new SJctrCacheModeDataModel());
        this.addDataObjectModel("COM_TIMER_TYPE_INF", new SJctrTimerTypeDataModel());
        this.addDataObjectModel("COM_VIEW_SPECIFIC_INFO", new SJctrSimpleDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_JOURNAL_OPTIONS_MSG.SELECT_INFLOW_CONTROL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrInflowControlDataModel inflowDataModel = (SJctrInflowControlDataModel)dstModel.getDataModel("COM_INFLOW_CONTROL_INF");
                int inflowControlRadio = inflowDataModel.getSelect();
                inflowDataModel.changeInflowControlTextBoxType(inflowControlRadio);
                if (inflowControlRadio == 0) {
                    inflowDataModel.setDataOverflowWatchEnable(true);
                } else {
                    inflowDataModel.setDisplayDataOverflowWatch("");
                    inflowDataModel.setDataOverflowWatchEnable(false);
                }
                inflowDataModel.setDirty("COM_DATA_OVERFLOW_WATCH_TEXTBOX");
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> selectedList = this.getCache("KEY_SELECTED_JOURNAL");
        if (selectedList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selectedList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoUniversalReplicatorJnlGrp> selectedJnlGrpList = this.getCache("KEY_SELECTED_JOURNAL");
            SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoUniversalReplicatorJnlGrp> jnlGrpList = SJctrRemoteReplicationUtility.checkAndGetExistJournalInfo(selectedJnlGrpList, jnlMgr);
            SJctrRemoteReplicationUtility.checkJournalTypicalVolRs(this, jnlGrpList);
            int jnlType = SJctrRemoteReplicationUtility.checkJournalType(jnlGrpList);
            if (jnlType == -1) {
                this.logUty.putlog("checkConstructData", "Journal type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206011);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean editableTimerType = this.isEditableOptionTimerType(jnlGrpList);
            boolean editableOther = this.isEditableOptionOther(jnlGrpList);
            if (!editableTimerType && !editableOther) {
                this.logUty.putlog("checkConstructData", "Contained invalid Journal Status.");
                SJctrError err = new SJctrError(210, 22, 206074);
                SJcException exp = err.createException();
                throw exp;
            }
            this.initialSetupDataModel(jnlGrpList, editableTimerType, editableOther);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            List<SJmoUniversalReplicatorJnlGrp> jnlGrpList = this.getCache(KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION);
            List<SJmoUniversalReplicatorJnlGrp> jnlGrpOriginalList = this.getCache(KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL);
            int copyType = SJctrRemoteReplicationUtility.checkJnltypeForJnlInfo((SJmoUniversalReplicatorJnlGrp)jnlGrpList.get(0));
            SJctrEditJournalOptionsConfirmData confirmData = new SJctrEditJournalOptionsConfirmData();
            List<SJmoUniversalReplicatorJnlGrp> sendJnlgList = this.getMergeJnlGrpList(jnlGrpList, jnlGrpOriginalList);
            Collections.sort(sendJnlgList, new Comparator<SJmoUniversalReplicatorJnlGrp>(){

                @Override
                public int compare(SJmoUniversalReplicatorJnlGrp arg0, SJmoUniversalReplicatorJnlGrp arg1) {
                    return arg0.getIJnlGroupId() - arg1.getIJnlGroupId();
                }
            });
            confirmData.setJnlgInfo(sendJnlgList);
            confirmData.setCopyType(copyType);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditJournalOptionsConfirmData> confirmDataList = new ArrayList<SJctrEditJournalOptionsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditJournalOptionsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }

    private void initialSetupDataModel(List<SJmoUniversalReplicatorJnlGrp> jnlgList, boolean editableOptTimerType, boolean editableOptOther) {
        SJctrSimpleDataModel viewInfo = (SJctrSimpleDataModel)this.getDataObjectModel("COM_VIEW_SPECIFIC_INFO");
        int copyType = SJctrRemoteReplicationUtility.checkJnltypeForJnlInfo(jnlgList.get(0));
        if (copyType == 1) {
            ((SJctrDataObject)viewInfo.getManageData()).setData(KEY_COPY_TYPE_STRING, "COM_COPY_TYPE_OPEN");
        } else if (copyType == 0) {
            ((SJctrDataObject)viewInfo.getManageData()).setData(KEY_COPY_TYPE_STRING, "COM_COPY_TYPE_MF");
        } else {
            SJctrLogUty.error("SJctrEditJournalOptionsDC", "initialSetupDataModel", "Copy type is invalid.");
        }
        HashMap<InitialSetupDataModelKey, Object> initialDataSetMap = new HashMap<InitialSetupDataModelKey, Object>();
        HashSet<Integer> inflowControlSet = new HashSet<Integer>();
        HashSet<Integer> dataOverflowWatchSet = new HashSet<Integer>();
        HashSet<Integer> cacheModeSet = new HashSet<Integer>();
        HashSet<Integer> timerTypeSet = new HashSet<Integer>();
        HashSet<Boolean> usedExctgJnlSet = new HashSet<Boolean>();
        for (SJmoUniversalReplicatorJnlGrp jnlg : jnlgList) {
            inflowControlSet.add(jnlg.getIoDelay());
            dataOverflowWatchSet.add(jnlg.getDataOverFlowWatch());
            cacheModeSet.add(jnlg.getActionMode());
            timerTypeSet.add(jnlg.getTimerKind());
            ArrayList<SJmoUniversalReplicatorJnlGrpMirror> mirrorList = jnlg.getMirrors();
            for (SJmoUniversalReplicatorJnlGrpMirror mirror : mirrorList) {
                usedExctgJnlSet.add(mirror.isBelongToEXCTG() && mirror.isSuperVisor());
            }
        }
        initialDataSetMap.put(InitialSetupDataModelKey.INFLOW_CONTROL, inflowControlSet);
        initialDataSetMap.put(InitialSetupDataModelKey.DATA_OVERFLOW_WATCH, dataOverflowWatchSet);
        initialDataSetMap.put(InitialSetupDataModelKey.CACHE_MODE, cacheModeSet);
        initialDataSetMap.put(InitialSetupDataModelKey.TIMER_TYPE, timerTypeSet);
        initialDataSetMap.put(InitialSetupDataModelKey.STATUS_EDITABLE_OPTION_TIMER_TYPE, editableOptTimerType);
        initialDataSetMap.put(InitialSetupDataModelKey.STATUS_EDITABLE_OPTION_OTHER, editableOptOther);
        initialDataSetMap.put(InitialSetupDataModelKey.USED_EXCTG_JOURNAL, usedExctgJnlSet);
        this.initialSetupInflowControlDataModel(initialDataSetMap);
        this.initialSetupCacheModeDataModel(initialDataSetMap);
        this.initialSetupTimerTypeModeDataModel(initialDataSetMap);
        this.putCache(KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION, jnlgList);
        ArrayList<SJmoUniversalReplicatorJnlGrp> jnlgListCopy = new ArrayList<SJmoUniversalReplicatorJnlGrp>();
        for (SJmoUniversalReplicatorJnlGrp jnlg : jnlgList) {
            try {
                jnlgListCopy.add((SJmoUniversalReplicatorJnlGrp)jnlg.clone());
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("initialSetupDataModel", "Information of SJmoUniversalReplicatorJnlGrp cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        this.putCache(KEY_EDIT_JOURNAL_OPTIONS_CACHE_JOURNAL_LIST_INFORMATION_ORIGINAL, jnlgListCopy);
    }

    private void initialSetupInflowControlDataModel(Map<InitialSetupDataModelKey, Object> initialDataSetMap) {
        SJctrInflowControlDataModel inflowDataModel = this.getInflowControlDataModel();
        boolean editableOptOther = (Boolean)initialDataSetMap.get((Object)InitialSetupDataModelKey.STATUS_EDITABLE_OPTION_OTHER);
        if (editableOptOther) {
            Set inflowControlSet = (Set)initialDataSetMap.get((Object)InitialSetupDataModelKey.INFLOW_CONTROL);
            if (inflowControlSet.size() == 1) {
                inflowDataModel.setSelect((Integer)inflowControlSet.iterator().next());
            } else {
                inflowDataModel.setSelect(-1);
            }
            if (inflowDataModel.getSelect() == 0) {
                inflowDataModel.changeInflowControlTextBoxType(0);
                Set dataOverflowWatchSet = (Set)initialDataSetMap.get((Object)InitialSetupDataModelKey.DATA_OVERFLOW_WATCH);
                if (dataOverflowWatchSet.size() == 1) {
                    inflowDataModel.setDisplayDataOverflowWatch(String.valueOf(dataOverflowWatchSet.iterator().next()));
                } else {
                    inflowDataModel.setDisplayDataOverflowWatch("");
                }
                inflowDataModel.setDataOverflowWatchEnable(true);
            } else {
                inflowDataModel.changeInflowControlTextBoxType(1);
                inflowDataModel.setDisplayDataOverflowWatch("");
                inflowDataModel.setDataOverflowWatchEnable(false);
            }
        } else {
            inflowDataModel.setEnable(false);
        }
    }

    private void initialSetupCacheModeDataModel(Map<InitialSetupDataModelKey, Object> initialDataSetMap) {
        SJctrCacheModeDataModel cacheModeDataModel = this.getCacheModeDataModel();
        boolean editableOptOther = (Boolean)initialDataSetMap.get((Object)InitialSetupDataModelKey.STATUS_EDITABLE_OPTION_OTHER);
        if (editableOptOther) {
            Set cacheModeSet = (Set)initialDataSetMap.get((Object)InitialSetupDataModelKey.CACHE_MODE);
            if (cacheModeSet.size() == 1) {
                cacheModeDataModel.setSelect((Integer)cacheModeSet.iterator().next());
            } else {
                cacheModeDataModel.setSelect(-1);
            }
        } else {
            cacheModeDataModel.setEnable(false);
        }
    }

    private void initialSetupTimerTypeModeDataModel(Map<InitialSetupDataModelKey, Object> initialDataSetMap) {
        SJctrTimerTypeDataModel timerTypeDataModel = this.getTimerTypeDataModel();
        boolean editableOptTimerType = (Boolean)initialDataSetMap.get((Object)InitialSetupDataModelKey.STATUS_EDITABLE_OPTION_TIMER_TYPE);
        if (editableOptTimerType) {
            Set timerTypeSet = (Set)initialDataSetMap.get((Object)InitialSetupDataModelKey.TIMER_TYPE);
            if (timerTypeSet.size() == 1) {
                timerTypeDataModel.setTimerType((Integer)timerTypeSet.iterator().next());
            } else {
                timerTypeDataModel.setTimerType(-1);
            }
        } else {
            timerTypeDataModel.setEnable(false);
        }
        Set usedExctgJnlSet = (Set)initialDataSetMap.get((Object)InitialSetupDataModelKey.USED_EXCTG_JOURNAL);
        boolean usedExctgJnl = usedExctgJnlSet.contains(true);
        timerTypeDataModel.setUsedExctgJnl(usedExctgJnl);
    }

    private List<SJmoUniversalReplicatorJnlGrp> getMergeJnlGrpList(List<SJmoUniversalReplicatorJnlGrp> jnlgList, List<SJmoUniversalReplicatorJnlGrp> jnlgOriginalList) {
        ArrayList<SJmoUniversalReplicatorJnlGrp> retJnlgList = new ArrayList<SJmoUniversalReplicatorJnlGrp>();
        SJctrInflowControlDataModel inflowDataModel = this.getInflowControlDataModel();
        SJctrCacheModeDataModel cacheModeDataModel = this.getCacheModeDataModel();
        SJctrTimerTypeDataModel timerTypeDataModel = this.getTimerTypeDataModel();
        boolean inflowCheck = inflowDataModel.isSelectCheckBox();
        boolean cacheCheck = cacheModeDataModel.isSelectCheckBox();
        boolean timerCheck = timerTypeDataModel.isSelectCheckBox();
        int inflowControlSelect = inflowDataModel.getSelect();
        for (int i = 0; i < jnlgList.size(); ++i) {
            SJmoUniversalReplicatorJnlGrp jnlGrpModel = jnlgList.get(i);
            SJmoUniversalReplicatorJnlGrp jnlGrpCopyModel = jnlgOriginalList.get(i);
            if (inflowCheck) {
                jnlGrpModel.setIoDelay(inflowControlSelect);
                if (inflowControlSelect == 0) {
                    jnlGrpModel.setDataOverFlowWatch(Integer.parseInt(inflowDataModel.getDisplayDataOverflowWatch()));
                } else {
                    jnlGrpModel.setDataOverFlowWatch(jnlGrpCopyModel.getDataOverFlowWatch());
                }
            } else {
                jnlGrpModel.setIoDelay(jnlGrpCopyModel.getIoDelay());
                jnlGrpModel.setDataOverFlowWatch(jnlGrpCopyModel.getDataOverFlowWatch());
            }
            if (cacheCheck) {
                jnlGrpModel.setActionMode(cacheModeDataModel.getSelect());
            } else {
                jnlGrpModel.setActionMode(jnlGrpCopyModel.getActionMode());
            }
            if (timerCheck) {
                jnlGrpModel.setTimerKind(timerTypeDataModel.getTimerType());
            } else {
                jnlGrpModel.setTimerKind(jnlGrpCopyModel.getTimerKind());
            }
            retJnlgList.add(jnlGrpModel);
        }
        return retJnlgList;
    }

    public List<SJmoLdevDetail> checkAndGetExistLdevInfo(List<SJmoLdevIndex> journalLdevIndexList, List<SJmoLdevDetail> allLdevInfoList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>();
        for (SJmoLdevIndex ldevIndex : journalLdevIndexList) {
            SJmoLdevDetail ldevDetail;
            try {
                ldevDetail = allLdevInfoList.get(ldevIndex.getSLdev());
            }
            catch (IndexOutOfBoundsException e) {
                this.logUty.putlog("checkAndGetExistLdevInfo", "Information of SJmoLdevDetail is null.");
                SJctrError err = new SJctrError(210, 22, 206505);
                SJcException exp = err.createException();
                throw exp;
            }
            retList.add(ldevDetail);
        }
        return retList;
    }

    public boolean existResourceJournalVol(SJmoUniversalReplicatorJnlGrp jnlg, SJctrResourceGroupUtility rsgUtil) {
        boolean sizeEqual = false;
        ArrayList<SJmoLdevIndex> jnlVolList = jnlg.getJnlVols();
        List<SJmoLdevIndex> extractResult = rsgUtil.extractLdev(jnlg.getJnlVols());
        if (jnlVolList.size() == extractResult.size()) {
            sizeEqual = true;
        }
        return sizeEqual;
    }

    public boolean existResourceDataVol(SJmoUniversalReplicatorJnlGrp jnlg, SJctrResourceGroupUtility rsgUtil) {
        SJmoUniversalReplicatorPairVolInfoMgr allURPairMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        SJmoReplicationPairVolInfo[] pairVolInfos = allURPairMgr.getPairVolInfoList();
        ArrayList<SJmoReplicationPairVolInfo> extractTargetPairVolInfo = new ArrayList<SJmoReplicationPairVolInfo>();
        int jnlAttribute = jnlg.getAttribute();
        if (jnlAttribute == 0) {
            return true;
        }
        block0: for (SJmoReplicationPairVolInfo pairVolInfo : pairVolInfos) {
            List<? extends SJmoLdevIndex> remoteVolInfoList = SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(pairVolInfo);
            for (SJmoUniversalReplicatorPairVolInfo sJmoUniversalReplicatorPairVolInfo : remoteVolInfoList) {
                int jnlgId = sJmoUniversalReplicatorPairVolInfo.getPairKind() == 0 ? sJmoUniversalReplicatorPairVolInfo.getRJnlGrpId() : sJmoUniversalReplicatorPairVolInfo.getMJnlGrpId();
                if (jnlg.getIJnlGroupId() != jnlgId) continue;
                extractTargetPairVolInfo.add(pairVolInfo);
                continue block0;
            }
        }
        boolean sizeEqual = false;
        List<SJmoLdevIndex> extractResult = rsgUtil.extractLdev(extractTargetPairVolInfo);
        if (extractResult.size() == extractTargetPairVolInfo.size()) {
            sizeEqual = true;
        }
        return sizeEqual;
    }

    private boolean isEditableOptionTimerType(List<SJmoUniversalReplicatorJnlGrp> jnlgList) {
        boolean editable = true;
        if (jnlgList.get(0).getValidty() == 2) {
            for (SJmoUniversalReplicatorJnlGrp jnlg : jnlgList) {
                if (SJctrRemoteReplicationUtility.checkAvailableFunction(jnlg, SJctrRemoteReplicationDataMacro.FUNC_EDIT_JNL_OPT_EDIT_TIMER_TYPE)) continue;
                editable = false;
                break;
            }
        } else {
            editable = false;
        }
        return editable;
    }

    private boolean isEditableOptionOther(List<SJmoUniversalReplicatorJnlGrp> jnlgList) {
        boolean editable = true;
        for (SJmoUniversalReplicatorJnlGrp jnlg : jnlgList) {
            if (SJctrRemoteReplicationUtility.checkAvailableFunction(jnlg, SJctrRemoteReplicationDataMacro.FUNC_EDIT_JNL_OPT_EDIT_OTHER)) continue;
            editable = false;
            break;
        }
        return editable;
    }

    private SJctrInflowControlDataModel getInflowControlDataModel() {
        return (SJctrInflowControlDataModel)this.getDataObjectModel("COM_INFLOW_CONTROL_INF");
    }

    private SJctrCacheModeDataModel getCacheModeDataModel() {
        return (SJctrCacheModeDataModel)this.getDataObjectModel("COM_CACHE_MODE_INF");
    }

    private SJctrTimerTypeDataModel getTimerTypeDataModel() {
        return (SJctrTimerTypeDataModel)this.getDataObjectModel("COM_TIMER_TYPE_INF");
    }

    public static enum EDIT_JOURNAL_OPTIONS_MSG implements SJctrNotifyState
    {
        SELECT_INFLOW_CONTROL;

    }

    private static enum InitialSetupDataModelKey {
        INFLOW_CONTROL,
        DATA_OVERFLOW_WATCH,
        CACHE_MODE,
        TIMER_TYPE,
        STATUS_EDITABLE_OPTION_TIMER_TYPE,
        STATUS_EDITABLE_OPTION_OTHER,
        USED_EXCTG_JOURNAL;

    }
}

