/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editquorumdisks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.remote.editquorumdisks.SJctrEditQuorumDisksConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;

public class SJctrEditQuorumDisksDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17834113;
    private static final String DISP_TITLE = "EDIT_QUORUM_DISKS";
    private static final String KEY_BLK_RM_PATH_MON_TITLE = "COM_BLK_RM_PATH_MON_TITLE";
    private static final String KEY_BLK_RM_PATH_MON_TEXTBOX = "COM_BLK_RM_PATH_MON_TEXTBOX";
    private static final String KEY_QUORUM_INFO_LIST = "COM_QUORUM_INFO_LIST";

    public SJctrEditQuorumDisksDC() {
        super(17834113);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        SJctrSimpleDataModel blkRmPathMonTitleBoxModel = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_BLK_RM_PATH_MON_TITLE, blkRmPathMonTitleBoxModel);
        SJctrTextBoxDataModel blkRmPathMonTxtBoxModel = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_BLK_RM_PATH_MON_TEXTBOX, blkRmPathMonTxtBoxModel);
        blkRmPathMonTxtBoxModel.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetQuorumDiskInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoQuorumDiskInfo> quorumDiskListInfo = SJctrHaUtility.getSJmoQuorumDiskInfo(this);
            List<SJmoQuorumDiskInfo> selectedQuorumDisksListInfo = this.getProxy().getCache("KEY_SELECTED_QUORUM_DISKS");
            if (null == selectedQuorumDisksListInfo) {
                this.logUty.putlog("constructData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selectedQuorumDisksListInfo.size()) {
                this.logUty.putlog("constructData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoQuorumDiskInfo> quorumDisksInfoList = SJctrHaUtility.checkAndGetExistQuorumInfo(selectedQuorumDisksListInfo, quorumDiskListInfo);
            if (!SJctrHaUtility.isAllSupportActActQuorumDisk(quorumDisksInfoList)) {
                this.logUty.putlog("constructData", "QuorumDisk is not ActiveActive Support.");
                SJctrError err = new SJctrError(210, 22, 206294);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrTextBoxDataModel blkRMPathMonTxtBoxModel = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_BLK_RM_PATH_MON_TEXTBOX);
            blkRMPathMonTxtBoxModel.setValue(this.getMixedBlkRMPathMonSec(quorumDisksInfoList));
            blkRMPathMonTxtBoxModel.setMin(Integer.toString(5));
            blkRMPathMonTxtBoxModel.setMax(Integer.toString(100));
            this.putCache(KEY_QUORUM_INFO_LIST, quorumDisksInfoList);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private String getMixedBlkRMPathMonSec(List<SJmoQuorumDiskInfo> quorumInfo) {
        String ret = Integer.toString(quorumInfo.get(0).getIReadResGuaranteedTime());
        for (SJmoQuorumDiskInfo quorumDiskInfo : quorumInfo) {
            if (ret.equals(Integer.toString(quorumDiskInfo.getIReadResGuaranteedTime()))) continue;
            ret = "";
            break;
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrEditQuorumDisksConfirmData confirmData = new SJctrEditQuorumDisksConfirmData();
            List<?> selectedQuorumInfoList = this.getCache(KEY_QUORUM_INFO_LIST);
            ArrayList<SJmoQuorumDiskInfo> quorumListInfo = new ArrayList<SJmoQuorumDiskInfo>();
            for (SJmoQuorumDiskInfo quorumInfo : selectedQuorumInfoList) {
                try {
                    quorumListInfo.add((SJmoQuorumDiskInfo)quorumInfo.clone());
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("checkEndData", "Information of SJmoQuorumDiskInfo cannot clone.");
                    SJctrError err = new SJctrError(210, 22, 107003);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            SJctrTextBoxDataModel blkRmPathMonTxtBoxModel = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_BLK_RM_PATH_MON_TEXTBOX);
            for (SJmoQuorumDiskInfo quorumInfo : quorumListInfo) {
                try {
                    int iBlkRmPathMonTime = Integer.parseInt(blkRmPathMonTxtBoxModel.getValue());
                    quorumInfo.setIReadResGuaranteedTime(iBlkRmPathMonTime);
                }
                catch (NumberFormatException e) {
                    this.logUty.putlog("checkEndData", "The error occurred at the Blocked Remote Path Monitoring getting. NumberFormatException : " + e.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
            }
            confirmData.setQuorumInfo(quorumListInfo);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditQuorumDisksConfirmData> confirmDataList = new ArrayList<SJctrEditQuorumDisksConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditQuorumDisksConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }
}

