/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editremoteconnopts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.remote.editremoteconnopts.SJctrEditRemoteConnOptsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;

public class SJctrEditRemoteConnOptsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831457;
    private static final String DISP_TITLE = "EDIT_REMOTE_CONN_OPTS";
    private static final String KEY_MIN_PATHS_TITLE = "COM_MIN_PATHS_TITLE";
    private static final String KEY_MIN_PATHS_COMBOBOX = "COM_MIN_PATHS_COMBOBOX";
    private static final String KEY_RIO_MIH_TIME_TITLE = "COM_RIO_MIH_TIME_TITLE";
    private static final String KEY_RIO_MIH_TIME_TEXTBOX = "COM_RIO_MIH_TIME_TEXTBOX";
    private static final String KEY_ROUND_TRIP_TIME_TITLE = "COM_ROUND_TRIP_TIME_TITLE";
    private static final String KEY_ROUND_TRIP_TIME_TEXTBOX = "COM_ROUND_TRIP_TIME_TEXTBOX";
    private static final String KEY_FREEZE_OPTION_TITLE = "COM_FREEZE_OPTION_TITLE";
    private static final String KEY_FREEZE_OPTION_RADIOBUTTON = "COM_FREEZE_OPTION_RADIOBUTTON";
    private static final String KEY_ENABLE = "COM_ENABLE";
    private static final String KEY_DISABLE = "COM_DISABLE";
    private static final String KEY_CHECKBOX = "COM_CHECKBOX";
    private static final String KEY_RCU_INFO_LIST = "COM_RCU_INFO_LIST";
    private static final String KEY_SELECTED_CONN_TYPE = "COM_SELECTED_CONN_TYPE";

    public SJctrEditRemoteConnOptsDC() {
        super(17831457);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrSimpleDataModel minPathsTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_MIN_PATHS_TITLE, minPathsTitleBox);
        SJctrCheckBoxDataModel minPathsCheckBox = new SJctrCheckBoxDataModel();
        minPathsCheckBox.setSelect(false);
        minPathsTitleBox.addDataModel(KEY_CHECKBOX, minPathsCheckBox);
        SJctrComboBoxDataModel minPathsPulldown = new SJctrComboBoxDataModel();
        this.addDataObjectModel(KEY_MIN_PATHS_COMBOBOX, minPathsPulldown);
        minPathsCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        minPathsPulldown.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrSimpleDataModel rioMihTimeTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_RIO_MIH_TIME_TITLE, rioMihTimeTitleBox);
        SJctrCheckBoxDataModel rioMihTimeCheckBox = new SJctrCheckBoxDataModel();
        rioMihTimeCheckBox.setSelect(false);
        rioMihTimeTitleBox.addDataModel(KEY_CHECKBOX, rioMihTimeCheckBox);
        SJctrTextBoxDataModel rioMihTimeText = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_RIO_MIH_TIME_TEXTBOX, rioMihTimeText);
        rioMihTimeCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        rioMihTimeText.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrSimpleDataModel roundTripTimeTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_ROUND_TRIP_TIME_TITLE, roundTripTimeTitleBox);
        SJctrCheckBoxDataModel roundTripTimeCheckBox = new SJctrCheckBoxDataModel();
        roundTripTimeCheckBox.setSelect(false);
        roundTripTimeTitleBox.addDataModel(KEY_CHECKBOX, roundTripTimeCheckBox);
        SJctrTextBoxDataModel roundTripTimeText = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_ROUND_TRIP_TIME_TEXTBOX, roundTripTimeText);
        roundTripTimeCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        roundTripTimeText.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrSimpleDataModel freezeOptionTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_FREEZE_OPTION_TITLE, freezeOptionTitleBox);
        SJctrCheckBoxDataModel freezeOptionCheckBox = new SJctrCheckBoxDataModel();
        freezeOptionCheckBox.setSelect(false);
        freezeOptionTitleBox.addDataModel(KEY_CHECKBOX, freezeOptionCheckBox);
        freezeOptionCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        SJctrRadioButtonGroupDataModel freezeOptRadio = new SJctrRadioButtonGroupDataModel();
        freezeOptRadio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                }
            }
        });
        this.addDataObjectModel(KEY_FREEZE_OPTION_RADIOBUTTON, freezeOptRadio);
        freezeOptRadio.add(KEY_ENABLE);
        freezeOptRadio.add(KEY_DISABLE);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> rcuInfoList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
        if (null == rcuInfoList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == rcuInfoList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRemoteReplicationRCUInfo viewData = (SJmoRemoteReplicationRCUInfo)rcuInfoList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkStartData", "Information of selected RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            List<SJmoRemoteReplicationRCUInfo> rcuInfoList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
            List<SJmoRemoteReplicationRCUInfo> selectedRCUInfoList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfoSelectableClone(rcuInfoList, mrcuInfoMgr, false);
            this.putCache(KEY_RCU_INFO_LIST, selectedRCUInfoList);
            SJmoRemoteReplicationRCUInfo selectedInfo = selectedRCUInfoList.get(0);
            SJctrResourceGroupUtility rsgUtil = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(this);
            if (!SJctrRemoteReplicationUtility.hasRcuPortRs(selectedInfo, rsgUtil)) {
                this.logUty.putlog("checkConstructData", "Not authorized port in selected RCU.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206041);
            }
            if (selectedInfo.getRCUOption().getINumofMimPath() > selectedInfo.getPathInfoList().size()) {
                this.logUty.putlog("checkConstructData", "Can't edit remote connection options because set path count under the minimum path count.");
                SJctrError err = new SJctrError(210, 22, 206149);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
            SJctrComboBoxDataModel minPathsSelected = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_MIN_PATHS_COMBOBOX);
            String minPaths = remoteReplicaUty.getMinNumOfPathsString(selectedInfo);
            minPathsSelected.setData((Serializable)((Object)minPaths));
            try {
                int intminPaths = Integer.parseInt(minPaths);
                this.createMinPathPullDown(minPathsSelected, intminPaths, selectedInfo);
            }
            catch (NumberFormatException e) {
                this.logUty.putlog("checkConstructData", "The error occurred at the Minimum Number of Paths getting. NumberFormatException : " + e.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            SJctrTextBoxDataModel rioMihTimeSelected = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_RIO_MIH_TIME_TEXTBOX);
            String rioMihTime = remoteReplicaUty.getRioMihTimeString(selectedInfo);
            rioMihTimeSelected.setValue(rioMihTime);
            SJctrTextBoxDataModel roundTripTimeSelected = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ROUND_TRIP_TIME_TEXTBOX);
            String roundTripTime = remoteReplicaUty.getRoundTripTimeString(selectedInfo);
            roundTripTimeSelected.setValue(roundTripTime);
            SJctrRadioButtonGroupDataModel freezeOptSelected = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_FREEZE_OPTION_RADIOBUTTON);
            int freezeOptFlg = selectedInfo.getRCUOption().getIFreezeOption();
            if (1 == freezeOptFlg) {
                freezeOptSelected.setSelect(KEY_ENABLE);
            } else {
                freezeOptSelected.setSelect(KEY_DISABLE);
            }
            rioMihTimeSelected.setMin(Integer.toString(10));
            rioMihTimeSelected.setMax(Integer.toString(100));
            roundTripTimeSelected.setLabel(this.getComUtility().getGuidance("ROUND_TRIP_TIME_EXPLAIN"));
            int connType = selectedInfo.getICUFree();
            if (connType == 1) {
                ((SJctrNestedListDataObject)minPathsSelected.getManageData()).setData("COM_MIN_NUM_OF_PATHS_HELP", this.getComUtility().getGuidance("MIN_NUM_PATH_EXPLAIN"));
            } else {
                ((SJctrNestedListDataObject)minPathsSelected.getManageData()).setData("COM_MIN_NUM_OF_PATHS_HELP", "");
            }
            this.getManageData().setData(KEY_SELECTED_CONN_TYPE, connType);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrSimpleDataModel freezeOptTitle;
            SJctrCheckBoxDataModel freezeOptCheck;
            SJctrSimpleDataModel roundTripTimeTitle;
            SJctrCheckBoxDataModel roundTripTimeCheck;
            SJctrSimpleDataModel rioMIHTimeTitle;
            SJctrCheckBoxDataModel rioMIHTimeCheck;
            SJctrEditRemoteConnOptsConfirmData confirmData = new SJctrEditRemoteConnOptsConfirmData();
            List<?> selectedRCUInfoList = this.getCache(KEY_RCU_INFO_LIST);
            SJmoRemoteReplicationRCUInfo rcuInfo = null;
            try {
                rcuInfo = (SJmoRemoteReplicationRCUInfo)((SJmoRemoteReplicationRCUInfo)selectedRCUInfoList.get(0)).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("checkEndData", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107003);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoRemoteReplicationRCUOptionInfo rcuOption = rcuInfo.getRCUOption();
            SJctrSimpleDataModel minPathsTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_MIN_PATHS_TITLE);
            SJctrCheckBoxDataModel minPathsCheck = (SJctrCheckBoxDataModel)minPathsTitle.getDataModel(KEY_CHECKBOX);
            if (minPathsCheck.isSelect()) {
                SJctrComboBoxDataModel minPathsPulldown = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_MIN_PATHS_COMBOBOX);
                try {
                    int minPathPull = Integer.parseInt(minPathsPulldown.getSelection());
                    rcuOption.setINumofMimPath(minPathPull);
                }
                catch (NumberFormatException e) {
                    this.logUty.putlog("checkEndData", "The error occurred at the Minimum Number of Paths getting. NumberFormatException : " + e.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
            }
            if ((rioMIHTimeCheck = (SJctrCheckBoxDataModel)(rioMIHTimeTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_RIO_MIH_TIME_TITLE)).getDataModel(KEY_CHECKBOX)).isSelect()) {
                SJctrTextBoxDataModel rioMIHTimeText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_RIO_MIH_TIME_TEXTBOX);
                try {
                    int rioMIHTime = Integer.parseInt(rioMIHTimeText.getValue());
                    rcuOption.setIRIOMIHTime(rioMIHTime);
                }
                catch (NumberFormatException e) {
                    this.logUty.putlog("checkEndData", "The error occurred at the RIO MIH TIME getting. NumberFormatException : " + e.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
            }
            if ((roundTripTimeCheck = (SJctrCheckBoxDataModel)(roundTripTimeTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_ROUND_TRIP_TIME_TITLE)).getDataModel(KEY_CHECKBOX)).isSelect()) {
                SJctrTextBoxDataModel roundTripTimeText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_ROUND_TRIP_TIME_TEXTBOX);
                try {
                    int roundTripTime = Integer.parseInt(roundTripTimeText.getValue());
                    rcuOption.setIRtTime(roundTripTime);
                }
                catch (NumberFormatException e) {
                    this.logUty.putlog("checkEndData", "The error occurred at the ROUND TRIP TIME getting. NumberFormatException : " + e.getMessage());
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
                }
            }
            if ((freezeOptCheck = (SJctrCheckBoxDataModel)(freezeOptTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_FREEZE_OPTION_TITLE)).getDataModel(KEY_CHECKBOX)).isSelect()) {
                SJctrRadioButtonGroupDataModel freezeOptRadio = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_FREEZE_OPTION_RADIOBUTTON);
                int freezeOpt = this.comvFreezeOption(freezeOptRadio.getSelect());
                rcuOption.setIFreezeOption(freezeOpt);
            }
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            confirmData.setRCUInfo(rcuInfoList);
            ArrayList<SJctrEditRemoteConnOptsConfirmData> confirmDataList = new ArrayList<SJctrEditRemoteConnOptsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditRemoteConnOptsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }

    private int comvFreezeOption(String strFreezeOpt) {
        int freezeOpt = -1;
        if (null != strFreezeOpt) {
            if (strFreezeOpt.equals(KEY_ENABLE)) {
                freezeOpt = 1;
            } else if (strFreezeOpt.equals(KEY_DISABLE)) {
                freezeOpt = 0;
            }
        }
        return freezeOpt;
    }

    private void createMinPathPullDown(SJctrComboBoxDataModel comboObj, int intminPaths, SJmoRemoteReplicationRCUInfo selectedInfo) {
        int min;
        ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList = selectedInfo.getPathInfoList();
        int numOfPaths = pathInfoList.size();
        for (int i = min = 1; i <= numOfPaths; ++i) {
            String str = SJctrComUtility.toDecString(i);
            comboObj.addItem(str);
        }
        comboObj.setEnable(true);
        comboObj.setSelectedIndex(intminPaths - 1);
    }
}

