/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.HURchangeSystemOption;
import sanproject.serverux.dataimpl.HURerrorDetail;
import sanproject.serverux.dataimpl.HURerrorSummary;
import sanproject.serverux.dataimpl.RCErrorDetail;
import sanproject.serverux.dataimpl.RCErrorInf;
import sanproject.serverux.dataimpl.RMCPCLPRofCUOption;
import sanproject.serverux.dataimpl.RMCPCUOption;
import sanproject.serverux.dataimpl.RMCPCUOptionMode;
import sanproject.serverux.dataimpl.RMCPCUofCUOption;
import sanproject.serverux.dataimpl.RMCPSLPRofCUOption;
import sanproject.serverux.dataimpl.RMCPSystemofCUOption;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationRcBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts.SJctrEditRemoteReplicaOptsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts.SJctrUniversalReplicatorCuOptionInfo;
import sanproject.sn2.controller.wizard.replication.remote.editremotereplicaopts.SJctrUniversalReplicatorSystemInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCuOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyCUOptionSystemInfo;

public class SJctrEditRemoteReplicaOptsAC
extends SJctrOperationRcBaseAC {
    private static final long serialVersionUID = -5936938661915906611L;
    private SJmoTrueCopyCUOptionSystemInfo systemOptInfoTc = new SJmoTrueCopyCUOptionSystemInfo();
    private List<SJmoRemoteReplicationCuOptionInfo> cuOptInfoTc = new ArrayList<SJmoRemoteReplicationCuOptionInfo>();
    private SJctrUniversalReplicatorSystemInfo systemOptInfoUr = new SJctrUniversalReplicatorSystemInfo();
    private List<SJctrUniversalReplicatorCuOptionInfo> cuOptInfoUr = new ArrayList<SJctrUniversalReplicatorCuOptionInfo>();
    private int copytype = -1;
    private static final int PATH_BLOCADE_SIM_WATCH_OPT_INDEX = 0;
    private static final int SERVICES_SIM_RC_OPT_INDEX = 1;
    private static final int SYSTEM_OPT_MAX_INIT_COPY_ACT_OPT_INDEX = 2;
    private static final int CU_OPT_MAX_INIT_COPY_ACT_OPT_INDEX = 0;
    private static final int CU_OPTION_SIZE = 256;
    private static final int CU_OPTION_ENABLE = 1;
    private static final int CU_OPTION_DISABLE = 0;
    private static final int UR_CU_OPTION_REPORT_SIM_SIZE = 510;
    private static final int UR_CU_OPTION_DISABLE = -1;
    private static final int ERROR_PART_DIGIT = 100;

    public void setApplyData(SJctrEditRemoteReplicaOptsConfirmData confirmData) {
        List<SJmoTrueCopyCUOptionSystemInfo> systemTc = confirmData.getSystemOptInfoTc();
        if (null != systemTc && 0 < systemTc.size()) {
            this.systemOptInfoTc = confirmData.getSystemOptInfoTc().get(0);
        }
        this.cuOptInfoTc = confirmData.getCusOptInfoTc();
        List<SJctrUniversalReplicatorSystemInfo> systemUr = confirmData.getSystemOptInfoUr();
        if (null != systemUr && 0 < systemUr.size()) {
            this.systemOptInfoUr = confirmData.getSystemOptInfoUr().get(0);
        }
        this.cuOptInfoUr = confirmData.getCusOptInfoUr();
        this.copytype = confirmData.getCopyType();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<Serializable> applyList = null;
        if (0 == this.copytype) {
            applyList = this.createTcOption();
        } else if (1 == this.copytype) {
            applyList = this.createUrOption();
        } else if (2 == this.copytype) {
            applyList = this.createHaOption();
        } else {
            SJctrLogUty.info(this.title, "getSetList", "Copy Type is invalid.");
            applyList = new ArrayList();
        }
        return applyList;
    }

    private ArrayList<RMCPCUOptionMode> createTcOption() {
        RMCPCUOptionMode optMode = new RMCPCUOptionMode();
        optMode.mode = 1;
        if (null != this.cuOptInfoTc && 0 < this.cuOptInfoTc.size()) {
            optMode.mode |= 2;
        }
        int[] cuArr = new int[256];
        for (int i = 0; i < cuArr.length; ++i) {
            cuArr[i] = 0;
        }
        RMCPCUOption tcOption = this.initTcSystemApplyParam();
        this.setSystemOptionTC(tcOption, this.systemOptInfoTc);
        this.setCuOptionTC(tcOption, this.cuOptInfoTc, cuArr);
        optMode.setCUs = cuArr;
        optMode.option = tcOption;
        ArrayList<RMCPCUOptionMode> list = new ArrayList<RMCPCUOptionMode>(1);
        list.add(optMode);
        return list;
    }

    private ArrayList<HURchangeSystemOption> createUrOption() {
        HURchangeSystemOption ursystem = this.initUrSystemApplyParam();
        this.setSystemOptionUr(ursystem, this.systemOptInfoUr);
        this.setCuOptionUr(ursystem, this.cuOptInfoUr);
        ArrayList<HURchangeSystemOption> list = new ArrayList<HURchangeSystemOption>(1);
        list.add(ursystem);
        return list;
    }

    private ArrayList<RMCPCUOptionMode> createHaOption() {
        RMCPCUOptionMode optMode = new RMCPCUOptionMode();
        optMode.mode = 16;
        int[] cuArr = new int[256];
        for (int i = 0; i < cuArr.length; ++i) {
            cuArr[i] = 0;
        }
        RMCPCUOption haOption = this.initTcSystemApplyParam();
        this.setSystemOptionTC(haOption, this.systemOptInfoTc);
        this.setCuOptionTC(haOption, this.cuOptInfoTc, cuArr);
        optMode.setCUs = cuArr;
        optMode.option = haOption;
        ArrayList<RMCPCUOptionMode> list = new ArrayList<RMCPCUOptionMode>(1);
        list.add(optMode);
        return list;
    }

    private RMCPCUOption initTcSystemApplyParam() {
        int i;
        RMCPCUOption tcSystemCuinfo = new RMCPCUOption();
        tcSystemCuinfo.LDKC = 0;
        tcSystemCuinfo.CUSetting = new RMCPCUofCUOption[256];
        for (i = 0; i < tcSystemCuinfo.CUSetting.length; ++i) {
            tcSystemCuinfo.CUSetting[i] = new RMCPCUofCUOption();
            tcSystemCuinfo.CUSetting[i].Option = new int[7];
        }
        tcSystemCuinfo.CLPRSetting = new RMCPCLPRofCUOption[32];
        for (i = 0; i < tcSystemCuinfo.CLPRSetting.length; ++i) {
            tcSystemCuinfo.CLPRSetting[i] = new RMCPCLPRofCUOption();
            tcSystemCuinfo.CLPRSetting[i].FuncSW = new int[2];
            tcSystemCuinfo.CLPRSetting[i].Option = new int[8];
        }
        tcSystemCuinfo.SLPRSetting = new RMCPSLPRofCUOption[32];
        for (i = 0; i < tcSystemCuinfo.SLPRSetting.length; ++i) {
            tcSystemCuinfo.SLPRSetting[i] = new RMCPSLPRofCUOption();
            tcSystemCuinfo.SLPRSetting[i].FuncSW = new int[2];
            tcSystemCuinfo.SLPRSetting[i].Option = new int[8];
        }
        tcSystemCuinfo.FuncSWOption = 0;
        tcSystemCuinfo.dummy2 = new int[256];
        return tcSystemCuinfo;
    }

    private void setSystemOptionTC(RMCPCUOption systemCuOptInfo, SJmoTrueCopyCUOptionSystemInfo systeminfo) {
        if (null == systemCuOptInfo || null == systeminfo) {
            return;
        }
        RMCPSystemofCUOption retsysteminfo = new RMCPSystemofCUOption();
        retsysteminfo.FuncSW = new int[2];
        retsysteminfo.Option = new int[6];
        retsysteminfo.MaxInitCopy = systeminfo.getIMaxInitCopy();
        retsysteminfo.PathBlockadeWatch = systeminfo.getIPathBlockadeWatch();
        retsysteminfo.Option[0] = systeminfo.getIPathBlockadeSIMWatch();
        retsysteminfo.Option[1] = systeminfo.getIServiceSIMReport();
        retsysteminfo.Option[2] = systeminfo.getICopyCountFlg();
        retsysteminfo.MaxInitCopyHA = systeminfo.getIMaxInitCopyHA();
        systemCuOptInfo.SystemSetting = retsysteminfo;
    }

    private void setCuOptionTC(RMCPCUOption systemCuOptInfo, List<SJmoRemoteReplicationCuOptionInfo> cuinfolist, int[] cuArr) {
        if (null == systemCuOptInfo || null == cuinfolist || 0 == cuinfolist.size() || null == cuArr || 0 == cuArr.length) {
            return;
        }
        for (SJmoRemoteReplicationCuOptionInfo cuInfo : cuinfolist) {
            int cuindex = cuInfo.getIndex();
            systemCuOptInfo.CUSetting[cuindex].Option[0] = cuInfo.getIDefCopyMaxTrack();
            systemCuOptInfo.CUSetting[cuindex].HostSupport = cuInfo.getIHostSupport();
            systemCuOptInfo.CUSetting[cuindex].RCUServiceSim = cuInfo.getIRcUServiceSim();
            cuArr[cuindex] = 1;
        }
    }

    private HURchangeSystemOption initUrSystemApplyParam() {
        HURchangeSystemOption urSystemCuinfo = new HURchangeSystemOption();
        urSystemCuinfo.flag = 0;
        urSystemCuinfo.reportSIM = new ArrayList(510);
        for (int i = 0; i < 510; ++i) {
            urSystemCuinfo.reportSIM.add(-1);
        }
        return urSystemCuinfo;
    }

    private void setSystemOptionUr(HURchangeSystemOption systemCuOptInfo, SJctrUniversalReplicatorSystemInfo systeminfo) {
        if (null == systemCuOptInfo || null == systeminfo) {
            return;
        }
        systemCuOptInfo.maxInitCopy = systeminfo.getMaxInitCopyAct();
    }

    private void setCuOptionUr(HURchangeSystemOption systemCuOptInfo, List<SJctrUniversalReplicatorCuOptionInfo> cuinfolist) {
        if (null == systemCuOptInfo || null == cuinfolist || 0 == cuinfolist.size()) {
            return;
        }
        for (SJctrUniversalReplicatorCuOptionInfo cuInfo : cuinfolist) {
            int cuindex = cuInfo.getIndex();
            if (SJctrDataController.isHM()) {
                systemCuOptInfo.reportSIM.set(cuindex, -1);
                continue;
            }
            systemCuOptInfo.reportSIM.set(cuindex, cuInfo.getServicesSim());
        }
    }

    @Override
    public int getLeadTime() {
        int leadTime = 3;
        if (0 == this.copytype) {
            leadTime = 3;
        } else if (1 == this.copytype) {
            leadTime = 10;
        } else if (2 == this.copytype) {
            leadTime = 3;
        } else {
            SJctrLogUty.info(this.title, "getLeadTime", "Copy Type is invalid.");
        }
        return leadTime;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        int funcErc = 210;
        int moduleErc = 22;
        int delegateErc = 0;
        SJctrError error = new SJctrError(funcErc, moduleErc, delegateErc);
        if (0 == this.copytype || 2 == this.copytype) {
            if (!(resultObject instanceof RCErrorInf)) {
                error.setError(107001);
                SJcException exp = error.createException();
                throw exp;
            }
            this.setResultDataTC(resultObject);
        } else if (1 == this.copytype) {
            if (!(resultObject instanceof HURerrorSummary)) {
                error.setError(107001);
                SJcException exp = error.createException();
                throw exp;
            }
            this.setResultDataUR(resultObject);
        } else {
            SJctrLogUty.info(this.title, "setApplyResult", "Copy Type is invalid.");
            error.setError(107001);
            this.resultData.add(error);
            SJcException exp = error.createException();
            throw exp;
        }
        this.setError(error);
    }

    private void setResultDataTC(Object resultObject) {
        RCErrorInf errinf = (RCErrorInf)resultObject;
        int funcErc = errinf.ErrorPart / 100;
        int moduleErc = errinf.ErrorPart % 100;
        RCErrorDetail[] detailarr = errinf.tDetail;
        if (null != detailarr) {
            for (int i = 0; i < detailarr.length; ++i) {
                RCErrorDetail detail = detailarr[i];
                if (null == detail || detail.ErrCode == 0) continue;
                SJctrRcOperationError optError = new SJctrRcOperationError(funcErc, moduleErc, detail.ErrCode, i);
                SJcException exp = optError.createException();
                throw exp;
            }
        }
    }

    private void setResultDataUR(Object resultObject) {
        HURerrorSummary errinfo = (HURerrorSummary)resultObject;
        ArrayList detailarr = errinfo.getErrorDetail();
        if (null != detailarr) {
            for (int i = 0; i < detailarr.size(); ++i) {
                HURerrorDetail detail = (HURerrorDetail)detailarr.get(i);
                if (null == detail || detail.ErrCode == 0) continue;
                SJctrRcOperationError optError = new SJctrRcOperationError(detail.ErrPart / 100, detail.ErrPart % 100, detail.ErrCode, i);
                SJcException exp = optError.createException();
                throw exp;
            }
        }
    }
}

