/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.journalproperties;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrLDEVDetailWithJnlInfo;
import sanproject.sn2.controller.wizard.replication.remote.journalproperties.SJctrJournalPropertiesSummaryModel;
import sanproject.sn2.controller.wizard.replication.remote.journalproperties.SJctrJournalVolumesTableModel;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrJournalPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595491;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE = "COM_TABLE_JNL_VOLS";
    public static final String KEY_SELECTED_JOURNAL = "COM_SELECTED_JOURNAL";
    public static final String KEY_JOURNAL_VOLS_APPLY_ERROR = "COM_JOURNAL_VOLS_APPLY_ERROR";

    public SJctrJournalPropertiesDC() throws SJcException {
        super(33595491);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrJournalPropertiesSummaryModel());
        SJctrJournalVolumesTableModel jnlVolsTable = new SJctrJournalVolumesTableModel();
        jnlVolsTable.setPaging(true);
        this.addDataObjectModel(KEY_TABLE, jnlVolsTable);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> jnlDataList = this.getProxy().getCache(KEY_SELECTED_JOURNAL);
        if (null == jnlDataList) {
            this.logUty.putlog("checkStartData", "Journal Group information list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == jnlDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of Journal Group information list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorJnlGrp jnlGrpInfo = (SJmoUniversalReplicatorJnlGrp)jnlDataList.get(0);
        if (null == jnlGrpInfo) {
            this.logUty.putlog("checkStartData", "Size of Journal Group information data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        List<?> jnlGrpList = this.getProxy().getCache(KEY_SELECTED_JOURNAL);
        SJmoUniversalReplicatorJnlGrp jnlGrpInfo = (SJmoUniversalReplicatorJnlGrp)jnlGrpList.get(0);
        List<SJmoLdevDetail> ldevDetailList = SJctrRemoteReplicationUtility.getSJmoLdevDetailFilteredByAllRsg(this);
        SJctrJournalPropertiesSummaryModel summaryModel = (SJctrJournalPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        summaryModel.makeSummaryData(jnlGrpInfo, ldevDetailList);
        SJctrJournalVolumesTableModel jnlVolsTable = (SJctrJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE);
        List<SJmoLdevDetail> jounalVolsDetail = SJctrRemoteReplicationUtility.checkAndGetExistLdevlInfo(jnlGrpInfo.getJnlVols(), ldevDetailList);
        ArrayList<SJctrLDEVDetailWithJnlInfo> jounalVolsDetailWithJnlInfo = new ArrayList<SJctrLDEVDetailWithJnlInfo>();
        for (SJmoLdevDetail selectedLdev : jounalVolsDetail) {
            int type = SJctrRemoteReplicationUtility.getJnlVolType(selectedLdev, jounalVolsDetail);
            SJctrLDEVDetailWithJnlInfo ldevDetailWithJnl = new SJctrLDEVDetailWithJnlInfo(selectedLdev, type);
            jounalVolsDetailWithJnlInfo.add(ldevDetailWithJnl);
        }
        jnlVolsTable.setBasicDataMap(this.getProxy().getCacheMap());
        jnlVolsTable.setBasicDataList(jounalVolsDetailWithJnlInfo);
        return true;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        List<SJctrErrorColumnData> errorInfo = this.getProxy().getCache(KEY_JOURNAL_VOLS_APPLY_ERROR);
        if (null != errorInfo) {
            SJctrJournalVolumesTableModel jnlVolsTable = (SJctrJournalVolumesTableModel)this.getDataObjectModel(KEY_TABLE);
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(KEY_TABLE, errTable);
            errTable.initialize(jnlVolsTable, errorInfo, new SJctrErrorColumnDataComparator());
            errTable.makeDataModel();
        }
    }
}

