/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.removejournals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrEXCTGJnlGrpIdComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrUniversalReplicatorEXCTGJnlGrpInfo;
import sanproject.sn2.controller.wizard.replication.remote.addjournals.com.SJctrExctgStorageSystemUtility;
import sanproject.sn2.controller.wizard.replication.remote.removejournals.SJctrRemoveJournalsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.removejournals.model.SJctrStorageSystemDataModel;
import sanproject.sn2.controller.wizard.replication.remote.removejournals.table.SJctrRemoveJournalsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrRemoveJournalsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831281;
    private static final String DISP_TITLE = "REMOVE_JOURNALS";
    private static final String KEY_MIRROR_ID = "COM_MIRROR_ID";
    private static final String KEY_TOTAL_NUM_OF_JNL_EXCTG = "COM_TOTAL_NUM_OF_JNL_EXCTG";
    private static final String KEY_LOCAL_MODEL_SERIALNO = "COM_LOCAL_MODEL_SERIALNO";
    private static final String KEY_SYSTEM_IMAGE_TYPE = "COM_SYSTEM_IMAGE_TYPE";
    private static final String LOCAL_IMAGE_TYPE = "LOCAL_IMAGE_TYPE";
    private static final String REMOTE_IMAGE_TYPE = "REMOTE_IMAGE_TYPE";
    private static final String KEY_SELECTED_STORAGE_NAME = "COM_SELECTED_STORAGE_NAME";
    private static final String KEY_EVENT_INFORMATION = "COM_EVENT_INFORMATION";
    private static final String KEY_EVENT_ID = "COM_EVENT_ID";
    private static final int EVENT_REMOVE_CHECKBOX = 0;
    private static final int EVENT_RESET_BUTTON = 1;
    private static final int EVENT_REMOVE_BUTTON = 2;
    private static final String KEY_FINISH_BUTTON_ENABLE = "COM_FINISH_BUTTON_ENABLE";
    private static final String KEY_CACHE_INFO_EXCTG_JNLGRP_MAP = "COM_CACHE_INFO_EXCTG_JNLGRP_MAP";
    private static final String KEY_CACHE_INFO_EXCTG_JNLGRP_MAP_LOCAL_KEY = "COM_CACHE_INFO_EXCTG_JNLGRP_MAP_LOCAL_KEY";

    public SJctrRemoveJournalsDC() {
        super(17831281);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorEXCTGMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            this.addDataObjectModel(storageInfo.toString(), new SJctrStorageSystemDataModel());
        }
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
        SJctrSimpleDataModel eventDataModel = new SJctrSimpleDataModel();
        eventDataModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrDataObject) {
                    SJctrDataObject data = (SJctrDataObject)setObject;
                    String storageName = (String)data.getData(SJctrRemoveJournalsDC.KEY_SELECTED_STORAGE_NAME);
                    SJctrRemoveJournalsDC.this.getManageData().setData(SJctrRemoveJournalsDC.KEY_SELECTED_STORAGE_NAME, storageName);
                    RemoveJournalsEventMSG eventMsg = null;
                    Integer eventId = (Integer)data.getData(SJctrRemoveJournalsDC.KEY_EVENT_ID);
                    switch (eventId) {
                        case 0: {
                            eventMsg = RemoveJournalsEventMSG.SELECT_REMOVE_CHECKBOX;
                            break;
                        }
                        case 1: {
                            eventMsg = RemoveJournalsEventMSG.SELECT_RESET_BUTTON;
                            break;
                        }
                        case 2: {
                            eventMsg = RemoveJournalsEventMSG.SELECT_REMOVE_BUTTON;
                        }
                    }
                    if (eventMsg != null) {
                        SJctrRemoveJournalsDC.this.fireMessageEvent(eventMsg);
                    }
                }
            }
        });
        this.addDataObjectModel(KEY_EVENT_INFORMATION, eventDataModel);
    }

    private void initListener() {
        this.addMessageEventListener(RemoveJournalsEventMSG.SELECT_REMOVE_CHECKBOX, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveJournalsDC.this.removeCheckboxAction(event, dstModel);
            }
        });
        this.addMessageEventListener(RemoveJournalsEventMSG.SELECT_RESET_BUTTON, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveJournalsDC.this.resetButtonAction(event, dstModel);
            }
        });
        this.addMessageEventListener(RemoveJournalsEventMSG.SELECT_REMOVE_BUTTON, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveJournalsDC.this.removeButtonAction(event, dstModel);
            }
        });
    }

    private void removeCheckboxAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String storageName = (String)this.getManageData().getData(KEY_SELECTED_STORAGE_NAME);
        SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemDataModel(storageName);
        SJctrRemoveJournalsTableModel tableDataModel = storageDataModel.getJournalsTableModel();
        int calcTotalNumJnls = 0;
        if (storageDataModel.isSelectRemoveCheckBox()) {
            calcTotalNumJnls = -tableDataModel.getRowCount();
            tableDataModel.clearRowData();
        } else {
            Map map = this.getCacheJnlGrpModelMap();
            List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(map, this.getCacheLocalKey());
            SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.valueOf(storageName);
            List key = SJctrExctgStorageSystemUtility.getKey(keysList, storageInfo.getIndex());
            List jnlGrpList = (List)map.get(key);
            calcTotalNumJnls = jnlGrpList.size();
            tableDataModel.addRowData(jnlGrpList);
        }
        tableDataModel.setDirty();
        int totalNum = (Integer)this.getManageData().getData(KEY_TOTAL_NUM_OF_JNL_EXCTG);
        this.getManageData().setData(KEY_TOTAL_NUM_OF_JNL_EXCTG, totalNum += calcTotalNumJnls);
        List removeList = this.getRemoveJnlGrpList();
        this.getManageData().setData(KEY_FINISH_BUTTON_ENABLE, !removeList.isEmpty());
    }

    private void resetButtonAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String storageName = (String)this.getManageData().getData(KEY_SELECTED_STORAGE_NAME);
        SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemDataModel(storageName);
        SJctrRemoveJournalsTableModel tableDataModel = storageDataModel.getJournalsTableModel();
        Map map = this.getCacheJnlGrpModelMap();
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(map, this.getCacheLocalKey());
        SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo = SJctrExctgStorageSystemUtility.StorageSystemInfo.valueOf(storageName);
        List key = SJctrExctgStorageSystemUtility.getKey(keysList, storageInfo.getIndex());
        List jnlGrpList = (List)map.get(key);
        int calcTotalNumJnls = jnlGrpList.size() - tableDataModel.getRowCount();
        tableDataModel.clearRowData();
        tableDataModel.addRowData(jnlGrpList);
        tableDataModel.setDirty();
        int totalNum = (Integer)this.getManageData().getData(KEY_TOTAL_NUM_OF_JNL_EXCTG);
        this.getManageData().setData(KEY_TOTAL_NUM_OF_JNL_EXCTG, totalNum += calcTotalNumJnls);
        List removeList = this.getRemoveJnlGrpList();
        this.getManageData().setData(KEY_FINISH_BUTTON_ENABLE, !removeList.isEmpty());
    }

    private void removeButtonAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String storageName = (String)this.getManageData().getData(KEY_SELECTED_STORAGE_NAME);
        SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemDataModel(storageName);
        SJctrRemoveJournalsTableModel tableDataModel = storageDataModel.getJournalsTableModel();
        int calcTotalNumJnls = tableDataModel.getSelectedRowCount();
        tableDataModel.removeSelectedRowData();
        tableDataModel.setDirty();
        int totalNum = (Integer)this.getManageData().getData(KEY_TOTAL_NUM_OF_JNL_EXCTG);
        this.getManageData().setData(KEY_TOTAL_NUM_OF_JNL_EXCTG, totalNum -= calcTotalNumJnls);
        this.getManageData().setData(KEY_FINISH_BUTTON_ENABLE, true);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> selectedList = this.getCache("KEY_SELECTED_EXCTG");
        if (selectedList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (selectedList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoUniversalReplicatorEXCTG selectedData = (SJmoUniversalReplicatorEXCTG)selectedList.get(0);
        if (selectedData == null) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoUniversalReplicatorEXCTG> selectedList = this.getCache("KEY_SELECTED_EXCTG");
            SJmoUniversalReplicatorEXCTG exctgInfo = (SJmoUniversalReplicatorEXCTG)selectedList.get(0);
            SJmoUniversalReplicatorEXCTGMgr exctgMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorEXCTGMgr(this);
            List<SJmoUniversalReplicatorEXCTG> exctgList = SJctrRemoteReplicationUtility.checkAndGetExistExctgInfo(selectedList, exctgMgr);
            if (!SJctrRemoteReplicationUtility.isExctgUsed(exctgList)) {
                this.logUty.putlog("checkConstructData", "Selected EXCTG is not used.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206128);
            }
            SJmoUniversalReplicatorEXCTG exctg = exctgList.get(0);
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlGrpList = exctg.getJnlGrpList();
            Collections.sort(exctgJnlGrpList);
            Map jnlGrpMap = SJctrExctgStorageSystemUtility.getExctgJnlGrpModelMap(exctgJnlGrpList);
            if (jnlGrpMap.size() == 0 || jnlGrpMap.size() > 4) {
                this.logUty.putlog("checkConstructData", "Registed storage system is invalid. Size = " + jnlGrpMap.size());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
            boolean enableLocalJnlResource = true;
            List localKey = this.getCacheLocalKey();
            List localJnlList = (List)jnlGrpMap.get(localKey);
            if (localJnlList != null) {
                List<SJmoUniversalReplicatorEXCTGJnlGrp> enableLocalJnlList = SJctrExctgStorageSystemUtility.checkAndGetSJmoUniversalReplicatorExctgJnlGrp(localJnlList, this);
                if (enableLocalJnlList.isEmpty() && jnlGrpMap.size() == 1) {
                    this.logUty.putlog("checkConstructData", "Deletable journal does not exist.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206129);
                }
                jnlGrpMap.put(localKey, enableLocalJnlList);
                enableLocalJnlResource = localJnlList.size() == enableLocalJnlList.size();
            }
            this.initialSetupDataModel(exctg);
            this.initialSetupStorageSystemDataModel(jnlGrpMap, enableLocalJnlResource);
            if (localJnlList == null) {
                this.getManageData().setData(KEY_SYSTEM_IMAGE_TYPE, REMOTE_IMAGE_TYPE);
            } else {
                this.getManageData().setData(KEY_SYSTEM_IMAGE_TYPE, LOCAL_IMAGE_TYPE);
            }
            this.getManageData().setData(KEY_FINISH_BUTTON_ENABLE, false);
            ArrayList<Map> cacheList = new ArrayList<Map>();
            cacheList.add(jnlGrpMap);
            this.putCache(KEY_CACHE_INFO_EXCTG_JNLGRP_MAP, cacheList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            List<?> selectedList = this.getCache("KEY_SELECTED_EXCTG");
            SJmoUniversalReplicatorEXCTG exctgInfo = (SJmoUniversalReplicatorEXCTG)selectedList.get(0);
            int exctgId = exctgInfo.getIExCtgId();
            SJctrRemoveJournalsConfirmData confirmData = new SJctrRemoveJournalsConfirmData();
            ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo> sendList = new ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo>();
            List removeJnlGrpList = this.getRemoveJnlGrpList();
            for (SJmoUniversalReplicatorEXCTGJnlGrp removeJnlGrp : removeJnlGrpList) {
                SJctrUniversalReplicatorEXCTGJnlGrpInfo jnlGrpInfo = new SJctrUniversalReplicatorEXCTGJnlGrpInfo(exctgId, removeJnlGrp);
                sendList.add(jnlGrpInfo);
            }
            Collections.sort(sendList);
            confirmData.setJnlgInfo(sendList);
            confirmData.setNeedData(this);
            ArrayList<SJctrRemoveJournalsConfirmData> confirmDataList = new ArrayList<SJctrRemoveJournalsConfirmData>(1);
            confirmDataList.add(confirmData);
            this.putCache(SJctrRemoveJournalsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }

    private void initialSetupDataModel(SJmoUniversalReplicatorEXCTG exctg) {
        SJctrComUtility comUtil = this.getComUtility();
        SJctrRemoteReplicationUtility remoteReplicaUty = comUtil.getRemoteReplicationUtility();
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        SJmoUniversalReplicatorEXCTGJnlGrp jnlGrp = exctg.getJnlGrpList().get(0);
        SJctrDataObject manageData = this.getManageData();
        manageData.setData(KEY_MIRROR_ID, jnlGrp.getMirrorId());
        manageData.setData(KEY_LOCAL_MODEL_SERIALNO, remoteReplicaUty.getModelSNoString(subsysInfo));
        manageData.setData(KEY_TOTAL_NUM_OF_JNL_EXCTG, exctg.getJnlGrpList().size());
    }

    private void initialSetupStorageSystemDataModel(Map<List, List> jnlGrpMap, boolean enableLocalJnlResource) {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
        SJctrComUtility comUtil = this.getComUtility();
        SJctrRemoteReplicationUtility remoteReplicaUty = comUtil.getRemoteReplicationUtility();
        SJctrLdevUtility ldevUtil = comUtil.getLdevUtility();
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(jnlGrpMap, this.getCacheLocalKey());
        int remoteCnt = 0;
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            List jnlGrpList;
            SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemDataModel(storageInfo.toString());
            List key = SJctrExctgStorageSystemUtility.getKey(keysList, storageInfo.getIndex());
            SJctrStorageSystemDataModel.StoragePosition ps = null;
            ps = key == null ? SJctrStorageSystemDataModel.StoragePosition.NO_POSITION : (key.equals(this.getCacheLocalKey()) ? SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION : SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION);
            storageDataModel.setStoragePosition(ps);
            if (ps == SJctrStorageSystemDataModel.StoragePosition.LOCAL_POSITION) {
                jnlGrpList = jnlGrpMap.get(key);
                storageDataModel.setTitleLabel(comUtil.getGuidance("LOCAL_STORAGE_SYS"));
                int modelId = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
                storageDataModel.setModelLabel(comUtil.getGuidance(remoteReplicaUty.getModelGuidancekey(modelId)));
                int sn = Integer.parseInt(subsysInfo.getDKCSNString());
                storageDataModel.setSerialNumberLabel(SJctrComUtility.toPaddingZeroString(sn, SJctrExctgStorageSystemUtility.getSerialNumberDigitNumber(modelId)));
                storageDataModel.setJournalsDataList(jnlGrpList);
                storageDataModel.setEnableRemoveCheckbox(enableLocalJnlResource);
                continue;
            }
            if (ps == SJctrStorageSystemDataModel.StoragePosition.REMOTE_POSITION) {
                jnlGrpList = jnlGrpMap.get(key);
                SJmoUniversalReplicatorEXCTGJnlGrp jnl = (SJmoUniversalReplicatorEXCTGJnlGrp)jnlGrpList.get(0);
                storageDataModel.setTitleLabel(comUtil.getGuidance("STORAGE_SYSTEM") + " " + ++remoteCnt);
                int modelId = jnl.getModelId();
                storageDataModel.setModelLabel(SJctrRemoteReplicationUtility.getModelNameString(modelId, comUtil));
                storageDataModel.setSerialNumberLabel(jnl.getSN());
                storageDataModel.setJournalsDataList(jnlGrpList);
                storageDataModel.setRemoteCommandDeviceLabel(SJctrRemoteReplicationUtility.getExctgRemComDevString(jnl.getRcmdDev(), ldevUtil));
                storageDataModel.setEnableRemoveCheckbox(true);
                continue;
            }
            storageDataModel.setTitleLabel(comUtil.getGuidance("STORAGE_SYSTEM") + " " + ++remoteCnt);
        }
    }

    private List getRemoveJnlGrpList() {
        SJctrExctgStorageSystemUtility.StorageSystemInfo[] storageInfoArray;
        ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> retList = new ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp>();
        Map map = this.getCacheJnlGrpModelMap();
        List[] keysList = SJctrExctgStorageSystemUtility.getSortedExctgJnlGrpMapKeysList(map, this.getCacheLocalKey());
        for (SJctrExctgStorageSystemUtility.StorageSystemInfo storageInfo : storageInfoArray = SJctrExctgStorageSystemUtility.StorageSystemInfo.values()) {
            SJctrStorageSystemDataModel storageDataModel = this.getStorageSystemDataModel(storageInfo.toString());
            SJctrRemoveJournalsTableModel tableModel = storageDataModel.getJournalsTableModel();
            List key = SJctrExctgStorageSystemUtility.getKey(keysList, storageInfo.getIndex());
            if (key == null) continue;
            List jnlList = (List)map.get(key);
            List<Object> jnlTableList = tableModel.getAllRowData();
            if (jnlTableList.size() == jnlList.size()) continue;
            Collections.sort(jnlTableList);
            for (SJmoUniversalReplicatorEXCTGJnlGrp jnlGrpModel : jnlList) {
                int index = Collections.binarySearch(jnlTableList, jnlGrpModel, new SJctrEXCTGJnlGrpIdComparator());
                if (index >= 0) continue;
                retList.add(jnlGrpModel);
            }
        }
        return retList;
    }

    private Map getCacheJnlGrpModelMap() {
        List<?> cacheList = this.getCache(KEY_CACHE_INFO_EXCTG_JNLGRP_MAP);
        Map map = (Map)cacheList.get(0);
        return map;
    }

    private List getCacheLocalKey() {
        List localKey = this.getCache(KEY_CACHE_INFO_EXCTG_JNLGRP_MAP_LOCAL_KEY);
        if (localKey == null) {
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
            localKey = SJctrExctgStorageSystemUtility.createExctgJnlGrpMapLocalKey(subsysInfo, remoteReplicaUty);
            this.putCache(KEY_CACHE_INFO_EXCTG_JNLGRP_MAP_LOCAL_KEY, localKey);
        }
        return localKey;
    }

    private SJctrStorageSystemDataModel getStorageSystemDataModel(String keyInfo) {
        return (SJctrStorageSystemDataModel)this.getDataObjectModel(keyInfo);
    }

    public static enum RemoveJournalsEventMSG implements SJctrNotifyState
    {
        SELECT_REMOVE_CHECKBOX,
        SELECT_RESET_BUTTON,
        SELECT_REMOVE_BUTTON;

    }
}

