/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resyncmirrors;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.HURresync1Pair;
import sanproject.serverux.dataimpl.HURresyncPairs;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationMirrorBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.resyncmirrors.SJctrResyncMirrorsConfirmData;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrResyncMirrorsAC
extends SJctrOperationMirrorBaseAC {
    private static final long serialVersionUID = -8403864880011584061L;
    private List<SJmoUniversalReplicatorPairVolInfo> pairList = null;
    private static final int RESYNC_RANGE_MIRROR = 0;
    private static final int COPY_PRIORITY = 1;
    private static final int RESYNC_NORMAL = 0;
    private static final int RESYNC_DIFF = 1;
    private static final int RESYNC_STANDBY = 2;
    private static final int COPY_START_FLG_NON = 0;
    private static final int COPY_START_FLG = 1;
    private static final int PATH_ID = 0;

    public void setApplyData(SJctrResyncMirrorsConfirmData confirmData) {
        this.applyInfo = confirmData.getMirrorsInfo();
        this.jnlType = confirmData.getCopyType();
        this.pairList = confirmData.getPairList();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<HURresyncPairs> applyList = null;
        ArrayList<HURresyncPairs> applyData = new ArrayList<HURresyncPairs>(1);
        ArrayList<HURresync1Pair> resyncPairList = new ArrayList<HURresync1Pair>(this.applyInfo.size());
        for (int i = 0; i < this.applyInfo.size(); ++i) {
            SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = (SJmoUniversalReplicatorJnlGrpMirror)this.applyInfo.get(i);
            HURresync1Pair resync1Pair = new HURresync1Pair();
            resync1Pair.mirrorID = mirrorInfo.getIMirrorId();
            resync1Pair.rcuSN = mirrorInfo.getPairSN();
            resync1Pair.ldkc = mirrorInfo.getLdkc();
            resync1Pair.modelID = mirrorInfo.getModelId();
            resync1Pair.pvol = SJctrRemoteReplicationUtility.getHUR1DataVol(mirrorInfo.getPDataVol(), this.jnlType);
            resync1Pair.svol = SJctrRemoteReplicationUtility.getHUR1DataVol(mirrorInfo.getSDataVol(), this.jnlType);
            resync1Pair.priority = 1;
            resync1Pair.ctGroup = this.getCtgId(mirrorInfo);
            resync1Pair.range = 0;
            resync1Pair.pathID = 0;
            resync1Pair.mJnlGrp = mirrorInfo.getIJnlGroupId();
            resync1Pair.rJnlGrp = mirrorInfo.getPairJnlGrpId();
            resync1Pair.copyStart = 0;
            resync1Pair.cfw = this.getCFW(i);
            resync1Pair.errLevel = this.pairList.get(i).getErrLv();
            resync1Pair.diffResync = this.getDiffResync(mirrorInfo);
            resyncPairList.add(resync1Pair);
        }
        if (resyncPairList.size() > 0) {
            ((HURresync1Pair)resyncPairList.get((int)(resyncPairList.size() - 1))).copyStart = 1;
        }
        HURresyncPairs resyncPair = new HURresyncPairs();
        resyncPair.flag = this.jnlType;
        resyncPair.pairInfo = resyncPairList;
        applyData.add(resyncPair);
        applyList = applyData;
        return applyList;
    }

    private int getDiffResync(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        int diff = -1;
        switch (mirrorInfo.getDelta()) {
            case 0: {
                diff = 0;
                break;
            }
            case 1: {
                diff = 1;
                break;
            }
            case 2: {
                diff = 2;
                break;
            }
            case 3: {
                diff = 1;
                break;
            }
            default: {
                SJctrLogUty.error(this.title, "getdiffResync", "Invalid data");
            }
        }
        return diff;
    }

    private int getCFW(int index) {
        int cfw = 0;
        if (this.jnlType == 0) {
            cfw = this.pairList.get(index).getCFW();
        }
        return cfw;
    }

    private int getCtgId(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        int ictg = 0;
        if (this.jnlType == 1 && mirrorInfo.getCtGrp() == 1) {
            ictg = mirrorInfo.getCtGrpId();
        }
        return ictg;
    }

    @Override
    public int getLeadTime() {
        int ret = SJctrRemoteReplicationUtility.getLeadTime(this.applyInfo.size(), 1024, 40);
        return ret;
    }
}

