/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynctcpairs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcPairTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.resynctcpairs.SJctrResyncTCPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.resynctcpairs.SJctrResyncTCPairsDataModel;
import sanproject.sn2.controller.wizard.replication.remote.resynctcpairs.SJctrResyncTCPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncTCPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17830961;
    private static final String DISP_TITLE = "RESYNC_PAIRS";
    private static final String KEY_TABLE = "COM_RESYNC_TC_TABLE";
    private static final String KEY_RESYNC_TC_PAIR_MODEL = "COM_RESYNC_TC_PAIR_MODEL";
    protected static final String KEY_COPY_PRIORITY = "COM_COPY_PRIORITY";
    private static final String KEY_BTN_CHANGE = "COM_BTN_CHANGE";
    private static final int NEVER = 0;
    private static final int SVOL_DATA = 1;
    private static final int SVOL_STATUS = 2;

    public SJctrResyncTCPairsDC() {
        super(17830961);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetTrueCopyPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrResyncTCPairsTableModel());
        this.addDataObjectModel(KEY_RESYNC_TC_PAIR_MODEL, new SJctrResyncTCPairsDataModel());
        SJctrTextBoxDataModel copyPrioritySpin = new SJctrTextBoxDataModel();
        copyPrioritySpin.setValue(String.valueOf(32));
        this.addDataObjectModel(KEY_COPY_PRIORITY, copyPrioritySpin);
        SJctrButtonDataModel changeBtn = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BTN_CHANGE, changeBtn);
        changeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                SJctrResyncTCPairsDC.this.changePriority();
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoTrueCopyPairVolInfoMgr allTCPairInfo = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
            List<SJmoTrueCopyPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrRemoteReplicationUtility.chkCacheTrueCopyPairsDetailData(this);
            List<SJmoTrueCopyPairVolInfo> pairExist = SJctrRemoteReplicationUtility.checkAndGetExistTCPairVolInfo(viewData, allTCPairInfo);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(pairExist);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Mixed copytype.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrUserController uc = this.getOwner();
            SJctrRemoteReplicationUtility.checkPpLicenseForTCList(uc, copytype);
            boolean attribute = SJctrRemoteReplicationUtility.isTrueCopyPairPositionPrimary(pairExist);
            if (!attribute) {
                this.logUty.putlog("checkConstructData", "Contained own device of the secondary volume.");
                SJctrError err = new SJctrError(210, 22, 206004);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = SJctrRemoteReplicationUtility.checkResyncTCPairStatus(pairExist);
            if (!st) {
                this.logUty.putlog("checkConstructData", "Contains a pair of invalid pair position.");
                SJctrError err = new SJctrError(210, 22, 206013);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrResyncTCPairsDataModel dataModel = (SJctrResyncTCPairsDataModel)this.getDataObjectModel(KEY_RESYNC_TC_PAIR_MODEL);
            dataModel.setCopytype(copytype);
            dataModel.setPairList(pairExist);
            SJctrResyncTCPairsTableModel table = (SJctrResyncTCPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(pairExist);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        SJctrResyncTCPairsDataModel dataModel = (SJctrResyncTCPairsDataModel)this.getDataObjectModel(KEY_RESYNC_TC_PAIR_MODEL);
        int copyType = dataModel.getCopytype();
        SJctrResyncTCPairsTableModel tbl = (SJctrResyncTCPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        Set<String> inVisibleKeySet = tbl.getinvisibleKeySet(copyType);
        SJctrRemoteReplicationUtility.setColumnVisible(tbl, inVisibleKeySet);
        super.makeDataModel();
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrResyncTCPairsConfirmData confirmData = new SJctrResyncTCPairsConfirmData();
            SJctrRcPairTableDataModelBase table = (SJctrRcPairTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
            confirmData.setLUPathMap(ldevLUPathMap);
            SJmoTrueCopyPairVolInfo pairExample = (SJmoTrueCopyPairVolInfo)selectedList.get(0);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVolInfo(pairExample);
            confirmData.setCopyType(copytype);
            SJctrResyncTCPairsDataModel dataModel = (SJctrResyncTCPairsDataModel)this.getDataObjectModel(KEY_RESYNC_TC_PAIR_MODEL);
            int fenceLevel = -1;
            int copypace = -1;
            boolean blTimeStamp = false;
            SJctrComboBoxDataModel pvolFenceLevel = (SJctrComboBoxDataModel)dataModel.getDataModel("COM_PVOL_FENCE_LEVEL");
            fenceLevel = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(pvolFenceLevel);
            if (copytype == 1) {
                SJctrTextBoxDataModel copyPaceTxt = (SJctrTextBoxDataModel)dataModel.getDataModel("COM_COPY_PACE_TXT");
                copypace = SJctrRemoteReplicationUtility.getValueTextBoxNum(copyPaceTxt);
                copypace |= 0x80;
            } else if (copytype == 0) {
                SJctrComboBoxDataModel copyPacePullDown = (SJctrComboBoxDataModel)dataModel.getDataModel("COM_COPY_PACE_PULLDOWN");
                copypace = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(copyPacePullDown);
                SJctrRadioButtonGroupDataModel sJctrRadioButtonGroupDataModel = (SJctrRadioButtonGroupDataModel)dataModel.getDataModel("COM_TIME_STAMP_TRANSFER");
                blTimeStamp = Boolean.valueOf(sJctrRadioButtonGroupDataModel.getSelect());
            }
            for (SJmoTrueCopyPairVolInfo sJmoTrueCopyPairVolInfo : selectedList) {
                BitSet behavor = sJmoTrueCopyPairVolInfo.getBehaviorBitSet();
                switch (fenceLevel) {
                    case 0: {
                        behavor.set(2, 4, false);
                        break;
                    }
                    case 1: {
                        behavor.set(2, true);
                        behavor.set(3, 4, false);
                        break;
                    }
                    case 2: {
                        behavor.set(2, false);
                        behavor.set(3, true);
                        behavor.set(4, false);
                    }
                }
                if (copytype == 0) {
                    behavor.set(12, blTimeStamp);
                }
                sJmoTrueCopyPairVolInfo.setBehaviorBitSet(behavor);
                sJmoTrueCopyPairVolInfo.setITracks(copypace);
            }
            confirmData.setPairsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrResyncTCPairsConfirmData> confirmDataList = new ArrayList<SJctrResyncTCPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrResyncTCPairsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void changePriority() {
        SJctrResyncTCPairsTableModel tableData = (SJctrResyncTCPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        SJctrTextBoxDataModel prioritySpin = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PRIORITY);
        int priority = SJctrRemoteReplicationUtility.getValueTextBoxNum(prioritySpin);
        List<Object> selectRowDataList = tableData.getSelectedRowData();
        for (Object selectRowData : selectRowDataList) {
            ((SJmoTrueCopyPairVolInfo)selectRowData).setIPriority(priority);
        }
        tableData.doRefresh();
        tableData.addRowSelectionList(selectRowDataList);
        this.updateFooter();
    }
}

