/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.selectjournals;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrJnlGroupInfoForEXCTG;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.selectjournals.table.SJctrSelectJournalsTableModel;

public class SJctrSelectJournalsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595494;
    private static final String DISP_TITLE = "SELECT_JOURNALS";
    private static final String KEY_TABLE = "COM_TABLE";

    public SJctrSelectJournalsDC() {
        super(33595494);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrSelectJournalsTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> selectedList = this.getCache("COM_AVAILABLE_JNL_LIST_EXCTG");
        List<?> enableAddJnlNumList = this.getCache("COM_ENABLE_SELECT_JNL_NUM_EXCTG");
        if (selectedList == null || enableAddJnlNumList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (selectedList.size() == 0 || enableAddJnlNumList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJctrJnlGroupInfoForEXCTG> selectedList = this.getCache("COM_AVAILABLE_JNL_LIST_EXCTG");
            SJctrSelectJournalsTableModel tableModel = (SJctrSelectJournalsTableModel)this.getDataObjectModel(KEY_TABLE);
            tableModel.setBasicDataList(selectedList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            List<?> enableAddJnlNumList = this.getCache("COM_ENABLE_SELECT_JNL_NUM_EXCTG");
            int enableAddJnlNum = (Integer)enableAddJnlNumList.get(0);
            SJctrSelectJournalsTableModel tableModel = (SJctrSelectJournalsTableModel)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedJnlGrpList = tableModel.getSelectedRowData();
            if (selectedJnlGrpList.size() > enableAddJnlNum) {
                this.logUty.putlog("checkEndData", "There is too much selected Journals.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206130);
            }
            for (SJctrJnlGroupInfoForEXCTG sJctrJnlGroupInfoForEXCTG : selectedJnlGrpList) {
                sJctrJnlGroupInfoForEXCTG.setNewJnl(1);
            }
            ArrayList<SJctrRemoteReplicationDataMacro.PushKey> cacheList = new ArrayList<SJctrRemoteReplicationDataMacro.PushKey>();
            cacheList.add(SJctrRemoteReplicationDataMacro.PushKey.OK);
            this.putCache("COM_SELECTED_JNL_LIST_EXCTG", selectedJnlGrpList);
            this.putCache("SELECT_JNL_PUSH_KEY", cacheList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return ret;
    }

    @Override
    protected void dialogCancelAction() {
        ArrayList<SJctrRemoteReplicationDataMacro.PushKey> cacheList = new ArrayList<SJctrRemoteReplicationDataMacro.PushKey>();
        cacheList.add(SJctrRemoteReplicationDataMacro.PushKey.CANCEL);
        this.putCache("SELECT_JNL_PUSH_KEY", cacheList);
        super.dialogOkAction();
    }

    @Override
    protected void dialogCloseAction() {
        ArrayList<SJctrRemoteReplicationDataMacro.PushKey> cacheList = new ArrayList<SJctrRemoteReplicationDataMacro.PushKey>();
        cacheList.add(SJctrRemoteReplicationDataMacro.PushKey.CLOSE);
        this.putCache("SELECT_JNL_PUSH_KEY", cacheList);
        super.dialogOkAction();
    }
}

