/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.suspendhactgs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.remote.suspendhactgs.SJctrSuspendHaCtgsAC;
import sanproject.sn2.controller.wizard.replication.remote.suspendhactgs.SJctrSuspendHaCtgsConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.suspendhactgs.SJctrSuspendHaCtgsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrSuspendHaCtgsSubWizard
extends SJctrSubWizard {
    private static final String LOG_TITLE = SJctrSuspendHaCtgsSubWizard.class.getSimpleName();
    public static final String TITLE = "SUSPEND_CTG";
    private static final Class<?> CONFIRM_DC = SJctrSuspendHaCtgsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            SJctrHaUtility.chkCacheHaCtgsDetailData(dc);
            List<SJctrHaCtgInfo> viewHaCtgsList = dc.getProxy().getCache("KEY_SELECTED_CTG");
            SJmoHAPairVolInfoMgr haPairInfoMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(dc);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            List<SJmoHUVMVirtualLdev> virtualLdevsList = SJctrHaUtility.getSJmoHUVMVirtualLdev(dc);
            List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(dc);
            List<SJmoRSGgetAllRsgs> rsgAllList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
            SJmoRSGgetAllRsgs rsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, rsgAllList);
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, rsgInfo);
            ArrayList<SJmoHAPairVolInfo> haPairsList = SJctrHaUtility.getHaPairVolInfoListNoResourceCheck(haPairInfoMgr, ldevDetailList);
            List<SJctrHaCtgInfo> existHaCtgs = SJctrHaUtility.getTargetHaCtgInfo(viewHaCtgsList, haPairsList, virtualLdevsList, virtualDkcList);
            boolean isExistHaPairInHaCtgs = SJctrHaUtility.checkExistHaPairInHaCtgs(existHaCtgs);
            if (!isExistHaPairInHaCtgs) {
                SJctrLogUty.error(LOG_TITLE, "constructConfirmData", "Some of Selected Consistency Groups table data have no Pair.");
                throw SJctrHaUtility.createRemoteReplicationException(206244);
            }
            boolean isEnableSuspendHaCtgStatus = SJctrHaUtility.checkEnableSuspendHaCtgStatus(existHaCtgs);
            if (!isEnableSuspendHaCtgStatus) {
                SJctrLogUty.error(LOG_TITLE, "constructConfirmData", "Contained invalid Consistency Group Status.");
                throw SJctrHaUtility.createRemoteReplicationException(206246);
            }
            ArrayList<SJmoHAPairVolInfo> headhaPairsList = SJctrHaUtility.getTargetCtgTopHAPairVolInfoList(existHaCtgs, haPairsList);
            boolean isRsgHaPairs = SJctrHaUtility.checkRsgHaPairs(headhaPairsList, rsgUty);
            if (!isRsgHaPairs) {
                SJctrLogUty.error(LOG_TITLE, "constructConfirmData", "Some of specified HA Consistency Groups are not authorized.");
                throw SJctrHaUtility.createRemoteReplicationException(206248);
            }
            int st = SJctrHaUtility.checkSuspendHaPairStatus(headhaPairsList);
            if (st == 0 || (st & 1) == 1) {
                SJctrLogUty.error(LOG_TITLE, "constructConfirmData", "Contained invalid Pair Status.");
                throw SJctrHaUtility.createRemoteReplicationException(206249);
            }
            SJctrSuspendHaCtgsConfirmData confirmData = new SJctrSuspendHaCtgsConfirmData();
            confirmData.setCtgsInfo(existHaCtgs);
            confirmData.setPairsInfo(headhaPairsList);
            confirmData.setNeedData(dc);
            confirmData.setLUPathMap(SJctrHaUtility.getLDEVLUPathMap(dc));
            ArrayList<SJctrSuspendHaCtgsConfirmData> confirmDataList = new ArrayList<SJctrSuspendHaCtgsConfirmData>();
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrSuspendHaCtgsConfirmData.class, confirmDataList);
            SJctrSuspendHaCtgsAC ac = new SJctrSuspendHaCtgsAC();
            ac.setApplyData(confirmData);
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException exp) {
            throw SJctrHaUtility.convRReplicaLogicalErr(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

