/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrHaViewPairPropertiesDetailDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrHaViewPairPropertiesPropertiesDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRJiHaPair;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrHaViewPairPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 35385416;
    private Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>> ldevLunMap = new HashMap<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>();
    private List<SJmoHAPairVolInfo> haPairList = new ArrayList<SJmoHAPairVolInfo>();
    private int currentIndex = -1;

    public SJctrHaViewPairPropertiesDC() {
        super(35385416);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_PAIR_PROPERTIES_INF", new SJctrHaViewPairPropertiesPropertiesDataModel());
        this.addDataObjectModel("COM_PAIR_DETAIL_INF", new SJctrHaViewPairPropertiesDetailDataModel());
        this.addDataObjectModel("COM_PAGE_NUM", new SJctrTextLabelDataModel());
        Set<SJctrFooterDataModel.Button> footerButton = Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.BACK, SJctrFooterDataModel.Button.NEXT, SJctrFooterDataModel.Button.CLOSE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(footerButton));
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.BACK, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHaViewPairPropertiesDC.this.backAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHaViewPairPropertiesDC.this.nextAction();
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> infoList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (infoList == null) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (infoList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoHAPairVolInfoMgr pairMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            List<SJmoPortLunInfo> modelPtLun = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJctrHaUtility.getSJmoSubsystemInfo(this);
            this.ldevLunMap = SJctrPortUtility.getPortLunMapFromLdevDetail(modelPtLun);
            ArrayList<Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>> ldevLunMapList = new ArrayList<Map<SJmoLdevIndex, ArrayList<SJctrPortLunTableKey>>>(1);
            ldevLunMapList.add(this.ldevLunMap);
            this.getProxy().putCache(SJctrGetLDEVLUPathInfo.class, ldevLunMapList);
            List<SJmoHAPairVolInfo> selectedPairList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            this.haPairList = SJctrHaUtility.getExistHaPairInfo(selectedPairList, pairMgr);
            if (this.haPairList.isEmpty()) {
                throw SJctrHaUtility.createRemoteReplicationException(206502);
            }
            RJiHAget1PairSummary[] summaryArray = SJctrHaUtility.getHAPairSummaryInfo(this, this.haPairList);
            if (summaryArray.length == 0) {
                this.logUty.putlog("checkConstructData", "Size of summaryInfo data list is zero.");
                throw SJctrHaUtility.createRemoteReplicationException(206502);
            }
            ArrayList<RJiHAget1PairSummary> rmiPairSummary = new ArrayList<RJiHAget1PairSummary>(summaryArray.length);
            for (int i = 0; i < summaryArray.length; ++i) {
                rmiPairSummary.add(summaryArray[i]);
            }
            for (RJiHAget1PairSummary pairSummary : rmiPairSummary) {
                this.logUty.putlog("checkConstructData### RJiHAget1PairSummary Info ###", "PairSummary.getLDEV()=" + pairSummary.getLDEV() + ":PairSummary.getAttr()=" + pairSummary.getAttr() + ":PairSummary.getPairLDEV()=" + pairSummary.getPairLDEV() + ":PairSummary.getPairStatus()=" + pairSummary.getPairStatus() + ":PairSummary.isSSWS()=" + pairSummary.isSSWS() + ":PairSummary.isQuorumDisabled()=" + pairSummary.isQuorumDisabled() + ":PairSummary.getQuorumID()=" + pairSummary.getQuorumID());
            }
            this.removeInvalidStatusPair(rmiPairSummary);
            if (rmiPairSummary.isEmpty()) {
                this.logUty.putlog("checkConstructData", "All Pair Information is Invalid.");
                throw SJctrHaUtility.createRemoteReplicationException(206502);
            }
            this.removeDisapearPairInfo(rmiPairSummary);
            if (this.haPairList.isEmpty()) {
                this.logUty.putlog("checkConstructData", "All pairs is invalid.");
                throw SJctrHaUtility.createRemoteReplicationException(206502);
            }
            boolean warnFlg = selectedPairList.size() != this.haPairList.size();
            this.getManageData().setData("COM_WARN_INFO_FLG", warnFlg);
            this.getProxy().putCache(SJctrGetRJiHaPair.class, rmiPairSummary);
            this.updateModelPairInfo(rmiPairSummary);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void removeDisapearPairInfo(List<RJiHAget1PairSummary> rmiPairList) {
        Iterator<SJmoHAPairVolInfo> ite = this.haPairList.iterator();
        while (ite.hasNext()) {
            SJmoHAPairVolInfo haPair = ite.next();
            RJiHAget1PairSummary rmiPair = SJctrHaUtility.getRmiPairRelatedModelPair(rmiPairList, haPair);
            if (rmiPair != null) continue;
            ite.remove();
        }
    }

    private void removeInvalidStatusPair(List<RJiHAget1PairSummary> rmiPairList) {
        Iterator<RJiHAget1PairSummary> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            RJiHAget1PairSummary rmiPair = ite.next();
            if (this.checkViewPairPropStatus(rmiPair)) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairPropStatus(RJiHAget1PairSummary rmiPair) {
        boolean rtn = false;
        if (rmiPair != null) {
            rtn = rmiPair.isSSWS() == 1 ? true : SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_PAIR_PROP_HA.contains(rmiPair.getPairStatus());
        }
        return rtn;
    }

    @Override
    public void makeDataModel() {
        try {
            super.makeDataModel();
            this.currentIndex = 0;
            this.refDataModel();
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
    }

    private void refDataModel() {
        if (0 <= this.currentIndex && this.currentIndex < this.haPairList.size()) {
            SJmoHAPairVolInfo haPair = this.haPairList.get(this.currentIndex);
            SJctrHaViewPairPropertiesPropertiesDataModel prop = (SJctrHaViewPairPropertiesPropertiesDataModel)this.getDataObjectModel("COM_PAIR_PROPERTIES_INF");
            prop.makeProperties(haPair, this);
            SJctrHaViewPairPropertiesDetailDataModel detail = (SJctrHaViewPairPropertiesDetailDataModel)this.getDataObjectModel("COM_PAIR_DETAIL_INF");
            detail.makeSummary(haPair);
            this.makePageLabel();
        }
        this.setDirtyAll();
    }

    private void makePageLabel() {
        String pageLabelString = String.valueOf(this.currentIndex + 1) + " / " + this.haPairList.size();
        SJctrTextLabelDataModel pageLabel = (SJctrTextLabelDataModel)this.getDataObjectModel("COM_PAGE_NUM");
        pageLabel.setLabel(pageLabelString);
    }

    private void backAction() {
        if (0 < this.currentIndex) {
            --this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    private void nextAction() {
        if (this.currentIndex < this.haPairList.size() - 1) {
            ++this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.BACK, 0 < this.currentIndex && this.currentIndex < this.haPairList.size());
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, 0 <= this.currentIndex && this.currentIndex < this.haPairList.size() - 1);
    }

    private void updateModelPairInfo(List<RJiHAget1PairSummary> rmiPairList) {
        for (SJmoHAPairVolInfo remoteVol : this.haPairList) {
            SJmoHAPairVolInfo haPair;
            RJiHAget1PairSummary rmiPair = SJctrHaUtility.getRmiPairRelatedModelPair(rmiPairList, remoteVol);
            SJmoHAPairVolInfo sJmoHAPairVolInfo = haPair = new SJmoHAPairVolInfo(rmiPair);
        }
    }
}

