/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.viewhistories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.MRCFgetHistInf;
import sanproject.serverux.dataimpl.MRCFgetHistStatus;
import sanproject.serverux.dataimpl.MrcGetHistInf_Input;
import sanproject.serverux.dataimpl.MrcGetHistInf_Output;
import sanproject.serverux.dataimpl.SigetHistParam;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetHistInf;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrHistoriesPagingComponentDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrLocalHistoriesComInfoDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesDummyTableModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesFcInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesFcTableModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesSiInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesSiTableModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesSimfTableModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesSsInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrViewHistoriesTiTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrViewHistoriesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664499;
    private static final String DISP_TITLE = "HISTORIES";
    private static final String KEY_HISTORIES_INFO = "COM_HISTORIES_INFO";
    private static final String KEY_COPYTYPE = "COM_COPYTYPE";
    private static final String KEY_PAGING_COMPO = "COM_PAGING_COMPO";
    private static final String KEY_TABLE_SI = "COM_TABLE_SI";
    private static final String KEY_TABLE_DSS = "COM_TABLE_DSS";
    private static final String KEY_TABLE_SS = "COM_TABLE_SS";
    private static final String KEY_TABLE_SIMF = "COM_TABLE_SIMF";
    private static final String KEY_TABLE_FC = "COM_TABLE_FC";
    private static final String KEY_HISTORIES_DUMMY_TABLE = "COM_HISTORIES_DUMMY_TABLE";
    private static final String KEY_EXPORT = "COM_EXPORT";
    private static final String KEY_ENABLE_RESOURCE_LDEV = "COM_ENABLE_RESOURCE_LDEV";
    private static final String COPYTYPE_NAME_BLANK = "NAME_BLANK";
    private static final int GET_HISTO_INFO_DEFAULT_PAGE = 1;
    private static final int SET_HISTO_INFO_DEFAULT_PAGE = 0;

    public SJctrViewHistoriesDC() throws SJcException {
        super(34664499);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HISTORIES_INFO, new SJctrLocalHistoriesComInfoDataModel());
        SJctrComboBoxDataModel copyTypePullDown = new SJctrComboBoxDataModel();
        copyTypePullDown.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewHistoriesDC.this.fireMessageEvent(VIEW_HISTORIES_MSG.CHANGE_COPYTYPE);
            }
        });
        this.addDataObjectModel(KEY_COPYTYPE, copyTypePullDown);
        SJctrHistoriesPagingComponentDataModel pagingComp = new SJctrHistoriesPagingComponentDataModel();
        pagingComp.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrViewHistoriesDC.this.fireMessageEvent(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED);
            }
        });
        this.addDataObjectModel(KEY_PAGING_COMPO, pagingComp);
        SJctrViewHistoriesSiTableModel siTable = new SJctrViewHistoriesSiTableModel();
        siTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SI, siTable);
        SJctrViewHistoriesTiTableModel tiTable = new SJctrViewHistoriesTiTableModel();
        tiTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_DSS, tiTable);
        SJctrViewHistoriesSimfTableModel simfTable = new SJctrViewHistoriesSimfTableModel();
        simfTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SIMF, simfTable);
        SJctrViewHistoriesFcTableModel fcTable = new SJctrViewHistoriesFcTableModel();
        fcTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_FC, fcTable);
        SJctrViewHistoriesDummyTableModel dummyTable = new SJctrViewHistoriesDummyTableModel();
        dummyTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_DUMMY_TABLE, dummyTable);
        SJctrButtonDataModel exportButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_EXPORT, exportButton);
        exportButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewHistoriesDC.this.fireMessageEvent(VIEW_HISTORIES_MSG.SELECT_EXPORT);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(VIEW_HISTORIES_MSG.CHANGE_COPYTYPE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewHistoriesDC.this.copyTypeChangedAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewHistoriesDC.this.pageChangedAction(event, dstModel);
            }
        });
        this.addMessageEventListener(VIEW_HISTORIES_MSG.SELECT_EXPORT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewHistoriesDC.this.makeExport(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this).get(0));
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
        this.getProxy().putCache(KEY_ENABLE_RESOURCE_LDEV, resourceLdevs);
        copyTypeCombo.addItem(COPYTYPE_NAME_BLANK, "");
        copyTypeCombo.addItem("SI_COPY", this.getComUtility().getGuidance("SI_COPY"));
        copyTypeCombo.addItem("DSS_COPY", this.getComUtility().getGuidance("DSS_COPY"));
        if (!SJctrViewHistoriesDC.isHM()) {
            copyTypeCombo.addItem("SI_MF_COPY", this.getComUtility().getGuidance("SI_MF_COPY"));
            copyTypeCombo.addItem("FCV2_FCSE", this.getComUtility().getGuidance("FCV2_FCSE"));
        }
        SJctrLocalHistoriesComInfoDataModel histriesInfo = (SJctrLocalHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
        histriesInfo.setHistoriesUpdate(false);
        return ret;
    }

    private List<SJctrViewHistoriesSiInfo> createSiHistList(MRCFgetHistInf rmiHistInfo, List<SJmoLdevIndex> resourceLdevs) {
        MRCFgetHistStatus[] histArray = rmiHistInfo.getSiHist();
        ArrayList<SJctrViewHistoriesSiInfo> retList = new ArrayList<SJctrViewHistoriesSiInfo>(histArray.length);
        for (MRCFgetHistStatus hist : histArray) {
            SJctrViewHistoriesSiInfo histInfo = new SJctrViewHistoriesSiInfo();
            if (!this.checkPairVolInfoValid(hist.getTaskCode(), SJctrReplicationDataMacro.HIST_PAIRINFO_INVALID_SI_PS)) {
                this.setHistoriesInfo(histInfo, hist, resourceLdevs, false, false);
                retList.add(histInfo);
                continue;
            }
            if (!this.setHistoriesInfo(histInfo, hist, resourceLdevs, true, true)) continue;
            retList.add(histInfo);
        }
        return retList;
    }

    private List<SJctrViewHistoriesSsInfo> createTiHistList(MRCFgetHistInf rmiHistInfo, List<SJmoLdevIndex> resourceLdevs) {
        MRCFgetHistStatus[] histArray = rmiHistInfo.getSiHist();
        List<SJctrViewHistoriesSsInfo> retList = this.createSnapshotHistList(histArray, resourceLdevs);
        return retList;
    }

    private List<SJctrViewHistoriesFcInfo> createFcHistList(MRCFgetHistInf rmiHistInfo, List<SJmoLdevIndex> resourceLdevs) {
        MRCFgetHistStatus[] histArray = rmiHistInfo.getSiHist();
        ArrayList<SJctrViewHistoriesFcInfo> retList = new ArrayList<SJctrViewHistoriesFcInfo>(histArray.length);
        for (MRCFgetHistStatus hist : histArray) {
            SJctrViewHistoriesFcInfo histInfo = new SJctrViewHistoriesFcInfo();
            if (!this.checkPairVolInfoValid(hist.getTaskCode(), SJctrReplicationDataMacro.HIST_PAIRINFO_INVALID_FC_PS)) {
                this.setHistoriesInfo(histInfo, hist, resourceLdevs, false, false);
                retList.add(histInfo);
                continue;
            }
            if (!this.checkPairVolInfoValid(hist.getTaskCode(), SJctrReplicationDataMacro.HIST_PAIRINFO_INVALID_FC_S)) {
                if (!this.setHistoriesInfo(histInfo, hist, resourceLdevs, true, false)) continue;
                retList.add(histInfo);
                continue;
            }
            if (!this.setHistoriesInfo(histInfo, hist, resourceLdevs, true, true)) continue;
            int reshipId = hist.getMessage() & 0xFFFFFF;
            histInfo.setRelationshipId(reshipId);
            retList.add(histInfo);
        }
        return retList;
    }

    private boolean checkPairVolInfoValid(int taskCode, int[] pairVolInvalidList) {
        boolean ret = true;
        for (int pairInfoInvalid : pairVolInvalidList) {
            if (taskCode != pairInfoInvalid) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private List<SJctrViewHistoriesSsInfo> createSnapshotHistList(MRCFgetHistStatus[] histArray, List<SJmoLdevIndex> resourceLdevs) {
        ArrayList<SJctrViewHistoriesSsInfo> retList = new ArrayList<SJctrViewHistoriesSsInfo>(histArray.length);
        for (MRCFgetHistStatus hist : histArray) {
            SJctrViewHistoriesSsInfo histInfo = new SJctrViewHistoriesSsInfo();
            if (!this.checkPairVolInfoValid(hist.getTaskCode(), SJctrReplicationDataMacro.HIST_PAIRINFO_INVALID_SS_PS)) {
                this.setHistoriesInfo(histInfo, hist, resourceLdevs, false, false);
                retList.add(histInfo);
                continue;
            }
            if (!this.setHistoriesInfo(histInfo, hist, resourceLdevs, true, true)) continue;
            int poolId = hist.getMessage() >> 16;
            histInfo.setPoolId((short)(poolId &= 0xFFFF));
            int mirrorUnit = hist.getMessage() & 0xFFFF;
            histInfo.setMirrorUnit((short)mirrorUnit);
            retList.add(histInfo);
        }
        return retList;
    }

    private boolean setHistoriesInfo(SJctrViewHistoriesSiInfo histInfo, MRCFgetHistStatus hist, List<SJmoLdevIndex> resourceLdevs, boolean pvolValid, boolean svolValid) {
        boolean ret = false;
        if (pvolValid) {
            SJmoLdevIndex pvol = new SJmoLdevIndex();
            pvol.setLdevIndex(hist.getPvolLdkc(), hist.getPvolCu(), hist.getPvolLdev());
            ret |= 0 <= Collections.binarySearch(resourceLdevs, pvol);
            histInfo.setPvol(pvol);
            histInfo.setSVolKind(hist.getSvolKind());
        }
        if (svolValid) {
            SJmoLdevIndex svol = new SJmoLdevIndex();
            svol.setLdevIndex(hist.getSvolLdkc(), hist.getSvolCu(), hist.getSvolLdev());
            ret |= 0 <= Collections.binarySearch(resourceLdevs, svol);
            histInfo.setSvol(svol);
            histInfo.setSVolKind(hist.getSvolKind());
        }
        histInfo.setDate(hist.getTime());
        histInfo.setTaskCode(hist.getTaskCode());
        return ret;
    }

    private void makeExport(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE);
        String copyType = copyTypeCombo.getSelection();
        SJctrTableDataModel outputTable = null;
        String fileName = this.getComUtility().getGuidance(DISP_TITLE) + "_";
        if (copyType != null) {
            if (copyType.equals("SI_COPY")) {
                outputTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SI);
                fileName = fileName + this.getComUtility().getGuidance("SI_COPY");
            } else if (copyType.equals("DSS_COPY")) {
                outputTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_DSS);
                fileName = fileName + this.getComUtility().getGuidance("DSS_COPY");
            } else if (copyType.equals("SS_COPY")) {
                outputTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SS);
                fileName = fileName + this.getComUtility().getGuidance("SS_COPY");
            } else if (copyType.equals("SI_MF_COPY")) {
                outputTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SIMF);
                fileName = fileName + this.getComUtility().getGuidance("SI_MF_COPY");
            } else if (copyType.equals("FCV2_FCSE")) {
                outputTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_FC);
                fileName = fileName + this.getComUtility().getGuidance("FCV2_FCSE");
            } else {
                this.logUty.putlog("makeExport", "Copy type is invalid. Copy Type = " + copyType, 40000);
            }
        }
        if (null == outputTable) {
            this.logUty.putlog("makeExport", "Oupput table is not exist.");
            SJctrError err = new SJctrError(209, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!SJctrViewHistoriesDC.isHM()) {
            SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
            fileName = fileName + SJctrComUtility.toPaddingZeroString(pagingComp.getCurrentPage(), 2);
        }
        fileName = fileName + "Export";
        String tsvFileName = SJctrComUtility.getTsvFileName(fileName);
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(outputTable);
        param.add(tsvFileName);
        this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_EXPORT, param);
    }

    private void copyTypeChangedAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE);
        this.getHistoriesInfoAction(true, 0);
        copyTypeCombo.removeItem(COPYTYPE_NAME_BLANK);
        this.setDirtyAll();
    }

    private void pageChangedAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        int setPageNumber = pagingComp.getCurrentPage() - 1;
        this.getHistoriesInfoAction(false, setPageNumber);
        this.setDirtyAll();
    }

    private void getHistoriesInfoAction(boolean isRefresh, int page) {
        SJctrLocalHistoriesComInfoDataModel histriesInfo = (SJctrLocalHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
        histriesInfo.setHistoriesUpdate(false);
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE);
        String copyTypeString = copyTypeCombo.getSelection();
        if (copyTypeString == null) {
            this.logUty.putlog("changeCopyType", "Selected CopyType is null");
            return;
        }
        List<SJmoLdevIndex> enableResourceLdevs = this.getProxy().getCache(KEY_ENABLE_RESOURCE_LDEV);
        if (copyTypeString.equals("SI_COPY")) {
            MRCFgetHistInf histLogInfo = this.getHistoriesInfo((short)1, page, isRefresh);
            SJctrViewHistoriesSiTableModel siTable = (SJctrViewHistoriesSiTableModel)this.getDataObjectModel(KEY_TABLE_SI);
            siTable.setBasicDataList(this.createSiHistList(histLogInfo, enableResourceLdevs));
            siTable.doRefresh();
            siTable.setCurrentPageNum(pagingComp.getCurrentPage());
            pagingComp.setLastPageLabel(this.getLastPageNumber(histLogInfo.getISiHistNum()));
        } else if (copyTypeString.equals("DSS_COPY")) {
            MRCFgetHistInf histLogInfo = this.getHistoriesInfo((short)8, page, isRefresh);
            SJctrViewHistoriesTiTableModel tiTable = (SJctrViewHistoriesTiTableModel)this.getDataObjectModel(KEY_TABLE_DSS);
            tiTable.setBasicDataList(this.createTiHistList(histLogInfo, enableResourceLdevs));
            tiTable.doRefresh();
            tiTable.setCurrentPageNum(pagingComp.getCurrentPage());
            pagingComp.setLastPageLabel(this.getLastPageNumber(histLogInfo.getISiHistNum()));
        } else if (copyTypeString.equals("SI_MF_COPY")) {
            MRCFgetHistInf histLogInfo = this.getHistoriesInfo((short)2, page, isRefresh);
            SJctrViewHistoriesSimfTableModel simfTable = (SJctrViewHistoriesSimfTableModel)this.getDataObjectModel(KEY_TABLE_SIMF);
            simfTable.setBasicDataList(this.createSiHistList(histLogInfo, enableResourceLdevs));
            simfTable.doRefresh();
            simfTable.setCurrentPageNum(pagingComp.getCurrentPage());
            pagingComp.setLastPageLabel(this.getLastPageNumber(histLogInfo.getISiHistNum()));
        } else if (copyTypeString.equals("FCV2_FCSE")) {
            MRCFgetHistInf histLogInfo = this.getHistoriesInfo((short)4, page, isRefresh);
            SJctrViewHistoriesFcTableModel fcTable = (SJctrViewHistoriesFcTableModel)this.getDataObjectModel(KEY_TABLE_FC);
            fcTable.setBasicDataList(this.createFcHistList(histLogInfo, enableResourceLdevs));
            fcTable.doRefresh();
            fcTable.setCurrentPageNum(pagingComp.getCurrentPage());
            pagingComp.setLastPageLabel(this.getLastPageNumber(histLogInfo.getISiHistNum()));
        } else {
            this.logUty.putlog("changeCopyType", "Selected CopyType is invalid");
            return;
        }
    }

    private int getLastPageNumber(int numOfAllLogs) {
        int lastPageNum = 1;
        if (numOfAllLogs > 0) {
            lastPageNum = (numOfAllLogs + 16383) / 16384;
        }
        return lastPageNum;
    }

    private MRCFgetHistInf getHistoriesInfo(short copyKind, int page, boolean isRefresh) {
        SJctrGetMRCFgetHistInf kind = this.createGetHistParam(copyKind, page, isRefresh);
        SJmoThroughRmiData rmiData = SJctrReplicationUtility.getRmiObject(this, kind);
        MrcGetHistInf_Output output = (MrcGetHistInf_Output)rmiData.getObjRmi();
        if (null == output) {
            this.getLogUty().putlog("getHistoriesInfo", "RMI output data is null.");
            SJctrError err = new SJctrError(209, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        MRCFgetHistInf histLogInfo = output.getInf();
        if (null == histLogInfo) {
            this.getLogUty().putlog("getHistoriesInfo", "Hirotries info is null.");
            SJctrError err = new SJctrError(209, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrLocalHistoriesComInfoDataModel histInfo = (SJctrLocalHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
        switch (copyKind) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                histInfo.setLastUpdateTime(histLogInfo, "COM_LAST_UPDATE");
                break;
            }
            default: {
                this.getLogUty().putlog("getHistoriesInfo", "copyKind parameter is invalid.copyKind is [" + copyKind + "]");
            }
        }
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        if (1 == histLogInfo.getSRefresh() && !isRefresh) {
            histInfo.setHistoriesUpdate(true);
            pagingComp.setCurrentPage(1);
        } else {
            pagingComp.setCurrentPage(++page);
        }
        return histLogInfo;
    }

    private SJctrGetMRCFgetHistInf createGetHistParam(short copyKind, int index, boolean isRefresh) {
        SigetHistParam getHistPrm = new SigetHistParam();
        getHistPrm.setSKind(copyKind);
        if (SJctrViewHistoriesDC.isHM()) {
            getHistPrm.setSIndex((short)-1);
            getHistPrm.setSRefresh((short)1);
            switch (copyKind) {
                case 1: {
                    getHistPrm.setIMaxCount(8192);
                    break;
                }
                case 8: {
                    getHistPrm.setIMaxCount(8192);
                    break;
                }
                default: {
                    this.getLogUty().putlog("createGetHistParam", "copyKind parameter is invalid.");
                    SJctrError err = new SJctrError(209, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
        } else {
            getHistPrm.setSIndex((short)index);
            short refresh = isRefresh ? (short)1 : 0;
            getHistPrm.setSRefresh(refresh);
            String lastUpdateArray = "";
            if (!isRefresh) {
                SJctrLocalHistoriesComInfoDataModel histInfo = (SJctrLocalHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
                switch (copyKind) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        lastUpdateArray = histInfo.getLastUpdateTime("COM_LAST_UPDATE");
                        break;
                    }
                    default: {
                        this.getLogUty().putlog("createGetHistParam", "copyKind parameter is invalid.");
                        SJctrError err = new SJctrError(209, 22, 107004);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                }
            }
            getHistPrm.setSzHistTime(lastUpdateArray);
        }
        MrcGetHistInf_Input input = new MrcGetHistInf_Input(getHistPrm);
        SJctrGetMRCFgetHistInf kindParam = new SJctrGetMRCFgetHistInf(input);
        return kindParam;
    }

    public static enum VIEW_HISTORIES_MSG implements SJctrNotifyState
    {
        CHANGE_COPYTYPE,
        SELECT_EXPORT;

    }
}

