/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.tasks.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlElemCon;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.topwindow.tasks.SJctrDispTaskInfo;

public class SJctrTaskOperationAuditLogData {
    static String ADT_FUNC = "0x5300";
    static String GUID_KEY_ADT_ENTRY_TASKS = "";
    static String GUID_KEY_ADT_NORMAL_END = "ADT_NORMAL_END";
    static String GUID_KEY_ADT_ERROR = "ADT_ERROR";
    static String GUID_KEY_ADT_NUM_OF_TASKS = "ADT_NUM_OF_TASKS";
    public static final String ADT_DELETE_TASKS = "ADT_DELETE_TASKS";
    public static final String ADT_RESUME_TASKS = "ADT_RESUME_TASKS";
    public static final String ADT_SUSPEND_TASKS = "ADT_SUSPEND_TASKS";
    public static final String ADT_DISABLE_AUTO_DELETE = "ADT_DISABLE_AUTO_DELETE";
    public static final String ADT_ENABLE_AUTO_DELETE = "ADT_ENABLE_AUTO_DELETE";
    static final String KEY_TASK_NAME = "ADT_TASK_NAME";
    static final String KEY_TASK_TYPE = "ADT_TYPE";
    static final String KEY_USER_NAME = "ADT_USER_ID";
    static final String KEY_SUBMIT_TIME = "ADT_SUBMISSION_TIMES";
    static final String KEY_RESULT = "ADT_RESULT";
    static final String[] KEY_LIST = new String[]{"ADT_TASK_NAME", "ADT_TYPE", "ADT_USER_ID", "ADT_SUBMISSION_TIMES", "ADT_RESULT"};
    static final List<String> keys = Arrays.asList(KEY_LIST);
    static final List<String> scrids = new ArrayList<String>(0);
    private String strAuditTitle;
    private String strNormalEnd;
    private String strError;
    private SJctrUserController userCtrl;
    public static boolean RESULT_NORMAL = true;
    public static boolean RESULT_ERROR = false;

    public SJctrTaskOperationAuditLogData(SJctrUserController userctr, String strAdtTitleKey) {
        this.userCtrl = userctr;
        SJctrComUtility util = this.userCtrl.getComUtility();
        this.strAuditTitle = util.getGuidance(strAdtTitleKey);
        this.strNormalEnd = util.getGuidance(GUID_KEY_ADT_NORMAL_END);
        this.strError = util.getGuidance(GUID_KEY_ADT_ERROR);
    }

    public void createAuditString(SJctrUserController userctr, String strAdtTitleKey) {
        this.userCtrl = userctr;
        SJctrComUtility util = this.userCtrl.getComUtility();
        this.strAuditTitle = util.getGuidance(strAdtTitleKey);
        this.strNormalEnd = util.getGuidance(GUID_KEY_ADT_NORMAL_END);
        this.strError = util.getGuidance(GUID_KEY_ADT_ERROR);
    }

    public SJctrAuditLogData createElement(SJctrDispTaskInfo task, boolean result, SJcMessage auditMsg) {
        SJctrDefaultAuditLogData data = new SJctrDefaultAuditLogData();
        data.setFullKeys(scrids, keys);
        data.setValue(KEY_TASK_NAME, task.getName());
        SJctrTask mTask = task.getTaskInst();
        if (mTask.getTypeEn() == "") {
            data.setValue(KEY_TASK_TYPE, task.getType());
        } else {
            data.setValue(KEY_TASK_TYPE, mTask.getTypeEn());
        }
        data.setValue(KEY_USER_NAME, task.getUserId());
        data.setValue(KEY_SUBMIT_TIME, task.getSubmitTime());
        String strResult = this.getResult(result, auditMsg);
        data.setValue(KEY_RESULT, strResult);
        return data;
    }

    public SJcAuditLogCtrlElemCon createElemCon() {
        SJcAuditLogCtrlElemCon ec = new SJcAuditLogCtrlElemCon();
        ec.setUserController(this.userCtrl);
        ec.setFunctionName(ADT_FUNC);
        ec.setOperationName(this.strAuditTitle);
        ec.setAdditionalInfo(null);
        ec.setFooter(null, GUID_KEY_ADT_NUM_OF_TASKS);
        return ec;
    }

    private String getResult(boolean result, SJcMessage auditMsg) {
        if (result) {
            return this.strNormalEnd;
        }
        String sRet = this.strError + "(" + auditMsg.getFunctionID() + auditMsg.getModuleID() + "-" + auditMsg.getMsgID() + ")";
        return sRet;
    }
}

