/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrPortManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private List<SJmoPortDetail> portDetailList;
    private List<SJmoPortAttributeInfo> portAttributeList;

    public SJctrPortManager() {
        this.initField();
    }

    private void initField() {
        this.portAttributeList = Collections.emptyList();
        this.portDetailList = Collections.emptyList();
    }

    public List<SJmoPortDetail> getPortDetailList() {
        return this.portDetailList;
    }

    public List<SJmoPortAttributeInfo> getPortAttributeList() {
        return this.portAttributeList;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetPortDetail.class.getName());
        if (getList != null && getList.size() > 0) {
            this.portDetailList = getList;
        }
        if ((getList = models.get(SJmoGetPortAttributeInfo.class.getName())) != null && getList.size() > 0) {
            this.portAttributeList = getList;
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
        List<SJmoPortDetail> detailList = this.getPortDetailList();
        List<SJmoPortAttributeInfo> attributeList = this.getPortAttributeList();
        int size = detailList.size();
        if (size != attributeList.size()) {
            SJctrError error = new SJctrError(0, 0, 0);
            throw error.createException();
        }
        for (int i = 0; i < size; ++i) {
            SJmoPortAttributeInfo attribute;
            SJmoPortDetail detail = detailList.get(i);
            if (detail.compareTo(attribute = attributeList.get(i)) == 0) continue;
            SJctrError error = new SJctrError(0, 0, 0);
            throw error.createException();
        }
    }

    public List<SJmoPortDetail> getPortDetailListOfExternal() {
        List<SJmoPortDetail> detailList = this.getPortDetailList();
        List<SJmoPortAttributeInfo> attributeList = this.getPortAttributeList();
        int size = attributeList.size();
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>(size);
        for (int i = 0; i < size; ++i) {
            SJmoPortAttributeInfo attributeInfo = attributeList.get(i);
            if (attributeInfo.getByPortKind() != 6) continue;
            retList.add(detailList.get(i));
        }
        return retList;
    }

    public List<SJmoPortDetail> getPortDetailListbyAttribute(Set<Byte> attributeSet) {
        List<SJmoPortDetail> detailList = this.getPortDetailList();
        List<SJmoPortAttributeInfo> attributeList = this.getPortAttributeList();
        int size = attributeList.size();
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>(size);
        for (int index = 0; index < size; ++index) {
            SJmoPortAttributeInfo attributeInfo = attributeList.get(index);
            byte attr = attributeInfo.getByPortKind();
            if (!attributeSet.contains(attr)) continue;
            retList.add(detailList.get(index));
        }
        return retList;
    }

    public SJmoPortDetail getPortDetail(short portId) {
        List<SJmoPortDetail> list = this.getPortDetailList();
        SJmoPortIndex key = new SJmoPortIndex();
        key.setSPort(portId);
        SJmoPortDetail retObject = null;
        int index = Collections.binarySearch(list, key);
        if (index >= 0) {
            retObject = list.get(index);
        }
        return retObject;
    }

    public SJmoPortAttributeInfo getPortAttributeInfo(short portId) {
        List<SJmoPortAttributeInfo> list = this.getPortAttributeList();
        SJmoPortIndex key = new SJmoPortIndex();
        key.setSPort(portId);
        SJmoPortAttributeInfo retObject = null;
        int index = Collections.binarySearch(list, key);
        if (index >= 0) {
            retObject = list.get(index);
        }
        return retObject;
    }
}

