/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;

public class SJctrTargetPortManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private SJmoExdTargetPortInfoMgr exdTargetPortManager;
    private Map<Integer, SJmoExdTargetPortInfo> discoveryTargetPortMap;

    public SJctrTargetPortManager() {
        this.initField();
    }

    private void initField() {
        this.exdTargetPortManager = null;
        this.discoveryTargetPortMap = new HashMap<Integer, SJmoExdTargetPortInfo>();
    }

    private SJmoExdTargetPortInfoMgr getExdTargetPortManager() {
        return this.exdTargetPortManager;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetExdTargetPortInfoMgr kind = new SJmoGetExdTargetPortInfoMgr();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetExdTargetPortInfoMgr.class.getName());
        if (getList != null && getList.size() > 0) {
            this.exdTargetPortManager = (SJmoExdTargetPortInfoMgr)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
    }

    public SJmoExdTargetPortInfo getTargetPortInfo(int wwnId) {
        SJmoExdTargetPortInfo retInfo = null;
        if (wwnId >= 0) {
            SJmoExdTargetPortInfoMgr targetPortManager = this.getExdTargetPortManager();
            if (targetPortManager != null) {
                retInfo = targetPortManager.getExdTargetPortInfo(wwnId);
            }
        } else {
            retInfo = this.discoveryTargetPortMap.get(wwnId);
        }
        return retInfo;
    }

    public List<SJmoExdTargetPortInfo> getTargetPortList() {
        ArrayList retList = Collections.emptyList();
        SJmoExdTargetPortInfoMgr targetPortManager = this.getExdTargetPortManager();
        if (targetPortManager != null) {
            retList = targetPortManager.getAlExdTargetPortInfo();
        }
        return retList;
    }

    public List<SJmoExdTargetPortInfo> getTargetPortListOfSubsystemId(int subsystemId) {
        ArrayList retList = Collections.emptyList();
        SJmoExdTargetPortInfoMgr targetPortManager = this.getExdTargetPortManager();
        if (targetPortManager != null) {
            retList = targetPortManager.getAlTargetPortInfoOfSubsystemId(subsystemId);
        }
        return retList;
    }

    public List<SJmoExdTargetPortInfo> getUnmapTargetPortList() {
        ArrayList<SJmoExdTargetPortInfo> retList = new ArrayList<SJmoExdTargetPortInfo>(this.discoveryTargetPortMap.values());
        return retList;
    }

    public List<SJmoExdTargetPortInfo> getUnmapTargetPortListOfSubsystemId(int subsystemId) {
        ArrayList<SJmoExdTargetPortInfo> retList = new ArrayList<SJmoExdTargetPortInfo>(this.discoveryTargetPortMap.size());
        for (SJmoExdTargetPortInfo targetPort : this.discoveryTargetPortMap.values()) {
            if (targetPort.getRmiExdTargetPortInfo().referSubsystemId() != subsystemId) continue;
            retList.add(targetPort);
        }
        return retList;
    }

    public SJmoExdTargetPortInfo createDiscoveryTargetPortInfo(EXDTargetPort exdTargetPort) {
        SJmoExdTargetPortInfo ret = null;
        if (exdTargetPort.isConfigured()) {
            int id = exdTargetPort.getId();
            SJmoExdTargetPortInfo targetPort = this.getTargetPortInfo(id);
            if (targetPort != null && this.equalsEXDTargetPort(exdTargetPort, targetPort.getRmiExdTargetPortInfo())) {
                ret = targetPort;
            }
        } else {
            for (SJmoExdTargetPortInfo info : this.discoveryTargetPortMap.values()) {
                if (!this.equalsEXDTargetPort(exdTargetPort, info.getRmiExdTargetPortInfo())) continue;
                ret = info;
                break;
            }
            if (ret == null) {
                List<SJmoExdTargetPortInfo> configerList = this.getTargetPortList();
                for (SJmoExdTargetPortInfo configer : configerList) {
                    if (!this.equalsEXDTargetPort(exdTargetPort, configer.getRmiExdTargetPortInfo())) continue;
                    return ret;
                }
                int id = -2 - this.discoveryTargetPortMap.size();
                exdTargetPort.setId(id);
                ret = new SJmoExdTargetPortInfo(exdTargetPort);
                this.discoveryTargetPortMap.put(id, ret);
            }
        }
        return ret;
    }

    private boolean equalsEXDTargetPort(EXDTargetPort o1, EXDTargetPort o2) {
        return o1.getDispTargetPortAddress().equals(o2.getDispTargetPortAddress());
    }
}

