/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.delextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalVolumeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.controller.wizard.uvm.delextvols.SJctrDelExtVolsConfirmData;
import sanproject.sn2.controller.wizard.uvm.delextvols.SJctrDelExtVolsSubWizard;
import sanproject.sn2.controller.wizard.uvm.delextvols.SJctrDelExtVolsTableModel;
import sanproject.sn2.controller.wizard.uvm.delextvols.SJctrDisconnectedVolsDataModel;
import sanproject.sn2.controller.wizard.uvm.delextvols.SJctrWithoutWriteCacheDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrDelExtVolsDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 0x1100991;
    public static final String GUID_TITLE = "DISP_DI99S_TITLE";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    private static final String KEY_DISCONNECTED_VOLS = "COM_DISCONCTED_VOLS";
    private static final String KEY_WITHOUT_WRITE_CACHE = "COM_WITHOUT_WRITE_CACHE";
    List<SJmoPgIndex> pgIndexList = null;
    List<SJmoExdVolumeInfo> delExtVolsList = null;
    SJctrDisconnectedVolsDataModel discnctVolsDataModel = null;
    SJctrWithoutWriteCacheDataModel withoutWriteCacheDataModel = null;
    SJctrExternalVolumeManager extVolInfoMgr = null;
    List<SJmoExDVirtualPgInfo> exdVpgInfoList = null;
    public static final String KEY_DELETE = "COM_DELETE";
    public static int RESULT_NORMAL = 0;
    public static int DELETE_EXTVOLS_NOT_FOUND_PARAM = 107001;
    public static int DELETE_EXTVOLS_NOT_FOUND_MODEL = 107018;
    public static int DELETE_EXTVOLS_NOT_EQUIP = 106529;
    public static int DELETE_EXTVOLS_NOT_SELECT_ROWDATA = 105042;
    public static int DELETE_EXTVOLS_NOT_SELECT_RADIO = 105234;
    public static int DELETE_EXTVOLS_UNUSABLE_RSGPG = 105269;
    public static int DELETE_EXTVOLS_UNUSABLE_RSGLDEV = 105270;

    public SJctrDelExtVolsDC() throws SJcException {
        super(0x1100991);
        this.initDataModel();
        this.initManager();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrDelExtVolsSubWizard.DELETE_EXT_VOLS_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = DELETE_EXTVOLS_NOT_FOUND_PARAM;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoPgIndex) continue;
                errorCode = DELETE_EXTVOLS_NOT_FOUND_PARAM;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> dat = this.getCache(SJctrDelExtVolsSubWizard.DELETE_EXT_VOLS_DATA);
        this.pgIndexList = dat;
        this.extVolInfoMgr = this.getManager(SJctrExternalVolumeManager.class);
        if (this.extVolInfoMgr == null) {
            errorCode = DELETE_EXTVOLS_NOT_FOUND_MODEL;
        }
        if (errorCode == RESULT_NORMAL) {
            this.exdVpgInfoList = this.getCache(SJmoGetExDVirtualPgInfo.class);
            if (this.exdVpgInfoList == null || this.exdVpgInfoList.size() == 0) {
                errorCode = DELETE_EXTVOLS_NOT_FOUND_MODEL;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrUserController uc = this.getOwner();
        List<?> rsgInfoList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgInfoList == null || rsgInfoList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, DELETE_EXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgInfo);
        List<SJmoLdevDetail> ldevDtlList = this.getCache(SJmoGetLdevDetail.class);
        if (ldevDtlList == null) {
            SJctrError err = new SJctrError(6, 22, DELETE_EXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrExtUtility exdUtil = uc.getComUtility().getExtUtility();
        this.discnctVolsDataModel = (SJctrDisconnectedVolsDataModel)this.getDataObjectModel(KEY_DISCONNECTED_VOLS);
        this.withoutWriteCacheDataModel = (SJctrWithoutWriteCacheDataModel)this.getDataObjectModel(KEY_WITHOUT_WRITE_CACHE);
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.pgIndexList.size());
        List<SJmoExdVolumeInfoOnPathGroup> extVolInfoList = this.extVolInfoMgr.getExternalVolumeList();
        Iterator<SJmoPgIndex> i$ = this.pgIndexList.iterator();
        while (i$.hasNext()) {
            SJmoPgIndex selectData;
            SJmoPgIndex pg = selectData = i$.next();
            boolean result = true;
            int errorcode = 0;
            if (extVolInfoList.size() == 0) {
                result = false;
                errorcode = DELETE_EXTVOLS_NOT_EQUIP;
            } else {
                boolean found = false;
                for (SJmoExdVolumeInfoOnPathGroup extVolInfo : extVolInfoList) {
                    SJmoExdVolumeInfo volume = extVolInfo.getExdVolumeInfo(pg.getFB4(), pg.getPG());
                    if (volume == null) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result = false;
                    errorcode = DELETE_EXTVOLS_NOT_EQUIP;
                } else {
                    ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>();
                    pgList.add(pg);
                    if (rsgUtil.extractImpossiblePg(pgList).size() != 0) {
                        result = false;
                        errorcode = DELETE_EXTVOLS_UNUSABLE_RSGPG;
                    } else {
                        List<SJmoLdevDetail> pgLdevList = exdUtil.getLdevDetailinPG(pg, ldevDtlList);
                        List<SJmoLdevIndex> unUsableLdevList = rsgUtil.extractImpossibleLdev(pgLdevList);
                        if (unUsableLdevList.size() != 0) {
                            result = false;
                            errorcode = DELETE_EXTVOLS_UNUSABLE_RSGLDEV;
                        }
                    }
                }
            }
            if (result) continue;
            ret = false;
            SJctrError errInfo = new SJctrError(6, 22, errorcode);
            EXDExternalVolume targetData = new EXDExternalVolume();
            targetData.setIFB4(pg.getFB4());
            targetData.setIPG(pg.getPG());
            SJmoExdVolumeInfo targetInfo = new SJmoExdVolumeInfo(targetData);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(targetInfo, errInfo);
            errList.add(errData);
        }
        this.discnctVolsDataModel.setSelect("COM_YES");
        this.withoutWriteCacheDataModel.setSelect("COM_NO");
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    public List<?> getDelExtVolsTableBasicDataList() {
        ArrayList<SJmoExdVolumeInfo> retList = new ArrayList<SJmoExdVolumeInfo>();
        List<?> selectDataList = this.getCache(SJctrDelExtVolsSubWizard.DELETE_EXT_VOLS_DATA);
        if (selectDataList != null || selectDataList.size() != 0) {
            List<SJmoExdVolumeInfoOnPathGroup> extVolInfoList = this.extVolInfoMgr.getExternalVolumeList();
            for (Object selectData : selectDataList) {
                SJmoPgIndex pg = (SJmoPgIndex)selectData;
                for (SJmoExdVolumeInfoOnPathGroup extVolInfo : extVolInfoList) {
                    SJmoExdVolumeInfo volume = extVolInfo.getExdVolumeInfo(pg.getFB4(), pg.getPG());
                    if (volume == null) continue;
                    retList.add(volume);
                }
            }
        }
        return retList;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<SJmoExdVolumeInfoOnPathGroup> exdVolInfoList = this.extVolInfoMgr.getExternalVolumeList();
        List<?> ldevNameInfoList = this.getCache(SJmoGetLdevNicknameInfo.class);
        int option = 0;
        option = this.checkRadioButton();
        ArrayList<SJmoExdVolumeInfo> extVolInfoList = new ArrayList<SJmoExdVolumeInfo>(this.pgIndexList.size());
        SJmoExDVirtualPgInfo exdVpgInfo = this.exdVpgInfoList.get(0);
        ArrayList exdPgInfoList = exdVpgInfo.getAlVpgForExd();
        Collections.sort(exdPgInfoList);
        ArrayList<SJmoLdevNicknameInfo> topLdevNameList = new ArrayList<SJmoLdevNicknameInfo>(this.pgIndexList.size());
        Iterator<SJmoPgIndex> i$ = this.pgIndexList.iterator();
        while (i$.hasNext()) {
            SJmoLdevIndex startLdevIndex;
            int nameIndex;
            SJmoExDPgInfo exdPGInfo;
            SJmoPgIndex selectData;
            SJmoPgIndex pg = selectData = i$.next();
            for (SJmoExdVolumeInfoOnPathGroup exdVolInfo : exdVolInfoList) {
                SJmoExdVolumeInfo volume = exdVolInfo.getExdVolumeInfo(pg.getFB4(), pg.getPG());
                if (volume == null) continue;
                SJmoExdVolumeInfo exdVolData = new SJmoExdVolumeInfo(volume.getRmiExdVolumeInfo());
                int index = -1;
                if (this.delExtVolsList != null && this.delExtVolsList.size() != 0) {
                    Collections.sort(this.delExtVolsList);
                    List<SJmoExdVolumeInfo> checkVolsList = this.delExtVolsList;
                    index = Collections.binarySearch(checkVolsList, exdVolData);
                }
                if (index >= 0) continue;
                extVolInfoList.add(exdVolData);
            }
            int search = Collections.binarySearch(exdPgInfoList, pg);
            if (search < 0 || (exdPGInfo = (SJmoExDPgInfo)exdPgInfoList.get(search)).getSNumOfLdev() <= 0 || (nameIndex = Collections.binarySearch(ldevNameInfoList, startLdevIndex = exdPGInfo.getStartLdevId())) < 0) continue;
            topLdevNameList.add((SJmoLdevNicknameInfo)ldevNameInfoList.get(nameIndex));
        }
        extVolInfoList.trimToSize();
        Collections.sort(extVolInfoList);
        Collections.sort(topLdevNameList);
        ArrayList<SJctrDelExtVolsConfirmData> confirmDataList = new ArrayList<SJctrDelExtVolsConfirmData>(1);
        SJctrDelExtVolsConfirmData confirmData = new SJctrDelExtVolsConfirmData();
        confirmData.setOption(option);
        confirmData.setExdVolumeInfo(extVolInfoList);
        confirmData.setExdVpgInfo(this.exdVpgInfoList);
        confirmData.setLdevNameInfo(topLdevNameList);
        confirmDataList.add(confirmData);
        this.putCache(SJctrDelExtVolsConfirmData.class, confirmDataList);
        if (this.delExtVolsList != null) {
            this.delExtVolsList.clear();
        }
        return ret;
    }

    private int checkRadioButton() {
        int option = 0;
        boolean discnctVols = false;
        boolean writeCache = false;
        if (this.discnctVolsDataModel.isSelectYes()) {
            discnctVols = true;
        }
        if (this.withoutWriteCacheDataModel.isSelectYes()) {
            writeCache = true;
        }
        if (discnctVols) {
            option = 0;
        } else if (!discnctVols && writeCache) {
            option = 1;
        }
        return option;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", GUID_TITLE);
    }

    private void initManager() {
        this.addManager(SJctrExternalVolumeManager.class);
        this.addManager(SJctrVpgManager.class);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetExDVirtualPgInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrDelExtVolsTableModel table = new SJctrDelExtVolsTableModel();
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        btn.setReceiveOnly();
        btn.setRollBackCheck(true);
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrDelExtVolsDC.this.deleteAction();
            }
        });
        buttonGroup.addDataModel(KEY_DELETE, btn);
        table.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
        this.addDataObjectModel(KEY_TABLE, table);
        this.addDataObjectModel(KEY_DISCONNECTED_VOLS, new SJctrDisconnectedVolsDataModel());
        this.addDataObjectModel(KEY_WITHOUT_WRITE_CACHE, new SJctrWithoutWriteCacheDataModel());
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    private void deleteAction() {
        SJctrTableDataModel selectTable;
        List<Object> selectRowList;
        if (this.delExtVolsList == null) {
            this.delExtVolsList = new ArrayList<SJmoExdVolumeInfo>();
        }
        if ((selectRowList = (selectTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE)).removeSelectedRowData()).size() <= 0) {
            SJctrError err = new SJctrError(6, 22, DELETE_EXTVOLS_NOT_SELECT_ROWDATA);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> removeList = selectRowList;
        this.delExtVolsList.addAll(removeList);
        Collections.sort(this.delExtVolsList);
        selectTable.setSortColumn(null, Boolean.FALSE);
        this.updateFooter();
    }

    public static enum SELECT_EXTVOLS_MSG implements SJctrNotifyState
    {
        SELECTED_DELETE;

    }
}

