/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.createclpr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.vpm.com.SJctrClprResidentCacheArea;
import sanproject.sn2.controller.wizard.vpm.com.SJctrClprTotalCacheArea;
import sanproject.sn2.controller.wizard.vpm.comdialog.changesetting.SJctrChangeSettingDialogDC;
import sanproject.sn2.controller.wizard.vpm.createclpr.SJctrCreateClprSelectClprTableModel;
import sanproject.sn2.controller.wizard.vpm.createclpr.SJctrCreateClprSummaryModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprSummary;
import sanproject.sn2.model.connector.kind.SJmoGetDcrCacheInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilClpr;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoClprSummary;
import sanproject.sn2.model.data.system.SJmoDcrCacheInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilClpr;

public class SJctrCreateClprDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x100F101;
    private static final String GUID_TITLE = "CREATE_CLPRS";
    private SJctrTextBoxDataModel clprNameTxtBox = null;
    private SJctrClprTotalCacheArea totalCacheArea = null;
    private SJctrClprResidentCacheArea residentCacheArea = null;
    private SJctrTextBoxDataModel extentNumTxtBox = null;
    private SJctrCreateClprSummaryModel createDefaultClpr = null;
    private SJctrCreateClprSelectClprTableModel createClprTable = null;
    private SJctrFooterDataModel footer = null;
    private int iClprMax = SJctrVpmUtility.CLPR_MAX;
    private List<SJmoClprInfo> baseClprinfoList = null;
    private SJmoClprInfo defaultClprinfo = null;
    private SJmoClprSummary clprSummary = null;
    private List<SJmoDcrCacheInfo> dcrCacheInfoList = null;
    private SJmoRscUtilClpr clprResUtil = null;
    private String strClprId = "";
    private boolean checkEndFlg = true;

    public SJctrCreateClprDC() throws SJcException {
        super(0x100F101);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkConstructData() {
        if (SJctrDataController.isHM()) {
            this.getComUtility().getVPMUtility();
        }
        this.checkLicense();
        this.baseClprinfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        List<?> clprSummaryList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_SUMMARY);
        if (!SJctrDataController.isHM()) {
            this.dcrCacheInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_DCR_CACHEINFO);
        }
        List<?> rscUtilClprList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_RSC_UTIL);
        List<?> dkcInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_DKC_INFO);
        if (!SJctrDataController.isHM()) {
            if (this.baseClprinfoList == null || this.baseClprinfoList.isEmpty() || clprSummaryList == null || clprSummaryList.isEmpty() || this.dcrCacheInfoList == null || this.dcrCacheInfoList.isEmpty() || rscUtilClprList == null || rscUtilClprList.isEmpty() || dkcInfoList == null || dkcInfoList.isEmpty()) {
                SJctrLogUty.warn("SJctrCreateClprDC", "checkConstructData", "Model Data Illegal");
                SJctrVpmUtility.makeErrorDialog(107002);
            }
        } else if (this.baseClprinfoList == null || this.baseClprinfoList.isEmpty() || clprSummaryList == null || clprSummaryList.isEmpty() || rscUtilClprList == null || rscUtilClprList.isEmpty() || dkcInfoList == null || dkcInfoList.isEmpty()) {
            SJctrLogUty.warn("SJctrCreateClprDC", "checkConstructData", "Model Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if (this.baseClprinfoList.size() >= this.iClprMax) {
            SJctrLogUty.warn("SJctrCreateClprDC", "checkConstructData", "CLPR Max Over. CLPRNum:" + this.baseClprinfoList.size());
            SJctrVpmUtility.makeErrorDialog(106001);
        }
        try {
            this.defaultClprinfo = (SJmoClprInfo)this.baseClprinfoList.get(0).clone();
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.warn("SJctrCreateClprDC", "checkConstructData", "SJmoClprInfo clone Error");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        this.clprSummary = (SJmoClprSummary)clprSummaryList.get(0);
        this.clprResUtil = (SJmoRscUtilClpr)rscUtilClprList.get(0);
        int clprDivSize = 0;
        clprDivSize = !SJctrDataController.isHM() ? SJctrVpmUtility.getClprDivSize(this.baseClprinfoList.get(0), this.dcrCacheInfoList.get(0)) : SJctrVpmUtility.getClprDivSize(this.baseClprinfoList.get(0));
        if (clprDivSize < SJctrVpmUtility.CLPR_CACHE_MIN) {
            SJctrLogUty.warn("SJctrCreateClprDC", "checkConstructData", "CLPR Cache Div Error. CLPR:0 DivCache:" + clprDivSize);
            SJctrVpmUtility.makeErrorDialog(106006);
        }
        this.putCache("KEY_GET_SELECTED_CLPRINFO", new ArrayList());
        ArrayList<SJmoClprInfo> defaultClprinfoList = new ArrayList<SJmoClprInfo>();
        defaultClprinfoList.add(this.defaultClprinfo);
        this.putCache("KEY_GET_DEFAULT_CLPRINFO", defaultClprinfoList);
        this.putCache("KEY_GET_BASE_CLPRINFO", this.baseClprinfoList);
        ArrayList<SJmoRscUtilClpr> clprResUtilList = new ArrayList<SJmoRscUtilClpr>();
        clprResUtilList.add(this.clprResUtil);
        this.putCache(SJctrVpmUtility.KEY_CLASS_CLPR_RSC_UTIL, clprResUtilList);
        return true;
    }

    public void checkLicense() {
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer licensecontainer = authorizeContainer.getLisenceContainer();
        if (!licensecontainer.checkPP(SJctrLicenseContainer.PPID_PRM)) {
            this.iClprMax = 4;
        }
    }

    private void initDataModel() {
        this.clprNameTxtBox = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_CLPR_NAME", this.clprNameTxtBox);
        this.totalCacheArea = new SJctrClprTotalCacheArea();
        this.addDataObjectModel("COM_TOTAL_CACHE", this.totalCacheArea);
        this.residentCacheArea = new SJctrClprResidentCacheArea();
        this.addDataObjectModel("COM_RESIDENT_CACHE", this.residentCacheArea);
        this.extentNumTxtBox = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_NUM_OF_EXTENTS", this.extentNumTxtBox);
        this.createDefaultClpr = new SJctrCreateClprSummaryModel();
        this.addDataObjectModel("COM_SUMMARY", this.createDefaultClpr);
        this.createClprTable = new SJctrCreateClprSelectClprTableModel();
        this.addDataObjectModel("COM_TABLE", this.createClprTable);
        this.createClprTable.setTableKeyList(new ArrayList<SJmoClprInfo>());
        SJctrButtonDataModel addBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD_BTN", addBtn);
        addBtn.setRollBackCheck(true);
        addBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateClprDC.this.addAction();
            }
        });
        SJctrButtonDataModel changeBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_CHANGE_BTN", changeBtn);
        changeBtn.setRollBackCheck(true);
        changeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateClprDC.this.cangeAction();
            }
        });
        SJctrButtonDataModel removeBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_REMOVE", removeBtn);
        removeBtn.setRollBackCheck(true);
        removeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateClprDC.this.removeAction();
            }
        });
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrClprTotalCacheArea.TOTALCAPA_MSG.CHG_CAPA, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateClprDC.this.changeTotalCacheEvent();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                SJctrCreateClprDC.this.cangeExitEvent(notifyObj);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprSummary();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetDcrCacheInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilClpr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetAllDKCInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void makeDataModel() {
        this.strClprId = SJctrComUtility.toDecString(this.getUseClprID());
        this.getManageData().setData("COM_CLPR_ID", this.strClprId);
        this.clprNameTxtBox.setValue(SJctrVpmUtility.getDefaultClprName(Integer.parseInt(this.strClprId)));
        int iTotalCacheSize = 0;
        iTotalCacheSize = !SJctrDataController.isHM() ? this.defaultClprinfo.getICacheCapacity() / SJctrVpmUtility.CLPR_CACHE_DIV_UNIT * SJctrVpmUtility.CLPR_CACHE_DIV_UNIT - SJctrVpmUtility.CLPR_CACHE_MIN - SJctrVpmUtility.getSecureDcrSpaceSize(this.dcrCacheInfoList.get(0)) : this.defaultClprinfo.getICacheCapacity() / SJctrVpmUtility.CLPR_CACHE_DIV_UNIT * SJctrVpmUtility.CLPR_CACHE_DIV_UNIT - SJctrVpmUtility.CLPR_CACHE_MIN;
        this.totalCacheArea.initClprTotalCacheArea(iTotalCacheSize, SJctrVpmUtility.CLPR_CACHE_MIN);
        int iResidentCacheSize = 0;
        if (!SJctrDataController.isHM()) {
            iResidentCacheSize = this.defaultClprinfo.getIDCRCapacity() / SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT * SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT;
        }
        this.residentCacheArea.initClprResidentCacheArea(iResidentCacheSize, 0);
        this.changeTotalCacheEvent();
        this.extentNumTxtBox.setValue(SJctrVpmUtility.STR_CLPR_RESIDENT_EXT_MIN);
        this.extentNumTxtBox.setMin(SJctrVpmUtility.STR_CLPR_RESIDENT_EXT_MIN);
        int iResidentExtentsMax = 0;
        iResidentExtentsMax = !SJctrDataController.isHM() ? this.defaultClprinfo.getIDCRExtentLimit() - this.dcrCacheInfoList.get(0).getIDcrUsed() : this.defaultClprinfo.getIDCRExtentLimit();
        this.extentNumTxtBox.setMax(SJctrComUtility.toDecString(iResidentExtentsMax));
        this.createDefaultClpr.initSummary(this.baseClprinfoList.get(0), this.defaultClprinfo);
        super.makeDataModel();
        this.totalCacheArea.initListener();
    }

    private void addAction() {
        List<?> clprInfoList = this.getCache("KEY_GET_SELECTED_CLPRINFO");
        if (this.baseClprinfoList.size() + clprInfoList.size() >= this.iClprMax) {
            SJctrLogUty.warn("SJctrCreateClprDC", "addAction", "CLPR Max Over. CLPRNum:" + (this.baseClprinfoList.size() + clprInfoList.size()));
            SJctrVpmUtility.makeErrorDialog(105017);
        }
        SJmoClprInfo createClprInfo = new SJmoClprInfo();
        createClprInfo.setIDataMode(2);
        short clprId = Short.parseShort(this.strClprId);
        createClprInfo.setSClpr(clprId);
        createClprInfo.setStrClprName(this.clprNameTxtBox.getValue());
        createClprInfo.setICacheCapacity(this.totalCacheArea.getSelectCapa());
        createClprInfo.setIDCRCapacity(this.residentCacheArea.getSelectCapa());
        createClprInfo.setIDCRExtentLimit(Integer.parseInt(this.extentNumTxtBox.getValue()));
        ArrayList<SJmoClprInfo> checkClprInfoList = new ArrayList<SJmoClprInfo>(this.baseClprinfoList.size() + clprInfoList.size());
        checkClprInfoList.addAll(this.baseClprinfoList);
        checkClprInfoList.addAll(clprInfoList);
        SJctrVpmUtility.chkClprName(createClprInfo.getStrClprName(), createClprInfo, checkClprInfoList);
        SJctrVpmUtility.chkTotalCacheSize(createClprInfo.getICacheCapacity(), this.clprSummary);
        if (!SJctrDataController.isHM()) {
            SJctrVpmUtility.chkResidentCacheSize(createClprInfo.getIDCRCapacity(), this.clprSummary);
            SJctrVpmUtility.chkNumofResidentExts(createClprInfo.getIDCRExtentLimit());
        }
        this.defaultClprinfo.setICacheCapacity(this.defaultClprinfo.getICacheCapacity() - createClprInfo.getICacheCapacity());
        this.defaultClprinfo.setIDCRCapacity(this.defaultClprinfo.getIDCRCapacity() - createClprInfo.getIDCRCapacity());
        this.defaultClprinfo.setIDCRExtentLimit(this.defaultClprinfo.getIDCRExtentLimit() - createClprInfo.getIDCRExtentLimit());
        ArrayList rscList = new ArrayList();
        ArrayList<SJmoClprInfo> clprRscList = new ArrayList<SJmoClprInfo>();
        clprRscList.add(createClprInfo);
        rscList.add(clprRscList);
        this.clprResUtil.setRsvData(rscList);
        short sClprId = this.getUseClprID();
        this.strClprId = sClprId >= 0 ? SJctrComUtility.toDecString(sClprId) : "";
        if (!this.strClprId.isEmpty()) {
            int iTotalCacheSize = this.defaultClprinfo.getICacheCapacity() - SJctrVpmUtility.CLPR_CACHE_MIN;
            if (iTotalCacheSize < SJctrVpmUtility.CLPR_CACHE_MIN + SJctrVpmUtility.getSecureDcrSpaceSize(this.defaultClprinfo)) {
                iTotalCacheSize = 0;
            }
            int iResidentExtentsMax = 0;
            iResidentExtentsMax = !SJctrDataController.isHM() ? this.defaultClprinfo.getIDCRExtentLimit() - this.dcrCacheInfoList.get(0).getIDcrUsed() : this.defaultClprinfo.getIDCRExtentLimit();
            this.getManageData().setData("COM_CLPR_ID", this.strClprId);
            this.clprNameTxtBox.setValue(SJctrVpmUtility.getDefaultClprName(Integer.parseInt(this.strClprId)));
            this.totalCacheArea.updateClprTotalCacheArea(iTotalCacheSize);
            this.extentNumTxtBox.setMin(SJctrComUtility.toDecString(0));
            this.extentNumTxtBox.setMax(SJctrComUtility.toDecString(iResidentExtentsMax));
        } else {
            this.getManageData().setData("COM_CLPR_ID", "");
            this.clprNameTxtBox.setValue("");
            this.totalCacheArea.updateClprTotalCacheArea(-1);
            this.residentCacheArea.updateClprResidentCacheArea(-1);
            this.extentNumTxtBox.setValue("");
            this.extentNumTxtBox.setMin(SJctrComUtility.toDecString(0));
            this.extentNumTxtBox.setMax(SJctrComUtility.toDecString(0));
        }
        this.createDefaultClpr.updateSummary(this.defaultClprinfo);
        ArrayList<SJmoClprInfo> addlList = new ArrayList<SJmoClprInfo>();
        addlList.add(createClprInfo);
        this.createClprTable.addRowDataTop(addlList);
        List<Object> createClprList = this.createClprTable.getAllRowData();
        Collections.sort(createClprList);
        this.putCache("KEY_GET_SELECTED_CLPRINFO", createClprList);
        ArrayList<SJmoClprInfo> defaultClprList = new ArrayList<SJmoClprInfo>();
        defaultClprList.add(this.defaultClprinfo);
        this.putCache("KEY_GET_DEFAULT_CLPRINFO", defaultClprList);
        ArrayList<SJmoRscUtilClpr> clprResUtilList = new ArrayList<SJmoRscUtilClpr>();
        clprResUtilList.add(this.clprResUtil);
        this.putCache(SJctrVpmUtility.KEY_CLASS_CLPR_RSC_UTIL, clprResUtilList);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void removeAction() {
        String strNewClprId;
        List<Object> removeDataList = this.createClprTable.removeSelectedRowData();
        if (removeDataList.isEmpty()) {
            SJctrLogUty.warn("SJctrCreateClprDC", "removeAction", "Invalid value for Table");
            SJctrVpmUtility.makeErrorDialog(105001);
        }
        for (Object delObj : removeDataList) {
            SJmoClprInfo delClpr = (SJmoClprInfo)delObj;
            this.defaultClprinfo.setICacheCapacity(this.defaultClprinfo.getICacheCapacity() + delClpr.getICacheCapacity());
            this.defaultClprinfo.setIDCRCapacity(this.defaultClprinfo.getIDCRCapacity() + delClpr.getIDCRCapacity());
            this.defaultClprinfo.setIDCRExtentLimit(this.defaultClprinfo.getIDCRExtentLimit() + delClpr.getIDCRExtentLimit());
            ArrayList rscList = new ArrayList();
            ArrayList<SJmoClprInfo> clprRscList = new ArrayList<SJmoClprInfo>();
            clprRscList.add(delClpr);
            rscList.add(clprRscList);
            this.clprResUtil.delRsvData(rscList);
        }
        int iTotalCacheSize = this.defaultClprinfo.getICacheCapacity() - SJctrVpmUtility.CLPR_CACHE_MIN;
        if (iTotalCacheSize < SJctrVpmUtility.CLPR_CACHE_MIN + SJctrVpmUtility.getSecureDcrSpaceSize(this.defaultClprinfo)) {
            iTotalCacheSize = 0;
        }
        int iResidentExtentsMax = 0;
        iResidentExtentsMax = !SJctrDataController.isHM() ? this.defaultClprinfo.getIDCRExtentLimit() - this.dcrCacheInfoList.get(0).getIDcrUsed() : this.defaultClprinfo.getIDCRExtentLimit();
        this.totalCacheArea.updateClprTotalCacheArea(iTotalCacheSize);
        this.extentNumTxtBox.setMin(SJctrComUtility.toDecString(0));
        this.extentNumTxtBox.setMax(SJctrComUtility.toDecString(iResidentExtentsMax));
        if (this.extentNumTxtBox.getValue().isEmpty()) {
            this.extentNumTxtBox.setValue(SJctrVpmUtility.STR_CLPR_RESIDENT_EXT_MIN);
        }
        if (!this.strClprId.equals(strNewClprId = SJctrComUtility.toDecString(this.getUseClprID()))) {
            this.strClprId = strNewClprId;
            this.getManageData().setData("COM_CLPR_ID", this.strClprId);
            this.clprNameTxtBox.setValue(SJctrVpmUtility.getDefaultClprName(Integer.parseInt(this.strClprId)));
        }
        this.createDefaultClpr.updateSummary(this.defaultClprinfo);
        List<Object> createClprList = this.createClprTable.getAllRowData();
        Collections.sort(createClprList);
        this.putCache("KEY_GET_SELECTED_CLPRINFO", createClprList);
        ArrayList<SJmoClprInfo> defaultClprList = new ArrayList<SJmoClprInfo>();
        defaultClprList.add(this.defaultClprinfo);
        this.putCache("KEY_GET_DEFAULT_CLPRINFO", defaultClprList);
        ArrayList<SJmoRscUtilClpr> clprResUtilList = new ArrayList<SJmoRscUtilClpr>();
        clprResUtilList.add(this.clprResUtil);
        this.putCache(SJctrVpmUtility.KEY_CLASS_CLPR_RSC_UTIL, clprResUtilList);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void cangeExitEvent(Object notifyObj) {
        Map map;
        List cngClprInfoList;
        if (!(notifyObj instanceof Map)) {
            SJctrLogUty.warn("SJctrCreateClprDC", "cangeExitEvent", "Argument Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if ((cngClprInfoList = (List)(map = (Map)notifyObj).get("COM_CNG_NAME_CLPR_INFO")) == null || cngClprInfoList.isEmpty()) {
            SJctrLogUty.warn("SJctrCreateClprDC", "cangeExitEvent", "Premise Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        List<Object> createClprList = this.createClprTable.getAllRowData();
        Collections.sort(createClprList);
        ArrayList<Object> targetClprList = new ArrayList<Object>(cngClprInfoList.size());
        for (SJmoClprInfo clpr : cngClprInfoList) {
            int iSearch = Collections.binarySearch(createClprList, clpr);
            if (iSearch < 0) {
                SJctrLogUty.warn("SJctrCreateClprDC", "cangeExitEvent", "clpr Not Found. CLPRID = " + clpr.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            SJmoClprInfo targetClpr = (SJmoClprInfo)createClprList.get(iSearch);
            targetClpr.setStrClprName(clpr.getStrClprName());
            targetClprList.add(targetClpr);
        }
        this.putCache("KEY_GET_SELECTED_CLPRINFO", createClprList);
        this.createClprTable.setTableKeyList(createClprList);
        this.createClprTable.doRefresh();
        this.createClprTable.addRowSelectionList(targetClprList);
    }

    private void cangeAction() {
        List<Object> selList = this.createClprTable.getSelectedRowDataOrder();
        if (selList.isEmpty()) {
            SJctrLogUty.warn("SJctrCreateClprDC", "cangeAction", "Invalid value for Table");
            SJctrVpmUtility.makeErrorDialog(105001);
        }
        List<?> baseClprinfoList = this.getCache("KEY_GET_BASE_CLPRINFO");
        List<?> clprInfoList = this.getCache("KEY_GET_SELECTED_CLPRINFO");
        ArrayList checkClprInfoList = new ArrayList(baseClprinfoList.size() + clprInfoList.size());
        checkClprInfoList.addAll(baseClprinfoList);
        checkClprInfoList.addAll(clprInfoList);
        Collections.sort(checkClprInfoList);
        HashMap transDataMap = new HashMap();
        transDataMap.put("COM_CNG_NAME_CLPR_INFO", selList);
        transDataMap.put("COM_ALL_DETAIL_CLPR_INFO", checkClprInfoList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrChangeSettingDialogDC.class, transDataMap);
        this.addUpdateDisp(relatedObj);
    }

    private void changeTotalCacheEvent() {
        if (!SJctrDataController.isHM()) {
            int iResidentCacheSize = -1;
            int iResidentCacheSizeMin = 0;
            int totalCapa = this.totalCacheArea.getSelectCapa();
            if (totalCapa >= 0) {
                int iDiffCacheSize;
                int iDcrCacheSizeMin;
                iResidentCacheSize = totalCapa - SJctrVpmUtility.CLPR_CACHE_MIN;
                int iResidentCacheSizeMax = (this.defaultClprinfo.getIDCRCapacity() - SJctrVpmUtility.getSecureDcrSpaceSizeForResident(this.dcrCacheInfoList.get(0))) / SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT * SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT;
                if (iResidentCacheSize > iResidentCacheSizeMax) {
                    iResidentCacheSize = iResidentCacheSizeMax;
                }
                if ((iDcrCacheSizeMin = (iDiffCacheSize = this.defaultClprinfo.getICacheCapacity() / SJctrVpmUtility.CLPR_CACHE_DIV_UNIT * SJctrVpmUtility.CLPR_CACHE_DIV_UNIT - totalCapa) - (SJctrVpmUtility.CLPR_CACHE_MIN + SJctrVpmUtility.getSecureDcrSpaceSize(this.defaultClprinfo))) < 0) {
                    iResidentCacheSizeMin = -iDcrCacheSizeMin;
                }
            }
            this.residentCacheArea.setIValueMin(iResidentCacheSizeMin);
            this.residentCacheArea.updateClprResidentCacheArea(iResidentCacheSize);
            this.residentCacheArea.setDirtyAll();
        }
    }

    @Override
    public void selectNextTask(SJctrActionDefine action) {
        switch (action) {
            case ACT_MIGRATE_CLPR: {
                this.logUty.putlog("selectNextTask", "Create CLPRs -> Migrate CLPR Resources");
                List<?> defaultClprInfoList = this.getCache("KEY_GET_DEFAULT_CLPRINFO");
                List<?> createClprInfoList = this.getCache("KEY_GET_SELECTED_CLPRINFO");
                List<?> baseClprInfoList = this.getCache("KEY_GET_BASE_CLPRINFO");
                if (defaultClprInfoList == null || defaultClprInfoList.isEmpty() || createClprInfoList == null || createClprInfoList.isEmpty() || baseClprInfoList == null || baseClprInfoList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "Premise Data Illegal");
                    SJctrVpmUtility.makeErrorDialog(107002);
                }
                ArrayList clprInfoList = new ArrayList(createClprInfoList.size() + baseClprInfoList.size());
                clprInfoList.addAll(baseClprInfoList);
                clprInfoList.set(0, defaultClprInfoList.get(0));
                clprInfoList.addAll(createClprInfoList);
                Collections.sort(clprInfoList);
                this.putCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO, clprInfoList);
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "Argument Data Illegal");
                SJctrVpmUtility.makeErrorDialog(107002);
            }
        }
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(GUID_TITLE);
    }

    public short getUseClprID() {
        Short sRet = -1;
        for (short sClpr = 0; sClpr < SJctrVpmUtility.CLPR_MAX; sClpr = (short)(sClpr + 1)) {
            SJmoClprIndex chkClprIdx = new SJmoClprIndex();
            chkClprIdx.setSClpr(sClpr);
            if (this.clprResUtil.chkClprID(chkClprIdx) != 0) continue;
            sRet = chkClprIdx.getSClpr();
            break;
        }
        return sRet;
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean bReturn = false;
        boolean msgFlg = false;
        this.checkEndFlg = true;
        if (this.checkEndFlg) {
            this.checkEndData();
            this.checkEndFlg = false;
        }
        if (!this.checkEndFlg) {
            List<?> defaultClprList = this.getCache("KEY_GET_DEFAULT_CLPRINFO");
            List<?> createClprList = this.getCache("KEY_GET_SELECTED_CLPRINFO");
            ArrayList<SJmoClprInfo> applyList = new ArrayList<SJmoClprInfo>();
            applyList.add((SJmoClprInfo)defaultClprList.get(0));
            applyList.addAll(createClprList);
            List<SJmoAllDKCInfo> dkcInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_DKC_INFO);
            msgFlg = SJctrVpmUtility.chkClprLowCacheSize(dkcInfoList, applyList);
            if (msgFlg) {
                SJctrRelatedDispDataObject related = this.createMsgDialog(SJctrVpmUtility.getWarningMsg(105022));
                SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
                msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrCreateClprDC.this.finishEvent(msgEvent, dstModel);
                    }
                });
                msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
                this.addUpdateDisp(related);
                bReturn = true;
            }
        }
        return bReturn;
    }
}

